<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use Cadoles\PortalBundle\Entity\Projecttask;
use Cadoles\PortalBundle\Form\ProjecttaskType;
use Cadoles\CoreBundle\Entity\Usergroup;

class ProjecttaskController extends Controller
{
    private $labelentity="CadolesPortalBundle:Projecttask";
    private $routeprimary="cadoles_portal_config_projecttask";

    private function entityForm(Projecttask $entity,$access="config")
    {
        $route=str_replace("_config_","_".$access."_",$this->routeprimary);

        if ($this->getDoctrine()->getManager()->contains($entity)) {
            return $this->createForm(ProjecttaskType::class, $entity, [
                "mode"   => "update",
                "access" => $access,
                "user" => $this->getUser(),
                "projecttask" => $entity
            ]);
        }
        else {
            return $this->createForm(ProjecttaskType::class, $entity, [
                "mode"   => "submit",
                "access" => $access,
                "user" => $this->getUser(),
                "projecttask" => $entity
            ]);
        }
    }

    public function submitAction(Request $request,$idproject,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = new Projecttask();
        $project=$em->getRepository("CadolesPortalBundle:Project")->find($idproject);
        if($project) $entity->setProject($project);
        $entity->setPriority(0);
        $entity->setPercentage(0);
        $pageid=$request->get("page");
        if($pageid) {
            $page=$em->getRepository("CadolesPortalBundle:Page")->find($pageid);
            $groups=$page->getGroups();
            $idgroup=$groups[0]->getId();
        }
        
        $form   = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        if ($form->isValid()) {
            if($entity->getPercentage()>100) $entity->setPercentage(100);
            $entity->setOwner($this->getUser());
            $entity->setSubmit(new \Datetime());

            $em->persist($entity);
            $em->flush();

            if($entity->getUser()&&$entity->getUser()!=$entity->getOwner()) {
                $this->notifMail($entity);
            }

            foreach($entity->getProject()->getGroups() as $group) {
                if($group->getFgcanshare()) {
                    $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_projecttask_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                    $message="Création tâche<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
                    if($usergroup) {
                        $key=$usergroup->getKeyvalue();
                        $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$group->getId(),$message);
                    }
                }
            }

            if(is_null($pageid))
                return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_projecttask_view',["id"=>$entity->getId()]));          
            else
                return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_page_view',["id"=>$pageid,"usage"=>"group","group"=>$idgroup]));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "submit",
            'access'            => $access,
            'form'              => $form->createView(),
            'pageid'            => $pageid
        ]);
    }

    public function updateAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
        $oldpercentage=$entity->getPercentage();
        $olduser=$entity->getUser();

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $user=$this->getUser();
            $em->getRepository("CadolesPortalBundle:Project")->getPermission($user,$entity->getProject(),$cansee,$canupdate,$canadd);
            if($user && ((is_null($entity->getUser()) && $user==$entity->getOwner()) || $user==$entity->getUser())) $canadd=true;
            else $canadd = $em->getRepository("CadolesPortalBundle:Project")->getInvalideur($user,$entity->getProject());
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }            
        
        // Création du formulaire
        $form = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        if ($form->isValid()) {
            if($entity->getPercentage()>100) $entity->setPercentage(100);
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();

            if($entity->getUser()&&$entity->getUser()!=$entity->getOwner()&&$entity->getUser()!=$olduser) {
                $this->notifMail($entity);
            }


            foreach($entity->getProject()->getGroups() as $group) {
                if($group->getFgcanshare()) {
                    $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_projecttask_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                    if($oldpercentage<100&$entity->getPercentage()==100)
                        $message="Tâche terminée<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    elseif($oldpercentage==100&$entity->getPercentage()<100)
                        $message="Tâche réouverte<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    else
                        $message="Modification tâche<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                    $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
                    if($usergroup) {
                        $key=$usergroup->getKeyvalue();
                        $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$group->getId(),$message);
                    }
                }
            }

            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_projecttask_view',["id"=>$entity->getId()]));          
        }


        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),                  
            'entity'            => $entity,
            'access'            => $access,
            'mode'              => "update",
            'form'              => $form->createView(),
        ]);
    }

    public function deleteAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $this->getDoctrine()->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
        
        $idproject=$entity->getProject()->getId();

        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $user=$this->getUser();
            $em->getRepository("CadolesPortalBundle:Project")->getPermission($user,$entity->getProject(),$cansee,$canupdate,$canadd);
            if($user && ((is_null($entity->getUser()) && $user==$entity->getOwner()) || $user==$entity->getUser())) $canadd=true;
            else $canadd = $em->getRepository("CadolesPortalBundle:Project")->getInvalideur($user,$entity->getProject());

            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }

        // Suppression
        $em->remove($entity);
        $em->flush();

        // Retour
        return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_project_view',["id"=>$idproject]));
    }

    public function viewAction($id, Request $request, $access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // On recherche la premiere page associé au groupe du projet
        $groups=$entity->getProject()->getGroups();
        $idpage=null;
        $idgroup=null;
        if($groups[0]) {
            if($groups[0]->getFgcanshare()) {
                $pages=$groups[0]->getPages();
                if($pages[0]) {
                    $idpage=$pages[0]->getId();
                    $groups=$pages[0]->getGroups();
                    $idgroup=$groups[0]->getId();
                }
            }
        }

        // Permissions
        $user=$this->getUser();
        if($access=="config") {
            $canupdate = true;
            $canadd=true;

            $projects=$em->getRepository("CadolesPortalBundle:Project")->findBy(["id"=>$entity->getProject()->getId()]);
        }
        else {
            // On récupère l'ensemble des projects de l'utilisateur
            $em->getRepository("CadolesPortalBundle:Project")->getProjectsUser($user,$projectsuser,$projectsadmin,$projectsshared);
            $projects=array_merge($projectsuser,$projectsadmin->toArray(),$projectsshared);

            // permission
            if($id==0) {
                $cansee=true;
                $canadd=true;
            }
            else {
                $em->getRepository("CadolesPortalBundle:Project")->getPermission($user,$entity->getProject(),$cansee,$canupdate,$canadd);
                $canadd = $em->getRepository("CadolesPortalBundle:Project")->getInvalideur($user,$entity->getProject());                
            }
          
            if(!$cansee) throw $this->createNotFoundException('Permission denied');

            $canupdate=false;
            if($user) {
                $canupdate=true;
                if((is_null($entity->getUser()) && $user==$entity->getOwner()) || $user==$entity->getUser()) $canadd=true;
            }
        }

        $em->getRepository("CadolesPortalBundle:Projecttask")->getProjectsTasks($projects,0,10,$count,$projecttasks);

        // Récupérer les fichiers de la tache
        $directory=$this->get('kernel')->getRootDir()."/../uploads/file/projecttask-".$id;
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->sortByName()->in($directory)->exclude('thumb')->exclude('thumbmini');
            
            foreach ($finder as $file) {
                $tmp=[];
                $tmp["name"]=$file->getRelativePathname();
                $tmp["extension"]=strtolower($file->getExtension());
                $fileinfo = new file($file->getPathname());
                $tmp["minetype"]=$fileinfo->getMimeType();
                $tmp["minefamily"]=explode("/",$tmp["minetype"])[0];

                $tmp["thumb"]="";
                if($tmp["extension"]=="pdf") {
                    $tmp["thumb"]="/".$this->getParameter('alias')."/bundles/cadolescore/images/files/".$tmp["extension"].".png";
                }
                elseif($fs->exists($directory."/thumbmini/".$tmp["name"])) {
                    $data = file_get_contents($directory."/thumbmini/".$tmp["name"]);
                    $tmp["thumb"]="data:image/" . $tmp["extension"] . ";base64," . base64_encode($data);
                }
                elseif($fs->exists($directory."/thumb/".$tmp["name"])) {
                    $data = file_get_contents($directory."/thumb/".$tmp["name"]);
                    $tmp["thumb"]="data:image/" . $tmp["extension"] . ";base64," . base64_encode($data);
                }
                elseif($fs->exists($this->get('kernel')->getRootDir()."/../web/bundles/cadolescore/images/files/".$tmp["extension"].".png")) {
                    $tmp["thumb"]="/".$this->getParameter('alias')."/bundles/cadolescore/images/files/".$tmp["extension"].".png";
                }

                array_push($files,$tmp);
            }
        }

        return $this->render($this->labelentity.':view.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),
            'entity'            => $entity,
            'access'            => $access,
            'canupdate'         => $canupdate,
            'canadd'            => $canadd,
            'projects'          => $projects,
            'projecttasks'      => $projecttasks,
            'files'             => $files,
            'idpage'            => $idpage,
            'idgroup'           => $idgroup,
        ]);

    }

    public function uploadAction(Request $request,$access=null) {
        // Fichier temporaire uploadé
        $tmpfile    = $request->files->get('upload');
        $extention  = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs         = new Filesystem();
        $rootdir    = $this->get('kernel')->getRootDir()."/../web";
        $fs->mkdir($rootdir."/uploads/ckeditor");
        
        // Fichier cible
        $targetName = uniqid().".".$extention;
        $targetFile = $rootdir."/uploads/ckeditor/".$targetName;
        $targetUrl  = "/".$this->getParameter('alias')."/uploads/ckeditor/".$targetName;
        $message    = "";

        move_uploaded_file($tmpfile,$targetFile);
        
        $output["uploaded"]=1;
        $output["fileName"]=$targetName;
        $output["url"]=$targetUrl;

        return new Response(json_encode($output));

    }    

    public function usersAction(Request $request, $access="config") {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        $projectid=$request->query->get('project');

        $project=$em->getRepository("CadolesPortalBundle:Project")->find($projectid);
        if($project) {
            $user=$this->getUser();
            $canadd = $em->getRepository("CadolesPortalBundle:Project")->getInvalideur($user,$project);
            
            // Si permission alors il peut affecter tt les personnes du groupe
            if($canadd||$access=="config") {
                $qb= $em->createQueryBuilder()
                        ->select('user')

                        ->from('CadolesPortalBundle:Project','project')
                        ->andwhere('project.id=:project')

                        ->from('CadolesCoreBundle:UserGroup','usergroup')
                        ->andwhere("usergroup.group MEMBER OF project.groups")

                        ->from('CadolesCoreBundle:User','user')
                        ->andwhere("usergroup.user=user")

                        ->setParameter('project',$projectid);
            
                $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();                    
                foreach($datas as $data) {
                    array_push($output,array("id"=>$data->getId(),"text"=>$data->getUsername()));
                }
            }
            // Sinon il ne peut que s'affecter lui
            else {
                array_push($output,array("id"=>$user->getId(),"text"=>$user->getUsername()));
            }
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function percentageAction($id,Request $request, $access="config") {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $percentage=$request->get('percentage');
        $entity = $this->getDoctrine()->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
        
        $idproject=$entity->getProject()->getId();
        $oldpercentage=$entity->getPercentage();

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $user=$this->getUser();
            if($user && ((is_null($entity->getUser()) && $user==$entity->getOwner()) || $user==$entity->getUser())) $canadd=true;
            else $canadd = $em->getRepository("CadolesPortalBundle:Project")->getInvalideur($user,$entity->getProject());
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }


        $entity->setPercentage($percentage);
        $em->persist($entity);
        $em->flush();

        foreach($entity->getProject()->getGroups() as $group) {
            if($group->getFgcanshare()) {
                $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_projecttask_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
                $message="";
                if($oldpercentage<100&$entity->getPercentage()==100)
                    $message="Tâche terminée<br><a href='$url' target='_top'>".$entity->getName()."</a>";
                elseif($oldpercentage==100&$entity->getPercentage()<100)
                    $message="Tâche réouverte<br><a href='$url' target='_top'>".$entity->getName()."</a>";

                if($message!="") {
                    $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
                    if($usergroup) {
                        $key=$usergroup->getKeyvalue();
                        $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$group->getId(),$message);
                    }
                }
            }
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    private function notifMail($entity) {
        $appname=$this->get('session')->get('appname');

        $url=$this->generateUrl('cadoles_core_redirect', ['route'=>'cadoles_portal_user_projecttask_view','id'=>$entity->getId()], UrlGeneratorInterface::ABSOLUTE_URL);
        $urltext=$url;
        $urlhtml="<a href='".$url."'>".$url."</a>";
        $bodytext="Une tâche vous a été affectée dans le groupe ".$entity->getProject()->getName()."\n".$entity->getName()."\n\nVous pouvez la consulter sur\n";
        $bodyhtml=nl2br($bodytext);

        $mail_params=array(
            "subject" => $appname." : Affectation Tâche dans le groupe ".$entity->getProject()->getName(),
            "body_html"=>$bodyhtml.$urlhtml,
            "body_text"=>$bodytext.$urltext,
        );          

        $message = $this->container->get('cadoles.core.service.mail');
        $message->sendEmail("template", $mail_params, $entity->getUser()->getEmail(), $this->getParameter("noreply"), $appname);                

    }
}
