<?php
namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

 /**
 * @ORM\Entity
 * @ORM\Table(name="itemcategory")
 * @ORM\HasLifecycleCallbacks
 * @UniqueEntity(fields="label", message="Une Catégorie existe déjà avec ce label")
 */
class Itemcategory
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=100)
     */
    private $label;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=24,  nullable=true)
     */
    private $color;

    /**
     * @var integer
     *
     * @ORM\Column(name="rowOrder", type="integer", nullable=true)
     */
    private $rowOrder;

    /**
     * @ORM\ManyToOne(targetEntity="Icon", inversedBy="itemcategorys")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @var ArrayCollection $groups
     * @var UserGroup
     *
     * @ORM\OneToMany(targetEntity="Item", mappedBy="itemcategory", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"rowOrder" = "ASC","title" = "ASC"})
     */

    protected $items;

    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }  

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Itemcategory
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Itemcategory
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set rowOrder
     *
     * @param integer $rowOrder
     *
     * @return Itemcategory
     */
    public function setRowOrder($rowOrder)
    {
        $this->rowOrder = $rowOrder;

        return $this;
    }

    /**
     * Get rowOrder
     *
     * @return integer
     */
    public function getRowOrder()
    {
        return $this->rowOrder;
    }

    /**
     * Set icon
     *
     * @param \Cadoles\PortalBundle\Entity\Icon $icon
     *
     * @return Itemcategory
     */
    public function setIcon(\Cadoles\PortalBundle\Entity\Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return \Cadoles\PortalBundle\Entity\Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Add item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     *
     * @return Itemcategory
     */
    public function addItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     */
    public function removeItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }
}
