<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Filesystem\Filesystem;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpKernel\KernelInterface;

use App\Entity\Alert;
use App\Form\AlertType;

class AlertController extends AbstractController
{
    private $nameentity  = 'Alert';
    private $labelentity = 'App\Entity\Alert';
    private $labelroute  = 'app_portal_config_alert';
    private $labeldata   = 'alert';
    private $labeldatas  = 'alerts';

    private $appKernel;
    
    public function __construct(KernelInterface $appKernel)
    {
        $this->appKernel = $appKernel;
    }

    public function ajaxseleclist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("App\Entity\Alert",'table')
           ->where('table.title LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.title');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getTitle()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function list(ManagerRegistry $em)
    {
        $alerts = $em->getRepository('App\Entity\Alert')->findBy([], ['rowOrder' => 'asc']);        
        $alertcategorys = $em->getRepository('App\Entity\Alertcategory')->findAll();
        $groups = $em->getRepository('App\Entity\Group')->findBy([], ['label' => 'asc']);

        return $this->render($this->nameentity.'\list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            'alerts'            => $alerts,
            'alertcategorys'    => $alertcategorys,
            'groups'            => $groups
        ]);
    }

    public function submit(Request $request, ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new Alert();
        $data->setFghideable(true);
        
        // Création du formulaire
        $form = $this->createForm(AlertType::class,$data,array("mode"=>"submit","labelniveau01" => $this->GetParameter("labelsniveau01")));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id,$em);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(AlertType::class,$data,array(
            "mode"      => "update",
            "labelniveau01" => $this->GetParameter("labelsniveau01")
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Si non masquable on s'assure qu'il n'y a pas de reader
            if(!$data->getFghideable()) {
                $readers=$data->getReaders();
                foreach($readers as $reader) {
                    $data->removeReader($reader);
                }
            }

            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id,$em);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
        
        return $this->redirectToRoute($this->labelroute);
    }

    public function order(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $id=$request->request->get('id');
        $order=$request->request->get('order');
        
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find entity.');
        }

        $entity->setRoworder($order);
        $em->getManager()->flush();

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    public function upload($access=null, Request $request, ManagerRegistry $em) {
        // Fichier temporaire uploadé
        $tmpfile    = $request->files->get('upload');
        $extention  = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs         = new Filesystem();
        $rootdir    = $this->appKernel->getProjectDir()."/public";
        $fs->mkdir($rootdir."/uploads/ckeditor");
        
        // Fichier cible
        $targetName = uniqid().".".$extention;
        $targetFile = $rootdir."/uploads/ckeditor/".$targetName;
        $targetUrl  = "/".$this->getParameter('alias')."uploads/ckeditor/".$targetName;
        $message    = "";

        move_uploaded_file($tmpfile,$targetFile);
        
        $output["uploaded"]=1;
        $output["fileName"]=$targetName;
        $output["url"]=$targetUrl;

        return new Response(json_encode($output));

    } 

    public function read(Request $request, ManagerRegistry $em) {
        $output=array();
        $id=$request->request->get('id');

        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find entity.');
        }

        if(!$entity->getReaders()->contains($this->getUser())) {
            $entity->addReader($this->getUser());
            $em->getManager()->flush();
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id,$em)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
