<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

class MailType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => "Envoyer l'invitation",
                "attr"        => array("class" => "btn btn-success")
            )
        );

        $builder->add('destinataire',
            TextType::class, array(
                "label"       =>"Destinataires",
                "mapped"      => false
            )
        );

        $builder->add('subject',
            TextType::class, array(
                "label"       =>"Sujet",
                "mapped"      => false
            )
        );

        $builder
        ->add("message",CKEditorType::class,[
            'config_name' => 'small_config',
            'label' => "Message",
            'mapped'=> false,
            'required' => false,
            'config' => ["height" => "150px"]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }
}
