<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Activity
 *
 * @ORM\Table(name="activity")
 * @ORM\Entity(repositoryClass="App\Repository\ActivityRepository")
 */
class Activity
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(name="subject", type="string", nullable=true)
     *
     */
    private $subject;

    /**
     * @ORM\Column(name="status", type="integer")
     *
     */
    private $status;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $startdate;    

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $enddate;    

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="activitys")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="activitys")
     */
    private $group;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $activity;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="activity", cascade={"persist"}, orphanRemoval=true)
     */
    private $activitydocuments;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $corrected;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="corrected", cascade={"persist"}, orphanRemoval=true)
     */
    private $correcteddocuments;

    /**
     * @ORM\OneToMany(targetEntity="Answer", mappedBy="activity", cascade={"persist"}, orphanRemoval=true)
     */
    private $answers;


    private $answeruser;
    public function getAnsweruser(): ?Answer
    {
        return $this->answeruser;
    }
    public function setAnsweruser(?Answer $answer): self
    {
        $this->answeruser = $answer;

        return $this;
    }
        
    public function __construct()
    {
        $this->activitydocuments = new ArrayCollection();
        $this->correcteddocuments = new ArrayCollection();
        $this->answers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function setSubject(?string $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getActivity(): ?string
    {
        return $this->activity;
    }

    public function setActivity(?string $activity): self
    {
        $this->activity = $activity;

        return $this;
    }

    public function getCorrected(): ?string
    {
        return $this->corrected;
    }

    public function setCorrected(?string $corrected): self
    {
        $this->corrected = $corrected;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getGroup(): ?Group
    {
        return $this->group;
    }

    public function setGroup(?Group $group): self
    {
        $this->group = $group;

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getActivitydocuments(): Collection
    {
        return $this->activitydocuments;
    }

    public function addActivitydocument(Document $activitydocument): self
    {
        if (!$this->activitydocuments->contains($activitydocument)) {
            $this->activitydocuments[] = $activitydocument;
            $activitydocument->setActivity($this);
        }

        return $this;
    }

    public function removeActivitydocument(Document $activitydocument): self
    {
        if ($this->activitydocuments->contains($activitydocument)) {
            $this->activitydocuments->removeElement($activitydocument);
            // set the owning side to null (unless already changed)
            if ($activitydocument->getActivity() === $this) {
                $activitydocument->setActivity(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getCorrecteddocuments(): Collection
    {
        return $this->correcteddocuments;
    }

    public function addCorrecteddocument(Document $correcteddocument): self
    {
        if (!$this->correcteddocuments->contains($correcteddocument)) {
            $this->correcteddocuments[] = $correcteddocument;
            $correcteddocument->setCorrected($this);
        }

        return $this;
    }

    public function removeCorrecteddocument(Document $correcteddocument): self
    {
        if ($this->correcteddocuments->contains($correcteddocument)) {
            $this->correcteddocuments->removeElement($correcteddocument);
            // set the owning side to null (unless already changed)
            if ($correcteddocument->getCorrected() === $this) {
                $correcteddocument->setCorrected(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Answer[]
     */
    public function getAnswers(): Collection
    {
        return $this->answers;
    }

    public function addAnswer(Answer $answer): self
    {
        if (!$this->answers->contains($answer)) {
            $this->answers[] = $answer;
            $answer->setActivity($this);
        }

        return $this;
    }

    public function removeAnswer(Answer $answer): self
    {
        if ($this->answers->contains($answer)) {
            $this->answers->removeElement($answer);
            // set the owning side to null (unless already changed)
            if ($answer->getActivity() === $this) {
                $answer->setActivity(null);
            }
        }

        return $this;
    }

    public function getStartdate(): ?\DateTimeInterface
    {
        return $this->startdate;
    }

    public function setStartdate(?\DateTimeInterface $startdate): self
    {
        $this->startdate = $startdate;

        return $this;
    }

    public function getEnddate(): ?\DateTimeInterface
    {
        return $this->enddate;
    }

    public function setEnddate(?\DateTimeInterface $enddate): self
    {
        $this->enddate = $enddate;

        return $this;
    }



}