#!/bin/bash

PHP_V="php7.4"
COMPOSER="/usr/lib/envole-tools/composer"

# Se positionner sur la racine du projet
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd ${DIR}
cd ..
DIR=$(pwd)

# Mise en place du fichier d'environnement model
yes 2>/dev/null | cp $DIR/scripts/.env.model $DIR/.env

# Import des env
. $DIR/.env
. $DIR/.env.local

# Déclaration d'un proxy
if [[ "$PROXY_USE" == "1" ]]
then
    export HTTP_PROXY="$PROXY_HOST:$PROXY_PORT"
    export HTTPS_PROXY="$PROXY_HOST:$PROXY_PORT"
fi

# Suppression des logs trop ancien
if [[ -d $DIR/var/log ]]
then
find $DIR/var/log -mindepth 1 -mtime +7 -delete
fi

# Installation des dépendances composer
echo COMPOSER = Version
export COMPOSER_ALLOW_SUPERUSER=1
$PHP_V $COMPOSER self-update --2 --quiet

echo COMPOSER = Install
$PHP_V $COMPOSER install --quiet

# Permissions
echo PERMISSIONS
./scripts/perm.sh www-data
