<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Form\FormError;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use App\Entity\Answer as Entity;
use App\Entity\Message as Message;

use App\Form\AnswerType as Form;
use App\Form\CorrectedType as Corrected;

class AnswerController extends AbstractController
{
    private $data   = "answer";
    private $route  = "app_user_answer";
    private $render = "Answer/";
    private $entity = "App:Answer";

    private $mail;
    public function __construct(\App\Service\mailService $mail) { $this->mail = $mail; }

    public function update($id,Request $request)
    {
        $now=new \DateTime();

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        
        // Controle accès
        if(!$data)
            return $this->redirectToRoute("app_home");
        else {
            if(!$this->getUser()->Hasrole("ROLE_ADMIN")&&$this->getUser()!=$data->getActivity()->getUser()&&$this->getUser()!=$data->getUser()) 
                return $this->redirectToRoute("app_home");
        }

        // Ne pas permettre l'affichage si date non entammée ou si statut brouillon
        if($this->getUser()==$data->getUser()) {
            if(($data->getActivity()->getStartdate()&&$data->getActivity()->getStartdate()>$now)||$data->getActivity()->getStatus()==0) return $this->redirectToRoute("app_home");
        }

        // Passer la réponse en cours si l'utilisateur en cours est l'élève
        if($this->getUser()==$data->getUser()&&$data->getStatus()==0) {
            $data->setStatus(1);
            $em->persist($data);
            $em->flush();      
            
            // Message
            $message = new Message;
            $message->setMessage("En cours");
            $message->setDeletable(false);
            $message->setUser($data->getUser());
            $message->setAnswer($data);
            $message->setInformation(true);
            $message->addReader($data->getUser());
            $em->persist($message);
            $em->flush();            
        }

        // Création du formulaire
        $ended=false;
        if($data->getActivity()->getEnddate()&&$data->getActivity()->getEnddate()<$now) $ended=true;
        $form = $this->createForm(Form::class,$data,array("mode"=>"update","status"=>$data->getStatus(),"activitystatus"=>$data->getActivity()->getStatus(),"ended"=>$ended));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");
        
        $valid=false;
        if($form->isSubmitted()&&$form->isValid()) {
            if($form->get('submit')->isClicked())
                $valid=true;
            
            if ($form->has('returned') && $form->get('returned')->isClicked())
                $valid=true;
        }

        // Sur validation
        if ($valid) {  
            $data = $form->getData();  

            // Retour de la réponse
            if ($form->has('returned') && $form->get('returned')->isClicked()){
                $data->setStatus(10);

                // Message
                $message=new Message;
                $message->setMessage("Activité rendue");
                $message->setDeletable(false);
                $message->setUser($data->getUser());
                $message->setAnswer($data);
                $message->setInformation(true);
                $message->addReader($data->getUser());

                $em->persist($message);
                $em->flush();       

                // Notification par mail du rendu de l'activité
                $to = $data->getActivity()->getUser()->getEmail();
                $from =  $data->getUser()->getEmail();
                $subject="Nineschool : Activité rendue";
                $body ="Activité = ".$data->getActivity()->getName()."<br>";
                $body.="Elève = ".$data->getUser()->getDisplayname()."<br>";
                $body.="Matière = ".$data->getActivity()->getSubject()."<br>";
                $body.="Url = ".$this->generateUrl('app_answer_view', ["id"=>$data->getId()], UrlGeneratorInterface::ABSOLUTE_URL);

                $this->mail->sendEmail($subject, $body, $to, $from);                
            }


            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute("app_activity");
        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => false,                 
            $this->data         => $data,
            'mode'              => 'update',
            'ended'             => $ended,
            'form'              => $form->createView()
        ]);
    }  

    public function view($id,Request $request) {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        
        // Controle accès
        if(!$data)
            return $this->redirectToRoute($this->route);
        else {
            if(!$this->getUser()->Hasrole("ROLE_ADMIN")&&$this->getUser()!=$data->getActivity()->getUser()) 
                return $this->redirectToRoute($this->route);
        }

        // Création du formulaire
        $form = $this->createForm(Corrected::class,$data,array("mode"=>"update","status"=>$data->getStatus(),"activitystatus"=>$data->getActivity()->getStatus()));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");
        
        $valid=false;
        if($form->isSubmitted()&&$form->isValid()) {
            if($form->get('submit')->isClicked())
                $valid=true;
            
            if ($form->has('corrected') && $form->get('corrected')->isClicked())
                $valid=true;

            if ($form->has('canceled') && $form->get('canceled')->isClicked())
                $valid=true;                
        }

        // Sur validation
        if ($valid) {  
            $data = $form->getData();  

            // Retour de la réponse
            if ($form->has('corrected') && $form->get('corrected')->isClicked()) {
                $data->setStatus(15);

                // Message
                $message=new Message;
                $message->setMessage("Activité corrigée");
                $message->setDeletable(false);
                $message->setUser($this->getUser());
                $message->setAnswer($data);
                $message->setInformation(true);
                $message->addReader($this->getUser());

                $em->persist($message);
                $em->flush();       

                // Notification par mail de la correction de l'activité
                $to = $data->getActivity()->getUser()->getEmail();
                $from =  $data->getUser()->getEmail();
                $subject="Nineschool : Activité réouverte";
                $body ="Activité = ".$data->getActivity()->getName()."<br>";
                $body.="Professeur = ".$data->getActivity()->getUser()->getDisplayname()."<br>";
                $body.="Matière = ".$data->getActivity()->getSubject()."<br>";
                $body.="Url = ".$this->generateUrl('app_answer_update', ["id"=>$data->getId()], UrlGeneratorInterface::ABSOLUTE_URL);

                $this->mail->sendEmail($subject, $body, $to, $from);  
            }
            
            // Annuler le rendu de l'élève
            if ($form->has('canceled') && $form->get('canceled')->isClicked()) {
                $data->setStatus(2);

                // Message
                $message=new Message;
                $message->setMessage("Activité réouverte");
                $message->setDeletable(false);
                $message->setUser($this->getUser());
                $message->setAnswer($data);
                $message->setInformation(true);
                $message->addReader($this->getUser());

                $em->persist($message);
                $em->flush();       

                // Notification par mail de la réouverture de l'activité
                $to = $data->getActivity()->getUser()->getEmail();
                $from =  $data->getUser()->getEmail();
                $subject="Nineschool : Activité réouverte";
                $body ="Activité = ".$data->getActivity()->getName()."<br>";
                $body.="Professeur = ".$data->getActivity()->getUser()->getDisplayname()."<br>";
                $body.="Matière = ".$data->getActivity()->getSubject()."<br>";
                $body.="Url = ".$this->generateUrl('app_answer_update', ["id"=>$data->getId()], UrlGeneratorInterface::ABSOLUTE_URL);

                $this->mail->sendEmail($subject, $body, $to, $from);                
            }


            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute("app_activity");
        }

        // Affichage du formulaire
        return $this->render($this->render.'view.html.twig', [
            'useheader'         => true,
            'usesidebar'        => false,                 
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }

    public function select(Request $request) {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        $id=$request->query->get('activity');

        $activity=$em->getRepository("App:Activity")->find($id);
        if(!$activity) {
            $response = new Response(json_encode($ret_string));    
            $response->headers->set('Content-Type', 'application/json');      
            return $response;    
        }

        $datas=$activity->getAnswers();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getDisplayname()));
        }

        $ret_string["results"]=$output;
        $response = new Response(json_encode($ret_string));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }     
}
