<?php

namespace App\Entity;

use App\Repository\SurveyRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SurveyRepository::class)
 */
class Survey
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="label", type="string", length=255)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="private", type="boolean")
     */
    private $private;

    /**
     * @ORM\Column(name="notification", type="boolean")
     */
    private $notification;

    /**
     * @ORM\Column(name="keyaccess", type="string", length=255)
     */
    private $key;

    /**
     * @ORM\Column(type="integer")
     */
    private $status;
    
    /**
     * @ORM\Column(type="boolean")
     */
    private $tonotifyclose;
    
    /**
     * @ORM\Column(type="boolean")
     */
    private $tonotifyopen;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $tonotifymessage;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="surveys")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Surveyoption", mappedBy="survey", cascade={"persist"}, orphanRemoval=true)
     */
    private $surveyoptions;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Surveyguest", mappedBy="survey", cascade={"persist"}, orphanRemoval=true)
     */
    private $surveyguests;

    /**
     * Calculate
     * jsonsurveyoptions = formatage des options du survey en une chaine json
     * jsonsurveyguests  = formatage des guests du survey en une chaine json
     */
    private $jsonsurveyoptions;
    private $jsonsurveyguests;
    private $result;
    private $datepurge;

    public function __construct()
    {
        $this->surveyoptions = new ArrayCollection();
        $this->surveyguests = new ArrayCollection();
    }

    public function setJsonsurveyoptions(string $jsonsurveyoptions): self
    {
        $this->jsonsurveyoptions = $jsonsurveyoptions;

        return $this;
    }

    public function getJsonsurveyoptions(): ?string
    {
        return $this->jsonsurveyoptions;
    }


    public function setJsonsurveyguests(string $jsonsurveyguests): self
    {
        $this->jsonsurveyguests = $jsonsurveyguests;

        return $this;
    }

    public function getJsonsurveyguests(): ?string
    {
        return $this->jsonsurveyguests;
    }    

    public function getResult(): ?array
    {
        $this->result=[];
        foreach($this->getSurveyguests() as $surveyguest) {  
            foreach($surveyguest->getSurveyvotes() as $vote) {
                $key=$vote->getSurveyoption()->getId();
                $val=$vote->getVote();
                if(!array_key_exists($key,$this->result))
                    $this->result[$key]=["id"=>$key,"date"=>$vote->getSurveyoption()->getDate(),"count"=>0];

                if(!is_null($val))
                    $this->result[$key]["count"]+=$val;
            }
        }

        $columns = array_column($this->result, 'count');
        array_multisort($columns, SORT_DESC, $this->result);

        return $this->result;
    } 

    public function getDatepurge()
    {
        $this->datepurge=new \DateTime('2000-01-01');
        foreach($this->surveyoptions as $option) {
            if($option->getDate()>$this->datepurge)
                $this->datepurge=clone($option->getDate());
        }

        $this->datepurge->modify('+10 day');
        return $this->datepurge;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getPrivate(): ?bool
    {
        return $this->private;
    }

    public function setPrivate(bool $private): self
    {
        $this->private = $private;

        return $this;
    }

    public function getNotification(): ?bool
    {
        return $this->notification;
    }

    public function setNotification(bool $notification): self
    {
        $this->notification = $notification;

        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getTonotifyclose(): ?bool
    {
        return $this->tonotifyclose;
    }

    public function setTonotifyclose(bool $tonotifyclose): self
    {
        $this->tonotifyclose = $tonotifyclose;

        return $this;
    }

    public function getTonotifyopen(): ?bool
    {
        return $this->tonotifyopen;
    }

    public function setTonotifyopen(bool $tonotifyopen): self
    {
        $this->tonotifyopen = $tonotifyopen;

        return $this;
    }

    public function getTonotifymessage(): ?string
    {
        return $this->tonotifymessage;
    }

    public function setTonotifymessage(?string $tonotifymessage): self
    {
        $this->tonotifymessage = $tonotifymessage;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Surveyoption[]
     */
    public function getSurveyoptions(): Collection
    {
        return $this->surveyoptions;
    }

    public function addSurveyoption(Surveyoption $surveyoption): self
    {
        if (!$this->surveyoptions->contains($surveyoption)) {
            $this->surveyoptions[] = $surveyoption;
            $surveyoption->setSurvey($this);
        }

        return $this;
    }

    public function removeSurveyoption(Surveyoption $surveyoption): self
    {
        if ($this->surveyoptions->removeElement($surveyoption)) {
            // set the owning side to null (unless already changed)
            if ($surveyoption->getSurvey() === $this) {
                $surveyoption->setSurvey(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Surveyguest[]
     */
    public function getSurveyguests(): Collection
    {
        return $this->surveyguests;
    }

    public function addSurveyguest(Surveyguest $surveyguest): self
    {
        if (!$this->surveyguests->contains($surveyguest)) {
            $this->surveyguests[] = $surveyguest;
            $surveyguest->setSurvey($this);
        }

        return $this;
    }

    public function removeSurveyguest(Surveyguest $surveyguest): self
    {
        if ($this->surveyguests->removeElement($surveyguest)) {
            // set the owning side to null (unless already changed)
            if ($surveyguest->getSurvey() === $this) {
                $surveyguest->setSurvey(null);
            }
        }

        return $this;
    }

        
}
