<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\Hiddentype;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;


class QuestguestsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('jsonquestguests', HiddenType::class, [
                'label' => 'jsonquestguests',
                'required' => false,
                'empty_data' => '',                  
            ])
          
            ->add('user',
            Select2EntityType::class, [
                "mapped" => false,
                "label" => "Inviter un Utilisateur",
                "disabled" => false,
                "required"    => false,
                "multiple" => false,
                "remote_route" => "app_user_select",
                "class" => "App:User",
                "primary_key" => "id",
                "text_property" => "displayname",
                "minimum_input_length" => 0,
                "page_limit" => 100,
                "delay" => 250,
                "cache" => false,
                "cache_timeout" => 60000,
                "language" => "fr",
                "placeholder" => "Inviter un Utilisateur",
            ])

            ->add('group',
            Select2EntityType::class, [
                "mapped" => false,
                "label" => "Inviter un Groupe",
                "disabled" => false,
                "required"    => false,
                "multiple" => false,
                "remote_route" => "app_group_select",
                "class" => "App:Group",
                "primary_key" => "id",
                "text_property" => "name",
                "minimum_input_length" => 0,
                "page_limit" => 100,
                "delay" => 250,
                "cache" => false,
                "cache_timeout" => 60000,
                "language" => "fr",
                "placeholder" => "Inviter un Groupe",
            ])
        ;  
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Quest',
        ]);
    }
}
