<?php
/**
 * PHP 5
 *
 * Permet de générer un calendrier
 * @author  Gaudé Benjamin <development@gaudebenjamin.com>
 */
class Calendar {

	public $days 	= array('lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi', 'dimanche');
	public $months 	= array('janvier', 'fevrier', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre');

	public function get_all_days( $year_start, $year_stop ) {
		$r 		= array();
		$date 	= new DateTime($year_start.'-01-01');

		while ($date->format('Y') <= $year_stop) {
			$y = $date->format('Y');
			$m = $date->format('m');
			$d = $date->format('j');

			$w = str_replace('0', '7', $date->format('w'));
			$r[$y][$m][$d] = $w;
			$date->add(new DateInterval('P1D'));
		}

		return $r;
	}

	public function getHolidays($year = null) {
	  if ($year === null) {
	    $year = intval(date('Y'));
	  }

	  $easterDate  = easter_date($year);
	  $easterDay   = date('j', $easterDate);
	  $easterMonth = date('n', $easterDate);
	  $easterYear   = date('Y', $easterDate);

	  $holidays = array(
	    // Dates fixes
	    mktime(0, 0, 0, 1,  1,  $year),  // 1er janvier
	    mktime(0, 0, 0, 5,  1,  $year),  // Fête du travail
	    mktime(0, 0, 0, 5,  8,  $year),  // Victoire des alliés
	    mktime(0, 0, 0, 7,  14, $year),  // Fête nationale
	    mktime(0, 0, 0, 8,  15, $year),  // Assomption
	    mktime(0, 0, 0, 11, 1,  $year),  // Toussaint
	    mktime(0, 0, 0, 11, 11, $year),  // Armistice
	    mktime(0, 0, 0, 12, 25, $year),  // Noel

	    // Dates variables
	    mktime(0, 0, 0, $easterMonth, $easterDay + 1,  $easterYear),
	    mktime(0, 0, 0, $easterMonth, $easterDay + 40, $easterYear),
	    mktime(0, 0, 0, $easterMonth, $easterDay + 50, $easterYear),
	  );

	  sort($holidays);

	  return $holidays;
	}
}
