<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik_Plugins
 * @package Piwik_ExamplePlugin
 */

/**
 *
 * @package Piwik_ProfiledVisits
 */
class Piwik_ProfiledVisits extends Piwik_Plugin
{
    public function getInformation()
    {
        return array(
            'description'          => 'Permet de voir les usages selon les profils d\'utilisateurs',
            'homepage'             => 'http://dev-eole.ac-dijon.fr',
            'author'               => 'Mathieu Terroba',
            'author_homepage'      => 'http://dev-eole.ac-dijon.fr',
            'license'              => 'GPL v3 or later',
            'license_homepage'     => 'http://www.gnu.org/licenses/gpl.html',
            'version'              => '0.1',
            'translationAvailable' => false,
        );
    }

    public function getListHooksRegistered()
    {
        return array(
//          'Controller.renderView' => 'addUniqueVisitorsColumnToGivenReport',
            /*'ArchiveProcessing_Day.compute'    => 'archiveDay',
            'ArchiveProcessing_Period.compute' => 'archivePeriod',*/
            'WidgetsList.add'                  => 'addWidgets',
           /* 'Menu.add'                         => 'addMenus'*/
        );
    }

    function activate()
    {
        // Executed every time plugin is Enabled
    }

    function deactivate()
    {
        // Executed every time plugin is disabled
    }


    public function addWidgets()
    {
        Piwik_AddWidget('Visites par profil', 'Répartition par profil', 'ProfiledVisits', 'getProfiledVisits');
        Piwik_AddWidget('Applications de l\'ENT', 'Applications les plus utilisées', 'ProfiledVisits', 'getApplisGlobal');
    }

}