<?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */
namespace Piwik\Plugins\ProfiledVisits;

use Piwik\Period;
use Piwik\Period\Range;
use Piwik\DataTable;
use Piwik\DataTable\Row;
use Piwik\Site;
use Piwik\Config;
use Piwik\Db;

/**
 * API for plugin ProfiledVisits
 *
 * @method static \Piwik\Plugins\ProfiledVisits\API getInstance()
 */
class API extends \Piwik\Plugin\API
{

    /**
     * Method to get stats by users profiles
     * 
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getUsersprofiles($idSite, $period, $date, $segment = false)
    {
        $table = new DataTable();

        $period = Period\Factory::makePeriodFromQueryParams(Site::getTimezoneFor($idSite), $period, $date);
        //$period->setDefaultEndDate($date);

        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/

        $profils = array(
                    'National_1'=>'Élève',
                    'National_2'=>'Responsable',
                    'National_3'=>'Enseignant',
                    'National_4'=>'Personnel de direction',
                    'National_5'=>'Personnel vie scolaire',
                    'National_6'=>'Personnel administratif',
                    'National_7'=>'Autre');

        
        foreach($profils as $pr=>$lib)
        {
            $queryP = "SELECT COUNT(*) as nb_visits FROM piwik_log_visit WHERE
                        idsite = ? AND visit_first_action_time >= ? AND visit_last_action_time <= ? AND custom_var_v3 = ?";
            $hitsP = Db::fetchAll($queryP, array($idSite,$dateStart." 00:00:00", $dateEnd." 23:59:59", $pr));
            $hp = $hitsP[0]['nb_visits'];
            $v = new Row(array(Row::COLUMNS => array('label'=> $lib, 'nb_visits'=>$hp),));
            $table->addRow($v);
        }
        
        $table->filter('ExcludeLowPopulation', array('nb_visits', 1));
        return $table;
    }

    /**
     * Method to get stats of used applications in global
     * 
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsutilisees($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false,false);
    }


    /**
     * Method to get stats of used applications by students
     *
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsEleves($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false, 'National_1');
    }


    /**
     * Method to get stats of used applications by teachers
     *
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsEnseignants($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false, 'National_3');
    }


    private function getApps($idSite, $period, $date, $segment = false, $profile = false)
    {
        $table = new DataTable();

        $period = Period\Factory::makePeriodFromQueryParams(Site::getTimezoneFor($idSite), $period, $date);
        //$period->setDefaultEndDate($date);

        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/

        $listApps = array(
            'wordpress',
            'etherpad',
            'opensondage',
            'sap',
            'spip',
            'envolemobile',
            'calendrier',
            'cdc',
            'grr',
            'gepi',
            'ajaxplorer',
            'cdt',
            'owncloud',
            'desktop',
            'piwigo',
            'envole',
            'xdesktop',
            'fluxbb',
            'gestionprofil',
            'dokuwiki',
            'roundcube',
            'taskfreak');

        foreach($listApps as $actionArray){
            $actionName = $actionArray;
            $cQuery = "SELECT COUNT(DISTINCT(piwik_log_link_visit_action.idvisit)) as nb_visits
                        FROM piwik_log_link_visit_action
                        LEFT JOIN piwik_log_visit ON piwik_log_visit.idvisit=piwik_log_link_visit_action.idvisit
                        WHERE piwik_log_visit.idsite = ? AND piwik_log_visit.visit_first_action_time > ? AND piwik_log_visit.visit_last_action_time < ?
                        AND piwik_log_link_visit_action.custom_var_v1 = ?";

            if ($profile AND in_array($profile, array('National_1','National_3')))
            {
                $cQuery.= " AND piwik_log_visit.custom_var_v3 = ?";
                $cActions = Db::FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $actionName, $profile));
            }else
            {
                $cActions = Db::FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $actionName));
            }


            $nb = $cActions[0]['nb_visits'];
            
            $v = new Row(array(Row::COLUMNS => array('label'=> $actionName, 'nb_visits'=>$nb),));
            $table->addRow($v);
        }
        
        $table->filter('ExcludeLowPopulation', array('nb_visits', 1));
        return $table;
    }
}
