(function () {
    // Récupérer les paramètres passés dans le src du script
    function getScriptParams() {
        var scripts = document.getElementsByTagName('script');
        var myScript = scripts[scripts.length - 1];
        var src = myScript.src;
        var params = {};
        if (src.indexOf('?') > -1) {
            var query = src.split('?')[1];
            query.split('&').forEach(function (part) {
                var item = part.split('=');
                params[decodeURIComponent(item[0])] = decodeURIComponent(item[1] || '');
            });
        }
        return params;
    }

    var params = getScriptParams();
    params.route = window.location.href;

    // Construire l'URL relative du PHP (même dossier que le script JS)
    var phpUrl = '/sondepiwik/sonde.php';

    // Ajout des paramètres passés au script
    var urlParams = new URLSearchParams(params).toString();
    if (urlParams.length > 0) {
        phpUrl += '?' + urlParams;
    }

    // Faire la requête AJAX vers le PHP
    fetch(phpUrl, {
        method: 'GET',
        credentials: 'include'  // pour envoyer les cookies (ex : session PHP)
    })
        .then(function (response) {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.text();
        })
        .then(function (text) {
            console.log('Réponse du serveur sonde:', text);

            // Optionnel : si tu veux appeler une fonction globale callback passée en paramètre
            if (params.callback && typeof window[params.callback] === 'function') {
                window[params.callback](text);
            }
        })
        .catch(function (err) {
            console.error('Erreur sonde:', err);
        });

})();
