<?
	
	// On vérifie si le php est executé en ligne de commande
	if(!is_null($argv)) {
		$param=array('key'=>$argv[2]);
	}

	$PATH="../";
	include_once($PATH."include/include.php");
	include_once($PATH."include/admin.php");															/* Page Admin		*/

	include_once($PATH."include/limesurvey.php");
    include_once($PATH."include/synchronisation.php");

	if($_SESSION['user_login']!="UserCron") include_once($PATH.$config["templatedir"]."/html.php");		/* Entete HTML		*/
	if($_SESSION['user_login']!="UserCron") include_once($PATH.$config["templatedir"]."/frame.php");	/* Entete HTML		*/

	$dbprf1=new ps_db;

	
	$q = "SELECT * FROM admin_limesurvey WHERE id=1";
	$dbprf1->query($q);
	if(!$dbprf1->next_record()) {
		AfficheLigne("ERREUR - Parametrage de synchronisation manquant");
		die();
	}

    function frmshell($string) {
        //return str_replace(" ","___","\\".$string."\\");
        return '"'. str_replace('"',"'",$string).'"';
    }
    function frmemail($string) {
        if($string=="") return "nomail@nomail.fr";
        else return frmshell($string);
    }

	$synchro_classe 	= $dbprf1->f("synchro_classe");
	$synchro_niveau 	= $dbprf1->f("synchro_niveau");
	$synchro_groupe 	= $dbprf1->f("synchro_groupe");
	$synchro_option 	= $dbprf1->f("synchro_option");

	// le type de recherche à éffectuer dans le ldap
	$types = array('Classe' => $synchro_classe, 'Niveau' => $synchro_niveau, 'Groupe' => $synchro_groupe, 'Option' => $synchro_option);

	if($synchro_classe || $synchro_niveau || $synchro_groupe || $synchro_option){
		// Connexion LDAP
		$ds = ldap_connect($config['LDAPserver'], $config['LDAPport']);
		if (!$ds) {
			AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
			die();
		}

        ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
        ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);

        if($config['LDAPtls']) {
            ldap_start_tls($ds);
        }
                
		$r=ldap_bind($ds,$config['LDAPreaderdn'],$config['LDAPreaderpw']);	
		if(!$r) {
			AfficheLigne("ERREUR - login impossible sur l'annuaire LDAP");
			die();
		}

		// Définition du fichier ou se trouve la liste des requêtes d'invitations
		$fic = "/var/www/html/limesurvey/application/config/ldap-invitations-posh-profil.php";

		// Supprimer le fichier fichier
		if(file_exists($fic)) unlink ($fic);

		// Ouvrir le fichier en écriture
		$fp = fopen ($fic, "w");
		if (!$fp){
			AfficheLigne("Erreur : impossible d'écrire dans le fichier '$fic'");
			return;
		}

		fputs ($fp, "<?php\n\n");

		foreach($types as $key => $value){
			// Inscrire la liste des classes dans le fichier
			if($value > 0){
				AfficheLigne("");
				AfficheTitre("SYNCHRONISATION $key");
				$res = ldap_search($ds,$config['LDAPracine'], 'type='.$key);
				for ($entryID=ldap_first_entry($ds,$res);$entryID!=false;$entryID=ldap_next_entry($ds,$entryID))
				{
					// Nom de la classe, du niveau, du groupe ou de l'option
					$lg = ldap_get_values($ds,$entryID,'cn');
					$nom = $lg[0];

					AfficheLigne("$nom : ajouté(e) dans la liste des Requêtes LDAP");

					// Ecrire dans le fichier
					fputs ($fp, "\$ldap_queries[\$query_id]['ldapServerId'] = 0;\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['name'] = '$key $nom';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['groupbase'] = '" . $config['LDAPracine'] ."';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['groupfilter'] = '(&(type=$key)(cn=$nom))';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['groupscope'] = 'sub';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['groupmemberattr'] = 'memberuid';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['groupmemberisdn'] = false;\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['useridattr'] = 'uid';\n");

					fputs ($fp, "\$ldap_queries[\$query_id]['userbase'] = '" . $config["LDAPracine"] ."';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['userfilter'] = '(objectclass=*)';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['userscope'] = 'sub';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['firstname_attr'] = 'givenname';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['lastname_attr'] = 'sn';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['email_attr'] = 'mail';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['token_attr'] = '';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['language'] = '';\n");
                    fputs ($fp, "\$ldap_queries[\$query_id]['attr1'] = 'divcod';\n");
					fputs ($fp, "\$ldap_queries[\$query_id]['attr2'] = '';\n");
					fputs ($fp, "\$query_id++;\n\n");
				}
			}
		}
		fputs ($fp, "?>");
		// Fermer le flux fichier
		fclose($fp);

        $dblime=new ps_db;
        $dblime->dbname($config["limesurveyhost"],"limesurvey",$config["limesurveypwd"],"limesurvey");

        // Génération des utilisateurs
        AfficheLigne("");
        AfficheTitre("CREATION DES UTILISATEURS MANQUANTS");
        $lstUser=listeUtilisateurs("Base","tout");
        $tbhave=[];
        foreach($lstUser as $tbuser) {
            array_push($tbhave,$tbuser["uid"]);
            //AfficheLigne("php /var/www/html/limesurvey/application/commands/console.php AddUser ".frmshell($tbuser["uid"])." ".frmemail($tbuser["mail"])." ".frmshell($tbuser["prenom"])." ".frmshell($tbuser["nom"]));
            $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php AddUser ".frmshell($tbuser["uid"])." ".frmemail($tbuser["mail"])." ".frmshell($tbuser["prenom"])." ".frmshell($tbuser["nom"]));
            if($output) AfficheLigne($output);
        }

        AfficheLigne("");
        AfficheTitre("SUPPRESSION DES UTILISATEURS OBSOLETES");
		$dblime->query("SELECT users_name FROM lime_users WHERE users_name!='admin' AND users_name!= 'restuser'");
        while($dblime->next_record()) {
            if(!in_array($dblime->f("users_name"),$tbhave)) {
                AfficheLigne($dblime->f("users_name")." = SUPPRESSION");
                $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php DeleteUser ".frmshell($dblime->f("users_name")));
            }
        }

        AfficheLigne("");
        AfficheTitre("CREATION DES GROUPES MANQUANTS");
        $lstGroupe=listeGroupes(array("Base","Classe","Equipe","Groupe","Option"));
        $tbhavegroup=[];
        foreach($lstGroupe as $groupe) {
            if($groupe["type"]=="Base" && $groupe["id"]=="tout") continue;
            $name="";
            switch($groupe["type"]) {
                case "Base": $name="PROFIL - ".$groupe["label"]; break;
                case "Classe": $name="CLASSE - ".$groupe["label"]; break;
                case "Equipe": $name="EQUIPE - ".$groupe["label"]; break;
                case "Option": $name="OPTION - ".$groupe["label"]; break;
                case "Groupe": $name="GROUPE - ".$groupe["label"]; break;
            }
            if($name!="") {
                array_push($tbhavegroup,$name);
                $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php AddGroup ".frmshell($name));
                if($output) AfficheLigne($output);            

                // Liste des Utilisateurs
                if($groupe["type"]=="Classe"||$groupe["type"]=="Option")
                    $lstUser=listeUtilisateurs($groupe["type"],$groupe["id"],array("eleve"),false);   
                else
                    $lstUser=listeUtilisateurs($groupe["type"],$groupe["id"],array(),false);   

                // Attacher les utilisateurs au groupe
                $tbhaveuser=[];
                foreach($lstUser as $user) {
                    array_push($tbhaveuser,$user["uid"]);
                    $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php AddUserGroup ".frmshell($name)." ".frmshell($user["uid"]));
                    if($output) AfficheLigne($output);            
                }

                // Détacher les utilisateurs au groupe
                $dblime->query("SELECT lime_user_groups.ugid ugid, lime_users.uid uid, name, users_name FROM lime_user_groups,lime_user_in_groups, lime_users  WHERE lime_user_groups.name = '".addslashes($name)."' AND lime_user_groups.ugid=lime_user_in_groups.ugid AND lime_user_in_groups.uid=lime_users.uid");
                while($dblime->next_record()) {
                    if(!in_array($dblime->f("users_name"),$tbhaveuser)) {
                        AfficheLigne($dblime->f("users_name")." >> ".$dblime->f("name")." = DETACHEMENT");
                        $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php DeleteUserGroup ".frmshell($dblime->f("ugid"))." ".frmshell($dblime->f("uid")));
                    }
                }
            }
        }
        
        AfficheLigne("");
        AfficheTitre("SUPPRESSION DES GROUPES OBSOLETES");
		$dblime->query("SELECT name FROM lime_user_groups WHERE name LIKE('PROFIL - %') OR name LIKE('CLASSE - %') OR name LIKE('OPTION - %') OR name LIKE('GROUPE - %')");
        while($dblime->next_record()) {
            if(!in_array($dblime->f("name"),$tbhavegroup)) {
                AfficheLigne($dblime->f("name")." = SUPPRESSION");
                $output = shell_exec("php /var/www/html/limesurvey/application/commands/console.php DeleteGroup ".frmshell($dblime->f("name")));
            }
        } 
                
        AfficheLigne("");
	}

	// Fin HTML
	if($_SESSION['user_login']!="UserCron") echo "</form>";
	if($_SESSION['user_login']!="UserCron") echo "</body>";
	if($_SESSION['user_login']!="UserCron") echo "</html>";
	?>
