# -*- coding:utf-8 -*-
import sys
from os.path import isfile, join
from configobj import ConfigObj


conffile = "/etc/arv/arv.conf"
config = ConfigObj(conffile)
try:
    config = ConfigObj(conffile)
except Exception, e:
    print "ERROR: --- unable to load configuration file ---"
    sys.exit(1)

ip_sep = '| '
# configuration file
# internale sqlite database
sw_database_mode = config.get('sw_database_mode', 'non')
sqlite_database = config.get('sqlite_database', '/var/lib/arv/db/sphynxdb.sqlite')
ipsec_conf_file = config.get('ipsec_conf_file', '/etc/ipsec.conf')
ipsec_secrets_file = config.get('ipsec_conf_file', '/etc/ipsec.secrets')
strongswan_database = config.get('strongswan_database', '/etc/ipsec.d/ipsec.db')
ipsec_tmp_path = config.get('ipsec_tmp_path', '/root/tmp/ConfIpsec')
strongswan_tmpconfigs_directory = config.get('strongswan_tmpconfigs_directory',
                                             '/var/lib/arv/nodeconf/')
tmpconfigs_directory_cacerts = join(strongswan_tmpconfigs_directory, 'ipsec.d/cacerts')
tmpconfigs_directory_certs = join(strongswan_tmpconfigs_directory, 'ipsec.d/certs')
tmpconfigs_directory_private = join(strongswan_tmpconfigs_directory, 'ipsec.d/private')
tmpconfigs_ipsec_conf_filename = join(strongswan_tmpconfigs_directory, 'ipsec.conf')
tmpconfigs_ipsec_secrets_filename = join(strongswan_tmpconfigs_directory, 'ipsec.secrets')

vpn_path = config.get('vpn_path', "/home/data/vpn")
arv_address_ip = config.get('arv_address_ip', None)
arv_address_ip_private = config.get('arv_address_ip_private', None)

ssl_dir = config.get('ssl_dir', '/var/lib/arv/CA')
ca_conf_file = config.get('ca_conf_file', '/etc/eole/ssl/ca-sphynx.conf')
conf_file_orig = config.get('conf_file_orig', '/etc/eole/ssl/certif-vpn.conf')
ssl_default_cert_time = config.get('ssl_default_cert_time', '1825')
x509_default_key_bits = config.get('x509_default_key_bits', '2048')
nearly_expired_cred = int(config.get('nearly_expired_cred', 45))

arv_port = int(config.get('arv_port', '8088'))
arv_ssl = config.get('arv_ssl', "enable")
arv_key = config.get('arv_crt', '/etc/ssl/certs/eole.key')
arv_crt = config.get('arv_crt', '/etc/ssl/certs/eole.crt')

arv_static_path = config.get('arv_static_path', '/usr/share/arv/static')

allow_user = config.get('allow_user', None)

log_file = config.get('error_log', '/var/log/arv/error.log')
#log_level: debug, info, warning, error, critical
log_level = config.get('log_level', 'critical')

key2keyid_path = "/usr/sbin/key2keyid"
if not isfile(key2keyid_path):
    raise ValueError("strongswan script %s not found"% key2keyid_path)
id2sql_path = "/usr/sbin/id2sql"
if not isfile(id2sql_path):
    raise ValueError("strongswan script %s not found"% id2sql_path)
bin2sql_path = "/usr/sbin/bin2sql"
if not isfile(bin2sql_path):
    raise ValueError("strongswan script %s not found"% bin2sql_path)

# default values in tables
ChildConfig_lifetime = config.get('ChildConfig_lifetime', 1200)
ChildConfig_rekeytime = config.get('ChildConfig_rekeytime', 1020)
ChildConfig_jitter = config.get('ChildConfig_jitter', 180)
ChildConfig_hostaccess = config.get('ChildConfig_hostaccess', "1")
ChildConfig_mode = config.get('ChildConfig_mode', "2")
#The start_action field (0 = ACTION_NONE/ADD, 1 = ACTION_ROUTE, 2 = ACTION_START/RESTART)
#2 for everyone
start_action = config.get('start_action', "2")
#The dpd_action field (0 = CLEAR, 1 = hold, 2 = START/RESTART)
dpd_action = config.get('dpd_action', "0")
remote_node_dpd_action = config.get('remote_node_dpd_action', "2")
ChildConfig_close_action = config.get('ChildConfig_close_action', "0")
ChildConfig_ipcomp = config.get('ChildConfig_ipcomp', "0")
IkeConfig_certreq = config.get('IkeConfig_certreq', "1")
IkeConfig_force_encap = config.get('IkeConfig_force_encap', "0")
PeerConfig_ike_version = config.get('PeerConfig_ike_version', "2")
PeerConfig_cert_policy = config.get('PeerConfig_cert_policy', "1")
PeerConfig_uniqueid = config.get('PeerConfig_uniqueid', "1")
PeerConfig_auth_method = config.get('PeerConfig_auth_method', "1")
PeerConfig_eap_type = config.get('PeerConfig_eap_type', "0")
PeerConfig_eap_vendor = config.get('PeerConfig_eap_vendor', "0")
PeerConfig_keyingtries = config.get('PeerConfig_keyingtries', 5)
PeerConfig_rekeytime = config.get('PeerConfig_rekeytime', 0)
PeerConfig_reauthtime = config.get('PeerConfig_reauthtime', 3600)
PeerConfig_jitter = config.get('PeerConfig_jitter', 180)
PeerConfig_overtime = config.get('PeerConfig_overtime', 300)
PeerConfig_mobike = config.get('PeerConfig_mobike', "0")
PeerConfig_dpd_delay = config.get('PeerConfig_dpd_delay', 120)
PeerConfig_mediation = config.get('PeerConfig_mediation', "0")
PeerConfig_mediated_by = config.get('PeerConfig_mediated_by', 0)
PeerConfig_peer_id = config.get('PeerConfig_peer_id', 0)
CertificateDistributionPoints_uri = config.get('CertificateDistributionPoints_uri', None)
CACert = config.get('CACert', None)
amon_module_list = config.get('amon_module_list', None)
sphynx_module_list = config.get('sphynx_module_list', None)

### Proposals id table
proposals = {1:'aes128-sha256-modp2048',
             2:'aes192-sha384-modp3072',
             3:'aes128gcm128',
             4:'aes192gcm128'
            }
ike_cfg_proposal = { 1:[(1,1), (2,2)] }
child_cfg_proposal = { 1:[(1,3), (2,4)] }

# On Sphynx 2.2
#proposals = {1:'aes256-sha2_512-modp8192',
#              2:'aes256-sha2_256-modp8192',
#              3:'aes128-sha2_256-modp2048',
#              4:'aes128-sha-modp2048',
#              5:'aes128-sha2_256-modp1536',
#              6:'aes128-sha-modp1536',
#              7:'3des-md5-modp1536',
#              8:'3des-md5-modp1024',
#              9:'3des-sha-modp1536',
#              10:'3des-sha-modp1024',
#              11:'aes256-sha2_512',
#              12:'aes256-sha2_256',
#              13:'aes128-sha2_256',
#              14:'aes128-sha1',
#              15:'3des-md5',
#              16:'3des-sha1'
#             }

#ike_cfg_proposal = { 1:[(1,1), (2,2), (3,3), (4,4), (5,5), (6,6), (7,7), (8,8), (9,9), (10,10)] }
#child_cfg_proposal = { 1:[(1,11), (2,12), (3,13), (4,14), (5,15), (6,16)] }

test_rvp = u"""
#!/bin/bash
# DEB:
#    fping %s
if [ -e /var/lock/subsys/ipsec ]
then
    # Pour EOLE 2.3
    [ -e /usr/share/eole/diagnose/module/152-rvp ] && /usr/share/eole/diagnose/module/152-rvp
    # Pour EOLE 2.4
    [ -e /usr/share/eole/diagnose/152-rvp ] && /usr/share/eole/diagnose/152-rvp
else
    echo "Le tunnel n'est pas actif!"
    exit 2
fi
# FIN:
""" % arv_address_ip_private

ipsec_conf_setup = u"""config setup
    uniqueids = yes
    cachecrls = yes
    strictcrlpolicy = no
"""

# Example :
# ipsec_conf_ca.format(\
#               "RACINE_AGRIATES_CA",\
#               "RACINE AGRIATES.pem",\
#               "http://crl1.igc.education.fr/agriates.crl",\
#               "http://crlr2.igc.education.fr/agriates.crl")
ipsec_conf_ca = u"""ca "{0}"
    cacert = "{1}"
    crluri = {2}
    crluri2 = {3}
    auto=add
"""

# Example :
# ipsec_conf_default.format(\
#                   clear,\
#                   PeerConfig_dpd_delay,\
#                   "aes128-sha256-modp2048,aes192-sha384-modp3072",\
#                   "aes128gcm128,aes192gcm12",\
#                   no,\
#                   no)
ipsec_conf_default = u"""conn %default
    keyingtries = 3
    keyexchange = ike
    authby = pubkey
    dpdaction = {0}
    dpddelay = {1}s
    ike = {2}
    esp = {3}
    forceencaps = {4}
    mobike = {5}
"""

# Example :
# ipsec_conf_connection.format(\
#               "adm_reseau172_1",\
#               "@/C=fr/O=gouv/OU=education/OU=ac-dijon/CN=0210066H-15",\
#               "0210066H-15.pem",\
#               "194.167.19.yyy",\
#               "10.21.11.0/24",\
#               "/etc/ipsec.d/ipsec_updown",\
#               "@/C=fr/O=gouv/OU=education/OU=ac-dijon/CN=AGRIATES-DIJON-10",\
#               "AGRIATES-DIJON-10.pem",\
#               "194.167.18.xxx",\
#               "172.16.0.0/12")
ipsec_conf_connection = u"""#DEB:{0}
conn "{0}"
    leftid = "{1}"
    leftcert = "{2}"
    left = {3}
    leftsubnet = "{4}"
    leftupdown = {5}
    rightid = "{6}"
    right = {7}
    rightsubnet = "{8}"
    auto=start
#FIN:{0}
"""
# Example :
# ipsec_secrets.format(\
#               "/C=fr/O=gouv/OU=education/OU=ac-dijon/CN=AGRIATES-DIJON-10",\
#               "/etc/ipsec.d/private/privAGRIATES-DIJON-10.pem")
ipsec_secrets = u"""#DEB:{0}
: RSA "{1}"
#FIN:{0}
"""

###2.3 to 2.4 correspondence variables
variable24 = {  "adresse_ip_vlan_eth0" : "vlan_ip_eth0",
                "adresse_netmask_vlan_eth0" : "vlan_netmask_eth0",
                "adresse_network_vlan_eth0" : "vlan_network_eth0",
                "adresse_broadcast_vlan_eth0" : "vlan_broadcast_eth0",
                "adresse_gw_vlan_eth0" : "vlan_gw_eth0",
                "id_vlan_eth0" : "vlan_id_eth0",
                "adresse_ip_vlan_eth1" : "vlan_ip_eth1",
                "adresse_netmask_vlan_eth1" : "vlan_netmask_eth1",
                "adresse_network_vlan_eth1" : "vlan_network_eth1",
                "adresse_broadcast_vlan_eth1" : "vlan_broadcast_eth1",
                "adresse_gw_vlan_eth1" : "vlan_gw_eth1",
                "id_vlan_eth1" : "vlan_id_eth1",
                "adresse_ip_vlan_eth2" : "vlan_ip_eth2",
                "adresse_netmask_vlan_eth2" : "vlan_netmask_eth2",
                "adresse_network_vlan_eth2" : "vlan_network_eth2",
                "adresse_broadcast_vlan_eth2" : "vlan_broadcast_eth2",
                "adresse_gw_vlan_eth2" : "vlan_gw_eth2",
                "id_vlan_eth2" : "vlan_id_eth2",
                "adresse_ip_vlan_eth3" : "vlan_ip_eth3",
                "adresse_netmask_vlan_eth3" : "vlan_netmask_eth3",
                "adresse_network_vlan_eth3" : "vlan_network_eth3",
                "adresse_broadcast_vlan_eth3" : "vlan_broadcast_eth3",
                "adresse_gw_vlan_eth3" : "vlan_gw_eth3",
                "id_vlan_eth3" : "vlan_id_eth3",
                "adresse_ip_vlan_eth4" : "vlan_ip_eth4",
                "adresse_netmask_vlan_eth4" : "vlan_netmask_eth4",
                "adresse_network_vlan_eth4" : "vlan_network_eth4",
                "adresse_broadcast_vlan_eth4" : "vlan_broadcast_eth4",
                "adresse_gw_vlan_eth4" : "vlan_gw_eth4",
                "id_vlan_eth4" : "vlan_id_eth4",
                "proxy_eth0_adresse" : "proxy_eth0_ip",
                "proxy_eth0_network" : "proxy_eth0_network",
                "nom_interface1" : "nom_zone_eth1",
                "passerelle_smtp" : "exim_relay_smtp",
                "mail_rewrite_domain" : "exim_qualify_domain" }

###CONSTANTS
NODE_MODIFIED = 1
