
"""Automatically sets the PYTHONPATH before running the unit tests
This is supposed to be used only in development mode
(i.e. testing from a fresh checkout)
"""

from os.path import dirname, abspath, split
import sys

projname = "arv"

here = dirname(abspath(__file__))

def find_root(path, projname):
    "recursively finds the relation name in the path"
    rootpath, basename = split(path)
    if basename == projname:
        return rootpath
    else:
        return find_root(rootpath, projname)

rootpath = find_root(here, projname)
if rootpath not in sys.path:
    sys.path.insert(1, rootpath)
