from arv.db.node import Node, TmplNode, Vertex, TmplVertex, Extremity
from arv.db.edge import Connect, TmplConnect, Edge, TmplEdge, Credential
from arv.lib.util import valid
from sqlalchemy.exc import IntegrityError

def obj_factory(obj_type):
    try:
        obj_type = valid(obj_type, 'string')
    except TypeError, e:
        raise Exception("Error in ret_object: ", str(e))

    objs = {u'node': Node,
            u'tmpl_node': TmplNode,
            u'vertex': Vertex,
            u'tmpl_vertex': TmplVertex,
            u'edge': Edge,
            u'tmpl_edge': TmplEdge,
            u'connect': Connect,
            u'tmpl_connect': TmplConnect,
            u'extremity': Extremity,
            u'credential': Credential,
            #u'crl': Crl,
           }
    #deprecaded has_key: if objs.has_key(obj_type):
    if obj_type in objs:
        return objs[obj_type]
    else:
        raise TypeError('Unkown object type: %s' % obj_type)

def get_object_by_id(obj_id, obj_type):
    try:
        obj_id = valid(obj_id, 'integer')
    except TypeError, e:
        raise Exception("Error in get_object_by_id: ", str(e))
    tobj = obj_factory(obj_type)

    try:
        ret = tobj.query.filter_by(id=obj_id).first()
    except IntegrityError, e:
        if " column name is not unique " in str(e):
            raise Exception("Name should be unique")
        else:
            raise Exception("error in get_object_by_id: %s" % str(e))
    except Exception, e:
        raise Exception("Error in get_object_by_id: ", str(e))

    if ret == None:
        raise Exception("not a valid obj_id %s for %s"%(obj_id, obj_type))
    return ret
