# this test is not much to test the database itself
# rather than testing that **it exists**

import autopath
from os.path import join
from os import unlink
from elixir import *
from arv.lib.edge import *

datadir = join(autopath.here, 'data')
db = join(datadir, "db.sqlite")
metadata.bind = "sqlite:///"+db

def setup_module(module):
    setup_all()
    create_all()

def commit_database():
    session.commit()
    session.flush()

def test_add_tmpl_node():
    tmplnode = add_tmpl_node(name=u"trial")
    commit_database()

def test_add_tmpl_vertex():
    tmplnode = add_tmpl_node(name=u"trial2")
    tmplvertex = tmplnode.add_tmpl_vertex(name=u'admin')
    commit_database()

def test_add_tmpl_connect():
    tmplnode1 = add_tmpl_node(name=u"trial3")
    tmplvertex1 = tmplnode1.add_tmpl_vertex(name=u'admin1')

    tmplnode2 = add_tmpl_node(name=u"trial4")
    tmplvertex2 = tmplnode2.add_tmpl_vertex(name=u'net1')

    tmplconnect = add_tmpl_connect(u"connect1", tmplnode1, tmplnode2)
    commit_database()

def test_add_tmpl_edge():
    tmplnode1 = add_tmpl_node(name=u"trial5")
    tmplvertex1 = tmplnode1.add_tmpl_vertex(name=u'admin2')

    tmplnode2 = add_tmpl_node(name=u"trial6")
    tmplvertex2 = tmplnode2.add_tmpl_vertex(name=u'net2')

    tmplconnect = add_tmpl_connect(u"connect2", tmplnode1, tmplnode2)
    tmplconnect.add_tmpl_edge(u"edge1", tmplvertex1, tmplvertex2)
    commit_database()

def test_node():
    tmplnode1 = add_tmpl_node(name=u"trial7")
    tmplnode1.add_node(u"etab1")
    commit_database()

def test_vertex():
    tmplnode1 = add_tmpl_node(name=u"trial8")
    tmplvertex1 = tmplnode1.add_tmpl_vertex(name=u'admin3')
    node_a = tmplnode1.add_node(u"college_trial")
    tmplvertex1.add_vertex(ip=u"192.168.230.10", node=node_a)
    commit_database()

def test_add_connect():
    tmplnode1 = add_tmpl_node(name=u"trial9")
    tmplvertex1 = tmplnode1.add_tmpl_vertex(name=u'admin4')

    node1 = tmplnode1.add_node(u"college_one")

    tmplnode2 = add_tmpl_node(name=u"trial10")
    tmplvertex2 = tmplnode2.add_tmpl_vertex(name=u'net14')

    node2 = tmplnode2.add_node(u"college_two")

    cred1 = node1.add_credential(u"oiqsoi", u"AzErTyUiOP")
    cred2 = node2.add_credential(u"oqii", u"AzErTyUiOPqsDfG")

    extr1 = node1.add_extremity(u'194.10.2.13')
    extr2 = node2.add_extremity(u'194.10.2.14')

    tmplconnect = add_tmpl_connect(u"connect3", tmplnode1, tmplnode2)
    tmplconnect.add_connect(tail_node=node1, head_node=node2, tail_cred=cred1, head_cred=cred2, tail_extr=extr1, head_extr=extr2)
    commit_database()

def test_add_edge():
    tmplnode1 = add_tmpl_node(name=u"trial11")
    tmplvertex1 = tmplnode1.add_tmpl_vertex(name=u'admin5')

    node1 = tmplnode1.add_node(u"college_one1")

    tmplnode2 = add_tmpl_node(name=u"trial12")
    tmplvertex2 = tmplnode2.add_tmpl_vertex(name=u'net15')

    node2 = tmplnode2.add_node(u"college_two1")

    cred1 = node1.add_credential(u"oiqsoi2", u"AzErTyUiOPpiodf")
    cred2 = node2.add_credential(u"oqii2", u"AzErTyUiOPqsDfGpiod")

    extr1 = node1.add_extremity(u'194.10.2.15')
    extr2 = node2.add_extremity(u'194.10.2.16')

    tmplconnect = add_tmpl_connect(u"connect4", tmplnode1, tmplnode2)
    tmpledge = tmplconnect.add_tmpl_edge(u"edge2", tmplvertex1, tmplvertex2)
    buf_connect = tmplconnect.add_connect(tail_node=node1, head_node=node2, tail_cred=cred1, head_cred=cred2, tail_extr=extr1, head_extr=extr2)
    tmpledge.add_edge(buf_connect)
    commit_database()

def teardown_module(module):
    unlink(db)




