# coding: utf-8
import xmlrpclib
from os.path import isfile
try:
    from zephir.zephir_conf.zephir_conf import id_serveur, adresse_zephir
    ZEPHIR = True
except:
    ZEPHIR = False
from arv.config import variable24, amon_module_list, sphynx_module_list
from arv.lib.util import trace
from arv.lib.logger import logger

ZEPHIR_PERM_CODE = 7
ZEPHIR_MODULE_VERSION = 5

class Zephir:
    @trace(hide_args=[2], hide_kwargs=['password'])
    def __init__(self, user, password):
        try:
            self.zephir = xmlrpclib.ServerProxy('https://%s:%s@%s:7080'%(user, password, adresse_zephir))
            #test connection
            perm = self.zephir.get_permissions(user)
            if perm[0] != 1 or ZEPHIR_PERM_CODE not in perm[1]:
                raise Exception('Unable to connect to Zéphir')
        except:
            raise Exception('Unable to connect to Zéphir')

    @trace()
    def dict_eole_version(self, module_list):
        resp_code, modules = self.zephir.modules.get_module()
        module_eole_version = {}
        if resp_code == 1:
            for module in modules:
                if module['libelle'] in module_list:
                    eole_version = ""
                    if "2.3" in module['libelle']:
                        eole_version = "2.3"
                    elif "2.4" in module['libelle']:
                        eole_version = "2.4"
                    module_eole_version[module['id']] = eole_version
            if module_eole_version == {}:
                raise Exception("Unable to get module 'amon-2.3' from Zéphir")
        else:
            raise Exception('Unable to get modules from Zéphir')
        return module_eole_version

    @trace()
    def get_amons(self):
        try:
            ret = []
            module_eole_version = self.dict_eole_version(amon_module_list)
            servers = []
            for module in module_eole_version:
                servers.extend(self.get_etab_module_servers(module))
            if servers != []:
                for amon in servers:
                    rne = amon['rne']
                    libelle = amon['libelle']
                    id_zephir = amon['id']
                    eole_version = module_eole_version[amon['module_actuel']]
                    if type(rne) == unicode:
                        rne = unicode.encode(rne, "utf-8")
                    if type(libelle) == unicode:
                        libelle = unicode.encode(libelle, "utf-8")
                    logger.debug("#-> amon {0} - {1}".format(libelle, rne))
                    ret.append((libelle, rne, id_zephir, eole_version, u'etablissement'))
            return ret
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_sphynxs(self):
        try:
            ret = []
            module_eole_version = self.dict_eole_version(sphynx_module_list)
            servers = []
            for module in module_eole_version:
                servers.extend(self.get_etab_module_servers(module))
            if servers != []:
                for sphynx in servers:
                    rne = sphynx['rne']
                    libelle = sphynx['libelle']
                    id_zephir = sphynx['id']
                    eole_version = module_eole_version[sphynx['module_actuel']]
                    if type(rne) == unicode:
                        rne = unicode.encode(rne, "utf-8")
                    if type(libelle) == unicode:
                        libelle = unicode.encode(libelle, "utf-8")
                    logger.debug("#-> sphynx {0} - {1}".format(libelle, rne))
                    ret.append((libelle, rne, id_zephir, eole_version, u'sphynx'))
            return ret
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_modules(self):
        try:
            ret = []
            tmodules = self.zephir.modules.get_module()
            if tmodules[0] != 1:
                raise exception('error: unable to get data from zéphir')
            logger.debug('zephir get_module : %s' % str(tmodules[1]))
            for module in tmodules[1]:
                if module['version'] == ZEPHIR_MODULE_VERSION:
                    name = module['libelle'].split('-')[0]
                    ret.append({'name': name, 'moduleid': module['id']})
            return ret
        except:
            raise Exception('Error: unable to get data from Zéphir')
    @trace()
    def get_module(self, module):
        try:
            server = None
            tmodules = self.get_modules()
            logger.debug('got the tmodules: ' +str(tmodules))
            for tmodule in tmodules:
                if tmodule['name'] == module:
                    return tmodule
            return None
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_etab_module(self, uai, name, module_id):
        try:
            tserver = self.zephir.serveurs.groupe_serveur({
                'rne': uai,
                'libelle':name,
                'module_actuel': module_id
            })
            if tserver[0] != 1:
                raise Exception('Error: unable to get data from Zéphir')
            if tserver[1] == []:
                return None
            return tserver[1][0]
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_etab_server(self, uai=None, name=None, id_server=None):
        try:
            if id_server == None:
                tserver = self.zephir.serveurs.groupe_serveur({
                    'rne': uai,
                    'libelle':name
                })
            else:
                tserver = self.zephir.serveurs.get_serveur(id_server)
            if tserver[0] != 1:
                raise Exception('Error: unable to get data from Zéphir')
            if tserver[1] == []:
                return None
            return tserver[1][0]
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_etab_module_servers(self, module_id):
        try:
            tserver = self.zephir.serveurs.groupe_serveur({'module_actuel': module_id})
            if tserver[0] != 1:
                raise Exception('Error: unable to get data from Zéphir')
            return tserver[1]
        except:
            raise Exception('Error: unable to get data from Zéphir')

    @trace()
    def get_var(self, uai, name, var, module=None):
        try:
            server = self.get_etab_server(uai, name)
            if server != None:
                sid = server['id']
                vars = self.zephir.serveurs.get_config(sid)

                if vars[0] != 1:
                    logger.debug("No variables for this server")
                    raise Exception('Error: unable to get data from Zéphir')
                else:
                    if var in vars[1]:
                        # use 2.3 variable name
                        var_name = var
                    elif variable24[var] in vars[1]:
                        # use 2.4 variable name
                        var_name = variable24[var]
                        logger.debug("Try 2.4 variable name : {0} --> {1}".format(str(var), str(var_name)))
                    else:
                        # var does not exist for this server
                        logger.debug("No variable named {0} for this server".format(str(var)))
                        return None
                if "[" in var_name:
                    # Variable multi
                    tmpvar = var_name.split('[')
                    var_name = str(tmpvar[0])
                    index = int(str(tmpvar[1]).split(']')[0])
                    var_list = vars[1][var_name].split('| ')
                    if index > len(var_list)-1 :
                        return None
                    else:
                        return var_list[index].strip()
                return vars[1][var_name]
            return None
        except:
            logger.debug("No variable {0} for this server".format(str(var)))

    @trace()
    def get_variables(self, module):
        try:
            ret=[]
            variables = self.zephir.modules.get_vars(module)
            if variables[0] != 1:
                raise exception('error: unable to get variables from Zéphir for %s' % module)
            logger.debug('zephir variables for %s: %s' % (module, str(variables)))
            for variable in variables[1].keys():
                ret.append({'name': variable})
            return ret
        except:
            import traceback
            traceback.print_exc()
            raise Exception('Error: unable to get variable from Zéphir')

    @trace()
    def send_db(self, archive, uai, name, id_zephir):
        if not isfile(archive):
            raise Exception('Error: unable to find VPN archive')
        try:
            f = open(str(archive), 'rb')
            str_obj = xmlrpclib.base64.encodestring(f.read())
            f.close()
            server = self.get_etab_server(uai, name, id_zephir)
            logger.debug("#-> server " + str(server))
            if server != None:
                server_id = int(server['id'])
                server_module = server['module_actuel']
                logger.debug("#-> Server module_id {0}".format(str(server_module)))
                sphynx_module = self.get_module('sphynx')['moduleid']
                logger.debug("#-> Sphynx module_id {0}".format(str(sphynx_module)))
                logger.debug("#-> server id {0}".format(server_id))
                res = self.zephir.uucp.sphynx_add(id_serveur, server_id, str_obj)
                if res[0] != 1:
                    raise Exception("unable to send data to zephir : %s" % str(res[1]))
            else:
                logger.debug("No serveur {0} {1} on Zéphir".format(str(uai), str(name)))
        except:
            import traceback
            traceback.print_exc()
            raise Exception('Error: unable to send data to zephir')
