/*
 *
 *
 */

Ext.namespace("ARV");

ARV.addnode2 = (function() {
    /*
     * Public
     */
    var connectstore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name : 'connect'},
            {name : 'id'},
        ]),
        url: 'arv/get_connects',
    });
    var connect_grid = new ARV.GridPanel({
        store: connectstore,
        columns: [
            {header: Ext.i18n.connect_window, sortable: true, dataIndex: 'connect'},
            {header: 'ID', sortable: true, dataIndex: 'id', hidden: true}
        ],
        deleteUrl: 'arv/del_connect',
        btnAddEvent: 'addmodconnect',
        btnModEvent: 'modifconnect',
        btnDelEvent: 'changemodconnect'
    });

    var connectwin = new ARV.PopupWindow({
        title: Ext.i18n.connect_window,
        items: [connect_grid],
        bbar: ['->', {
            text: Ext.i18n.exit,
            handler: function(){
                ARV.observable.fireEvent('treenode1changed');
                connectwin.hide()
            }
        }]
    });

    return {
        openWindow: function(node_a_id, node_a_name, node_b_id, node_b_name, connect_id){
            var create_extrwindow = function(id) {
                form = {
                    xtype: 'form',
                    id: 'extremity_form',
                    bbar: [{
                        text: Ext.i18n.save,
                        handler: function(btn, ev) {
                            Ext.getCmp('extremity_form').getForm().submit({
                                url: 'arv/add_extremity',
                                params: {id: id},
                                //waitMsg: Ext.i18n.dialog_submit,
                                success: function(){
                                    winaddextremity.destroy()
                                }
                            });
                        },
                        scope: this
                    }, '-', {
                        text: Ext.i18n.cancel,
                        handler: function(btn, ev) {
                        winaddextremity.destroy()
                        },
                        scope: this
                    }],
                    items: [{
                        xtype: "textfield",
                        fieldLabel: Ext.i18n.addextremity_pub_ip,
                        width: 150,
                        name: 'pub_ip',
                        allowBlank:false
                    },{
                        xtype: "textfield",
                        fieldLabel: Ext.i18n.addextremity_priv_ip,
                        width: 150,
                        name: 'priv_ip',
                    }],
                };
                var winaddextremity = new ARV.PopupWindow({
                    title: Ext.i18n.addnode2_title,
                    items: [form]
                }).show();
            };

            var edges_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'tmplvertex1'},
                    {name : 'tmplvertex2'},
                    {name : 'activate'},
                ]),
                url: 'arv/get_tmpl_edges'
            });

            //var tmplconnect_store = new Ext.data.Store({
            //    reader: new Ext.data.JsonReader({
            //        root :'data',
            //        successProperty: 'success',
            //    },[
            //        {name : 'tmplconnect'},
            //        {name : 'id'},
            //    ]),
            //    url: 'arv/get_tmpl_connects'
            //});

            Ext.apply(Ext.form.VTypes, {
                IPAddress:  function(v) {
                    return /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(v);
                },
                IPAddressText: 'Must be a numeric IP address',
                IPAddressMask: /[\d\.]/i
            });

            var ipeditor = new Ext.grid.GridEditor(
                new Ext.form.TextField({vtype: 'IPAddress'}), {}
            );

            var activate_edges_column = new Ext.grid.CheckboxColumn({
                header: '<div class="x-grid3-hd-checker">&#160;</div>',
                dataIndex: 'activate',
                width:40
            });

            var cardcontent = [{
                id: 'card-0',
                xtype: 'form',
                border: false,
                items: [{
                    xtype: "arvcombo",
                    id: 'node2',
                    fieldLabel: Ext.i18n.addnode2_node,
                    record: [
                        {name : 'node'},
                        {name : 'id'},
                    ],
                    baseParams: {id: node_a_id},
                    url: 'arv/get_nodes',
                    autoLoad: false,
                    displayField: 'node',
                    listen: {
                        'load': function(store, records, option){
                            if (records.length != 0) {
                                Ext.getCmp('node2').setValue(records[0].get('id'));
                            }
                        }
                    }
                }],
            },{
                id: 'card-1',
                xtype: 'form',
                items: [{
                    xtype: "arvcombo",
                    id: 'tmplconnect',
                    fieldLabel: Ext.i18n.addnode2_tmplconnect,
                    record: [
                        {name : 'tmplconnect'},
                        {name : 'id'},
                    ],
                    url: 'arv/get_tmpl_connects',
                    autoLoad: false,
                    displayField: 'tmplconnect',
                    listen: {
                        'load': function(store, records, option){
                            if (records.length != 0) {
                                Ext.getCmp('tmplconnect').setValue(records[0].get('id'));
                            }
                        }
                    }
                }]
             }, {
                id: 'card-2',
                border: false,
                xtype: 'form',
                items: [{
                    xtype: 'label',
                    html: '<b>'+node_a_name+'</b>',
                },{
                    layout: 'column',
                    border: false,
                    items:[{
                        columnWidth: .9,
                        layout: 'form',
                        border: false,
                        items: [{
                            xtype: "arvcombo",
                            id: 'cred1',
                            fieldLabel: Ext.i18n.addnode2_cred,
                            record: [
                                {name : 'id'},
                                {name : 'cred'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_cred',
                            autoLoad: false,
                            displayField: 'cred',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('cred1').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth: .1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modcred.openCredWindow(node_a_id, Ext.getCmp('cred1').store);
                            }
                        }]
                    }]
                }, {
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'extr1',
                            fieldLabel: Ext.i18n.addnode2_extr,
                            record: [
                                {name : 'id'},
                                {name : 'extr'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_extr',
                            autoLoad: false,
                            displayField: 'extr',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('extr1').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth:.1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modextip.openIPWindow(
                                    node_a_id,
                                    'extrip_node2_changed'
                                );
                            }
                        }]
                    }]
                }, {
                    xtype: 'label',
                    border: false,
                    id: 'node2_label'
                },{
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'cred2',
                            fieldLabel: Ext.i18n.addnode2_cred,
                            record: [
                                {name : 'id'},
                                {name : 'cred'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_cred',
                            autoLoad: false,
                            displayField: 'cred',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('cred2').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth: .1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modcred.openCredWindow(Ext.getCmp('node2').getValue(), Ext.getCmp('cred2').store);
                            }
                        }]
                    }]
                }, {
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'extr2',
                            fieldLabel: Ext.i18n.addnode2_extr,
                            record: [
                                {name : 'id'},
                                {name : 'extr'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_extr',
                            autoLoad: false,
                            displayField: 'extr',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('extr2').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth:.1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modextip.openIPWindow(
                                    Ext.getCmp('node2').getValue(),
                                    'extrip_node2_changed'
                                );
                            }
                        }]
                    }]
                }]
            }, {
                id: 'card-3',
                xtype: 'grid',
                border: true,
                layout: 'fit',
                plugins: activate_edges_column,
                store: edges_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
                        activate_edges_column,
                        {id: 'tmplvertex1', header: Ext.i18n.tmplvertex1, sortable: true, dataIndex: 'tmplvertex1', width: '200px'},
                        {id: 'tmplvertex2', header: Ext.i18n.tmplvertex2, sortable: true, dataIndex: 'tmplvertex2', width: '200px'},
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,

            }];

            var nbcard = 0;
            var navHandler = function(incr){
                var l = Ext.getCmp('addnode2-wizard-panel').getLayout();
                var i = l.activeItem.id.split('card-')[1];
                var next = parseInt(i) + incr;
                switch (next) {
                    case 0:
                        //choisir un serveur RVP
                        Ext.getCmp('button-addnode2').disable();
                    break;
                    case 1:
                        //choisir un modèle de lien sécurisé
                        idnode2 = Ext.getCmp('node2').getValue();
                        if (idnode2 == '') {
                            error_msg(Ext.i18n.field_empty)
                            return;
                        };
                        Ext.getCmp('button-addnode2').disable();
                        tmplconnect_store = Ext.getCmp('tmplconnect').store;
                        tmplconnect_store.removeAll();
                        tmplconnect_store.baseParams={
                            node_a_id: node_a_id,
                            node_b_id: idnode2
                        };
                        tmplconnect_store.load();
                    break;
                    case 2:
                        //Certificats + IPs
                        Ext.getCmp('button-addnode2').disable();
                        if (connect_id == null) {
                            idtmplconnect = Ext.getCmp('tmplconnect').getValue();
                            if (idtmplconnect == '') {
                                error_msg(Ext.i18n.field_empty);
                                return;
                            };
                        } else {
                            idtmplconnect = null;
                        }
                        Ext.getCmp('node2_label').setText('<b>'+Ext.getCmp('node2').getRawValue()+'</b>', false);
                        extr1_store = Ext.getCmp('extr1').store;
                        extr1_store.removeAll();
                        if (connect_id == null) {
                            extr1_store.baseParams={node: node_a_id};
                        } else {
                            extr1_store.baseParams={node: node_a_id, connect_id: connect_id};
                        }
                        extr1_store.load();
                        extr2_store = Ext.getCmp('extr2').store;
                        extr2_store.removeAll();
                        if (connect_id == null) {
                            extr2_store.baseParams={node: Ext.getCmp('node2').getValue()};
                        } else {
                            extr2_store.baseParams={node: node_b_id, connect_id: connect_id};
                        }
                        extr2_store.load();
                        //load credential with connect (if modification) or
                        //tmpl_connect (if new connect)
                        cred1_store = Ext.getCmp('cred1').store;
                        cred1_store.removeAll();
                        if (connect_id == null) {
                            cred1_store.baseParams={
                                node: node_a_id,
                                tmplconnect_id: idtmplconnect
                            }
                        } else {
                            cred1_store.baseParams={
                                node: node_a_id,
                                connect_id: connect_id
                            }
                        };
                        cred1_store.load();
                        cred2_store = Ext.getCmp('cred2').store;
                        cred2_store.removeAll();
                        if (connect_id == null) {
                            cred2_store.baseParams={
                                node: Ext.getCmp('node2').getValue(),
                                tmplconnect_id: idtmplconnect
                            }
                        } else {
                            cred2_store.baseParams={
                                node: Ext.getCmp('node2').getValue(),
                                connect_id: connect_id
                            }
                        };
                        cred2_store.load();
                    break;
                    case 3:
                        //modèle de réseau -> modèle de réseau
                        extr1 = Ext.getCmp('extr1').getValue();
                        extr2 = Ext.getCmp('extr2').getValue();
                        cred1 = Ext.getCmp('cred1').getValue();
                        cred2 = Ext.getCmp('cred2').getValue();
                        if ((cred1 == '') || (cred2 == '') || (extr1 == '') || (extr2 == '')) {
                            error_msg(Ext.i18n.field_empty)
                            return;
                        };
                        Ext.getCmp('button-addnode2').enable();
                        edges_store.removeAll();
                        edges_store.baseParams={}
                        if (idtmplconnect != null) {
                            edges_store.baseParams['id'] = idtmplconnect
                        };
                        if (connect_id != null) {
                            edges_store.baseParams['connect_id'] = connect_id;
                        };
                        edges_store.load();
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                if (node_b_id == null) {
                    Ext.getCmp('card-prev').setDisabled(next==0);
                } else {
                    Ext.getCmp('card-prev').setDisabled(next==2);
                };
                Ext.getCmp('card-next').setDisabled(next==3);

            };

            if (connect_id == null) {
                //if new connect
                nbcard = 0
                var wizard_ok_button = {
                    id: 'button-addnode2',
                    text: Ext.i18n.save,
                    disabled: true,
                    handler: function() {
                        idnode2 = Ext.getCmp('node2').getValue();
                        var records = {};
                        edges_store.each(
                            function (record){
                                records[record.get('id')] = record.get('activate');
                            }
                        );
                        Ext.getCmp('card-0').getForm().submit({
                            url: 'arv/add_connect',
                            //waitMsg: Ext.i18n.dialog_submit,
                            params: {
                                node1: node_a_id,
                                tmpl_connect: Ext.getCmp('tmplconnect').getValue(),
                                edges: Ext.util.JSON.encode(records),
                                extr1: Ext.getCmp('extr1').getValue(),
                                extr2: Ext.getCmp('extr2').getValue(),
                                cred1: Ext.getCmp('cred1').getValue(),
                                cred2: Ext.getCmp('cred2').getValue()

                            },
                            success: response_success,
                        })
                    }
                }
            } else {
                //if modify connect
                nbcard = 2;
                //FIXME
                var wizard_ok_button = {
                    id: 'button-addnode2',
                    text: Ext.i18n.modify,
                    disabled: true,
                    handler: function() {
                        idnode2 = Ext.getCmp('node2').getValue();
                        var records = {};
                        edges_store.each(
                            function (record){
                                records[record.get('id')] = record.get('activate');
                            }
                        );
                        Ext.getCmp('card-0').getForm().submit({
                            url: 'arv/mod_connect',
                            //waitMsg: Ext.i18n.dialog_submit,
                            params: {
                                connect_id: connect_id,
                                edges: Ext.util.JSON.encode(records),
                                extr1: Ext.getCmp('extr1').getValue(),
                                extr2: Ext.getCmp('extr2').getValue(),
                                cred1: Ext.getCmp('cred1').getValue(),
                                cred2: Ext.getCmp('cred2').getValue()

                            },
                            success: response_success,
                        })
                    }
                }
            }
            var wizard = {
                id:'addnode2-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'card-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,

                },{
                    id: 'card-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winaddnode2.destroy();
                    }
                }, wizard_ok_button
                ]
            };

            var response_success = function(response, options){
                if (node_b_id == null) {
                    ARV.observable.fireEvent("treenode2changed");
                } else {
                    ARV.observable.fireEvent("changemodconnect");
                }
                winaddnode2.destroy();
            };

            var winaddnode2 = new ARV.PopupWindow({
                title: Ext.i18n.addnode2_title,
                width: 400,
                items: [wizard],
            }).show();

            if (node_b_id != null) {
                Ext.getCmp('node2').setValue(node_b_id);
                Ext.getCmp('node2').setRawValue(node_b_name);
                //Ext.getCmp('tmplconnect').setValue(pouet);
                navHandler(0);
            } else {
                Ext.getCmp('node2').store.load();
            }
        },
        openConnectWindow: function(nodea, nodeb){
            connectstore.removeAll();
            connectstore.baseParams={nodea: nodea, nodeb: nodeb};
            connectstore.load();
            connectwin.show();
        },
        load: function(nodea, nodeb) {
            connectstore.removeAll();
			if (nodea != null && nodeb != null) {
	            connectstore.baseParams={nodea: nodea, nodeb: nodeb};
    	        connectstore.load();
			};
        },
        loadIP: function() {
            Ext.getCmp('extr1').store.load();
            Ext.getCmp('extr2').store.load();
        },
        getSelectedId: function() {
            if (connect_grid.getSelectionModel().hasSelection()) {
                return connect_grid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },
    };
})();


// vim: ts=4 sw=4 expandtab
