/*
 *
 *
 */

Ext.namespace("ARV");

ARV.addtmplconnect = (function() {
    /*
     * Public
     */

    var selected_tmplnode1 = null;
    var selected_tmplnode2 = null;
    var storetmplnode1 = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name : 'tmplnode'},
                {name : 'id'},
            ]),
            url: 'arv/get_tmpl_nodes'
    });
    var storetmplnode2 = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name : 'tmplnode'},
                {name : 'id'},
            ]),
            url: 'arv/get_tmpl_nodes'
    });
    return {
        tmplnode_1_reload: function(){
            selected_tmplnode1 = null;
            storetmplnode1.load()
        },
        tmplnode_2_reload: function(){
            selected_tmplnode2 = null;
            storetmplnode2.removeAll();
            //FIWME: storetmplnode2.baseParams={exclude: selected_tmplnode1};
            storetmplnode2.load()
        },
        openWindow: function(){
            var nbcard = 0;
            var navHandler = function(incr){
                var l = Ext.getCmp('card-wizard-panel').getLayout();
                var i = l.activeItem.id.split('card-')[1];
                var next = parseInt(i) + incr;
                switch (next) {
                    case 1: if (Ext.getCmp('name').getValue() == '') {
                                error_msg(Ext.i18n.field_empty)
                                return;
                            };
                            Ext.getCmp('save-button').disable();
                            if (selected_tmplnode1 == null) {
                                storetmplnode1.load();
                            }
                    break;
                    case 2: if (selected_tmplnode1 == null) {
                                error_msg(Ext.i18n.row_not_selected)
                                return;
                            }
                            Ext.getCmp('save-button').disable();
                            if (selected_tmplnode2 == null) {
                                storetmplnode2.removeAll();
                                //FIWME: storetmplnode2.baseParams={exclude: selected_tmplnode1};
                                storetmplnode2.load();
                            }
                    break;
                    case 3:
                        if (selected_tmplnode2 == null) {
                                error_msg(Ext.i18n.row_not_selected)
                                return;
                        }
                        Ext.getCmp('save-button').enable();
                        credauth_store = Ext.getCmp('credauth').store
                        credauth_store.removeAll();
                        credauth_store.load();
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                Ext.getCmp('card-prev').setDisabled(next==0);
                Ext.getCmp('card-next').setDisabled(next==3);

            };

            colModel = new Ext.grid.ColumnModel({
                columns: [
                      {id: 'tmplnode1', header: Ext.i18n.tmplnode, sortable: true, dataIndex: 'tmplnode', width: 280},
                      {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
                  ],
                  defaults: {
                      sortable: true,
                  },
            });
            var sm_tmplnode1 = new Ext.grid.RowSelectionModel({
                singleSelect:true,
                listeners: {
                    'rowselect': function(sm, rowIndex, extDataRecord){
                        selected_tmplnode1 = extDataRecord.data.id;
                        selected_tmplnode2 = null;
                    }
                }
            });
            var sm_tmplnode2 = new Ext.grid.RowSelectionModel({
                singleSelect:true,
                listeners: {
                    'rowselect': function(sm, rowIndex, extDataRecord){
                        selected_tmplnode2 = extDataRecord.data.id;
                    }
                }
            });
            var add_tmpl_node = function(btn, ev) {
                // create tmplnode
                Ext.MessageBox.prompt(Ext.i18n.add_tmpl_node_title, Ext.i18n.add_tmpl_node,
                    function (btn, text){
                        if (btn == 'ok'){
                            Ext.Ajax.request({
                               url: 'arv/add_tmpl_node',
                               params: {name: text}
                            });
                            storetmplnode1.load();
                            storetmplnode2.load();
                        };
                    }
                )
            };
            var cardcontent = [{
                    id: 'card-0',
                    xtype: 'form',
                    border: false,
                    items: {
                        id: 'name',
                        xtype : "textfield",
                        fieldLabel : Ext.i18n.addtmpl_connect_name,
                        name : Ext.i18n.tmplnode_name,
                        allowBlank: false,
                    }
                },{
                    id:'card-1',
                    border: false,
                    layout: 'fit',
                    items: {
                        xtype: 'grid',
                        store: storetmplnode1,
                        border: false,
                        colModel: colModel,
                        sm: sm_tmplnode1,
                        bbar: [{
                            text: Ext.i18n.add,
                            iconCls: 'arv-add',
                            handler: add_tmpl_node,
                            scope: this
                        }, '-', {
                            text: Ext.i18n.remove,
                            iconCls: 'arv-delete',
                            handler: function(btn, ev) {
                                if (sm_tmplnode1.getSelected()) {
                                    delete_btn('arv/del_tmpl_node',
                                        sm_tmplnode1.getSelected().data.id,
                                        'tmplnode_1_changed'
                                    );
                                } else {
                                    error_msg(Ext.i18n.error_select_tmplnode)
                                }
                            },
                            scope: this
                        }],
                    }
              },{
                    id:'card-2',
                    border: false,
                    layout: 'fit',
                    items: {
                        xtype: 'grid',
                        width: 300,
                        store: storetmplnode2,
                        border: false,
                        colModel: colModel,
                    sm: sm_tmplnode2,
                    bbar: [{
                          text: Ext.i18n.add,
                          iconCls: 'arv-add',
                          handler: add_tmpl_node,
                          scope: this
                      }, '-', {
                          text: Ext.i18n.remove,
                          iconCls: 'arv-delete',
                          handler: function(btn, ev) {
                              if (sm_tmplnode2.getSelected()) {
                                  delete_btn('arv/del_tmpl_node',
                                      sm_tmplnode2.getSelected().data.id,
                                      'tmplnode_2_changed'
                                  )
                              } else {
                                  error_msg(Ext.i18n.error_select_tmplnode)
                              }
                          },
                          scope: this
                      }],
                  }
              },{
                  id:'card-3',
                  border: false,
                  layout: {
                      type: 'hbox',
                      pack: 'start',
                      align: 'stretch'
                  },
                  xtype: 'panel',
                  items: [{
                      id: 'card-3-form',
                      xtype: 'form',
                      flex: 1,
                      border: false,
                      items: {
                          xtype: "arvcombo",
                          id: 'credauth',
                          width: 100,
                          fieldLabel: Ext.i18n.addtmpl_connect_credauth,
                          record: [
                              {name : 'id'},
                              {name : 'credauth'},
                          ],
                          url: 'arv/get_credauth',
                          displayField:'credauth',
                          autoLoad: true,
                          listen: {
                              'load': function(store, records, option){
                                  if (records.length != 0) {
                                      Ext.getCmp('credauth').setValue(records[0].get('id'));
                                  }
                              }
                          }
                      }
                  }, {
                    layout: 'vbox',
                    border: false,
                    width: 70,
                    layoutConfig: {
                        align: 'stretch',
                        pack: 'start'
                    },
                    items: {
                        xtype: 'form',
                        labelWidth: 0,
                        id: 'fp_credauth_form',
                        fileUpload: true,
                        layout: 'fit',
                        border: false,
                        items: {
                            xtype: 'fileuploadfield',
                            buttonOnly: true,
                            id: 'credentialauth',
                            buttonText: Ext.i18n.addnode2_choice_button,
                            listeners: {
                                'fileselected': function(fb, v){
                                    var response_success_cred = function(response, option) {
                                        Ext.getCmp('credauth').store.load();
                                        ARV.observable.fireEvent("credchanged");
                                    };
                                    fb = Ext.getCmp('fp_credauth_form').getForm();
                                    if (fb.isValid){
                                        fb.submit({
                                            url: 'arv/add_credauth',
                                            //waitMsg: Ext.i18n.dialog_submit,
                                            success: response_success_cred,
                                        });
                                    };

                                }
                           }
                        }
                    }
                  }]
            }];

            var wizard = {
                id:'card-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'card-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,

                },{
                    id: 'card-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winaddtmplconnect.destroy();
                    }
                },{
                    id: 'save-button',
                    text: Ext.i18n.save,
                    disabled: true,
                    handler: function() {
                        tmplconnect_name = Ext.getCmp('name').getValue()
                        credauth = Ext.getCmp('credauth').getValue();
                        if ((selected_tmplnode1 == null) || (selected_tmplnode2 == null) || (tmplconnect_name == '') || (credauth == '')) {
                            error_msg(Ext.i18n.row_not_selected);
                            return;
                        };
                        Ext.getCmp('card-0').getForm().submit({
                            url: 'arv/add_tmpl_connect',
                            //waitMsg: Ext.i18n.dialog_submit,
                            params: {tmplnode1: selected_tmplnode1, tmplnode2: selected_tmplnode2, credauth: credauth},
                            success: response_success,
                        });

                        //var selected_tmplnode2;
                        //Ext.getCmp('name').getValue()
                    }
                }]
            };
            var response_success = function(response, options){
                ARV.observable.fireEvent("treetmplconnectchanged");
                winaddtmplconnect.destroy();
            };
            var winaddtmplconnect = new ARV.PopupWindow({
    	       	title: Ext.i18n.win_addtmpl_connect_title,
                items: [wizard],
            }).show();
        }

    };
})();

// vim: ts=4 sw=4 expandtab
