/*
 *
 *
 */


Ext.namespace("ARV");


ARV.GridPanel = Ext.extend(Ext.grid.GridPanel, {
	initComponent:function() {
		grid = this;
		if (this.forcefit == null) {
			this.forcefit = true
		};
        if (this.row_class == null) {
            this.row_class = function(record, index) {return ''}
        };
		var config = {
			border: true,
			split: true,
			layout: 'fit',
			store: this.store,
			title: this.title,
			autoScroll: true,
			width: 200,
			viewConfig: {
				forceFit: this.forcefit,
                getRowClass: this.row_class
			},
			colModel: new Ext.grid.ColumnModel({
				columns: this.columns,
				defaults: {
					sortable: true,
				},
			}),
			sm: new Ext.grid.RowSelectionModel({
				singleSelect:true
			}),
			enableColumnHide: false
        //}
		};
        if (this.error_message == null) {
            error_message = Ext.i18n.error_select_node
        };
        if (this.bbar == null) {
            this.bbar = []
            //add bbar if btnAddEvent is set
            if (this.btnAddEvent != null) {
                this.bbar[0] = {
                    text: Ext.i18n.add,
                    iconCls: 'arv-add',
                    handler: function(btn, ev) {
                        ARV.observable.fireEvent(this.btnAddEvent);
                    },
                        scope: this
                }
            };
            if (this.btnModEvent != null) {
                if (this.btnAddEvent != null) {
                    this.bbar[this.bbar.length] = '-'
                };
                this.bbar[this.bbar.length] = {
                    text: Ext.i18n.modify,
                    iconCls: 'arv-modify',
                    handler: function(btn, ev) {
                        ARV.observable.fireEvent(this.btnModEvent);
                    },
                        scope: this
                }
            };
            if (this.btnDelEvent != null) {
                if (this.btnAddEvent != null || this.btnModEvent != null) {
                    this.bbar[this.bbar.length] = '-'
                };
                this.bbar[this.bbar.length] = {
                    text: Ext.i18n.remove,
                    iconCls: 'arv-delete',
                    handler: function(btn, ev) {
                        if (this.btnDelEvent != null) {
                            sm = this.getSelectionModel();
                            if (sm.getSelected()) {
                                if (this.deleteUrl == null) {
                                    error_msg("ERROR: no deleteUrl")
                                };
                                delete_btn(this.deleteUrl,
                                    sm.getSelected().get('id'),
                                    this.btnDelEvent)
                            }else{
                                error_msg(this.error_message)
                            }
                        }
                    },
                    scope: this
                }
            };
        };
        if (this.bbar.length != 0) {
            grid.bbar = this.bbar
        };
		Ext.apply(this, config);
		ARV.GridPanel.superclass.initComponent.call(this)
	},
});

Ext.reg('arvgridpanel', ARV.GridPanel);
