
Ext.namespace("ARV");

ARV.login = (function() {
    /*
     * Public
     */

//    var observable = new Ext.util.Observable();
//    observable.addEvents(
//        "node1added"
//     );
    var loginwin = '';
    return {
        openWindow: function(){
            if (loginwin != '')
                return;
            //Ext.QuickTips.init();
            var login = new Ext.FormPanel({
                labelWidth :80,
                url :'arv/login',
                frame :true,
                bodyStyle :'padding:5px;',
                defaultType :'textfield',
                monitorValid :true,
                items : [{
                    fieldLabel: Ext.i18n.login_user,
                    id :'user',
                    name :'user',
                    allowBlank :false
                }, {
                    fieldLabel: Ext.i18n.login_password,
                    id :'password',
                    name :'password',
                    inputType :'password',
                    allowBlank :false
                }],

                buttons: [{
                    text: Ext.i18n.login,
                    formBind :true,
                    handler : function() {
                        login.getForm().submit({
                            success: function(form, action) {
                                if (action && action.result) {
                                    Ext.util.Cookies.set("usezephir", action.result.data.zephir);
                                    ARV.login.closeWindow();
                                    ARV.observable.fireEvent('login');
                                }
                            },
                        });
                    }
                }],
                keys: [{
                    key: [Ext.EventObject.ENTER],
                    text: Ext.i18n.login,
                    formBind :true,
                    handler: function() {
                        login.getForm().submit({
                            success: function(form, action) {
                                if (action && action.result) {
                                    Ext.util.Cookies.set("usezephir", action.result.data.zephir);
                                    ARV.login.closeWindow();
                                    ARV.observable.fireEvent('login');
                                }
                            //Ext.Msg.alert("Alert","Enter Key Event !");
                            },
                        });
                    }
                }]
            });
            loginwin = new ARV.PopupWindow({
                title: Ext.i18n.login_title,
                width: 300,
                height: 150,
                items: [login]
            }).show();
        },
        closeWindow: function() {
            if (loginwin.close) {
                loginwin.close();
            };
            loginwin = ''
        }
    }
})();
// vim: ts=4 sw=4 expandtab
