/*
 *
 *
 */

Ext.namespace("ARV");

ARV.treenode2 = (function() {
    /*
     * Private
     */
    var selid2 = null;
    var tnode2grid = new ARV.GridNode({
        region: 'center',
        title: Ext.i18n.node2,
        btnAddEvent: 'addconnect',
        btnModEvent: 'modconnect'
    });
    tnode2grid.getSelectionModel().on('rowselect', function() {ARV.observable.fireEvent('viewconnectchanged')}, this);
    this_store2 = tnode2grid.getStore();
    this_store2.on('load', function() {
        if (selid2 != null) {
            index = this_store2.findExact('id', selid2);
            if (index != -1) {
                tnode2grid.getSelectionModel().selectRow(index)
            }
        };
        selid2 = null
    }, this);
    /*
     * Public
     */

    return {

        get: function() {
            return tnode2grid;
        },

        load: function(node) {
            store=tnode2grid.getStore();
            store.removeAll();
            if (node != null) {
                store.baseParams={id: node, connected: 'true'};
                store.load();
            };
            ARV.observable.fireEvent('viewconnectchanged');
        },
        storeSelId: function () {
            selid2 = ARV.treenode2.getSelectedId();
        },

        getSelectedId: function() {
            if (tnode2grid.getSelectionModel().hasSelection()) {
                return tnode2grid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },

        getSelectedName: function() {
            if (tnode2grid.getSelectionModel().hasSelection()) {
                return tnode2grid.getSelectionModel().getSelected().get('node');
            } else {
                return null
            }
        }
    };
})();
