/*
 *
 *
 */

Ext.namespace("ARV");

ARV.treetmpledge = (function() {
    /*
     * Private
     */
    var connect = null;

    var ttestore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name: 'id'},
                {name: 'tmplvertexname'},
                {name: 'tmplvertex1'},
                {name: 'tmplvertex1id'},
                {name: 'tmplvertex2'},
                {name: 'tmplvertex2id'},
            ]),
            url: 'arv/get_tmpl_edges'
    });

    var tmplnode1 = new Ext.Panel({
        title: Ext.i18n.tmplnode1,
        layout: 'fit',
        width: '200',
        html: "&nbsp;"
    });

    var tmplnode2 = new Ext.Panel({
        title: Ext.i18n.tmplnode2,
        layout: 'fit',
        width: '200',
        html: "&nbsp;"
    });

    columns = [
        {id: 'tmplvertexname', header: Ext.i18n.tmplvertex_name, sortable: true, dataIndex: 'tmplvertexname', width: '133px'},
        {id: 'tmplvertex1', header: Ext.i18n.tmplvertex1, sortable: true, dataIndex: 'tmplvertex1', width: '133px'},
        {header: 'tmplvertex1id', sortable: true, dataIndex: 'tmplvertex1id', hidden: true},
        {id: 'tmplvertex2', header: Ext.i18n.tmplvertex2, sortable: true, dataIndex: 'tmplvertex2', width: '133px'},
        {header: 'tmplvertex2id', sortable: true, dataIndex: 'tmplvertex2id', hidden: true},
        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
    ];

    var tree = new ARV.GridPanel({
        store: ttestore,
        columns: columns,
        layout: 'fit',
        forcefit: false,
        flex: 2,
        title: Ext.i18n.tmpledges,
        deleteUrl: 'arv/del_tmpl_edge',
        btnAddEvent: 'treetmpledgeadd',
        btnModEvent: 'treetmpledgemod',
        btnDelEvent: 'treetmpledgechanged'
    });

    /*
     * Public
     */

    return {
        removeAll: function(){
            ttestore.removeAll();
        },
        load: function(tmplconnectid, tmplnodea, tmplnodeb) {
            connect = tmplconnectid;
            ttestore.removeAll();
            if (tmplconnectid != null) {
                ttestore.baseParams={id: tmplconnectid};
                ttestore.load();
                tmplnode1.body.update(tmplnodea);
                tmplnode2.body.update(tmplnodeb);
            } else {
                if (tmplnode1.body) {
                    tmplnode1.body.update('&nbsp;');
                    tmplnode2.body.update('&nbsp;');
                }
            }
        },
        get: function() {
            return tree;
        },
        getTmplNode1: function() {
            return tmplnode1;
        },
        getTmplNode2: function() {
            return tmplnode2;
        },
        getSelectedRecord: function() {
            if (tree.getSelectionModel().hasSelection()) {
                return tree.getSelectionModel().getSelected();
            } else {
                return null
            }
        }
    };
})();
