/*
 *
 *
 */

Ext.namespace("ARV");

ARV.viewconnect = (function() {
    /*
     * Private
     */

    var viewstore = new Ext.data.GroupingStore({
    reader: new Ext.data.JsonReader({
        root: 'data',
        successProperty: 'success',
        fields: [
        {name : 'edge'},
        {name : 'id'},
        {name : 'connect'},
        {name : 'vertexa'},
        {name : 'vertexb'},
        ]}),
            sortInfo: {field: 'id', direction: 'ASC'},
            groupField: 'connect',
        url: 'arv/get_edges'
    });

    columns = [
        {header: 'Connect', width: 20, sortable: true, dataIndex: 'connect'},
        {header: Ext.i18n.edge_name, width: 20, sortable: true, dataIndex: 'edge'},
        {header: Ext.i18n.tmplvertex_ip1, width: 20, sortable: true, dataIndex: 'vertexa'},
        {header: Ext.i18n.tmplvertex_ip1, width: 20, sortable: true, dataIndex: 'vertexb'},
        {header: 'id', width: 25, sortable: true, dataIndex: 'id', summaryType: 'max', hidden: true}
    ];
	var viewtree = new ARV.GridPanel({
        layout: 'fit',
        region: 'center',
        title: Ext.i18n.edge,
        store: viewstore,
		columns: columns,
        //singleSelect
        view: new Ext.grid.GroupingView({
            forceFit: true,
            showGroupName: false,
            enableNoGroups: false,
            enableGroupingMenu: false,
            hideGroupedColumn: true
        }),
        //deleteUrl: 'arv/del_edge',
        //btnDelEvent: 'treenode1changed',
        //error_message: Ext.i18n.error_select_edge
    });


    /*
     * Public
     */


    return {

        get: function() {
            return viewtree;
        },
        cleanTreeGroup: function() {
                viewstore.removeAll();
        },
        load: function(nodea, nodeb) {
            this.cleanTreeGroup();
            if (nodea != null && nodeb != null) {
                viewstore.baseParams={nodea: nodea, nodeb: nodeb};
                viewstore.load();
            }
        }

    };
})();
