Ext.namespace("ARV");

ARV.credential = (function() {
    var selid = null;
    var cred_store = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name: 'id'},
            {name: 'name'},
            {name: 'ca'},
            {name: 'expiration_date'},
            {name: 'delta'},
            {name: 'is_expired'},
            {name: 'is_nearly_expired'},
            {name: 'node'},
        ]),
        url: 'arv/get_all_cred'
    });
    cred_store.on('load', function() {
        if (selid != null) {
            index = this_store.findExact('id', selid);
            if (index != -1) {
                cred_grid.getSelectionModel().selectRow(index)
            }
        };
        selid = null
    }, this);
    var columns = [{id: 'id', dataIndex: 'id', hidden: true},
        {header: Ext.i18n.name, dataIndex: 'name', width: 50},
        {header: Ext.i18n.exp_date_title, dataIndex: 'expiration_date', width: 20},
        {header: Ext.i18n.delta, dataIndex: 'delta', width: 20},
        {header: Ext.i18n.ca, dataIndex: 'ca', width: 20},
        {header: Ext.i18n.related_node, dataIndex: 'node', width: 100},
    ];
    var cred_grid = new ARV.GridPanel({
        layout: 'fit',
        region: 'center',
        store: cred_store,
        columns: columns,
        btnModEvent: 'credmod_from_credtab',
        row_class: function(record, index) {
            if (record.get('is_expired')) {
                return 'red-class';
            } else if (record.get('is_nearly_expired')) {
                return 'orange-class';
            } else {
                return ''
            }
        }
    });
    return {
        get: function() {
            return cred_grid;
        },
        load: function() {
            selid = ARV.viewcred.getSelectedId();
            cred_store.removeAll();
            cred_store.load();
        },
        getSelectedType: function() {
            if (cred_grid.getSelectionModel().hasSelection()) {
                if (cred_grid.getSelectionModel().getSelected().get('ca')) {
                    return "ca"
                };
                return 'cred'
            } else {
                return null
            }
        },
        modCAWindow: function(cred_id){
            var cardcontent = [{
                id: 'cardmc-1-mod',
                xtype: 'form',
                fileUpload: true,
                border: false,
                items: [{
                    xtype: 'fileuploadfield',
                    id: 'credential',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_public_key,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('save-button').enable();
                        }
                    }
                }]
            }];
            var wizard = {
                id:'mod-ca-panel',
                xtype: 'panel',
                layout: 'card',
                border: false,
                activeItem: 0,
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winmodcred.destroy();
                    }
                },{
                    id: 'save-button',
                    text: Ext.i18n.modify,
                    disabled: true,
                    handler: function() {
                        fb = Ext.getCmp('cardmc-1-mod').getForm();
                        if (fb.isValid){
                            fb.submit({
                                url: 'arv/mod_ca',
                                //waitMsg: Ext.i18n.dialog_submit,
                                params: {cred_id: cred_id},
                                success: response_success,
                            });
                        };
                    }
                }]
            };
            var response_success = function(response, options){
                winmodcred.destroy();
                ARV.observable.fireEvent("credchanged");
            };
            var winmodcred = new ARV.PopupWindow({
                title: Ext.i18n.modcred_title,
                items: [wizard]
            }).show();
        },
        getSelectedId: function() {
            if (cred_grid.getSelectionModel().hasSelection()) {
                return cred_grid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        }
    }
})();
