Ext.namespace("ARV");

(function() {

    Ext.onReady(function() {
        Ext.get('waiter-msg').update(Ext.i18n.loading);

        var nodea=null;
        var nodeaname=null;
        var tmplnodea=null;
        var tmplnodeb=null;

        var tabview = {
            title: Ext.i18n.view,
            layout: 'border',
            items : [{
                layout: 'border',
                xtype: 'panel',
                region: 'west',
                width: 400,
                border: false,
                split: true,
                items: [ARV.treenode1.get(), ARV.treenode2.get()],
            },
                ARV.viewconnect.get()
            ]
        };
        var tabtemplate = {
            title: Ext.i18n.template,
            layout: "border",
            xtype: 'panel',
            border: false,
            items: [
                ARV.treetmplconnect.get(),
                {
                    region: 'center',
                    border: false,
                    split: true,
                    layout: 'hbox',
                    layoutConfig: {
                        align : 'stretch',
                        pack  : 'start',
                    },
                    items: [{
                        layout: 'vbox',
                        border: false,
                        width: 400,
                        layoutConfig: {
                            align : 'stretch',
                            pack  : 'start',
                        },
                        items: [{
                            layout: 'hbox',
                            border: false,
                            items: [ARV.treetmpledge.getTmplNode1(), ARV.treetmpledge.getTmplNode2()]
                        }, ARV.treetmpledge.get()]
                    },ARV.treetmpledge.getTmplVertex()]
                }
            ]
        };
        var tabnode = {
            title: Ext.i18n.nodes,
            layout: 'fit',
            items: ARV.viewcred.get()
        };
        var tabcred = {
            title: Ext.i18n.cred_title,
            layout: 'fit',
            items: ARV.credential.get()
        };
        var viewport = new Ext.Viewport(
        {
            layout : "border",
            border: false,
            items : [{
                xtype : "tabpanel",
                border: false,
                region : "center",
                activeTab: 0,
                items : [tabview, tabnode, tabtemplate, tabcred],
                bbar: new Ext.ux.StatusBar({
                    defaultText: Ext.i18n.ready,
                    //defaultIconCls: 'x-status-valid',
                    id: 'statusbar',
                    busyText: Ext.i18n.loading,
                    items: [{
                        text: Ext.i18n.apply,
                        handler: function (){
                            ARV.observable.fireEvent('apply');
                        }
                    }, '-', {
                        iconCls: 'x-arv-logout',
                        handler: function (){
                            ARV.observable.fireEvent('logout');
                        }
                    }]
                })
            }],

        });
    ARV.treenode1.load();
    ARV.treetmpledge.loadTmplVertex();
	ARV.treetmplconnect.load();
	ARV.viewcred.load();
	ARV.credential.load();
    });
})();

