/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Group all common gaspacho Event
 * Verify if ajax request:
 * - if session is valid
 * - if a message must to be display
 * - if an error must be display
 */
Ext.namespace("ARV");
ARV.observable = (function() {
    var observable = new Ext.util.Observable();
    observable.addEvents(
    );

    var waiter_time = 0;
    var statusbar = Ext.getCmp('statusbar');

    observable.on({
        //treenode 1
        "login": function() {
            ARV.treenode1.load();
            ARV.treetmplconnect.load();
            ARV.treetmpledge.loadTmplVertex();
            ARV.viewcred.load();
            ARV.credential.load();
        },
        "treenode1changed" : function(){
            //if treenode1 has change (add node/remove node)
            ARV.treenode1.load();
            ARV.viewcred.load();
        },
        "nodeadd": function(){
            //open addnode1 window
            ARV.addnode1.openWindow();
        },
        "nodedel": function(){
            ARV.viewcred.load();
            ARV.treenode1.load();
            ARV.credential.load();
        },
        "nodemod": function(){
            selectid = ARV.viewcred.getSelectedId();
            if (selectid == null) {
                error_msg(Ext.i18n.error_select_node);
                return
            };
            ARV.addnode1.openWindow(
                selectid,
                ARV.viewcred.getSelectedUAI(),
                ARV.viewcred.getSelectedName()
            )
        },
        //treenode 2
        "treenode2changed" : function(){
            //if treenode2 has change (add node/remove node)
            //of treenode1 is selected
            ARV.treenode2.load(ARV.treenode1.getSelectedId());
            //c'était pour recharger la colonne Etat (savoir si un certificat
            //était ajouté au node
            //ARV.viewcred.load();
        },
        "addconnect": function(){
            //open addnode2 window if node1 is selected
            node1 = ARV.treenode1.getSelectedId();
            if (node1 == null) {
                error_msg(Ext.i18n.error_select_node1);
                return
            };
            node1name = ARV.treenode1.getSelectedName();
            ARV.addnode2.openWindow(
                node1,
                node1name
            )
        },
        'modconnect': function(){
            //open addnode2 window if node2 is selected
            node2 = ARV.treenode2.getSelectedId();
            if (node2 == null) {
                error_msg(Ext.i18n.error_select_node2)
                return
            }
            node1 = ARV.treenode1.getSelectedId();
            //node1name = ARV.treenode1.getSelectedName();
            //node2name = ARV.treenode2.getSelectedName();
            ARV.addnode2.openConnectWindow(
                node1,
                node2
            )
        },
        'addmodconnect': function(){
            //open addnode2 window if node2 is selected
            node2 = ARV.treenode2.getSelectedId();
            node2name = ARV.treenode2.getSelectedName();
            if (node2 == null) {
                error_msg(Ext.i18n.error_select_node2)
                return
            }
            node1 = ARV.treenode1.getSelectedId();
            node1name = ARV.treenode1.getSelectedName();
            ARV.addnode2.openWindow(
                node1,
                node1name,
                node2,
                node2name
            )
        },
        'modifconnect': function(){
            //open addnode2 window if node2 is selected
            node2 = ARV.treenode2.getSelectedId();
            node2name = ARV.treenode2.getSelectedName();
            if (node2 == null) {
                error_msg(Ext.i18n.error_select_node2)
                return
            }
            node1 = ARV.treenode1.getSelectedId();
            node1name = ARV.treenode1.getSelectedName();
            connect_id = ARV.addnode2.getSelectedId();
            leftsendcert = ARV.addnode2.getSelectedLeftSendCert();
            ARV.addnode2.openWindow(
                node1,
                node1name,
                node2,
                node2name,
                connect_id,
                leftsendcert
            )
        },
        "changemodconnect" : function(){
            //if treenode2 has change (add node/remove node)
            //if treenode1 is selected
            node1 = ARV.treenode1.getSelectedId();
            node2 = ARV.treenode2.getSelectedId();
            ARV.addnode2.load(node1, node2);
        },

        //viewconnect
        "viewconnectchanged" : function(){
            //if treenode2 is selected
            ARV.viewconnect.load(
                ARV.treenode1.getSelectedId(),
                ARV.treenode2.getSelectedId()
            );
        },

        //treetmplconnect
        "treetmplconnectchanged": function(){
            ARV.treetmplconnect.load();
        },
        "treetmplconnectadd": function(){
            ARV.addtmplconnect.openWindow();
        },

        //treetmpledge
        "treetmpledgechanged": function(){
            record = ARV.treetmplconnect.getSelectedRecord();
            if (record != null) {
                ARV.treetmpledge.load(record.get('id'), record.get('tmplnodea'), record.get('tmplnodeb'));
            } else {
                ARV.treetmpledge.load()
            }
        },
        'treetmpledgeadd': function(){
            record = ARV.treetmplconnect.getSelectedRecord();
            if (record == null) {
                error_msg(Ext.i18n.error_select_tmplconnect)
                return
            }
            ARV.addtmpledge.openWindow(record.get('id'),
                    record.get('tmplnodeaid'), record.get('tmplnodea'),
                    record.get('tmplnodebid'), record.get('tmplnodeb'));
        },
        'treetmpledgemod': function(){
            recordconnect = ARV.treetmplconnect.getSelectedRecord();
            recordedge = ARV.treetmpledge.getSelectedRecord();
            if (recordconnect == null) {
                error_msg(Ext.i18n.error_select_tmplconnect)
                return
            };
            if (recordedge == null) {
                error_msg(Ext.i18n.error_select_tmpledge)
                return
            };
            ARV.addtmpledge.openWindow(recordconnect.get('id'),
                recordconnect.get('tmplnodeaid'),
                recordconnect.get('tmplnodea'),
                recordconnect.get('tmplnodebid'),
                recordconnect.get('tmplnodeb'),
                recordedge.get('id'),
                recordedge.get('tmplvertexname'),
                recordedge.get('tmplvertex1id'),
                recordedge.get('tmplvertex2id')
            );
        },

        'tmplnode_1_changed': function() {
            ARV.addtmplconnect.tmplnode_1_reload()
        },
        'tmplnode_2_changed': function() {
            ARV.addtmplconnect.tmplnode_2_reload()
        },
        'tmplvertexchanged': function() {
            ARV.treetmpledge.loadTmplVertex();
        },
        'treetmplvertexmod': function() {
            tmplvertex = ARV.treetmpledge.getSelectedRecordTmplVertex();
            if (tmplvertex == null) {
                error_msg(Ext.i18n.error_select_tmplvertex)
                return
            };
            tmplnode = tmplvertex.get('tmplnode');
            tmplnodeid = tmplvertex.get('tmplnodeid');
            tv_name = tmplvertex.get('tmplvertexname');
            tv_id = tmplvertex.get('id');
            tv_mimetype = tmplvertex.get('tmplvertexmimetype');
            tv_module = tmplvertex.get('tmplvertexmodule');
            tv_ip1 = tmplvertex.get('tmplvertexip1');
            tv_ip2 = tmplvertex.get('tmplvertexip2');
            ARV.addtmpledge.openTmplVertexWindow(tmplnodeid, tmplnode, null, tv_name, tv_id, tv_mimetype,
                                                tv_module, tv_ip1, tv_ip2);
        },
        'modifycred': function() {
            node = ARV.viewcred.getSelectedId();
            if (node == null) {
                error_msg(Ext.i18n.error_select_node)
                return
            }
            ARV.modcred.openWindow(node)
        },
        'extripadd': function() {
            node = ARV.viewcred.getSelectedId();
            ARV.modextip.openIPWindow(node, 'extripchanged');
        },
        'extripmod': function() {
            extip = ARV.modextip.getSelectedId();
            if (extip == null) {
                error_msg(Ext.i18n.error_select_extrip)
                return
            }
            ARV.modextip.openModIPWindow(extip, 'extripchanged');
        },
        'modifyextrip': function() {
            node = ARV.viewcred.getSelectedId();
            if (node == null) {
                error_msg(Ext.i18n.error_select_node);
                return
            };
            ARV.modextip.openWindow(
                node,
                ARV.viewcred.getSelectedUAI()
            )
        },
        'extripchanged': function() {
            node = ARV.viewcred.getSelectedId();
            ARV.modextip.load(node)
        },
        'extrip_node2_changed': function() {
            ARV.addnode2.loadIP()
        },
        'credadd': function() {
            node = ARV.viewcred.getSelectedId();
            ARV.modcred.openCredWindow(node);
            ARV.credential.load();
        },
        'credmod': function() {
            cred = ARV.modcred.getSelectedId();
            if (cred == null) {
                error_msg(Ext.i18n.error_select_cred);
                return
            };
            ARV.modcred.modCredWindow(cred)
        },
        'credmod_from_credtab': function() {
            cred = ARV.credential.getSelectedId();
            if (cred == null) {
                error_msg(Ext.i18n.error_select_cred);
                return
            };

            type = ARV.credential.getSelectedType();
            if (type == 'cred') {
                ARV.modcred.modCredWindow(cred);
            } else if (type == 'ca') {
                ARV.credential.modCAWindow(cred);
            }
        },
        'credchanged': function() {
            node = ARV.viewcred.getSelectedId();
            if (node != null) {
                ARV.modcred.load(node);
            };
            ARV.credential.load();
        },
        'closemodifycred': function() {
            ARV.viewcred.load();
            ARV.credential.load();
        },
        'logout': function() {
            Ext.Ajax.request({
                url: 'arv/logout',
            });
            ARV.observable.fireEvent('login');
        },
        'apply': function() {
            Ext.Ajax.request({
                url: 'arv/apply',
                timeout: 900000,
            });
        },
        'send_db': function() {
            node = ARV.viewcred.getSelectedId();
            if (node == null) {
                error_msg(Ext.i18n.error_select_node);
                return
            };
            Ext.Ajax.request({
                url: 'arv/send_db',
                params: {
                    node: node
                }
            })
        },
        'sync_zephir': function() {
            node = ARV.viewcred.getSelectedId();
            if (node == null) {
                error_msg(Ext.i18n.error_select_node);
                return
            };
            Ext.Ajax.request({
                url: 'arv/sync_zephir',
                params: {
                    node: node
                }
            })
            ARV.treenode1.load();
            ARV.viewcred.load();
            ARV.credential.load();
        }
    });

    //before request, show waiter
    Ext.Ajax.on('beforerequest', function() {
        if (statusbar == null) {
            statusbar = Ext.getCmp('statusbar');
        }
        waiter_time++;
        statusbar.showBusy()
    }, this);
    //if exception in request
    Ext.Ajax.on('requestexception', function(conn, response, options) {
        if (response.status === 0) {
            msg = Ext.i18n.observable_server_unreachable
        } else {
            if (response.status === 404) {
                msg = Ext.i18n.url_not_found + ': ' + options.url
            } else {
                msg = Ext.i18n.observable_http_error + ' ' + response.status +' (' + response.statusText + ')'
            }
        };
        ARV.observable.displayError(msg);
        waiter_time=waiter_time-1;
    }, this);
    //request complete
    Ext.Ajax.on('requestcomplete', function(conn, response, options) {
        send_clear = true;
        jresponse = Ext.util.JSON.decode(response.responseText)
        if (jresponse.authentification == false) {
            ARV.login.openWindow();
            waiter_time = 0;
        };
        if (jresponse.success == false) {
            message = Ext.i18n.python[jresponse.message];
            if (!message) {
                message = jresponse.message
            };
            ARV.observable.displayError(message);
            send_clear = false
        } else {
            if (jresponse.message) {
                message = Ext.i18n.python[jresponse.message];
                if (!message) {
                    message = jresponse.message
                };
                send_clear = false;
                ARV.observable.displayInfo(message);
            };
            if (jresponse.download) {
                Ext.DomHelper.append(document.body, {
                    tag: 'iframe',
                    id: 'downloadIframe',
                    frameBorder: 0,
                    width: 0,
                    height: 0,
                    css: 'display:none;visibility:hidden;height:0px;',
                    src: jresponse.download
                });
            }
        };
        if (send_clear) {
            ARV.observable.displayClear();
        } else {
            waiter_time=waiter_time-1;
        }
    }, this);
    return {
        fireEvent: function(eventname, params) {
            //fireEvent in observable
            console.log(eventname);
            observable.fireEvent(eventname, params)
        },
        displayError: function(message) {
            statusbar.setStatus({
                text: message,
                iconCls: 'x-status-error'
            });
            Ext.MessageBox.show({
                title: Ext.i18n.observable_error_title,
                msg: message,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            })
        },
        displayInfo: function(message) {
            statusbar.setStatus({
                text: message,
                iconCls: 'x-status-valid',
                clear: true // auto-clear after a set interval
            })
        },
        displayClear: function(message) {
            waiter_time=waiter_time-1;
            if (waiter_time < 1) {
                statusbar.clearStatus({useDefaults:true});
                waiter_time = 0
            }
        }
    }

})();
// vim: ts=4 sw=4 expandtab
