/*
 *
 *
 */

Ext.namespace("ARV");

ARV.treetmplconnect = (function() {
    /*
     * Private
     */
    var store = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name : 'tmplconnect'},
                {name : 'id'},
                {name : 'tmplnodea'},
                {name : 'tmplnodeaid'},
                {name : 'tmplnodeb'},
                {name : 'tmplnodebid'},
                {name : 'leftsendcert'}
            ]),
            url: 'arv/get_tmpl_connects'
    });
	columns = [
		{id: 'tmplconnect', header: Ext.i18n.name, sortable: true, dataIndex: 'tmplconnect'},
		{id: 'leftsendcert', header: Ext.i18n.leftsendcert, dataIndex: 'leftsendcert'},
		{header: 'id', sortable: true, dataIndex: 'id', hidden: true},
		{header: 'tmplnodea', sortable: true, dataIndex: 'tmplnodea', hidden: true},
		{header: 'tmplnodeb', sortable: true, dataIndex: 'tmplnodeb', hidden: true},
		{header: 'tmplnodeaid', sortable: true, dataIndex: 'tmplnodeaid', hidden: true},
		{header: 'tmplnodebid', sortable: true, dataIndex: 'tmplnodebid', hidden: true}
	];
	var grid = new ARV.GridPanel({
		store: store,
		columns: columns,
		region: 'west',
        width: 250,
		title: Ext.i18n.tmpl_connect,
		deleteUrl: 'arv/del_tmpl_connect',
		btnAddEvent: 'treetmplconnectadd',
		btnDelEvent: 'treetmplconnectchanged'
	});
	grid.getSelectionModel().on('rowselect', function() {ARV.observable.fireEvent('treetmpledgechanged')}, this);
    /*
     * Public
     */

    return {
        get: function() {
            return grid;
        },
        load: function() {
            store.removeAll();
            store.load();
			ARV.observable.fireEvent('treetmpledgechanged')
        },
        getSelectedRecord: function() {
            if (grid.getSelectionModel().hasSelection()) {
                return grid.getSelectionModel().getSelected();
            } else {
                return null
            }
        }

    };
})();
