
Ext.namespace("ARV");

ARV.addtmpledge = (function() {
    var observable = new Ext.util.Observable();
    /*
     * Private
     */
    return {
        openTmplVertexWindow: function(id, name, vstore, vertex_name, vertex_id, vertex_mimetype, vertex_module, vertex_ip1, vertex_ip2) {
            if (vertex_mimetype == null) {
                vertex_mimetype = 'ip';
            };

            var mimetype_store = new Ext.data.ArrayStore({
                fields: ['mimetype', 'name'],
                data: [
                    ['ip', Ext.i18n.vertex_mimetype_ip],
                    ['network', Ext.i18n.vertex_mimetype_network],
                    ['range' ,Ext.i18n.vertex_mimetype_range]
                ]
            });
            var module_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root :'data',
                    successProperty: 'success',
                },[{name: 'name'}, {name: 'moduleid'}]),
                listeners: {
                    'datachanged': function () {
                        Ext.getCmp('zephir_module').setValue(vertex_module);
                    }
                },
                url: 'arv/get_zephir_modules'
            });
            var variable_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root :'data',
                    successProperty: 'success',
                },[
                    {name: 'name'},
                ]),
                url: 'arv/get_zephir_variables'
            });
            module_store.load();
            if (vertex_id == null) {
                var button_vertex = {
                    text: Ext.i18n.save,
                    handler: function(btn, ev) {
                        Ext.getCmp('vertex_form').getForm().submit({
                            url: 'arv/add_tmpl_vertex',
                            params: {id: id},
                            //waitMsg: Ext.i18n.dialog_submit,
                            success: function(form){
                                tmp_tmpl_vertex = form.getValues()['name'];
                                if (vstore != null)
                                    vstore.load();
                                ARV.observable.fireEvent("tmplvertexchanged");
                                winaddtmplvertex.destroy()
                            }
                        })
                    },
                    scope: this
                }
            } else {
                var button_vertex = {
                    text: Ext.i18n.modify,
                    handler: function(btn, ev) {
                        Ext.getCmp('vertex_form').getForm().submit({
                            url: 'arv/mod_tmpl_vertex',
                            params: {id: id, tmpl_vertex_id: vertex_id},
                            //waitMsg: Ext.i18n.dialog_submit,
                            success: function(){
                                if (vstore != null)
                                    vstore.load();
                                ARV.observable.fireEvent("tmplvertexchanged");
                                winaddtmplvertex.destroy()
                            }
                        })
                    },
                    scope: this
                }
            };
            add_vertex_form = {
                xtype: 'form',
                id: 'vertex_form',
                buttonAlign: 'right',
                items: [{
                    xtype: "textfield",
                    name: 'name',
                    fieldLabel: Ext.i18n.addvertex_name,
                    width: 150,
                    value: vertex_name,
                    allowBlank: false
                },{
                    xtype: 'combo',
                    name: 'mimetype',
                    id: 'mimetype_combo',
                    store: mimetype_store,
                    displayField: 'name',
                    editable: false,
                    mode: 'local',
                    width: 150,
                    hiddenName:'mimetype',
                    valueField: 'mimetype',
                    allowBlank: false,
                    value: vertex_mimetype,
                    typeAhead: true,
                    forceSelection: true,
                    triggerAction: 'all',
                    fieldLabel: Ext.i18n.vertex_mimetype,
                    listeners:{
                        'select': function(combo, record) {
                            value = record.get('mimetype');
                            update_labels(value);
                        }
                    }
                },{
                    xtype: 'combo',
                    name: 'zephir_module',
                    id: 'zephir_module',
                    store: module_store,
                    displayField: 'name',
                    hiddenName: 'moduleid',
                    valueField: 'moduleid',
                    editable: false,
                    mode: 'local',
                    width: 150,
                    allowBlank: true,
                    typeAhead: true,
                    triggerAction: 'all',
                    fieldLabel: Ext.i18n.vertex_zephir_module,
                    listeners: {
                        'select': function(combo, record) {
                            module = record.get('moduleid');
                            if ( module != null ) {
                                variable_store.baseParams = {module: module};
                                variable_store.load()
                            }
                        }
                    },
                    tpl: new Ext.XTemplate('<tpl for=".">' +
                        '<div class="x-combo-list-item">' +
                        '<tpl if="name==null">' +
                        '&nbsp;' +
                        '</tpl>' +
                        '<tpl if="name!=null">' +
                        '{name}' +
                        '</tpl>' +
                        '</div></tpl>')
                },{
                    //FIXME: verifier que c'est une ip
                    xtype: "combo",
                    name: 'zephir_var_ip1',
                    store: variable_store,
                    displayField: 'name',
                    fieldLabel: Ext.i18n.addvertex_ip_ip1,
                    mode: 'local',
                    value: vertex_ip1,
                    allowBlank: true,
                    width: 150,
                    name: 'ip1',
                    id: 'ip1',
                    typeAhead: true,
                    triggerAction: 'all',
                },{
                    //FIXME: verifier que c'est une ip
                    xtype: "combo",
                    name: 'zephir_var_ip2',
                    store: variable_store,
                    displayField: 'name',
                    fieldLabel: '',
                    value: vertex_ip2,
                    mode: 'local',
                    allowBlank: true,
                    width: 150,
                    name: 'ip2',
                    id: 'ip2',
                    typeAhead: true,
                    triggerAction: 'all',
                }],
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(btn, ev) {
                        winaddtmplvertex.destroy()
                    },
                    scope: this
                }, button_vertex
                ]
            };
            var winaddtmplvertex = new ARV.PopupWindow({
                title: Ext.i18n.tmplvertex_title + ' ' + name,
                items: [add_vertex_form]
            }).show();
            function update_labels(value) {
                label1 = Ext.getCmp('ip1').label.up('.x-form-item', 10, true).child('.x-form-item-label');
                label2 = Ext.getCmp('ip2').label.up('.x-form-item', 10, true).child('.x-form-item-label');
                if (value == 'ip') {
                    Ext.getCmp('ip2').setDisabled(true);
                    label1.update(Ext.i18n.addvertex_ip_ip1);
                    label2.update('');
                } else if (value == 'range' ) {
                    Ext.getCmp('ip2').setDisabled(false);
                    label1.update(Ext.i18n.addvertex_range_ip1);
                    label2.update(Ext.i18n.addvertex_range_ip2)
                } else if (value == 'network') {
                    Ext.getCmp('ip2').setDisabled(false);
                    label1.update(Ext.i18n.addvertex_network_ip1);
                    label2.update(Ext.i18n.addvertex_network_ip2)
                }
            };
            update_labels(vertex_mimetype);
        },

        openWindow: function(tmplconnectid, tmplnode1, tmplnode1name, tmplnode2, tmplnode2name, tmpledgeid, tmplvertexname, tmplvertex1id, tmplvertex2id) {
            var tmp_tmpl_vertex = null;
            //if new tmpledge tmpledgeid is null
            if (tmpledgeid == null) {
                  button_tmpledge = {
                      text: Ext.i18n.save,
                      handler: function() {

                          teform.getForm().submit({
                              url: 'arv/add_tmpl_edge',
                              //waitMsg: Ext.i18n.dialog_submit,
                              params: {id: tmplconnectid},
                              success: response_success,
                          })
                     }
                }
            } else {
                  button_tmpledge = {
                      text: Ext.i18n.modify,
                      handler: function() {

                          teform.getForm().submit({
                              url: 'arv/mod_tmpl_edge',
                              //waitMsg: Ext.i18n.dialog_submit,
                              params: {id: tmpledgeid},
                              success: response_success,
                          })
                     }
                }
            };
            var teform = new Ext.FormPanel({
                border: false,
                frame: true,
                labelWidth: 150,
                items : [{
                    xtype : "textfield",
                    fieldLabel : Ext.i18n.addtmpledge_name,
                    width: '95%',
                    name : "name",
                    value: tmplvertexname,
                    allowBlank:false
                },{
                    layout: 'column',
                    items:[{
                        columnWidth: .7,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'vertex_1',
                            hiddenName: 'tmplvertex1',
                            emptyText: Ext.i18n.none_add_first,
                            fieldLabel: Ext.i18n.tmplvertex_label + ' ' + tmplnode1name,
                            name: 'tmplvertex1',
                            record: [
                                {name: 'tmplvertex'},
                                {name: 'mimetype'},
                                {name: 'module'},
                                {name: 'ip1'},
                                {name: 'ip2'},
                                {name: 'id'},
                            ],
                            url: 'arv/get_tmpl_vertices',
                            baseParams: {tmplnodeid: tmplnode1, modtmplvertex: 'true'},
                            displayField:'tmplvertex',
                            listen: {
                                'load': function(store, records, option){
                                    ARV.addtmpledge.setVertexValue(records, tmplvertex1id, 'vertex_1', tmp_tmpl_vertex);
                                    tmp_tmpl_vertex = null;
                                }
                            },
                            anchor:'99%'
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.modnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                vertex_1 =  Ext.getCmp('vertex_1');
                                store = vertex_1.getStore();
                                index = store.find('id', vertex_1.getValue());
                                rec = store.getAt(index);
                                ARV.addtmpledge.openTmplVertexWindow(tmplnode1, tmplnode1name,
                                        vertex_1.store, vertex_1.getRawValue(),
                                        rec.data.id,
                                        rec.data.mimetype,
                                        rec.data.module,
                                        rec.data.ip1,
                                        rec.data.ip2);
                            }
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.addtmpledge.openTmplVertexWindow(tmplnode1, tmplnode1name, Ext.getCmp('vertex_1').store);
                            }
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.del_choice_button,
                            anchor:'95%',
                            handler: function () {
                                vertex_1 =  Ext.getCmp('vertex_1');
                                store =  vertex_1.getStore();
                                index = store.find('id', vertex_1.getValue());
                                rec = store.getAt(index);
                                delete_btn('arv/del_tmpl_vertex',
                                    rec.data.id,
                                    'tmplvertexchanged', store
                                );
                            }
                        }]
                    }]
                },{
                    layout:'column',
                    items:[{
                        columnWidth:.7,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'vertex_2',
                            emptyText: Ext.i18n.none_add_first,
                            fieldLabel: Ext.i18n.tmplvertex_label + ' ' + tmplnode2name,
                            name: 'tmplvertex2',
                            hiddenName: 'tmplvertex2',
                            record: [
                                {name: 'tmplvertex'},
                                {name: 'mimetype'},
                                {name: 'module'},
                                {name: 'ip1'},
                                {name: 'ip2'},
                                {name: 'id'},
                            ],
                            url: 'arv/get_tmpl_vertices',
                            baseParams: {tmplnodeid: tmplnode2, modtmplvertex: 'true'},
                            displayField:'tmplvertex',
                            listen: {
                                'load': function(store, records, option){
                                    ARV.addtmpledge.setVertexValue(records, tmplvertex2id, 'vertex_2', tmp_tmpl_vertex);
                                    tmp_tmpl_vertex = null;
                                }
                            },
                            anchor:'99%'
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.modnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                vertex_2 =  Ext.getCmp('vertex_2');
                                store = vertex_2.getStore();
                                index = store.find('id', vertex_2.getValue());
                                rec = store.getAt(index);
                                ARV.addtmpledge.openTmplVertexWindow(tmplnode2, tmplnode2name,
                                        vertex_2.store, vertex_2.getRawValue(),
                                        rec.data.id,
                                        rec.data.mimetype,
                                        rec.data.module,
                                        rec.data.ip1,
                                        rec.data.ip2);
                            }
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.addtmpledge.openTmplVertexWindow(tmplnode2, tmplnode2name, Ext.getCmp('vertex_2').store);
                            }
                        }]
                    },{
                        columnWidth:.1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.del_choice_button,
                            anchor:'95%',
                            handler: function () {
                                vertex_2 =  Ext.getCmp('vertex_2');
                                store =  vertex_2.getStore();
                                index = store.find('id', vertex_2.getValue());
                                rec = store.getAt(index);
                                delete_btn('arv/del_tmpl_vertex',
                                    rec.data.id,
                                    'tmplvertexchanged', store
                                );
                            }
                        }]
                    }]
                }],

                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winaddtmpledge.destroy()
                    }
                }, button_tmpledge]
            });
            var response_success = function(response, options){
                ARV.observable.fireEvent("treetmpledgechanged");
                winaddtmpledge.destroy();
            };
            var winaddtmpledge = new ARV.PopupWindow({
    	       	title: Ext.i18n.win_addtmpl_edge_title,
                layout: 'fit',
                items: teform,
                width: 500,
                height: 200
            }).show();
        },
        setVertexValue: function(records, vertexid, vertexname, tmp_tmpl_vertex) {
            if (records.length != 0) {
                if (tmp_tmpl_vertex == null) {
                    new_value = false;
                    if (vertexid != null) {
                        for (var i = 0; i < records.length; i++) {
                            vid = records[i].get('id');
                            if (vid == vertexid) {
                                Ext.getCmp(vertexname).setValue(vid);
                                new_value = true;
                                break;
                            };
                        };
                    };
                    if (new_value == false) {
                        Ext.getCmp(vertexname).setValue(records[0].get('id'));
                    }
                } else {
                    for (var i = 0; i < records.length; i++) {
                        nid = records[i].get('tmplvertex');
                        if (nid == tmp_tmpl_vertex) {
                            Ext.getCmp(vertexname).setValue(records[i].get('id'));
                            break;
                        }
                    }
                }
            }
        }
    }
})();

// vim: ts=4 sw=4 expandtab
