/*
 *
 *
 */

Ext.namespace("ARV");


ARV.GridNode = Ext.extend(ARV.GridPanel, {
    initComponent:function() {
        this.columns = [{id: 'uai', header: Ext.i18n.uai, sortable: true, dataIndex: 'uai', width: 60},
            {id: 'node', header: Ext.i18n.node, sortable: true, dataIndex: 'node'},
            {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
        ];
        this.store = new Ext.data.Store({
            reader: new Ext.data.JsonReader({
                root :'data',
                successProperty: 'success',
            },[ {name : 'uai'},
                {name : 'node'},
                {name : 'id'},
            ]),
            url: 'arv/get_nodes'
        });
        this.deleteUrl = 'arv/del_node';
        this.dataIndex1 = 'uai';
        this.dataIndex2 = 'node';
        Ext.apply(this, {
            store: this.store,
            columns: this.columns,
            plugins:  new Ext.ux.grid.GridFilters({
                // encode and local configuration options defined previously for easier reuse
                // encode: encode, // json encode the filter query
                local: true,   // defaults to false (remote filtering)
                filters: [{
                    type: 'string',
                    dataIndex: this.dataIndex1,
                    },
                    {
                     type: 'string',
                     dataIndex: this.dataIndex2,
                    }
                ]
            }),

        });
        ARV.GridNode.superclass.initComponent.call(this)
    }
});

Ext.reg('arvgridnode', ARV.GridNode);
