# -*- coding: UTF-8 -*-
"""website server
"""
from arv.lib.logger import logger
from sys import exit
# ____________________________________________________________
from twisted.application import internet, service
from twisted.web import server, resource, static
from twisted.internet import reactor, ssl
from twisted.web.error import UnexposedMethodError
# ____________________________________________________________
# ____________________________________________________________
from arv.db.initialize import initialize_database, commit_database
# ____________________________________________________________
from arv.web.page import *
from arv.web.childpage import *
from arv.db.edge import get_edges
# ____________________________________________________________

class RootPage(resource.Resource):
    def getChild(self, name, request):
        pages = {'login': Login(),
                'logout': Close(),
                'apply': Apply(),

                'get_nodes': GetNodes(),
                'get_nodes_state': GetNodesState(),
                'get_edges': GetEdges(),
                'get_cred': GetCred(),
                'get_credauth': GetCredAuth(),
                'get_all_cred': GetAllCred(),
                'get_extr': GetExtr(),
                'get_connects': GetConnects(),
                'get_tmpl_nodes': GetTmplNodes(),
                'get_tmpl_connects': GetTmplConnects(),
                'get_tmpl_edges': GetTmplEdges(),
                'get_tmpl_vertices': GetTmplVertices(),
                'get_zephir_etabs': GetZephirEtabs(),
                'get_zephir_modules': GetZephirModules(),
                'get_zephir_variables': GetZephirVariables(),

                'add_tmpl_connect': AddTmplConnect(),
                'add_tmpl_node': AddTmplNode(),
                'add_tmpl_edge': AddTmplEdge(),
                'add_node': AddNode(),
                'add_connect': AddConnect(),
#                'add_cred': AddCred(),
                'add_credauth': AddCredAuth(),
                'add_extremity': AddExtremity(),
                'mod_extremity': ModExtrIP(),
                'add_imported_cred': AddImportedCred(),
                'add_imported_pkcs12': AddImportedPKCS12(),
                'add_generated_cred': AddGeneratedCred(),
                'add_tmpl_vertex': AddTmplVertex(),

                'mod_node': ModNode(),
                'mod_tmpl_edge': ModTmplEdge(),
                'mod_tmpl_vertex': ModTmplVertex(),
                'mod_connect': ModConnect(),
                'mod_keys': ModKeys(),
                'mod_ca': ModCA(),
                'sync_zephir': SynchroARVZephir(),

                'del_tmpl_connect': DelTmplConnect(),
                'del_tmpl_node': DelTmplNode(),
                'del_tmpl_edge': DelTmplEdge(),
                'del_tmpl_vertex': DelTmplVertex(),
                'del_node': DelNode(),
                'del_edge': DelEdge(),
                'del_connect': DelConnect(),
                'del_cred': DelCred(),
                'del_extip': DelExtrIP(),

                'dl_credential': DlCredential(),
                'send_db': SendDb()
            }

        if static.isDangerous(name):
            return static.dangerousPathError
        if name in pages.keys():
            print name
            print pages[name]
            return pages[name]
        # unauthorized request
        return UnexposedMethodError()

    def render(self, request):
        return "well, you are not expected to be here"

root = static.File(arv_static_path)
root.putChild("arv", RootPage())
site = server.Site(root)

initialize_database()
# delete records in edge table not deleted before fix #4680
for edge in get_edges():
    if not edge.connect:
        edge.delete()
commit_database()
# end fix #4680
application = service.Application("ARV")

if arv_ssl == "disabled":
    arvservice = internet.TCPServer(arv_port, site)
else:
    sslContext = ssl.DefaultOpenSSLContextFactory(
        arv_key,
        arv_crt,
    )
    arvservice = internet.SSLServer(arv_port, site, contextFactory = sslContext)

arvservice.setServiceParent(application)


