# -*- coding: utf-8 -*-
from os.path import isfile
from pyeole.pkg import EolePkg
from pyeole.process import system_out

def setup_module(module):
    """
    Initialisation du cache APT
    """
    module.repo = EolePkg("apt")


def _test_eole_package(pkgname):
    """
    Si le paquet est installé, vérifie que c'est la version EOLE
    """
    pkg = repo.get_package(pkgname)
    if pkg.installed is None:
        print("Le paquet {0} n'est pas installé".format(pkgname))
    else:
        print("Test du paquet {0}".format(pkgname))
        assert pkg.installed.origins[0].origin == 'Eole'


def test_eole_packages():
    """
    Paquets recompilés par EOLE
    """
    _test_eole_package('bareos')
    _test_eole_package('check-bareos-plugin')
    _test_eole_package('lightsquid')
    _test_eole_package('python-xmlsec')
    _test_eole_package('smbldap-tools')
    _test_eole_package('uucp')


def test_apt_changelog():
    """
    is apt changelog working ?
    """
    if not isfile('/etc/eole/.instance'):
        print("apt changelog n'est pas fonctionnel sur un serveur non instancié")
        return
    PACKAGES = ['eole-server', 'eole-open-iscsi', 'vim', 'mc']
    for pkgname in PACKAGES:
        assert system_out(['apt', 'changelog', pkgname])[0] == 0

