# coding: utf-8
import datetime
import autopath
from os.path import join
import subprocess
from copy import copy
from bson.objectid import ObjectId

from eoleaaf.util import db
from eoleaaf.parseaaf import main


data = join(autopath.HERE, 'data')

responsable = {"ENTPersonJointure": "994845",
               "ENTPersonDateNaissance": '',
               "ENTPersonNomPatro": "DELACOURT",
               "sn": "DELACOURT",
               "givenName": "Mathieu",
               "personalTitle": "M",
               "homePhone": "+33 0 00 11 22 33",
               "telephoneNumber": '',
               "ENTPersonAdresse": "2 ROUTE DE CHARTRES",
               "ENTPersonCodePostal": "75000",
               "ENTPersonVille": "PARIS",
               "ENTPersonPays": "FRANCE",
#GENERATE
               "ENTPersonLogin": "mathieu.delacourt01",
#ADDED
               'FieldActionType': 'CREATE',
               'FieldModifiedStatus': 1,
               'UserType': "responsable",
}

eleve = {"ENTPersonJointure": "14357",
         "ENTEleveStructRattachId": "436201",
         "ENTPersonDateNaissance": "28/11/1914",
         "ENTPersonNomPatro": "DELACOURT",
         "sn": "DELACOURT",
         "ENTPersonLogin": "albertine.delacourt02",
         'FieldActionType': 'CREATE',
         'FieldModifiedStatus': 1,
         'UserType': "eleve",
         "givenName": "Albertine",
         "ENTPersonAutresPrenoms": ["Albertine", "Pauline"],
         "personalTitle": "Mme.",
#         "ENTEleveParents": ["994845", "994846"],
#         "ENTElevePere": "994845",
#         "ENTEleveMere": "994846",
#         "ENTEleveAutoriteParentale": ["994845", "994846"],
         "ENTElevePersRelEleve1": '',
         "ENTEleveQualitePersRelEleve1": '',
         "ENTElevePersRelEleve2": '',
         "ENTEleveQualitePersRelEleve2": '',
         #FIXME donnee brute utile a extraire ? => http://media.eduscol.education.fr/file/ENT/27/9/Documentation-solutionsENT-evolutionsAAF-SDETv4_238279.pdf
         "ENTElevePersRelEleve": ["994845$1$0$2$1$0", "994846$2$1$1$1$0"],
         "ENTEleveBoursier": "O",
         "ENTEleveRegime": "EXTERNE LIBRE",
         "ENTEleveTransport": "N",
         "ENTEleveStatutEleve": "SCOLAIRE",
         "ENTEleveMEF": "21220008110",
         "ENTEleveLibelleMEF": "T-STL SC.PHYS.CHIM. EN LABORATOIRE",
         "ENTEleveNivFormation": "TERMINALE GENERALE & TECHNO YC BT",
         "ENTEleveFiliere": "TERMINALE TECHNOLOGIQUE",
         "ENTEleveEnseignements": ["PHILOSOPHIE", "CHIMIE, BIOCHIMIE, SCIENCES DU VIVANT", "ENSEIGNEMENT TECHNOLOGIQUE EN LV1", "SCIENCES PHYSIQUES ET CHIMIQUES EN LABO.", "VIE DE CLASSE", "ACCOMPAGNEMENT PERSONNALISE", "ANGLAIS LV1", "EDUCATION PHYSIQUE ET SPORTIVE", "ESPAGNOL LV2", "MATHEMATIQUES", "PHYSIQUE-CHIMIE"],
         "ENTEleveCodeEnseignements": ["010300", "308600"],
         #"ENTPersonStructRattach": "2515",
         #"ENTEleveClasses": "2515$T STL",
         "ENTEleveGroupes": []}

eleve2 = copy(eleve)
#eleve2["ENTEleveParents"] = ["994445", "994446"]
#eleve2["ENTEleveAutoriteParentale"] = ["994445", "994446"]
eleve2["ENTElevePersRelEleve"] = ["994445$1$0$2$1$0", "994446$2$1$1$1$0"]
eleve2["ENTEleveMEF"] = "21220008111"
#eleve2["ENTElevePere"] = "994445"
#eleve2["ENTEleveMere"] = "994446"
eleve2["ENTPersonLogin"] = 'albertine.delacourt03'
eleve2["ENTPersonJointure"] = "14358"

eleve3 = copy(eleve)
#eleve3["ENTEleveParents"] = ["994885", "994886"]
#eleve3["ENTEleveAutoriteParentale"] = ["994885", "994886"]
eleve3["ENTElevePersRelEleve"] = ["994885$1$0$2$1$0", "994886$2$1$1$1$0"]
eleve3["ENTEleveMEF"] = "21221118110"
#eleve3["ENTElevePere"] = "994885"
#eleve3["ENTEleveMere"] = "994886"
eleve3["ENTPersonLogin"] = 'albertine.delacourt04'
eleve3["ENTPersonJointure"] = "14359"

eleves = {'21220008110': eleve,
          '21220008111': eleve2,
          '21221118110': eleve3}

responsable2 = copy(responsable)
responsable2['ENTPersonJointure'] = '994885'
responsable2['ENTPersonLogin'] = 'mathieu.delacourt02'
responsable2["givenName"] = "Mathieu"
responsable2['homePhone'] = '+33 0 00 11 22 37'

responsable3 = copy(responsable)
responsable3['ENTPersonJointure'] = '994846'
responsable3["personalTitle"] = "Mme"
responsable3["givenName"] = "Jeanne"
responsable3["ENTPersonLogin"] = "jeanne.delacourt01"
responsable3['homePhone'] = '+33 0 00 11 22 34'

responsable4 = copy(responsable)
responsable4['ENTPersonJointure'] = '994446'
responsable4["personalTitle"] = "Mme"
responsable4["givenName"] = "Lyse"
responsable4["ENTPersonLogin"] = "lyse.delacourt01"
responsable4['homePhone'] = '+33 0 00 11 22 36'

responsable5 = copy(responsable)
responsable5['ENTPersonJointure'] = '994445'
responsable5["givenName"] = "Philippe"
responsable5["ENTPersonLogin"] = "philippe.delacourt01"
responsable5['homePhone'] = '+33 0 00 11 22 35'

responsable6 = copy(responsable)
responsable6['ENTPersonJointure'] = '994886'
responsable6["personalTitle"] = "Mme"
responsable6["givenName"] = "Albertine"
responsable6["ENTPersonLogin"] = "albertine.delacourt01"
responsable6['homePhone'] = '+33 0 00 11 22 38'

responsables = {'994845': responsable,
                '994885': responsable2,
                '994846': responsable3,
                '994446': responsable4,
                '994445': responsable5,
                '994886': responsable6,
}


prof = {
    "ENTPersonJointure": "163",
    "ENTPersonDateNaissance": "06/01/1918",
    "ENTPersonNomPatro": "DELMARE",
    "ENTPersonLogin": "ghislaine.delmare01",
    'FieldActionType': 'CREATE',
    'FieldModifiedStatus': 1,
    'UserType': 'enseignant',
    "sn": "DELMARE",
    "givenName": "GHISLAINE",
    "personalTitle": "Mme",
    "mail": "ghislaine.delmare@ac-test.fr",
    #"ENTPersonStructRattach": "2515",
    "ENTAuxEnsCategoDiscipline": "LANGUES VIVANTES",
    "ENTAuxEnsDisciplinesPoste": "ANGLAIS",
#    "ENTAuxEnsMEF": ["2515$10210001110$4EME", "2515$10210001112$4EME SECTION EUROPEENNE", "2515$10110001110$5EME", "2515$10010012110$6EME"],
#    "ENTAuxEnsMatiereEnseignEtab": "2515$ANGLAIS LV1",
#    "ENTAuxEnsClasses": ["2515$4E3", "2515$5E2", "2515$5E3", "2515$5E4", "2515$6E1", "2515$6E2"],
    #"ENTAuxEnsGroupes": '',
    #"ENTAuxEnsClassesMatieres": ["2515$4E3$030201", "2515$5E2$030201", "2515$5E3$030201", "2515$5E4$030201", "2515$6E1$030201", "2515$6E2$030201"],
    #"ENTAuxEnsGroupesMatieres": '',
    #"ENTAuxEnsClassesPrincipal": '2515$4E3',
    #"ENTPersonFonctions": "2515$ENS$ENSEIGNEMENT$L0422$ANGLAIS",
    "PersEducNatPresenceDevantEleves": "O"
    }


administratif = {
    "ENTPersonJointure": "34",
    "ENTPersonDateNaissance": "04/09/1985",
    "ENTPersonNomPatro": "THEODULE",
    "ENTPersonLogin": "annie.dubled01",
    'FieldActionType': 'CREATE',
    'FieldModifiedStatus': 1,
    'UserType': 'administratif',
    "sn": "DUBLED",
    "givenName": "ANNIE",
    "personalTitle": "Mme",
    "mail": "Annie.Dubled@ac-test.fr",
    "ENTPersonStructRattach": '',
    "ENTAuxEnsMEF": '',
    "ENTAuxEnsMatiereEnseignEtab": '',
    "ENTAuxEnsClasses": '',
    "ENTAuxEnsClassesMatieres": '',
    #"ENTPersonFonctions": "2515$ORI$ORIENTATION$O0040$ORIENTATION",
    "PersEducNatPresenceDevantEleves": "N",
}

etablissement = {
    "ENTStructureJointure": "2515",
    "ENTStructureUAI": "0000000TW",
    "ENTEtablissementUAI": "0000000TW",
    "ENTStructureSIREN": "17450234560289",
    "ENTStructureNomCourant": "D.E.E.E.-DU ac-test",
    "ENTStructureTypeStruct": "INSPECTIONS ACADEMIQUES",
    "ENTEtablissementMinistereTutelle": "MINISTERE DE L'EDUCATION NATIONALE",
    "ENTEtablissementContrat": "PU",
    'FieldActionType': 'CREATE',
    'FieldModifiedStatus': 1,
    "postOfficeBox": "608",
    "street": "RUE CITE",
    "postalCode": "18013",
    "l": "DIJON CEDEX",
    "telephoneNumber": "+33 211 25 687  00",
    "facsimileTelephoneNumber": "+33 2 125899 20 01",
    "ENTEtablissementStructRattachFctl": '',
    "ENTEtablissementBassin": "BASSIN DU TEST",
    "ENTServAcAcademie": "ac test",
    "ENTStructureClasses": '',
    "ENTStructureGroupes": [{'class': '4E3', 'group': '4E3_A'}, {'class': '4E3', 'group': '4E3_B'}],
}

subject = {
        "ENTMatJointure": '308600',
        "ENTLibelleMatiere": 'ANGLAIS',
        'FieldActionType': 'CREATE',
        'FieldModifiedStatus': 1
        }


def test_etablissement():
    keys = set(etablissement.keys()) | set(["_id", 'FieldFromXMLImportActionDate', 'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('etablissement')
    for res in result:
        print("etablissement")
        assert keys == set(res.keys())
        for key in etablissement:
            assert res[key] == etablissement[key], "la valeur correspondant à : {} est différente".format(key)


def test_subject():
    keys = set(subject.keys()) | set(["_id", 'FieldFromXMLImportActionDate', 'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('subject')
    for res in result:
        print("subject")
        assert keys == set(res.keys())
        for key in subject:
            assert res[key] == subject[key], "la valeur correspondant à : {} est différente".format(key)


def test_prof():
    objectid = 'ENTPersonStructRattach'
    relations = [('ENTAuxEnsMatiereEnseignEtab', ['ANGLAIS LV1']),
                 ("ENTAuxEnsClasses", ["4E3", "5E2", "5E3", "5E4", "6E1", "6E2"]),
                 ("ENTAuxEnsClassesPrincipal", ["4E3"]),
                 ("ENTAuxEnsGroupes", ["4E3_A"]),
                 ("ENTAuxEnsMEF", ["4EME", "4EME SECTION EUROPEENNE", "5EME", "6EME"]),
                 ('ENTPersonFonctions', (['ENSEIGNEMENT'], ['ANGLAIS'])),
                 ("ENTAuxEnsClassesMatieres", ["4E3", "5E2", "5E3", "5E4", "6E1", "6E2"]),
                 ("ENTAuxEnsGroupesMatieres", ["4E3_A"]),
                 ]
    keys = set(prof.keys()) | set(["userPassword", "_id", 'uid', 'FieldFromXMLImportActionDate', 'id']) | set([objectid])
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'enseignant')
    for res in result:
        print("professeur")
        assert keys == set(res.keys())
        for key in prof:
            assert res[key] == prof[key], "la valeur correspondant à : {} est différente".format(key)
        etab = res[objectid]
        assert isinstance(etab, ObjectId), "{} n'est pas une relation".format(objectid)

        for relation, values in relations:
            assert relation in res
            if relation == "ENTAuxEnsClassesMatieres":
                for idx, rel in enumerate(res[relation]):
                    assert rel['class'] == values[idx]
                    assert isinstance(rel['subject'], ObjectId)
            elif relation == "ENTAuxEnsGroupesMatieres":
                assert res[relation]['group'] == values[0]
                assert isinstance(res[relation]['subject'], ObjectId)
            else:
                if isinstance(res[relation], list):
                    for idx, rel in enumerate(res[relation]):
                        assert isinstance(rel['etablissement'], ObjectId)
                        assert rel['etablissement'] == etab
                        assert rel['name'] == values[idx]
                else:
                    assert isinstance(res[relation]['etablissement'], ObjectId)
                    assert res[relation]['etablissement'] == etab
                    if isinstance(values, tuple):
                        assert res[relation]['function'] == values[0][0]
                        assert res[relation]['discipline'] == values[1][0]
                    else:
                        assert res[relation]['name'] == values[0]

def test_administratif():
    relations = [('ENTPersonFonctions', (['ORIENTATION'], ['ORIENTATION']))
                 ]
    keys = set(administratif.keys()) | set(["userPassword", "_id", 'uid', 'FieldFromXMLImportActionDate', 'id'])
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'administratif')
    for res in result:
        print("administratif")
        assert keys == set(res.keys())
        for key in administratif:
            assert res[key] == administratif[key], "la valeur correspondant à : {} est différente".format(key)
        for relation, values in relations:
            assert relation in res
            assert isinstance(res[relation]['etablissement'], ObjectId)
            assert res[relation]['function'] == values[0][0]
            assert res[relation]['discipline'] == values[1][0]


def test_responsable():
    keys = set(responsable.keys()) | set(["userPassword", "_id", 'uid', 'FieldFromXMLImportActionDate', 'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'responsable')
    for res in result:
        idx = res['ENTPersonJointure']
        print("responsable numero", idx)
        assert keys == set(res.keys())
        for key in responsable:
            assert res[key] == responsables[idx][key], "la valeur correspondant à : {} est différente".format(key)


def test_eleves():
    objectids = ['ENTEleveParents', 'ENTElevePere', 'ENTEleveMere', 'ENTEleveAutoriteParentale', 'ENTPersonStructRattach']
    relations = [('ENTEleveClasses', ['T STL'])]
    keys = set(eleve.keys()) | set(["userPassword", "_id", 'uid', 'FieldFromXMLImportActionDate', 'id']) | set(objectids)
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'eleve')
    for res in result:
        idx = res['ENTEleveMEF']
        print("eleve numero", idx)
        assert keys == set(res.keys())
        for key in eleve:
            if key != 'ENTEleveCodeEnseignements':
                assert res[key] == eleves[idx][key], "la valeur correspondant à : {} est différente".format(key)
            else:
                assert res[key][0] == '010300'
                assert isinstance(res[key][1], ObjectId)
        for objectid in objectids:
            values = res[objectid]
            if isinstance(values, list):
                for val in values:
                    assert isinstance(val, ObjectId), "{} n'est pas une relation".format(objectid)
                    #FIXME bon parent ?
            else:
                assert isinstance(values, ObjectId), "{} n'est pas une relation".format(objectid)

        for relation, values in relations:
            assert relation in res
            assert isinstance(res[relation]['etablissement'], ObjectId)
            assert res[relation]['etablissement'] == res['ENTPersonStructRattach']
            assert res[relation]['name'] == values[0]


