#!/bin/sh
LC_ALL=fr_FR.UTF-8
export LC_ALL


logPath=$(CreoleGet geoexport_path)
log="$logPath/logs/exports.log"
date=$(/bin/date)
listeBases="/var/lib/postgresql/listeBases"
listeTables="/var/lib/postgresql/listeTables.txt"
exportTables="/var/lib/postgresql/exporTables.sh"
password=$(cat .pgpass |grep postgres|cut -d":" -f5)

rm -f $listeTables

#recup de la liste des bases
psql -d adl -U postgres -t -c 'select datname from pg_database where datistemplate = false ;' > $listeBases
sed -i /^$/d $listeBases

#generation de la liste des tables à exporter
while read line
do
    tableExiste=$(psql -d $line -U postgres -t -c "select count(*) from pg_catalog.pg_tables where tablename ='liste_export'"|tr -d " ")
    if [ "$tableExiste" == "1" ]; then
#    psql -d $line -U postgres -t -c "select concat('ogr2ogr f \"ESRI Shapefile\" /home/data/$line- ',id,'chaine2',nom_schema) FROM public.liste_export WHERE export = true;"
#psql -d $line -U postgres -t -c "select id,nom_shema,nom_table_vue FROM public.liste_export WHERE export = true;" > $line.txt
psql -d $line -U postgres -t -c "select concat('$line','&',nom_schema,'&',nom_table_vue) FROM public.liste_export WHERE export = true;" >> $listeTables
fi
done  < $listeBases

sed -i /^$/d $listeTables

#generation du script d'export
echo "#!/bin/bash" > $exportTables

while read line
do
	base=$(echo "$line" | cut -d"&" -f1 | tr -d " ")
	schema=$(echo "$line" | cut -d"&" -f2 | tr -d " ")
	table=$(echo "$line"|cut -d"&" -f3|tr -d " ")
    nomFichier=$(echo $logPath/$base-$schema-$table.shp)
    echo "echo \"---------- Traitement de la base $base schéma $schema table $table, fichier de sortie $nomFichier\"" >> $exportTables
    echo '/usr/bin/ogr2ogr -f "ESRI Shapefile" ' "$nomFichier" 'PG:"host='127.0.0.1' port='5432' dbname='"$base"' user=postgres password='"$password"'" -sql "select * from' $schema.$table'" 2>&1 >>' $log >> $exportTables
    echo "echo \"---------- fin de traitement de la base $base schéma $schema table $table, fichier de sortie $nomFichier\"" >> $exportTables
done < $listeTables

chmod +x $exportTables

