# -*- coding: utf-8 -*-

from os.path import join, isfile
from os import unlink
import sys
import importlib
from pathlib import Path

from pytest import raises

from pyeole.log import init_logging
from creole.loader import creole_loader

log = init_logging()

def setup_module(module):
    module.HERE = Path(__file__).resolve().parent
    module.ROOT_PATH = HERE.parent

    # Import action from ewt-actions
    PATH = HERE.parent.parent.joinpath('ewt-actions', 'ewt')
    # the ewt-action's project has to be cloned beside eole-dhcp
    if not PATH.is_dir():
        raise Exception("Please clone the ewt-action's project beside eole-dhcp for the test framework to be efficient")

    if PATH.as_posix() not in sys.path:
        sys.path.insert(1, PATH)

    PATH = ROOT_PATH.joinpath('extra', 'dhcpactivation', 'salt')
    module_path = PATH.joinpath('custom.py')
    spec = importlib.util.spec_from_file_location(module_path.stem, module_path)
    module = importlib.util.module_from_spec(spec)
    sys.modules[module_path.stem] = module
    spec.loader.exec_module(module)

    PATH = ROOT_PATH.joinpath('extra', 'dhcp', 'salt')
    module_path = PATH.joinpath('custom.py')
    spec = importlib.util.spec_from_file_location(module_path.stem, module_path)
    module = importlib.util.module_from_spec(spec)
    sys.modules[module_path.stem] = module
    spec.loader.exec_module(module)

    module.TEST_DATA_PATH = HERE.joinpath('data').as_posix()

def setup_function(function):
    test = join(TEST_DATA_PATH, 'generic', 'extra', 'dhcp', 'config.eol')
    if isfile(test):
        unlink(test)

    dhcp_custom._force_dirs = ['/usr/share/eole/creole/dicos']
    dhcp_custom._force_eoleextradico = join(ROOT_PATH, 'extra')
    dhcp_custom._force_configeol = join(TEST_DATA_PATH, 'generic', 'config.eol')
    dhcp_custom._force_eoleextraconfig = join(TEST_DATA_PATH, 'generic', 'extra')
    dhcp_custom._reload_config = False
    custom._upsert_reserved = dhcp_custom.upsert_reserved
    custom._get_subnets = dhcp_custom.get_subnets


def teardown_function(function):
    dhcp_custom._force_dirs = None
    dhcp_custom._force_eoleextradico = None
    dhcp_custom._force_configeol = None
    dhcp_custom._force_eoleextraconfig = None
    dhcp_custom._reload_config = True
    del custom._upsert_reserved
    del custom._get_subnets
    test = join(TEST_DATA_PATH, 'generic', 'extra', 'dhcp', 'config.eol')
    if isfile(test):
        unlink(test)
    dhcp_custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_empty.conf')


def test_conv_base():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_base.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:02', 'hostname': u'coucou', 'id': 1, 'ip': u'192.168.0.51'}, {'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}

def test_conv_outside_subnet():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_outside_subnet.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}

def test_conv_inside_named_range():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_inside_named_range.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:02', 'hostname': u'coucou', 'id': 1, 'rangename': u'test2'}, {'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}

def test_conv_inside_dynamic_range():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_inside_dynamic_range.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}
