# -*- coding: utf-8 -*-

from os.path import join, isfile
from os import unlink
import sys
from pathlib import Path
import importlib
from pyeole.log import init_logging
from pytest import raises
log = init_logging()

def setup_module(module):
    module.HERE = Path(__file__).resolve().parent
    PATH = HERE.joinpath('extra', 'dhcp', 'salt', 'custom.py')
    spec = importlib.util.spec_from_file_location(PATH.stem, PATH)
    module.custom = importlib.util.module_from_spec(spec)
    sys.modules[PATH.stem] = custom
    spec.loader.exec_module(custom)

    module.custom_desactivation._force_dirs = ['/usr/share/eole/creole/dicos']
    module.custom_desactivation._force_eoleextradico = '/usr/share/eole/creole/extra'
    module.custom_desactivation._force_configeol = join(HERE, 'data/generic/config.eol')
    module.custom_desactivation._force_eoleextraconfig = join(HERE, 'data/dhcpdesactivation/extra')
    module.custom_desactivation._reload_config = False


def teardown_module(module):
    module.custom_desactivation._force_dirs = None
    module.custom_desactivation._force_eoleextradico = None
    module.custom_desactivation._force_configeol = None
    module.custom_desactivation._force_eoleextraconfig = None
    module.custom_desactivation._reload_config = True
    test = 'dhcpdesactivation'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_desactivation():
    for func in dir(custom_desactivation):
        print(func)
        if not func.startswith("_") and not func == 'submit':  # submit doesn't work with the whole pytest environment
            assert getattr(custom_desactivation, func)() == {"messages": [{"msg": "Veuillez d'abord activer l'action DHCP de l'EAD3.", "level": "error"}]}

