# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{%- set pki_dir = salt["config.get"]("pki_dir") %}

{%- set old_name = pillar["old"] %}
{%- set old_key_path = pki_dir
    | path_join(
      "minions",
      old_name,
    ) %}

{%- set new_name = pillar["new"] %}
{%- set new_key_path = pki_dir
    | path_join(
      "minions",
      new_name,
    ) %}

eole-workstation/orch/minion/rename:
  salt.state:
    - tgt: "{{ old_name }}"
    - sls:
        - eole-workstation.salt.minion.name
    - pillar:
        minion_name: "{{ new_name }}"

eole-workstation/orch/minion/restart/cmd.run:
  salt.function:
    - name: cmd.run
    - tgt: "{{ old_name }}"
    - arg:
        - "salt-call service.restart salt-minion"
    - kwarg:
        bg: true
    - onchanges:
      - salt: eole-workstation/orch/minion/rename

eole-workstation/orch/minion/master-rename-minion-key:
  file.rename:
    - name: '{{ new_key_path }}'
    - source: '{{ old_key_path }}'
    - onchanges:
      - salt: eole-workstation/orch/minion/rename
      - salt: eole-workstation/orch/minion/restart/cmd.run
