#-*-coding:utf-8-*-

from twisted.python import log
from twisted.internet import reactor
from twisted.python.failure import Failure

from ldaptor.protocols.ldap.ldapconnector import LDAPClientCreator
from ldaptor.protocols.ldap import ldapclient
from ldaptor.protocols import pureldap
from ldaptor.protocols.ldap.ldapsyntax import LDAPEntryWithClient


# FIX #28745 : requestValue doit pouvoir être None, donc ne pas hériter de basestring
def fake_ldapextendedrequest_init(self, requestName, requestValue=None, tag=None):
    pureldap.LDAPProtocolRequest.__init__(self)
    pureldap.BERSequence.__init__(self, [], tag=tag)
    assert requestName is not None
    assert isinstance(requestName, basestring)
    self.requestName=requestName
    #assert isinstance(requestValue, basestring)
    self.requestValue=requestValue


ldapclient.pureldap.LDAPExtendedRequest.__init__ = fake_ldapextendedrequest_init

class LDAPBERDecoderContext_LDAPSearchResultReference(ldapclient.pureldap.BERDecoderContext):
    Identities = {
        ldapclient.pureldap.BEROctetString.tag: ldapclient.pureldap.LDAPString,
    }
ldapclient.pureldap.LDAPBERDecoderContext_LDAPSearchResultReference = LDAPBERDecoderContext_LDAPSearchResultReference


class LDAPSearchResultReference(ldapclient.pureldap.LDAPProtocolResponse, ldapclient.pureldap.BERSequence):
    tag = ldapclient.pureldap.CLASS_APPLICATION | 0x13

    def __init__(self, uris=None, tag=None):
        ldapclient.pureldap.LDAPProtocolResponse.__init__(self)
        ldapclient.pureldap.BERSequence.__init__(self, value=[], tag=tag)
        assert uris is not None
        self.uris = uris

    @classmethod
    def fromBER(cls, tag, content, berdecoder=None):
        l = ldapclient.pureldap.berDecodeMultiple(content,
                              LDAPBERDecoderContext_LDAPSearchResultReference(
                                  fallback=berdecoder))
        r = cls(uris=l)
        return r

    def toWire(self):
        return ldapclient.pureldap.BERSequence(ldapclient.pureldap.BERSequence(self.uris), tag=self.tag).toWire()

    def __repr__(self):
        return '{}(uris={}{})'.format(
            self.__class__.__name__,
            repr([str(uri) for uri in self.uris]),
            ', tag={}'.format(self.tag) if self.tag != self.__class__.tag else '',
        )
    def __str__(self):
        return ''.join([str(uri.value) for uri in self.uris])
ldapclient.pureldap.LDAPSearchResultReference = LDAPSearchResultReference
ldapclient.pureldap.LDAPBERDecoderContext.Identities[LDAPSearchResultReference.tag] = LDAPSearchResultReference


class EOLELDAPEntry(LDAPEntryWithClient):
    pouet = True
    def _cbSearchMsg(self, msg, *args, **kwargs):
        if isinstance(msg, LDAPSearchResultReference):
            return False
        return LDAPEntryWithClient._cbSearchMsg(self, msg, *args, **kwargs)

# end FIX


class EOLELDAPClientCreator(LDAPClientCreator):
    def connect(self, dn, overrides=None):
        d = LDAPClientCreator.connect(self, dn, overrides)
        if self.use_tls:
            d.addCallbacks(lambda proto: proto.startTLS())
        return d



def unbind_proto(result, proto):
    """
        Unbind an authenticated prototype
    """
    try:
        proto.unbind()
    except:
        log.err('Error trying to unbind LDAP connector (already disconnected ?)')
        pass
    return result

def make_ldapconnector():
    """
        Build ldap connection
    """
    return EOLELDAPClientCreator(reactor, ldapclient.LDAPClient)

