# -*- coding: utf-8 -*-

from os.path import join, isdir
from os import makedirs, unlink

import autopath
from pyeole import log

import logging

DATA = join(autopath.HERE, "data")
TEST_FORMAT = "%(asctime)s - %(name)s - %(levelname)s - TESTTEST '%(funcName)s' %(message)s"
log.DEFAULT_LOG_FILE = join(DATA, 'eole-default.log')

def setup_module(module):

    if not isdir(DATA):
        makedirs(DATA)

    module.logfile  = join(DATA, "eole-log.log")
    module.errfile   = join(DATA, "eole-critical.log")
    module.debugfile = join(DATA, "eole-debug.log")

    module.logfilesplit  = join(DATA, "eole-split-log.log")
    module.errfilesplit   = join(DATA, "eole-split-critical.log")
    module.debugfilesplit = join(DATA, "eole-split-debug.log")

    module.logfileformat  = join(DATA, "eole-format-log.log")
    module.errfileformat   = join(DATA, "eole-format-critical.log")
    module.debugfileformat = join(DATA, "eole-format-debug.log")

    module.eolelog = log.make_logger("testpackage", logfile, errfile=errfile, debugfile=debugfile, loglevel="DEBUG", splitlog=False)
    module.eolesplitlog = log.make_logger("testpackagesplit", logfilesplit, errfile=errfilesplit, debugfile=debugfilesplit, loglevel="DEBUG", splitlog=True)
    module.eoleformatlog = log.make_logger("testpackageformat", logfileformat, errfileformat, debugfileformat, "DEBUG", False, TEST_FORMAT)

def test_format_logger():
    eoleformatlog.critical("test critical message")
    assert "TESTTEST" in open(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(errfileformat).read().splitlines()[-1]

    eoleformatlog.error("test error message")
    assert "TESTTEST" in open(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(errfileformat).read().splitlines()[-1]

    eoleformatlog.warning("test warning message")
    assert "TESTTEST" in open(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(errfileformat).read().splitlines()[-1]

    eoleformatlog.info("test info message")
    assert "TESTTEST" in open(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(errfileformat).read().splitlines()[-1]

    eoleformatlog.debug("test debug message")
    assert "TESTTEST" in open(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in open(errfileformat).read().splitlines()[-1]

def test_split_logger():
    eolesplitlog.critical("test critical message")
    assert "critical" not in open(debugfilesplit).read()
    assert "critical" not in open(logfilesplit).read()
    assert "critical" in open(errfilesplit).read()

    eolesplitlog.error("test error message")
    assert "error" not in open(debugfilesplit).read()
    assert "error" not in open(logfilesplit).read()
    assert "error" in open(errfilesplit).read()

    eolesplitlog.warning("test warning message")
    assert "warning" not in open(debugfilesplit).read()
    assert "warning" not in open(logfilesplit).read()
    assert "warning" in open(errfilesplit).read()

    eolesplitlog.info("test info message")
    assert "info" not in open(debugfilesplit).read()
    assert "info" in open(logfilesplit).read()
    assert "info" not in open(errfilesplit).read()

    eolesplitlog.debug("test debug message")
    assert "debug" in open(debugfilesplit).read()
    assert "debug" not in open(logfilesplit).read()
    assert "debug" not in open(errfilesplit).read()

def test_logger():
    eolelog.critical("test critical message")
    assert "critical" in open(logfile).read()
    assert "critical" in open(errfile).read()
    assert "critical" in open(debugfile).read()

    eolelog.error("test error message")
    assert "error" in open(errfile).read()
    assert "error" in open(logfile).read()
    assert "error" in open(debugfile).read()

    eolelog.warning("test warning message")
    assert "warning" in open(errfile).read()
    assert "warning" in open(logfile).read()
    assert "warning" in open(debugfile).read()

    eolelog.info("test info message")
    assert "info" not in open(errfile).read()
    assert "info" in open(logfile).read()
    assert "info" in open(debugfile).read()

    eolelog.debug("test debug message")
    assert "debug" not in open(errfile).read()
    assert "debug" not in open(logfile).read()
    assert "debug" in open(debugfile).read()

def teardown_module(module):
   # return
    unlink(module.logfile)
    unlink(module.errfile)
    unlink(module.debugfile)
    unlink(module.logfilesplit)
    unlink(module.errfilesplit)
    unlink(module.debugfilesplit)
    unlink(module.logfileformat)
    unlink(module.errfileformat)
    unlink(module.debugfileformat)

