#!/usr/bin/env python3
# -*- coding: utf-8 -*-


import warnings
#json are not ordered (https://github.com/esnme/ultrajson/issues/241)
#try:
#    from ujson import dumps, loads
#except:
from json import dumps, loads
try:
    from http.server import HTTPServer, SimpleHTTPRequestHandler
    from urllib.parse import unquote
except ImportError:
    from SimpleHTTPServer import SimpleHTTPRequestHandler
    from BaseHTTPServer import HTTPServer
    from urllib import unquote

def get_values(config):
    pass

from tiramisu.config import Config
from tiramisu_web import tiramisu_copy, TiramisuWeb
#from data.unicode1 import get_description
#from data.unicode1_multi import get_description
#from data.unicode1_requires import get_description
#from data.unicode1_master_slaves import get_description
#from data.unicode1_master_slaves_hidden_all_default import get_description, get_values
#from data.unicode1_master_slaves_requires_default import get_description, get_values
#from data.filename1 import get_description
#from data.unicode1_not_equal import get_description
#from data.unicode_hidden import get_description
#from data.unicode1_master_hidden_slaves import get_description
#from data.unicode1_master_slaves_hidden import get_description
#from data.choice1_master_slaves import get_description
from data.choice1_master_slaves_hidden import get_description, get_values
#from data.unicode1_master_slaves_requires import get_description
#from data.hostname1 import get_description
#from data.ip1 import get_description


global config
config = None


def get_config():
    """generation config
    """
    descr = get_description()
    global config
    if config is None:
        config = Config(descr)
        get_values(config)
    return config


class RequestHandler(SimpleHTTPRequestHandler):
    """main
    """
    def __init__(self, *args):
        self.config = get_config()
        SimpleHTTPRequestHandler.__init__(self, *args)

    def do_GET(self):
        if self.path == '/variables':
            tiramisu = TiramisuWeb(self.config, remotable='none')
            form = [{'title': 'Configurer',
                     'type': 'submit'}]
            values = tiramisu.get_jsonform(form)

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            from pprint import pprint
            #pprint(values)
            self.wfile.write(dumps(values).encode())
        #elif self.path == '/':
        #    self.path = 'build/bundled/index.html'
        #    SimpleHTTPRequestHandler.do_GET(self)
        #elif self.path == '/src/javascript/tiramisu-form.html':
        #    self.path = 'build/bundled/src/javascript/tiramisu-form.html'
        #    SimpleHTTPRequestHandler.do_GET(self)
        else:
            if self.path != '/' and self.path != '/spinning.gif' and \
                    not self.path.startswith('/bower_components') and not self.path.startswith('/javascript'):
                self.path = '/notfound'
            if self.path == '/':
                self.path = '/src/index.html'
            if self.path.startswith('/bower_components'):
                self.path = '/src' + self.path
            if self.path.startswith('/javascript'):
                self.path = '/src' + self.path
            SimpleHTTPRequestHandler.do_GET(self)

    def do_PUT(self):
        """Put data
        """
        content_len = int(self.headers.get('content-length', 0))
        body = loads(self.rfile.read(content_len))
        #/variables/variable/<path>/<index>
        splitted_path = unquote(self.path).split('/', 3)
        if splitted_path[1] == 'variables' and splitted_path[2] == 'variable':
            tiramisu = TiramisuWeb(self.config, remotable='none')
            path = splitted_path[3]
            values = tiramisu.append_value(body[u'tiramisu'], path)

            text = "OK"
            type_ = 'info'
            for value in values.get('updates', []):
                if value.get('invalid'):
                    text = "Some variables are invalids"
                    type_ = 'error'
                    break

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            values['message'] = {'text': text, 'type': type_}
            self.wfile.write(dumps(values).encode())

    def do_POST(self):
        """Post data
        """
        content_len = int(self.headers.get('content-length', 0))
        body = loads(self.rfile.read(content_len))
        #/variables/variable/<path>/<value>
        splitted_path = unquote(self.path).split('/', 4)
        print "POST on {} with {}".format(self.path, body)
        if splitted_path[1] == 'variables':
            tiramisu = TiramisuWeb(self.config, remotable='none')
            if len(splitted_path) >= 4 and splitted_path[2] == 'variable':
                path = splitted_path[3]
                #value = loads(splitted_path[4])
                if len(splitted_path) == 5:
                    index = int(splitted_path[4])
                else:
                    index = None
                value = body[u'value']
                values = tiramisu.set_updates(body[u'tiramisu'], path, value, index)
            else:
                values = tiramisu.set_updates(body[u'tiramisu'])
                assert list(self.config.cfgimpl_get_values().mandatory_warnings()) == []
                print(self.config.make_dict(flatten=True))

            text = "OK"
            type_ = 'info'
            for value in values.get('updates', []):
                if value.get('invalid'):
                    text = "Some variables are invalids"
                    type_ = 'error'
                    from pprint import pprint
                    pprint(values)
                    break

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            values['message'] = {'text': text, 'type': type_}
            self.wfile.write(dumps(values).encode())

    def do_DELETE(self):
        """do delete
        """
        content_len = int(self.headers.get('content-length', 0))
        body = loads(self.rfile.read(content_len))
        #/variable/<path>/<index>
        splitted_path = unquote(self.path).split('/', 3)
        print splitted_path

        if splitted_path[1] == 'variable':
            path = splitted_path[2]
            tiramisu = TiramisuWeb(self.config, remotable='none')
            if len(splitted_path) == 4:
                index = int(splitted_path[3])
                values = tiramisu.del_value(body[u'tiramisu'], path, index)
            else:
                values = tiramisu.del_value(body[u'tiramisu'], path)

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            self.wfile.write(dumps(values).encode())


def main(port=8000):
    """Launches the http server
    """
    print('Listening on localhost:%s' % port)
    server = HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == "__main__":
    main()
