# eole-genconfig-tests

Automatisation des tests fonctionnels pour GenConfig.

## Description

Ce projet a pour objet d'automatiser les tests fonctionnels liés à l'utilitaire
GenConfig. L'outil de test est basé sur :

* [MochaJS](https://mochajs.org/) : Mocha est un framework de test JavaScript
  riche en fonctionnalités. Il peut être exécuté sur Node.js ou dans un
  navigateur. Les tests sont exécutés en série, permettant des rapports flexibles
  et précis, tout en cartographiant les exceptions non capturées pour les cas de
  test correct.
* [NightmareJS](http://www.nightmarejs.org/) : Librairie d'automatisation
  haut-niveau des actions réalisables dans un navigateur web.

## Usage

### Prérequis

- NodeJS v6.9.1 (LTS)

### Installation des dépendances

```bash
cd eole-genconfig-tests
npm install
```

### Exécution des tests

Soit une machine EOLE nouvellement instanciée.

```bash
cd eole-genconfig-tests
MACHINE_HOST="<Adresse IP machine EOLE>" ROOT_PASSWORD="<Mot de passe root de la machine EOLE>" npm test
```

Exemple de sortie

```bash
MACHINE_HOST="..." ROOT_PASSWORD="..." npm test

> eole-automated-testing@1.0.0 test /home/ghis/Workspace/eole-genconfig-tests
> mocha --timeout 120000 --recursive



  eole-genconfig
    login()
      ✓ should be possible to access the web interface on port 7000 (644ms)
      ✓ should be possible to login with crendentials "root"/"eole" (2723ms)
      ✓ should not be possible to login with credentials "root"/"*NOT_A_PASSWORD*" (5375ms)

  eole-genconfig
    save()
      ✓ should be possible to save the configuration without modification (5835ms)
      ✓ should be possible to change the establishment's name  (7054ms)


  5 passing (22s)

```

### Configuration

Posibilité de configurer les variables MACHINE_HOST, ROOT_PASSWORD et d'autres
données de test (paramètres, mots de passes, timeouts, etc.) dans le fichier
`config.js` :

```bash
define("MACHINE_HOST", "192.168.0.24");
define("ROOT_PASSWORD", "eole");
define("ROOT_WRONG_PASSWORD", "*NOT_A_PASSWORD*");
define("LOGIN_WAIT", 500);
define("SHOW", true);
```

Si les données sont correctement renseignées, la commande à exécuter sera alors réduite à

```bash
npm test
```

### Filtres

`mocha` permet la définition de filtres :

* `mocha --grep <pattern>`: Applique un filtre sur la description des tests (ex: `eole-genconfig`, `login()`)
* `mocha --fgrep <pattern>`: Applique un filter sur le nom des fichiers de tests (ex: `login.js`, `save.js`)

*TODO*: Implémenter la gestion de ces arguments pour la commande `npm test`
