from tiramisu.option import ChoiceOption, OptionDescription
from tiramisu.setting import groups

def get_description():
    """generate description for this test
    """
    option = ChoiceOption('choice1', "Choice description", ("choice 1", "choice 2"), multi=True)
    option1 = ChoiceOption('choice2', "Choice description", ("choice 3", "choice 4"), multi=True)
    option2 = ChoiceOption('choice3', "Choice description", ("choice 5", "choice 6"), multi=True)
    option3 = ChoiceOption('choice4', "Choice description", ("choice 7", "choice 8"), multi=True)
    descr1 = OptionDescription("choice1", "Common configuration 1",
                               [option, option1, option2, option3])
    descr1.impl_set_group_type(groups.master)
    descr = OptionDescription("options", "Common configuration 2", [descr1])
    descr = OptionDescription("options", "Common configuration 3", [descr])
    return descr


def get_values(config):
    config.options.choice1.choice1.append('choice 2')
    config.options.choice1.choice2[0]  = 'choice 4'
