from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu.setting import groups


def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Unicode master", multi=True)
    option1 = UnicodeOption('unicode1', "Unicode slave 1", multi=True)
    option2 = UnicodeOption('unicode2', "Unicode slave 2", multi=True, properties=('hidden',))
    option3 = UnicodeOption('unicode3', "Unicode slave 3", multi=True)
    descr1 = OptionDescription("unicode", "Common configuration",
                               [option, option1, option2, option3])
    descr1.impl_set_group_type(groups.master)
    descr = OptionDescription("options", "Common configuration", [descr1])
    descr = OptionDescription("options", "Common configuration", [descr])
    return descr


def get_values(config):
    config.options.unicode1.unicode1.append(u'val1')
    config.options.unicode1.unicode1.append(u'val2')
    config.options.unicode1.unicode2[0] = u'super'
