# -*- coding: utf-8 -*-
from json import loads, dumps
from tiramisu.config import Config
from tiramisu_web import TiramisuWeb

from data import unicode1
from data import choice1
from data import filename1
from data import hostname1
from data import mail1
from data import number1
from data import date1
from data import username1
from data import boolean1
from data import unicode1_multi
from data import unicode1_multi_mandatory
from data import unicode1_mandatory
from data import unicode1_master_slaves
from data import unicode1_calculated_var_with_autofreeze


def test_json_unicode():
    tiramisu = TiramisuWeb(Config(unicode1.get_description()), remotable='none')
    form = [{'title': 'Configurer',
             'type': 'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))

    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.unicode"}], "form": [{"type": "input", "key": "options.unicode", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.unicode": {"mode": "basic", "type": "string", "name": "options.unicode", "value": null, "title": "Unicode 1"}}}}}')

    assert values == expected


def test_json_choice():
    tiramisu = TiramisuWeb(Config(choice1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.choice"}], "form": [{"type": "choice", "key": "options.choice", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.choice": {"name": "options.choice", "title": "Choice description", "enum": ["choice 1", "choice 2"], "value": null, "mode": "basic", "type": "string"}}}}}', encoding='utf-8')
    assert values == expected


def test_json_filename():
    tiramisu = TiramisuWeb(Config(filename1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads(u'{"model": [{"required": true, "value": null, "invalid": false, "key": "usbpath", "owner": "default", "properties": ["mandatory"]}], "form": [{"pattern": "^[a-zA-Z0-9\\\\-\\\\._~/+]+$", "type": "input", "key": "usbpath", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"usbpath": {"mode": "basic", "type": "string", "name": "usbpath", "value": null, "title": "Chemin d\'accès"}}}', encoding='utf-8')
    assert values == expected


# def test_json_hostname():
#     tiramisu = TiramisuWeb(Config(hostname1.get_description()), remotable='none')
#     form = [{u'title': u'Configurer',
#              u'type': u'submit'}]
#     values = loads(dumps(tiramisu.get_jsonform(form)).encode())
#     # FIXME marche pas
#     expected = loads('{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.hostname"}], "form": [{"key": "options.hostname", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.hostname": {"mode": "basic", "type": "string", "name": "options.hostname", "value": null, "title": "Hostname Description"}}}}}')
#
#     assert values == expected


def test_json_mail():
    tiramisu = TiramisuWeb(Config(mail1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.mail"}], "form": [{"pattern": "^[a-zA-Z0-9.!#$%&\'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\\\.[a-zA-Z0-9-]+)*$", "type": "input", "key": "options.mail", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.mail": {"mode": "basic", "type": "email", "name": "options.mail", "value": null, "title": "Mail Description"}}}}}')

    assert values == expected


def test_json_number():
    tiramisu = TiramisuWeb(Config(number1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.integer"}], "form": [{"type": "input", "key": "options.integer", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.integer": {"mode": "basic", "type": "number", "name": "options.integer", "value": null, "title": "integer 1"}}}}}')
    assert values == expected


def test_json_date():
    tiramisu = TiramisuWeb(Config(date1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads(u'{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.date"}], "form": [{"key": "options.date", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.date": {"mode": "basic", "type": "string", "name": "options.date", "value": null, "title": "Date description"}}}}}')
    assert values == expected


def test_json_username():
    tiramisu = TiramisuWeb(Config(username1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads(u'{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.username"}], "form": [{"pattern": "^[a-z_][a-z0-9_-]{0,30}[$a-z0-9_-]{0,1}$", "type": "input", "key": "options.username", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.username": {"mode": "basic", "type": "string", "name": "options.username", "value": null, "title": "Username description"}}}}}')
    assert values == expected


def test_json_boolean():
    tiramisu = TiramisuWeb(Config(boolean1.get_description()), remotable='none')
    form = [{u'title': u'Configurer',
             u'type': u'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)).encode())
    expected = loads(u'{"model": [{"key": "options"}, {"owner": "default", "value": null, "invalid": false, "key": "options.boolean"}], "form": [{"key": "options.boolean", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.boolean": {"mode": "basic", "type": "boolean", "name": "options.boolean", "value": null, "title": "Boolean 1"}}}}}')
    assert values == expected


def test_json_unicode_multi():
    tiramisu = TiramisuWeb(Config(unicode1_multi.get_description()), remotable='none')
    form = [{'title': 'Configurer',
             'type': 'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "properties": ["empty"], "value": [], "invalid": false, "key": "options.unicode"}], "form": [{"type": "input", "key": "options.unicode", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.unicode": {"isMulti": true, "mode": "basic", "type": "string", "name": "options.unicode", "value": [], "title": "Unicode 1"}}}}}')

    assert values == expected


def test_json_unicode_mandatory():
    tiramisu = TiramisuWeb(Config(unicode1_mandatory.get_description()), remotable='none')
    form = [{'title': 'Configurer',
             'type': 'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "properties": ["mandatory"], "required": true, "value": null, "invalid": false, "key": "options.unicode"}], "form": [{"type": "input", "key": "options.unicode", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.unicode": {"mode": "basic", "type": "string", "name": "options.unicode", "value": null, "title": "Unicode 1"}}}}}')

    assert values == expected


def test_json_unicode_multi_mandatory():
    tiramisu = TiramisuWeb(Config(unicode1_multi_mandatory.get_description()), remotable='none')
    form = [{'title': 'Configurer',
             'type': 'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))
    expected = loads('{"model": [{"key": "options"}, {"owner": "default", "properties": ["mandatory", "empty"], "required": true, "value": [], "invalid": false, "key": "options.unicode"}], "form": [{"type": "input", "key": "options.unicode", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"options": {"mode": "basic", "title": "Common configuration", "type": "object", "name": "options", "properties": {"options.unicode": {"isMulti": true, "mode": "basic", "type": "string", "name": "options.unicode", "value": [], "title": "Unicode 1"}}}}}')

    assert values == expected


def test_json_unicode_master_slaves():
    tiramisu = TiramisuWeb(Config(unicode1_master_slaves.get_description()), remotable='none')
    form = [{'title': 'Configurer',
             'type': 'submit'}]
    values = loads(dumps(tiramisu.get_jsonform(form)))
    expected = loads('{"model": [{"key": "unicode"}, {"owner": "default", "value": [], "invalid": false, "key": "unicode.unicode", "properties": ["empty"]}, {"owner": "default", "value": [], "invalid": false, "key": "unicode.unicode1"}, {"owner": "default", "value": [], "invalid": false, "key": "unicode.unicode2"}, {"owner": "default", "value": [], "invalid": false, "key": "unicode.unicode3"}], "form": [{"type": "input", "key": "unicode.unicode2", "clearable": true}, {"type": "input", "key": "unicode.unicode", "clearable": true}, {"type": "input", "key": "unicode.unicode1", "clearable": true}, {"type": "input", "key": "unicode.unicode3", "clearable": true}, {"type": "submit", "title": "Configurer"}], "schema": {"unicode": {"mode": "basic", "title": "Common configuration", "type": "array", "name": "unicode", "properties": {"unicode.unicode": {"name": "unicode.unicode", "title": "Unicode master", "isMulti": true, "value": [], "mode": "basic", "type": "string"}, "unicode.unicode1": {"name": "unicode.unicode1", "title": "Unicode slave 1", "isMulti": true, "value": [], "mode": "basic", "type": "string"}, "unicode.unicode2": {"name": "unicode.unicode2", "title": "Unicode slave 2", "isMulti": true, "value": [], "mode": "basic", "type": "string"}, "unicode.unicode3": {"name": "unicode.unicode3", "title": "Unicode slave 3", "isMulti": true, "value": [], "mode": "basic", "type": "string"}}}}}')

    assert values == expected
