#!/usr/bin/env python3
# -*- coding: utf-8 -*-


import warnings
#json are not ordered (https://github.com/esnme/ultrajson/issues/241)
#try:
#    from ujson import dumps, loads
#except:
from json import dumps, loads
from os.path import splitext
try:
    from http.server import HTTPServer, SimpleHTTPRequestHandler
    from urllib.parse import unquote
except ImportError:
    from SimpleHTTPServer import SimpleHTTPRequestHandler
    from BaseHTTPServer import HTTPServer
    from urllib import unquote

def get_values(api):
    pass


get_description = None
get_permissives = None
get_properties = None
get_form = None


from pprint import pprint

from tiramisu import Config, OptionDescription
from tiramisu_web import TiramisuWeb
#
#from data.boolean1 import get_description
#from data.choice1 import get_description
#from data.choice1_multi import get_description
#from data.choice1_rename import get_description, get_form
#from data.number1 import get_description
#from data.unicode1 import get_description
#from data.unicode2 import get_description
#from data.unicode2_copy import get_description
from data.date1 import get_description
#from data.filename1 import get_description
#from data.hostname1 import get_description
#FIXME from data.ip1 import get_description
#from data.mail1 import get_description
#from data.username1 import get_description
##
#from data.number1_value import get_description
#from data.number1_mod_value import get_description, get_values
##multi
#from data.unicode1_multi import get_description
#from data.unicode1_multi_value import get_description
#from data.unicode1_multi_mandatory import get_description
#from data.unicode1_multi_mod_value import get_description, get_values
#from data.unicode2_multi_copy import get_description
#from data.unicode_property import get_description, get_properties
from data.unicode_property_optiondescription import get_description, get_properties
##hidden
#from data.unicode_hidden import get_description
#from data.unicode1_multi_hidden import get_description
##require
#from data.choice1_requires import get_description
#from data.unicode1_requires import get_description
#from data.unicode1_multi_requires import get_description
#from data.unicode1_optiondescription_requires import get_description
#FIXME avec des multi !
##mandatory
#FIXME devrait etre rouge au chargement .... from data.unicode1_mandatory import get_description
##not equal
#from data.unicode1_not_equal import get_description
##master
#from data.choice1_master_slaves import get_description
#from data.choice1_master_slaves_value import get_description, get_values
#from data.unicode1_master_slaves import get_description
#from data.unicode1_master_slaves_not_equal import get_description
#from data.unicode1_master_slaves_value import get_description, get_values
#from data.unicode1_master_slaves_default_value import get_description
#from data.unicode1_master_slaves_requires_slave_value import get_description, get_values
#
#from data.unicode1_master_slaves_requires_default import get_description, get_values
#
#from data.choice1_master_slaves_hidden import get_description
#from data.unicode1_master_hidden_slaves import get_description
#from data.unicode1_master_slaves_hidden import get_description, get_values
#from data.unicode1_master_slaves_requires_all import get_description
#from data.unicode1_master_slaves_requires_slave import get_description
#from data.unicode1_master_slaves_requires_slaves import get_description
#from data.unicode1_master_slaves_requires_value import get_description, get_values
#from data.unicode1_master_slaves_hidden_all_default import get_description
#
#from data.unicode1_master_slaves_requires import get_description
#FIXME multi avec default_multi
#FIXME disabled
from test_json import list_data


#FIXME pas de retour possible pour une master et les slaves !


global api
api = None
if get_description is None:
    ALL_DATA = True
else:
    ALL_DATA = False


def get_config(form=None):
    """generation config
    """
    global api
    if api is None:
        if ALL_DATA:
            descrs = []
            filenames = list_data()
            nfilenames = filenames.copy()
            for filename in filenames:
                if '_' in filename:
                    continue
                nfilenames.remove(filename)
                modulepath = splitext(filename)[0]
                mod = __import__(modulepath)
                descrs.append(mod.get_description())
            for filename in nfilenames:
                if 'master' in filename:
                    continue
                modulepath = splitext(filename)[0]
                mod = __import__(modulepath)
                descrs.append(mod.get_description())
            for filename in nfilenames:
                if 'master' not in filename:
                    continue
                modulepath = splitext(filename)[0]
                mod = __import__(modulepath)
                descrs.append(mod.get_description())
            api = Config(OptionDescription('root', 'root', descrs))
            for filename in filenames:
                modulepath = splitext(filename)[0]
                mod = __import__(modulepath)
                if 'get_values' in dir(mod):
                    mod.get_values(api, allpath=True)
                if form is not None and 'get_form' in dir(mod):
                    form.extend(mod.get_form(allpath=True))
        else:
            descr = get_description()
            api = Config(descr)
            get_values(api)
            if get_permissives:
                api.permissive.set(get_permissives())
            if get_properties:
                api.property.set(get_properties())
            if get_form:
                form.extend(get_form())
    return api


class RequestHandler(SimpleHTTPRequestHandler):
    """main
    """
    def __init__(self, *args):
        SimpleHTTPRequestHandler.__init__(self, *args)

    def do_GET(self):
        if self.path == '/variables':
            form = [{'title': 'Configurer',
                     'type': 'submit'}]
            api = get_config(form)
            tiramisu = TiramisuWeb(api, remotable='none')
            values = tiramisu.get_jsonform(form)

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            pprint(values)
            self.wfile.write(dumps(values).encode())
        #elif self.path == '/':
        #    self.path = 'build/bundled/index.html'
        #    SimpleHTTPRequestHandler.do_GET(self)
        #elif self.path == '/src/javascript/tiramisu-form.html':
        #    self.path = 'build/bundled/src/javascript/tiramisu-form.html'
        #    SimpleHTTPRequestHandler.do_GET(self)
        else:
            #if self.path != '/' and self.path != '/spinning.gif' and self.path != '/example.html' and \
            #        not self.path.startswith('/bower_components') and not self.path.startswith('/javascript'):
            #    self.path = '/notfound'

            if self.path == '/':
                self.path = '/src/index.html'
            #if self.path == '/':
            #    self.path = '/src/index2.html'
            #if self.path == '/user.html':
            #    self.path = '/src/user.html'
            #if self.path == '/user2.html':
            #    self.path = '/src/user2.html'
            if self.path == '/example.html':
                self.path = '/src/example.html'
            if self.path.startswith('/bower_components'):
                self.path = '/src' + self.path
            if self.path.startswith('/javascript'):
                self.path = '/src' + self.path
            SimpleHTTPRequestHandler.do_GET(self)

    def do_POST(self):
        """Post data
        """
        content_len = int(self.headers.get('content-length', 0))
        body = loads(self.rfile.read(content_len))
        #/variables/variable/<path>/<value>
        splitted_path = unquote(self.path).split('/', 4)
        print("POST on {} with:".format(self.path))
        pprint(body)
        if splitted_path[1] == 'variables':
            api = get_config()
            tiramisu = TiramisuWeb(api, remotable='none')
            if len(splitted_path) >= 4 and splitted_path[2] == 'variable':
                path = splitted_path[3]
                #value = loads(splitted_path[4])
                if len(splitted_path) == 5:
                    index = int(splitted_path[4])
                else:
                    index = None
                value = body[u'value']
                values = tiramisu.set_updates(body, path, value, index)
            else:
                values = tiramisu.set_updates(body)
                api = get_config()
                assert list(api.value.mandatory_warnings()) == []

            text = "OK"
            type_ = 'info'
            #print(values)
            #for value in values.get('updates', []):
            #    print(value)
            #    if value.get('invalid'):
            #        text = "Some variables are invalids"
            #        type_ = 'error'
            #        pprint(values)
            #        break

            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            values['message'] = {'text': text, 'type': type_}
            self.wfile.write(dumps(values).encode())


def main(port=8000):
    """Launches the http server
    """
    print('Listening on localhost:%s' % port)
    server = HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == "__main__":
    main()
