# -*- coding: utf-8 -*-

from tiramisu.option import (UnicodeOption, OptionDescription, PortOption,
                             IntOption, ChoiceOption, SymLinkOption, IPOption,
                             NetworkOption, NetmaskOption, DomainnameOption, BroadcastOption,
                             URLOption, EmailOption, FilenameOption, DateOption,
                             PasswordOption, BoolOption, UsernameOption)
from . import eosfunc
from tiramisu import Config


from tiramisu_web import Params, ParamOption, ParamContext, ParamValue, MasterSlaves


def get_config():
    option_139789498664080 = UnicodeOption(**{'default': u'192.0.2.1', 'doc': u'Adresse IP du bridge', 'multi': False, 'properties': (), 'name': 'adresse_ip_br0'})
    option_139789498664352 = UnicodeOption(**{'default': u'255.255.255.0', 'doc': u'Adresse IP du netmask du bridge', 'multi': False, 'properties': (), 'name': 'adresse_netmask_br0'})
    option_139789498664624 = UnicodeOption(**{'default': u'192.0.2.0', 'doc': u'Adresse r\xe9seau du bridge br0', 'multi': False, 'properties': (), 'name': 'adresse_network_br0'})
    option_139789498664896 = UnicodeOption(**{'default': u'192.0.2.255', 'doc': u'Adresse IP du broadcast du bridge', 'multi': False, 'properties': (), 'name': 'adresse_broadcast_br0'})
    option_139789498665168 = UnicodeOption(**{'default': u'', 'doc': u'Chemin du conteneur root', 'multi': False, 'properties': (), 'name': 'container_path_root'})
    option_139789498665440 = UnicodeOption(**{'default': u'127.0.0.1', 'doc': u'Adresse IP du conteneur root', 'multi': False, 'properties': (), 'name': 'container_ip_root'})
    option_139789498665712 = UnicodeOption(**{'default': u'root', 'doc': u'Nom du groupe du conteneur root', 'multi': False, 'properties': (), 'name': 'container_name_root'})
    option_139789497844632 = SymLinkOption(**{'name': 'adresse_ip_root', "opt": option_139789498665440})
    option_139789498665984 = UnicodeOption(**{'doc': u'Chemin du conteneur all', 'multi': False, 'properties': (), 'name': 'container_path_all'})
    option_139789498666256 = UnicodeOption(**{'doc': u'Adresse IP du conteneur all', 'multi': False, 'properties': (), 'name': 'container_ip_all'})
    option_139789498666528 = UnicodeOption(**{'default': u'all', 'doc': u'Nom du groupe du conteneur all', 'multi': False, 'properties': (), 'name': 'container_name_all'})
    option_139789497846032 = SymLinkOption(**{'name': 'adresse_ip_all', "opt": option_139789498666256})
    option_139789497851984 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs', 'doc': u'Chemin du conteneur annuaire', 'multi': False, 'properties': (), 'name': 'container_path_annuaire'})
    option_139789497852256 = UnicodeOption(**{'default': u'192.0.2.50', 'doc': u'Adresse IP du conteneur annuaire', 'multi': False, 'properties': (), 'name': 'container_ip_annuaire'})
    option_139789497852528 = UnicodeOption(**{'default': u'bdd', 'doc': u'Nom du groupe du conteneur annuaire', 'multi': False, 'properties': (), 'name': 'container_name_annuaire'})
    option_139789497847432 = SymLinkOption(**{'name': 'adresse_ip_annuaire', "opt": option_139789497852256})
    option_139789497852800 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs', 'doc': u'Chemin du conteneur mail', 'multi': False, 'properties': (), 'name': 'container_path_mail'})
    option_139789497853072 = UnicodeOption(**{'default': u'192.0.2.51', 'doc': u'Adresse IP du conteneur mail', 'multi': False, 'properties': (), 'name': 'container_ip_mail'})
    option_139789497853344 = UnicodeOption(**{'default': u'reseau', 'doc': u'Nom du groupe du conteneur mail', 'multi': False, 'properties': (), 'name': 'container_name_mail'})
    option_139789497853616 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs', 'doc': u'Chemin du conteneur dhcp', 'multi': False, 'properties': (), 'name': 'container_path_dhcp'})
    option_139789497853888 = UnicodeOption(**{'default': u'192.0.2.52', 'doc': u'Adresse IP du conteneur dhcp', 'multi': False, 'properties': (), 'name': 'container_ip_dhcp'})
    option_139789497854160 = UnicodeOption(**{'default': u'partage', 'doc': u'Nom du groupe du conteneur dhcp', 'multi': False, 'properties': (), 'name': 'container_name_dhcp'})
    option_139789497858040 = SymLinkOption(**{'name': 'adresse_ip_dhcp', "opt": option_139789497853888})
    option_139789497854432 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs', 'doc': u'Chemin du conteneur fichier', 'multi': False, 'properties': (), 'name': 'container_path_fichier'})
    option_139789497854704 = UnicodeOption(**{'default': u'192.0.2.52', 'doc': u'Adresse IP du conteneur fichier', 'multi': False, 'properties': (), 'name': 'container_ip_fichier'})
    option_139789497854976 = UnicodeOption(**{'default': u'partage', 'doc': u'Nom du groupe du conteneur fichier', 'multi': False, 'properties': (), 'name': 'container_name_fichier'})
    option_139789497859440 = SymLinkOption(**{'name': 'adresse_ip_fichier', "opt": option_139789497854704})
    option_139789497855248 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs', 'doc': u'Chemin du conteneur web', 'multi': False, 'properties': (), 'name': 'container_path_web'})
    option_139789497855520 = UnicodeOption(**{'default': u'192.0.2.51', 'doc': u'Adresse IP du conteneur web', 'multi': False, 'properties': (), 'name': 'container_ip_web'})
    option_139789497864272 = UnicodeOption(**{'default': u'reseau', 'doc': u'Nom du groupe du conteneur web', 'multi': False, 'properties': (), 'name': 'container_name_web'})
    option_139789497861016 = SymLinkOption(**{'name': 'adresse_ip_web', "opt": option_139789497855520})
    option_139789497864544 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs', 'doc': u'Chemin du conteneur dns', 'multi': False, 'properties': (), 'name': 'container_path_dns'})
    option_139789497864816 = UnicodeOption(**{'default': u'192.0.2.53', 'doc': u'Adresse IP du conteneur dns', 'multi': False, 'properties': (), 'name': 'container_ip_dns'})
    option_139789497865088 = UnicodeOption(**{'default': u'internet', 'doc': u'Nom du groupe du conteneur dns', 'multi': False, 'properties': (), 'name': 'container_name_dns'})
    option_139789497865360 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs', 'doc': u'Chemin du conteneur mysql', 'multi': False, 'properties': (), 'name': 'container_path_mysql'})
    option_139789497865632 = UnicodeOption(**{'default': u'192.0.2.50', 'doc': u'Adresse IP du conteneur mysql', 'multi': False, 'properties': (), 'name': 'container_ip_mysql'})
    option_139789497865904 = UnicodeOption(**{'default': u'bdd', 'doc': u'Nom du groupe du conteneur mysql', 'multi': False, 'properties': (), 'name': 'container_name_mysql'})
    option_139789497863256 = SymLinkOption(**{'name': 'adresse_ip_mysql', "opt": option_139789497865632})
    option_139789497866176 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs', 'doc': u'Chemin du conteneur proxy', 'multi': False, 'properties': (), 'name': 'container_path_proxy'})
    option_139789497866448 = UnicodeOption(**{'default': u'192.0.2.53', 'doc': u'Adresse IP du conteneur proxy', 'multi': False, 'properties': (), 'name': 'container_ip_proxy'})
    option_139789497866720 = UnicodeOption(**{'default': u'internet', 'doc': u'Nom du groupe du conteneur proxy', 'multi': False, 'properties': (), 'name': 'container_name_proxy'})
    option_139789497868928 = SymLinkOption(**{'name': 'adresse_ip_proxy', "opt": option_139789497866448})
    option_139789497866992 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs', 'doc': u'Chemin du conteneur ftp', 'multi': False, 'properties': (), 'name': 'container_path_ftp'})
    option_139789497867264 = UnicodeOption(**{'default': u'192.0.2.52', 'doc': u'Adresse IP du conteneur ftp', 'multi': False, 'properties': (), 'name': 'container_ip_ftp'})
    option_139789497867536 = UnicodeOption(**{'default': u'partage', 'doc': u'Nom du groupe du conteneur ftp', 'multi': False, 'properties': (), 'name': 'container_name_ftp'})
    option_139789497870328 = SymLinkOption(**{'name': 'adresse_ip_ftp', "opt": option_139789497867264})
    option_139789497867808 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs', 'doc': u'Chemin du conteneur internet', 'multi': False, 'properties': (), 'name': 'container_path_internet'})
    option_139789497872464 = UnicodeOption(**{'default': u'192.0.2.53', 'doc': u'Adresse IP du conteneur internet', 'multi': False, 'properties': (), 'name': 'container_ip_internet'})
    option_139789497872736 = UnicodeOption(**{'default': u'internet', 'doc': u'Nom du groupe du conteneur internet', 'multi': False, 'properties': (), 'name': 'container_name_internet'})
    option_139789497871728 = SymLinkOption(**{'name': 'adresse_ip_internet', "opt": option_139789497872464})
    option_139789497873008 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs', 'doc': u'Chemin du conteneur bdd', 'multi': False, 'properties': (), 'name': 'container_path_bdd'})
    option_139789497873280 = UnicodeOption(**{'default': u'192.0.2.50', 'doc': u'Adresse IP du conteneur bdd', 'multi': False, 'properties': (), 'name': 'container_ip_bdd'})
    option_139789497873552 = UnicodeOption(**{'default': u'bdd', 'doc': u'Nom du groupe du conteneur bdd', 'multi': False, 'properties': (), 'name': 'container_name_bdd'})
    option_139789497877400 = SymLinkOption(**{'name': 'adresse_ip_bdd', "opt": option_139789497873280})
    option_139789497873824 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs', 'doc': u'Chemin du conteneur reseau', 'multi': False, 'properties': (), 'name': 'container_path_reseau'})
    option_139789497874096 = UnicodeOption(**{'default': u'192.0.2.51', 'doc': u'Adresse IP du conteneur reseau', 'multi': False, 'properties': (), 'name': 'container_ip_reseau'})
    option_139789497874368 = UnicodeOption(**{'default': u'reseau', 'doc': u'Nom du groupe du conteneur reseau', 'multi': False, 'properties': (), 'name': 'container_name_reseau'})
    option_139789497878800 = SymLinkOption(**{'name': 'adresse_ip_reseau', "opt": option_139789497874096})
    option_139789497874640 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs', 'doc': u'Chemin du conteneur partage', 'multi': False, 'properties': (), 'name': 'container_path_partage'})
    option_139789497874912 = UnicodeOption(**{'default': u'192.0.2.52', 'doc': u'Adresse IP du conteneur partage', 'multi': False, 'properties': (), 'name': 'container_ip_partage'})
    option_139789497875184 = UnicodeOption(**{'default': u'partage', 'doc': u'Nom du groupe du conteneur partage', 'multi': False, 'properties': (), 'name': 'container_name_partage'})
    option_139789497880200 = SymLinkOption(**{'name': 'adresse_ip_partage', "opt": option_139789497874912})
    option_139789498700496 = OptionDescription(children=[option_139789498664080, option_139789498664352, option_139789498664624, option_139789498664896, option_139789498665168, option_139789498665440, option_139789498665712, option_139789497844632, option_139789498665984, option_139789498666256, option_139789498666528, option_139789497846032, option_139789497851984, option_139789497852256, option_139789497852528, option_139789497847432, option_139789497852800, option_139789497853072, option_139789497853344, option_139789497853616, option_139789497853888, option_139789497854160, option_139789497858040, option_139789497854432, option_139789497854704, option_139789497854976, option_139789497859440, option_139789497855248, option_139789497855520, option_139789497864272, option_139789497861016, option_139789497864544, option_139789497864816, option_139789497865088, option_139789497865360, option_139789497865632, option_139789497865904, option_139789497863256, option_139789497866176, option_139789497866448, option_139789497866720, option_139789497868928, option_139789497866992, option_139789497867264, option_139789497867536, option_139789497870328, option_139789497867808, option_139789497872464, option_139789497872736, option_139789497871728, option_139789497873008, option_139789497873280, option_139789497873552, option_139789497877400, option_139789497873824, option_139789497874096, option_139789497874368, option_139789497878800, option_139789497874640, option_139789497874912, option_139789497875184, option_139789497880200], **{'doc': u'Information sur les conteneurs', 'properties': ('hidden', 'normal'), 'name': 'containers'})
    option_139789498700496.impl_set_information("icon", u"""puzzle-piece""")
    option_139789497875456 = UnicodeOption(**{'default': u'amonecole', 'doc': u'Nom du module EOLE', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'eole_module'})
    option_139789497875728 = UnicodeOption(**{'multi': False, 'name': 'ubuntu_version', 'doc': u'Nom de version de la distribution Ubuntu', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.get_version, 'callback_params': Params(args=(ParamValue("UBUNTU_VERSION"),), kwargs={})})
    option_139789497876000 = UnicodeOption(**{'multi': False, 'name': 'eole_version', 'doc': u'Num\xe9ro de version majeure du module EOLE', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.get_version, 'callback_params': Params(args=(ParamValue("EOLE_VERSION"),), kwargs={})})
    option_139789497888848 = UnicodeOption(**{'multi': False, 'name': 'eole_release', 'doc': u'Num\xe9ro de version fonctionnelle du module EOLE', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.get_version, 'callback_params': Params(args=(ParamValue("EOLE_RELEASE"),), kwargs={})})
    option_139789497889120 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'mode_conteneur_actif', 'default': 'oui', 'doc': u'Le serveur est en mode conteneur', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497889392 = ChoiceOption(**{'callback_params': None, 'multi': False, 'values': (u'oui', u'non'), 'name': 'module_instancie', 'doc': u'Le serveur a \xe9t\xe9 instanci\xe9', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.is_instanciate})
    option_139789497889664 = UnicodeOption(**{'doc': u"Identifiant de l'\xe9tablissement (exemple UAI)", 'multi': False, 'properties': ('auto_freeze', 'mandatory', 'basic'), 'name': 'numero_etab'})
    option_139789497889664.impl_set_information("separator", (u'\xc9tablissement', None))
    option_139789497889936 = UnicodeOption(**{'doc': u"Nom de l'\xe9tablissement", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'libelle_etab'})
    option_139789497890208 = DomainnameOption(**{'multi': False, 'name': 'nom_machine', 'allow_ip': False, 'type_': 'hostname', 'doc': u'Nom de la machine', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497875456, False)})})
    option_139789497890208.impl_set_information("separator", ('Nom DNS du serveur', None))
    option_139789497890208.impl_set_information("help", u"""Nom de la machine (exemple : eolebase)""")
    option_139789497890480 = DomainnameOption(**{'type_': 'netbios', 'name': 'smb_netbios_name', 'doc': u'Nom du contr\xf4leur de domaine (ex: monserveur)', 'multi': False, 'warnings_only': True, 'properties': ('auto_freeze', 'mandatory', 'basic')})
    option_139789497890480.impl_set_information("help", u"""Nom DNS du contrôleur de domaine. En mode conteneur, il doit être différent de celui du serveur Linux EOLE.""")
    option_139789497890208.impl_add_consistency("not_equal", option_139789497890480, **{'warnings_only': True})
    option_139789497890752 = DomainnameOption(**{'type_': 'domainname', 'name': 'nom_domaine_local', 'doc': u'Nom DNS du r\xe9seau local', 'allow_ip': True, 'allow_without_dot': True, 'multi': False, 'properties': ('mandatory', 'basic')})
    option_139789497890752.impl_set_information("help", u"""Nom de domaine privé du reseau local""")
    option_139789497891024 = DomainnameOption(**{'multi': False, 'name': 'nom_domaine_machine', 'allow_ip': False, 'type_': 'domainname', 'doc': u"Nom DNS associ\xe9 \xe0 l'interface 0", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamOption(option_139789497890208, False), ParamValue("."), ParamOption(option_139789497890752, False)), kwargs={})})
    option_139789497891296 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_academie', 'doc': u'Nom de domaine acad\xe9mique (ex : ac-dijon)', 'allow_ip': False, 'multi': False, 'properties': ('mandatory', 'basic')})
    option_139789497891296.impl_set_information("separator", (u'Param\xe8tres r\xe9seau globaux', None))
    option_139789497891568 = DomainnameOption(**{'type_': 'hostname', 'name': 'suffixe_domaine_academique', 'doc': u'Suffixe du nom de domaine acad\xe9mique', 'default': u'fr', 'allow_ip': False, 'multi': False, 'properties': ('mandatory', 'basic')})
    option_139789497891840 = ChoiceOption(**{'multi': False, 'values': (u'2', u'3', u'4', u'5'), 'name': 'nombre_interfaces', 'default': u'2', 'doc': u"Nombre d'interfaces \xe0 activer", 'properties': ('mandatory', 'normal')})
    option_139789497892112 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_proxy_client', 'default': 'non', 'doc': u'Utiliser un serveur mandataire (proxy) pour acc\xe9der \xe0 Internet', 'properties': ('mandatory', 'basic')})
    option_139789497892112.impl_set_information("help", u"""Le module EOLE doit utiliser un serveur mandataire (proxy) pour accéder à Internet""")
    option_139789497892384 = DomainnameOption(**{'multi': False, 'name': 'proxy_client_adresse', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom ou adresse IP du serveur proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497892112}]})
    option_139789497892384.impl_set_information("help", u"""Adresse IP ou nom de domaine du serveur proxy à utiliser par le module EOLE""")
    option_139789497938000 = PortOption(**{'multi': False, 'name': 'proxy_client_port', 'allow_private': True, 'default': 3128, 'doc': u'Port du serveur proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497892112}]})
    option_139789497938000.impl_set_information("help", u"""Port du serveur proxy à utiliser par le module EOLE""")
    option_139789497938272 = ChoiceOption(**{'multi': False, 'values': (u'statique', u'dhcp', u'pppoe'), 'name': 'eth0_method', 'default': u'statique', 'doc': u"M\xe9thode d'attribution de l'adressage pour l'interface", 'properties': ('mandatory', 'basic')})
    option_139789497938272.impl_set_information("separator", ("Configuration de l'interface", None))
    option_139789497938544 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_ip_dns', 'doc': u'Adresse IP du serveur DNS', 'properties': ('basic',), 'callback': eosfunc.auto_dns, 'callback_params': Params(args=(ParamOption(option_139789497938272, False),), kwargs={})})
    option_139789497938544.impl_set_information("help", u"""Adresse IP du serveur de nom primaire, en général celui de votre fournisseur Internet""")
    option_139789497938816 = UnicodeOption(**{'default': u'Europe/Paris', 'doc': u'Fuseau horaire du serveur', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'time_zone'})
    option_139789497938816.impl_set_information("proposed_value", (u'Africa/Asmara', u'Africa/Cairo', u'Africa/Tripoli', u'America/Adak', u'America/Anchorage', u'America/Argentina/Buenos_Aires', u'America/Argentina/Catamarca', u'America/Argentina/Cordoba', u'America/Argentina/Jujuy', u'America/Argentina/Mendoza', u'America/Cayenne', u'America/Chicago', u'America/Denver', u'America/Detroit', u'America/Edmonton', u'America/Guadeloupe', u'America/Halifax', u'America/Havana', u'America/Indianapolis', u'America/Jamaica', u'America/Los_Angeles', u'America/Manaus', u'America/Martinique', u'America/Mazatlan', u'America/Mexico_City', u'America/Miquelon', u'America/New_York', u'America/Noronha', u'America/Phoenix', u'America/Regina', u'America/Rio_Branco', u'America/Santiago', u'America/Sao_Paulo', u'America/St_Johns', u'America/Tijuana', u'America/Toronto', u'America/Vancouver', u'America/Whitehorse', u'America/Winnipeg', u'Antarctica/McMurdo', u'Asia/Ashgabat', u'Asia/Chongqing', u'Asia/Dhaka', u'Asia/Ho_Chi_Minh', u'Asia/Hong_Kong', u'Asia/Kathmandu', u'Asia/Kolkata', u'Asia/Macau', u'Asia/Riyadh', u'Asia/Seoul', u'Asia/Shanghai', u'Asia/Singapore', u'Asia/Taipei', u'Asia/Tehran', u'Asia/Tel_Aviv', u'Asia/Thimphu', u'Asia/Tokyo', u'Asia/Ulaanbaatar', u'Atlantic/Faroe', u'Atlantic/Reykjavik', u'Australia/Adelaide', u'Australia/Brisbane', u'Australia/Darwin', u'Australia/Hobart', u'Australia/Lord_Howe', u'Australia/Melbourne', u'Australia/Perth', u'Australia/Sydney', u'Europe/Dublin', u'Europe/Helsinki', u'Europe/Istanbul', u'Europe/Lisbon', u'Europe/London', u'Europe/Moscow', u'Europe/Paris', u'Europe/Warsaw', u'Indian/Mayotte', u'Indian/Reunion', u'Pacific/Auckland', u'Pacific/Chatham', u'Pacific/Easter', u'Pacific/Gambier', u'Pacific/Honolulu', u'Pacific/Kwajalein', u'Pacific/Noumea', u'Pacific/Marquesas', u'Pacific/Pago_Pago', u'Pacific/Tahiti', u'Pacific/Wallis'))
    option_139789497939088 = DomainnameOption(**{'multi': True, 'name': 'serveur_ntp', 'allow_without_dot': True, 'default': [u'0.fr.pool.ntp.org', u'1.fr.pool.ntp.org', u'2.fr.pool.ntp.org', u'3.fr.pool.ntp.org'], 'doc': u'Adresse du serveur NTP', 'type_': 'domainname', 'allow_ip': True, 'default_multi': u'0.fr.pool.ntp.org', 'properties': ('mandatory', 'normal')})
    option_139789497939088.impl_set_information("help", u"""Nom ou adresse IP du serveur de temps""")
    option_139789497939360 = ChoiceOption(**{'multi': False, 'values': (u'autosign\xe9', u'letsencrypt', u'manuel'), 'name': 'cert_type', 'default': u'autosign\xe9', 'doc': u'Certificat SSL', 'properties': ('mandatory', 'basic')})
    option_139789497939360.impl_set_information("separator", ('Choix du certificat SSL', None))
    option_139789497939632 = FilenameOption(**{'multi': False, 'name': 'server_cert', 'doc': u'Chemin du fichier contenant le certificat SSL', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("manuel"),), kwargs={'default_match': ParamValue("None"), 'condition_1': ParamOption(option_139789497939360, False), 'mismatch': ParamValue("/etc/ssl/certs/eole.crt")}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497939632.impl_set_information("help", u"""Le certificat SSL doit être au format PEM et est généralement fourni dans un fichier avec l'extension \"crt\"""")
    option_139789497939904 = FilenameOption(**{'multi': False, 'name': 'server_key', 'default': u'/etc/ssl/certs/eole.key', 'doc': u'Chemin du fichier contenant la cl\xe9 priv\xe9e du certificat SSL', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497939904.impl_set_information("help", u"""La clé privé doit être au format PEM et est généralement fournie dans un fichier avec l'extension \"key\"""")
    option_139789497940176 = FilenameOption(**{'multi': False, 'name': 'server_pem', 'doc': u'Chemin du fichier contenant la cha\xeene de certification', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("manuel"),), kwargs={'default_match': ParamValue("None"), 'condition_1': ParamOption(option_139789497939360, False), 'mismatch': ParamValue("/etc/ssl/certs/eole.pem")}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}, {'expected': u'autosign\xe9', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497940176.impl_set_information("help", u"""La chaîne de certification doit être au format PEM et est généralement fournie dans un fichier avec l'extension \"pem\"""")
    option_139789497940448 = DomainnameOption(**{'multi': True, 'name': 'serveur_maj', 'allow_without_dot': True, 'default': [u'eole.ac-dijon.fr', u'ftp.crihan.fr'], 'doc': u'Serveur de mise \xe0 jour', 'type_': 'domainname', 'allow_ip': True, 'default_multi': u'eole.ac-dijon.fr', 'properties': ('mandatory', 'normal')})
    option_139789497940448.impl_set_information("separator", (u'Mise \xe0 jour', None))
    option_139789497940448.impl_set_information("help", u"""Nom ou adresse IP du serveur de mise à jour""")
    option_139789497940720 = DomainnameOption(**{'multi': True, 'name': 'ubuntu_update_mirrors', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Serveur de mise \xe0 jour Ubuntu', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.auto_copy_val, 'callback_params': Params(args=(ParamOption(option_139789497940448, False),), kwargs={})})
    option_139789497940720.impl_set_information("help", u"""Nom ou adresse IP du serveur de mise à jour pour les paquets Ubuntu (utilise la valeur de serveur_maj par défaut)""")
    option_139789497940992 = DomainnameOption(**{'multi': True, 'name': 'envole_update_mirrors', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Serveur de mise \xe0 jour Envole', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.auto_copy_val, 'callback_params': Params(args=(ParamOption(option_139789497940448, False),), kwargs={})})
    option_139789497941264 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_filtrage_proxy', 'default': 'oui', 'doc': u'Activer le filtrage sur le proxy', 'properties': ('mandatory', 'expert')})
    option_139789497941264.impl_set_information("help", u"""Active le logiciel de filtrage e2guardian""")
    option_139789497941536 = URLOption(**{'multi': False, 'name': 'url_maj_blacklist', 'allow_without_dot': True, 'default': u'http://eole.orion.education.fr/maj/blacklists', 'allow_ip': True, 'doc': u'Adresse web de mise \xe0 jour des blacklists', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497954384 = UnicodeOption(**{'default': u'eth1', 'doc': u'Interface associ\xe9e \xe0 adresse_ip_fichier_link', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'fichier_link_interface'})
    option_139789498700816 = OptionDescription(children=[option_139789497875456, option_139789497875728, option_139789497876000, option_139789497888848, option_139789497889120, option_139789497889392, option_139789497889664, option_139789497889936, option_139789497890208, option_139789497890752, option_139789497891024, option_139789497891296, option_139789497891568, option_139789497891840, option_139789497892112, option_139789497892384, option_139789497938000, option_139789497938544, option_139789497938816, option_139789497939088, option_139789497939360, option_139789497939632, option_139789497939904, option_139789497940176, option_139789497940448, option_139789497940720, option_139789497940992, option_139789497941536, option_139789497954384], **{'doc': u'g\xe9n\xe9ral', 'properties': ('basic',), 'name': 'general'})
    option_139789498700816.impl_set_information("help", u"""Paramètres de base du serveur""")
    option_139789498700816.impl_set_information("icon", u"""wrench""")
    option_139789497954656 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_log_distant', 'default': 'non', 'doc': u'Activer la gestion des logs centralis\xe9s', 'properties': ('mandatory', 'expert')})
    option_139789497954928 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_apt_cacher', 'default': 'oui', 'doc': u'Activer le cache APT', 'properties': ('mandatory', 'expert')})
    option_139789497954928.impl_set_information("help", u"""Apt-cacher est une solution proxy de mise en cache de paquets Debian""")
    option_139789497955200 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_eoledb', 'default': 'oui', 'doc': u'Activer le service de gestion de bases de donn\xe9es EoleDB', 'properties': ('mandatory', 'expert')})
    option_139789497955200.impl_set_information("help", u"""Utiliser ou non le service de gestion des bases de données EoleDB""")
    option_139789497955472 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_clam', 'default': 'oui', 'doc': u"Activer l'anti-virus ClamAV", 'properties': ('mandatory', 'normal')})
    option_139789497955472.impl_set_information("help", u"""ClamAV est un logiciel anti-virus pour Unix""")
    option_139789497955744 = ChoiceOption(**{'multi': False, 'values': (u'local', u'distant'), 'name': 'activer_client_ldap', 'default': u'local', 'doc': u'Emplacement du serveur LDAP', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497956016 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_dhcp', 'default': 'non', 'doc': u'Activer le serveur DHCP', 'properties': ('mandatory', 'basic')})
    option_139789497956016.impl_set_information("help", u"""DHCP (Dynamic Host Configuration Protocol) est un protocole réseau dont le rôle est d’assurer la configuration automatique des paramètres IP d’une station""")
    option_139789497956288 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_tftp', 'default': 'non', 'doc': u"Activer l'utilisation d'un serveur PXE/TFTP", 'properties': ('mandatory', 'expert')})
    option_139789497956288.impl_set_information("help", u"""TFTP (Trivial File Transfer Protocol) est un protocole simplifié de transfert de fichiers""")
    option_139789497956560 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_dhcprelay', 'default': 'non', 'doc': u'Activer le relai DHCP', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497956560.impl_set_information("help", u"""Le relai DHCP permet de relayer les trames DHCP d'un réseau vers d'autres réseaux""")
    option_139789497956832 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_esu', 'default': 'oui', 'doc': u'Utiliser le logiciel ESU', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497956832.impl_set_information("help", u"""ESU est une application de gestion avancée des postes clients""")
    option_139789497957104 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_nut', 'default': 'non', 'doc': u"Activer la gestion de l'onduleur NUT", 'properties': ('mandatory', 'normal')})
    option_139789497957104.impl_set_information("help", u"""NUT (Network UPS Tools) est un ensemble d'outils permettant de gérer et de superviser un système relié à un ou des onduleurs""")
    option_139789497957376 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_apache', 'default': 'oui', 'doc': u'Activer le serveur web Apache', 'properties': ('mandatory', 'normal')})
    option_139789497957376.impl_set_information("help", u"""Apache un serveur HTTP""")
    option_139789497957648 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_activer_nginx_web', 'doc': u'V\xe9rifier s\u2019il est possible d\u2019activer la publication d\u2019applications web par Nginx', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("['non', 'oui']"),), kwargs={'mismatch': ParamValue("oui"), 'condition_1': ParamOption(option_139789497889120, False), 'match': ParamValue("non"), 'condition_2': ParamOption(option_139789497957376, False)})})
    option_139789497957648.impl_set_information("help", u"""Vérifie que le mode conteneur est actif ou qu’apache est désactivé.""")
    option_139789497957920 = ChoiceOption(**{'multi': False, 'name': 'activer_nginx_web', 'doc': u'Activer la publication d\u2019applications web par Nginx', 'values': (u'oui', u'non'), 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497957648, False)}), "requires": [{'expected': u'non', 'action': 'frozen', 'inverse': False, "option": option_139789497957648}, {'expected': u'non', 'action': 'hidden', 'inverse': False, "option": option_139789497957648}, {'expected': u'non', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497957648}]})
    option_139789497957920.impl_set_information("help", u"""Publier les applications web par Nginx""")
    option_139789497962576 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_activer_ead3', 'doc': u'V\xe9rifier si l\u2019on peut activer l\u2019interface d\u2019administration du module (EAD3)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.activate_master_only_web_app, 'callback_params': Params(args=None, kwargs={'activer_nginx_web': ParamOption(option_139789497957920, True), 'activer_apache': ParamOption(option_139789497957376, True), 'mode_conteneur_actif': ParamOption(option_139789497889120, False)})})
    option_139789497962576.impl_set_information("help", u"""Vérifier que la publication web par Nginx ou Apache est actif""")
    option_139789497962848 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'nginx_degrade_http', 'default': 'non', 'doc': u'D\xe9grader la s\xe9curit\xe9 en HTTP', 'properties': ('mandatory', 'expert')})
    option_139789497962848.impl_set_information("help", u"""Désactiver l’utilisation du HTTPS. Certaines applications comme gen_config sont désactivées dans ce cas.""")
    option_139789497963120 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_activer_ead3_https', 'doc': u'V\xe9rifier si HTTPS Nginx est d\xe9sactiv\xe9 pour l\u2019interface d\u2019administration du module (EAD3)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497962848, True), 'match': ParamValue("oui")})})
    option_139789497963392 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ead3', 'default': 'non', 'doc': u'Activer l\u2019interface d\u2019administration du module (EAD3)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497962576}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963120}]})
    option_139789497963392.impl_set_information("help", u"""Publier l’interface d’administration du module sur le port standard HTTPS (443)""")
    option_139789497963664 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_saltstack', 'doc': u'Activer SaltStack', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_val_first_value, 'callback_params': Params(args=(ParamOption(option_139789497963392, True), ParamValue("non")), kwargs={})})
    option_139789497963664.impl_set_information("help", u"""SaltStack est un logiciel de gestion de configuration écrit en Python""")
    option_139789497963936 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'install_rvp', 'default': 'non', 'doc': u'Activer le r\xe9seau virtuel priv\xe9 RVP', 'properties': ('mandatory', 'normal')})
    option_139789497963936.impl_set_information("help", u"""Le RVP utilise strongSwan qui est une implémentation libre et complète de VPN IPsec""")
    option_139789497964208 = ChoiceOption(**{'multi': False, 'values': (u'non', u'local', u'distant'), 'name': 'activer_sso', 'default': u'local', 'doc': u'Utiliser un serveur EoleSSO', 'properties': ('mandatory', 'normal')})
    option_139789497964208.impl_set_information("help", u"""EoleSSO est un serveur d'authentification développé pour répondre à la problématique du SSO (authentification unique)""")
    option_139789497964480 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ead_web', 'default': 'oui', 'doc': u"Activer l'interface web de l'EAD", 'properties': ('mandatory', 'expert')})
    option_139789497964480.impl_set_information("help", u"""L'EAD est une interface simplifiée de gestion du serveur""")
    option_139789497964752 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'frontend_ead_distant_eth4', 'default': 'non', 'doc': u"Autoriser l'acc\xe8s au backend EAD depuis des frontend EAD distants", 'properties': ('mandatory', 'expert')})
    option_139789497964752.impl_set_information("separator", (u"Configuration de l'acc\xe8s au backend EAD", None))
    option_139789497964752.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 depuis l'interface 4""")
    option_139789497965024 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'frontend_ead_distant_eth1', 'default': 'non', 'doc': u"Autoriser l'acc\xe8s au backend EAD depuis des frontend EAD distants", 'properties': ('mandatory', 'expert')})
    option_139789497965024.impl_set_information("separator", (u"Configuration de l'acc\xe8s au backend EAD", None))
    option_139789497965024.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 depuis l'interface 1""")
    option_139789497965296 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'frontend_ead_distant_eth0', 'default': 'non', 'doc': u"Autoriser l'acc\xe8s au backend EAD depuis des frontend EAD distants", 'properties': ('mandatory', 'expert')})
    option_139789497965296.impl_set_information("separator", (u"Configuration de l'acc\xe8s au backend EAD", None))
    option_139789497965296.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 depuis l'interface 0""")
    option_139789497965568 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'frontend_ead_distant_eth3', 'default': 'non', 'doc': u"Autoriser l'acc\xe8s au backend EAD depuis des frontend EAD distants", 'properties': ('mandatory', 'expert')})
    option_139789497965568.impl_set_information("separator", (u"Configuration de l'acc\xe8s au backend EAD", None))
    option_139789497965568.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 depuis l'interface 3""")
    option_139789497965840 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'frontend_ead_distant_eth2', 'default': 'non', 'doc': u"Autoriser l'acc\xe8s au backend EAD depuis des frontend EAD distants", 'properties': ('mandatory', 'expert')})
    option_139789497965840.impl_set_information("separator", (u"Configuration de l'acc\xe8s au backend EAD", None))
    option_139789497965840.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 depuis l'interface 2""")
    option_139789497966112 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_firewall', 'default': 'oui', 'doc': u'Activer le support du firewall', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497970768 = ChoiceOption(**{'multi': False, 'name': 'acces_distant_backend_ead', 'doc': u"Autoriser l'utilisation du backend EAD par des frontend EAD distants", 'values': (u'oui', u'non'), 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("oui"), 'condition_4': ParamOption(option_139789497964752, True), 'condition_1': ParamOption(option_139789497965024, True), 'condition_0': ParamOption(option_139789497965296, False), 'condition_3': ParamOption(option_139789497965568, True), 'condition_2': ParamOption(option_139789497965840, True), 'match': ParamValue("non")}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497970768.impl_set_information("help", u"""Ouverture des ports 4201 et 4202 pour permettre à un frontend EAD distant d'utiliser le backend EAD de ce serveur""")
    option_139789497971312 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_mysql', 'default': 'oui', 'doc': u'Activer le serveur de bases de donn\xe9es MySQL', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497971312.impl_set_information("help", u"""MySQL est un serveur de bases de données relationnelles SQL""")
    option_139789497971584 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bareos_dir', 'default': 'oui', 'doc': u'Activer la sauvegarde du serveur', 'properties': ('mandatory', 'normal')})
    option_139789497971040 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bareos_sd', 'doc': u'Activer le support de stockage de la sauvegarde', 'properties': ('normal',), 'callback': eosfunc.auto_copy_val, 'callback_params': Params(args=(ParamOption(option_139789497971584, False),), kwargs={})})
    option_139789497971856 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_cups', 'default': 'oui', 'doc': u"Activer le serveur d'impression CUPS", 'properties': ('mandatory', 'normal')})
    option_139789497971856.impl_set_information("help", u"""Le Common Unix Printing System (CUPS) est un système modulaire d'impression informatique pour les systèmes d'exploitation Unix et assimilés""")
    option_139789497972128 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_wpad', 'default': 'oui', 'doc': u'Activer le support de WPAD', 'properties': ('mandatory', 'normal')})
    option_139789497972128.impl_set_information("help", u"""WPAD est un protocole qui permet la découverte automatique du proxy par les navigateurs""")
    option_139789497972400 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_revprox', 'doc': u'Activer le reverse proxy Nginx', 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497957376, False)})})
    option_139789497972400.impl_set_information("help", u"""Le Reverse Proxy permet de relayer des accès extérieurs vers des serveurs situés derrière le pare-feu""")
    option_139789497972672 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_hide_nginx_family', 'doc': u'V\xe9rifier s\u2019il faut cacher la famille Nginx', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497957920, True), 'match': ParamValue("oui"), 'condition_2': ParamOption(option_139789497972400, False)})})
    option_139789497972672.impl_set_information("help", u"""Vérifie que la publication d’application web par Nginx et le reverse proxy sont désactivés.""")
    option_139789497972944 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_proftpd', 'default': 'oui', 'doc': u"Activer l'acc\xe8s FTP", 'properties': ('mandatory', 'normal')})
    option_139789497972944.impl_set_information("help", u"""ProFTPD est un serveur FTP""")
    option_139789497973216 = UnicodeOption(**{'default': u'/var/lib/eole/ead3files', 'doc': u'Chemin de t\xe9l\xe9versement des fichiers EAD3', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ead3_upload_path'})
    option_139789497973216.impl_set_information("help", u"""Chemin absolu (commençant par un /) vers lequel sont téléversés les fichiers provenant de l'action \"Gestion de fichier\"""")
    option_139789497973488 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_activer_genconfig', 'doc': u'V\xe9rifier si l\u2019on peut activer l\u2019interface de configuration du module (GenConfig)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.activate_master_only_web_app, 'callback_params': Params(args=None, kwargs={'activer_nginx_web': ParamOption(option_139789497957920, True), 'activer_apache': ParamOption(option_139789497957376, True), 'mode_conteneur_actif': ParamOption(option_139789497889120, False)})})
    option_139789497973488.impl_set_information("help", u"""Vérifier que la publication web par Nginx ou Apache est active""")
    option_139789497973760 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_activer_genconfig_https', 'doc': u'V\xe9rifier si HTTPS Nginx est d\xe9sactiv\xe9 pour l\u2019interface de configuration du module (GenConfig)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497962848, True), 'match': ParamValue("oui")})})
    option_139789497974032 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_genconfig', 'default': 'oui', 'doc': u'Activer l\u2019interface de configuration du module (GenConfig)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497973488}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497973760}]})
    option_139789497974032.impl_set_information("help", u"""Publier l’interface de configuration du module sur le port standard HTTPS (443)""")
    option_139789498701136 = OptionDescription(children=[option_139789497954656, option_139789497954928, option_139789497955200, option_139789497955472, option_139789497955744, option_139789497956016, option_139789497956288, option_139789497956560, option_139789497956832, option_139789497957104, option_139789497963664, option_139789497963936, option_139789497957376, option_139789497964208, option_139789497964480, option_139789497970768, option_139789497971312, option_139789497971584, option_139789497971040, option_139789497941264, option_139789497971856, option_139789497972128, option_139789497957648, option_139789497972672, option_139789497957920, option_139789497972400, option_139789497972944, option_139789497962576, option_139789497963120, option_139789497963392, option_139789497973216, option_139789497973488, option_139789497973760, option_139789497974032], **{'doc': u'services', 'properties': ('basic',), 'name': 'services'})
    option_139789498701136.impl_set_information("help", u"""Paramètres des services fournis par le serveur""")
    option_139789498701136.impl_set_information("icon", u"""cogs""")
    option_139789497974304 = UnicodeOption(**{'multi': False, 'name': 'type_amon_concat', 'doc': u'Mod\xe8le de filtrage', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamOption(option_139789497891840, False), ParamValue("zones")), kwargs={})})
    option_139789497983056 = UnicodeOption(**{'multi': False, 'name': 'type_amon', 'doc': u'Mod\xe8le de filtrage', 'properties': ('basic',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("amon"),), kwargs={'mismatch': ParamValue("2zones-amonecole"), 'condition_1': ParamOption(option_139789497875456, False), 'match': ParamOption(option_139789497974304, False)})})
    option_139789497983056.impl_set_information("proposed_value", (u'2zones', u'2zones-amonecole', u'3zones', u'3zones-dmz', u'4zones', u'5zones'))
    option_139789497983056.impl_set_information("help", u"""Modèle de pare-feu Era à appliquer sur le serveur""")
    option_139789497983328 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'install_scribe_dmz', 'default': 'non', 'doc': u"Activer la gestion d'un Scribe dans la DMZ", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497983872 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_serveur_scribe_dmz', 'doc': u'Nom du Scribe dans la DMZ (pour enregistrement DNS)', 'allow_ip': True, 'multi': False, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497983328}]})
    option_139789497983600 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_scribe_dmz', 'doc': u'Adresse IP du Scribe dans la DMZ', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497983328}]})
    option_139789498701456 = OptionDescription(children=[option_139789497983056, option_139789497974304, option_139789497983328, option_139789497983872, option_139789497983600], **{'doc': u'firewall', 'properties': ('basic',), 'name': 'firewall'})
    option_139789498701456.impl_set_information("help", u"""Configuration du pare-feu""")
    option_139789498701456.impl_set_information("icon", u"""fire""")
    option_139789497984144 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bash_completion', 'default': 'oui', 'doc': u"Activer l'auto-compl\xe9tion \xe9tendue sur la console (touche TAB)", 'properties': ('mandatory', 'expert')})
    option_139789497984144.impl_set_information("separator", ('Console', None))
    option_139789497984416 = IntOption(**{'default': 900, 'doc': u"Temps d'inactivit\xe9 avant d\xe9connexion bash (0 pour d\xe9sactiver)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'bash_tmout'})
    option_139789497984416.impl_set_information("help", u"""Durée en secondes""")
    option_139789497984688 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ctrl_alt_suppr', 'default': 'oui', 'doc': u'Activer le reboot sur ctrl-alt-suppr', 'properties': ('mandatory', 'expert')})
    option_139789497984960 = ChoiceOption(**{'multi': False, 'values': (u'dark', u'light'), 'name': 'vim_background', 'default': u'dark', 'doc': u"Nuance du fond d'\xe9cran dans VIM", 'properties': ('mandatory', 'expert')})
    option_139789497984960.impl_set_information("help", u"""Indication de la valeur de la couleur d’arrière-plan de l’éditeur VIM pour améliorer la lisibilité de la coloration syntaxique (dark et light pour une coloration adaptée à un arrière-plan sombre et clair respectivement)""")
    option_139789497985504 = IntOption(**{'multi': False, 'name': 'vm_swappiness', 'default': 60, 'doc': u"Poids relatif de l'utilisation de la swap par rapport \xe0 la m\xe9moire vive", 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"0"), 'maxi': ParamValue(u"100")})})
    option_139789497985504.impl_set_information("separator", (u'Optimisations syst\xe8me', None))
    option_139789497985504.impl_set_information("help", u"""Le swappiness est un paramètre du noyau Linux permettant de définir avec quelle sensibilité il va écrire dans le swap si la quantité de RAM à utiliser devient trop importante""")
    option_139789497985232 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_rngd', 'default': 'non', 'doc': u'Activer le service de g\xe9n\xe9ration de nombres al\xe9atoires rng-tools', 'properties': ('mandatory', 'expert')})
    option_139789497985232.impl_set_information("help", u"""Le démon rngd agit comme une passerelle entre un vrai générateur de nombres aléatoires, matériel (TRNG), tel que ceux que l'on peut trouver dans les puces Intel/AMD/VIA et le pseudo-générateur de nombres aléatoires du noyau (PRNG)""")
    option_139789497985776 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'check_passwd', 'default': 'oui', 'doc': u'V\xe9rifier la complexit\xe9 des mots de passe', 'properties': ('mandatory', 'expert')})
    option_139789497985776.impl_set_information("separator", (u'Validation des mots de passe des utilisateurs syst\xe8me (root, eole, ...)', None))
    option_139789497986048 = IntOption(**{'multi': False, 'name': 'check_passwd_min_len_one_type', 'default': 0, 'doc': u'Taille minimum du mot de passe utilisant une seule classe de caract\xe8res', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985776}]})
    option_139789497986048.impl_set_information("help", u"""Taille minimum du mot de passe compris seulement dans une classe, 0 pour interdire (les classes de caractères sont : chiffres, lettres minuscules, lettres majuscules, et autres caractères)""")
    option_139789497986320 = IntOption(**{'multi': False, 'name': 'check_passwd_min_len_two_type', 'default': 9, 'doc': u'Taille minimum du mot de passe utilisant deux classes de caract\xe8res', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985776}]})
    option_139789497986320.impl_set_information("help", u"""Taille minimum du mot de passe compris seulement dans deux classes, 0 pour interdire (les classes de caractères sont : chiffres, lettres minuscules, lettres majuscules, et autres caractères)""")
    option_139789497986592 = IntOption(**{'multi': False, 'name': 'check_passwd_min_len_three_type', 'default': 8, 'doc': u'Taille minimum du mot de passe utilisant trois classes de caract\xe8res', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985776}]})
    option_139789497986592.impl_set_information("help", u"""Taille minimum du mot de passe compris seulement dans trois classes, 0 pour interdire (les classes de caractères sont : chiffres, lettres minuscules, lettres majuscules, et autres caractères)""")
    option_139789497999440 = IntOption(**{'multi': False, 'name': 'check_passwd_min_len_four_type', 'default': 8, 'doc': u'Taille minimum du mot de passe utilisant quatre classes de caract\xe8res', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985776}]})
    option_139789497999440.impl_set_information("help", u"""Taille minimum du mot de passe compris seulement dans quatre classes, 0 pour interdire (les classes de caractères sont : chiffres, lettres minuscules, lettres majuscules, et autres caractères)""")
    option_139789497999712 = IntOption(**{'multi': False, 'name': 'check_passwd_max', 'default': 40, 'doc': u'Taille maximale du mot de passe ', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985776}]})
    option_139789497999984 = UnicodeOption(**{'callback_params': None, 'multi': True, 'name': 'cdrom_devices', 'doc': u'Liste des lecteurs de CDROM pr\xe9sent sur le serveur', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_cdrom_devices})
    option_139789498000256 = IntOption(**{'multi': True, 'name': 'cdrom_minor', 'doc': u'Minor du device CDROM pr\xe9sent sur le serveur', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.cdrom_minormajor, 'callback_params': Params(args=(ParamValue("minor"), ParamOption(option_139789497999984, False)), kwargs={})})
    option_139789498000528 = IntOption(**{'multi': True, 'name': 'cdrom_major', 'doc': u'Major du device CDROM pr\xe9sent sur le serveur', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.cdrom_minormajor, 'callback_params': Params(args=(ParamValue("major"), ParamOption(option_139789497999984, False)), kwargs={})})
    option_139789498701776 = MasterSlaves(children=[option_139789497999984, option_139789498000256, option_139789498000528], **{'doc': u'Liste des lecteurs de CDROM pr\xe9sent sur le serveur', 'properties': ('expert',), 'name': 'cdrom_devices'})
    option_139789498000800 = IntOption(**{'callback_params': None, 'multi': False, 'name': 'partitioning_free_PE', 'doc': u'Nombre de blocs disponibles pour une nouvelle partition', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_free_PE})
    option_139789498000800.impl_set_information("separator", ('Ajustement du partitionnement', None))
    option_139789498001072 = ChoiceOption(**{'callback_params': None, 'multi': False, 'values': (u'oui', u'non'), 'name': 'allow_manual_partitioning', 'doc': u'Permettre le partitionnement manuel', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.enable_lv_creation})
    option_139789498001072.impl_set_information("help", u"""Active automatiquement les champs de saisie si le serveur n’est pas encore instancié et que le groupe de volumes dispose de PE libres""")
    option_139789498001344 = UnicodeOption(**{'callback_params': None, 'multi': True, 'name': 'eole_created_lv_names', 'doc': u'Liste des noms de volume logique actuellement cr\xe9\xe9s sur le module', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.get_lv_names})
    option_139789498001344.impl_set_information("help", u"""Cette liste est utilisée pour calculer partitioning_lv_name et test_extend_standard_partitioning""")
    option_139789498001888 = UnicodeOption(**{'multi': True, 'name': 'eole_lv_names', 'doc': u'Liste des noms de volume logique du partitionnement EOLE standard', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamValue("root"), ParamValue("tmp"), ParamValue("var"), ParamValue("opt"), ParamValue("home")), kwargs={})})
    option_139789498001888.impl_set_information("help", u"""Cette liste est utilisée pour calculer test_extend_standard_partitioning""")
    option_139789498001616 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_extend_standard_partitioning', 'doc': u"Tester s'il faut \xe9tendre automatiquement le partitionnement EOLE", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.check_partitioning_auto_extend, 'callback_params': Params(args=None, kwargs={'created_lv_names': ParamOption(option_139789498001344, False), 'expected_lv_names': ParamOption(option_139789498001888, False)})})
    option_139789498001616.impl_set_information("help", u"""Vérifier que le partitionnement est compatible EOLE afin de pouvoir être étendu automatiquement""")
    option_139789498002160 = ChoiceOption(**{'multi': False, 'name': 'use_eole_standard_volume_extension', 'doc': u'Utiliser le mod\xe8le d\u2019extension standard EOLE', 'values': (u'oui', u'non'), 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789498001616, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'frozen', 'inverse': False, "option": option_139789498001616}, {'expected': u'non', 'action': 'hidden', 'inverse': False, "option": option_139789498001616}, {'expected': u'non', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789498001616}]})
    option_139789498002160.impl_set_information("help", u"""L’administrateur souhaite utiliser le modèle de répartition de l’espace standard d’EOLE""")
    option_139789498002432 = IntOption(**{'multi': True, 'name': 'eole_lv_standard_extends', 'doc': u'Liste des pourcentages d\u2019espace libre \xe0 attribuer aux volumes logiques', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamValue(0), ParamValue(0), ParamValue(0), ParamValue(0), ParamValue(100)), kwargs={})})
    option_139789498002432.impl_set_information("help", u"""Cette liste fournit le pourcentage d’espace libre à attribuer à chaque volume lors d’un partitionnement EOLE standard""")
    option_139789498002704 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'partitioning_create_lv', 'default': 'non', 'doc': u'Ajuster le partitionnement', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789498002160}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498001072}]})
    option_139789498002704.impl_set_information("help", u"""Activer les champs de saisie pour la création de volumes logiques ou l’extension de volumes logiques existants""")
    option_139789498002976 = UnicodeOption(**{'multi': True, 'name': 'partitioning_lv_name', 'doc': u'Nom du volume \xe0 cr\xe9er', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789498001344, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498002704}]})
    option_139789498002976.impl_set_information("help", u"""Nom du volume logique LVM à créer dans le groupe de volume par défaut""")
    option_139789498015824 = IntOption(**{'multi': True, 'name': 'partitioning_lv_size', 'doc': u'Taille du volume en pourcentage de l\u2019espace disponible', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamValue(0),), kwargs={}), "validator": eosfunc.check_free_space})
    option_139789498015824.impl_set_information("help", u"""Taille du volume logique en pourcentage de l’espace disponible""")
    option_139789498016096 = UnicodeOption(**{'multi': True, 'name': 'partitioning_lv_format', 'default_multi': u'ext4', 'doc': u'Format du syst\xe8me de fichiers', 'properties': ('mandatory', 'expert'), "validator": eosfunc.is_fs_type})
    option_139789498016096.impl_set_information("help", u"""Format de la partition""")
    option_139789498016368 = FilenameOption(**{'doc': u'Point de montage du volume logique', 'multi': True, 'properties': ('expert',), 'name': 'partitioning_lv_mount_point'})
    option_139789498016368.impl_set_information("help", u"""Point de montage du volume logique""")
    option_139789498016640 = UnicodeOption(**{'doc': u'Options du montage', 'multi': True, 'properties': ('expert',), 'name': 'partitioning_lv_mount_options'})
    option_139789498016640.impl_set_information("help", u"""Options du montage""")
    option_139789498702096 = MasterSlaves(children=[option_139789498002976, option_139789498015824, option_139789498016096, option_139789498016368, option_139789498016640], **{'doc': u'Nom du volume \xe0 cr\xe9er', 'properties': ('expert',), 'name': 'partitioning_lv_name'})
    option_139789498016912 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'partitioning_lv_extend', 'default': 'non', 'doc': u'Allouer l\u2019espace restant', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789498002160}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498001072}]})
    option_139789498016912.impl_set_information("help", u"""Allouer l’espace restant à un volume logique existant""")
    option_139789498017184 = FilenameOption(**{'multi': False, 'name': 'partitioning_lv_to_extend', 'doc': u'Volume logique \xe0 \xe9tendre', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498016912}], "validator": eosfunc.is_lv_name})
    option_139789498017184.impl_set_information("help", u"""Nom du volume logique à étendre avec l’espace restant""")
    option_139789498702416 = OptionDescription(children=[option_139789497984144, option_139789497984416, option_139789497984688, option_139789497984960, option_139789497985504, option_139789497985232, option_139789497985776, option_139789497986048, option_139789497986320, option_139789497986592, option_139789497999440, option_139789497999712, option_139789498701776, option_139789498000800, option_139789498001072, option_139789498001616, option_139789498002160, option_139789498001888, option_139789498002432, option_139789498001344, option_139789498002704, option_139789498702096, option_139789498016912, option_139789498017184], **{'doc': u'syst\xe8me', 'properties': ('expert',), 'name': 'systeme'})
    option_139789498702416.impl_set_information("help", u"""Configuration système avancée""")
    option_139789498702416.impl_set_information("icon", u"""desktop""")
    option_139789498017456 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_permit_root', 'default': 'oui', 'doc': u"Autoriser les connexions SSH pour l'utilisateur root", 'properties': ('mandatory', 'expert')})
    option_139789498017456.impl_set_information("separator", ('Configuration SSH', None))
    option_139789498017728 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_allow_passwd', 'default': 'oui', 'doc': u'Autoriser les connexions SSH par mot de passe (si non clef RSA obligatoire)', 'properties': ('mandatory', 'expert')})
    option_139789498018000 = UsernameOption(**{'doc': u'Autoriser les connexions SSH pour les groupes', 'multi': True, 'properties': ('expert',), 'name': 'ssh_allow_groups'})
    option_139789498018272 = UnicodeOption(**{'default': u'5:30:10', 'doc': u'Crit\xe8res \xe0 appliquer pour le blocage des tentatives de connexions par force brute', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ssh_maxstartups'})
    option_139789498018272.impl_set_information("help", u"""La première valeur est le nombre de tentatives de connexions échouées tolérées. La dernière valeur est le nombre de connexions échouées maximales. La deuxième valeur fixe le pourcentage de refus aléatoire une fois le nombre de connexions tolérées atteint. Ce pourcentage de refus augmente à chaque échec supplémentaire jusqu'à ce que le nombre de connexions maximales soit atteint.""")
    option_139789498702736 = OptionDescription(children=[option_139789498017456, option_139789498017728, option_139789498018000, option_139789498018272], **{'doc': u'sshd', 'properties': ('expert',), 'name': 'sshd'})
    option_139789498702736.impl_set_information("help", u"""Configuration des connexions SSH""")
    option_139789498702736.impl_set_information("icon", u"""shell""")
    option_139789498018544 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_reception_logs', 'default': 'non', 'doc': u'Activer la r\xe9ception des logs de machines distantes', 'properties': ('mandatory', 'normal')})
    option_139789498018544.impl_set_information("separator", (u'R\xe9ception', None))
    option_139789498018816 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_reception_logs_relp', 'default': 'non', 'doc': u'Activer la r\xe9ception des logs de machines distantes via le protocole RELP (fiable, non compatible TLS)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498018544}]})
    option_139789498019088 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresses_ip_clients_logs_relp', 'doc': u'IP des clients \xe0 autoriser pour le protocole RELP', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498018816}]})
    option_139789498019360 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_client_logs_relp', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498018816}]})
    option_139789498703056 = MasterSlaves(children=[option_139789498019088, option_139789498019360], **{'doc': u'IP des clients \xe0 autoriser pour le protocole RELP', 'properties': ('basic',), 'name': 'adresses_ip_clients_logs_relp'})
    option_139789498032208 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_reception_logs_udp', 'default': 'non', 'doc': u'Activer la r\xe9ception des logs de machines distantes via le protocole UDP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498018544}]})
    option_139789498032480 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresses_ip_clients_logs_udp', 'doc': u'Adresse IP \xe9quipement autoris\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498032208}]})
    option_139789498032752 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_client_logs_udp', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498032208}]})
    option_139789498703376 = MasterSlaves(children=[option_139789498032480, option_139789498032752], **{'doc': u'Adresse IP \xe9quipement autoris\xe9', 'properties': ('basic',), 'name': 'adresses_ip_clients_logs_udp'})
    option_139789498033024 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_reception_logs_tcp', 'default': 'non', 'doc': u'Activer la r\xe9ception des logs de machines distantes via le protocole TCP (compatible TLS)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498018544}]})
    option_139789498033296 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'rsyslog_reception_tls', 'default': 'non', 'doc': u'Activer le chiffrement des transferts pour la r\xe9ception (TLS)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498033024}]})
    option_139789498033568 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresses_ip_clients_logs_tcp', 'doc': u'IP des clients \xe0 autoriser pour le protocole TCP', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498033024}]})
    option_139789498033840 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_client_logs_tcp', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498033024}]})
    option_139789498044496 = MasterSlaves(children=[option_139789498033568, option_139789498033840], **{'doc': u'IP des clients \xe0 autoriser pour le protocole TCP', 'properties': ('basic',), 'name': 'adresses_ip_clients_logs_tcp'})
    option_139789498034112 = FilenameOption(**{'default': u'/etc/rsyslog.d/ssl/certs/zephirlog_ca.pem', 'doc': u'Emplacement de la CA', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'rsyslog_ca_file'})
    option_139789498034384 = FilenameOption(**{'default': u'/etc/rsyslog.d/ssl/private/rsyslog_privkey.pem', 'doc': u'Emplacement de la cl\xe9', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'rsyslog_privkey_file'})
    option_139789498034928 = FilenameOption(**{'default': u'/etc/rsyslog.d/ssl/certs/rsyslog_cert.pem', 'doc': u'Emplacement du certificat', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'rsyslog_cert_file'})
    option_139789498034656 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_envoi_logs', 'default': 'non', 'doc': u"Activer l'envoi des logs \xe0 une machine distante (TCP si TLS activ\xe9, RELP sinon)", 'properties': ('mandatory', 'normal')})
    option_139789498034656.impl_set_information("separator", ('Envoi', None))
    option_139789498035200 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_serveur_logs', 'doc': u'Adresse IP du serveur de log central', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498034656}]})
    option_139789498035472 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'rsyslog_envoi_tls', 'default': 'non', 'doc': u"Activer le chiffrement des transferts pour l'envoi (TLS)", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498034656}]})
    option_139789498035744 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'envoyer_tous_logs', 'default': 'oui', 'doc': u'Envoyer tous les journaux', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498034656}]})
    option_139789498035744.impl_set_information("separator", (u'Choix des journaux \xe0 envoyer', None))
    option_139789497528400 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'utiliser_rsyslog_plage_envoi_globale', 'default': 'non', 'doc': u'Utiliser une plage temporelle pour le transfert des logs', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789498035744}]})
    option_139789497528672 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'rsyslog_plage_globale_heure_debut', 'default': u'1', 'doc': u'Heure de d\xe9but du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497528400}]})
    option_139789497528944 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'rsyslog_plage_globale_heure_fin', 'default': u'1', 'doc': u'Heure de fin du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497528400}]})
    option_139789497529216 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'envoyer_logs_squid', 'default': 'non', 'doc': u'Activer le transfert des logs de Squid', 'properties': ('mandatory', 'normal')})
    option_139789497529216.impl_set_information("separator", ('Squid', None))
    option_139789497529488 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activate_squid_realtime', 'default': 'non', 'doc': u'Activer le transfert des logs de Squid en temps r\xe9el', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497529216}]})
    option_139789497529760 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'squid_heure_debut', 'default': u'1', 'doc': u'Heure de d\xe9but du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497529488}]})
    option_139789497530032 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'squid_heure_fin', 'default': u'1', 'doc': u'Heure de fin du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497529488}]})
    option_139789497530304 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'envoyer_logs_dansguardian', 'default': 'non', 'doc': u'Activer le transfert des logs de e2guardian', 'properties': ('mandatory', 'normal')})
    option_139789497530304.impl_set_information("separator", ('e2guardian', None))
    option_139789497530576 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activate_dansguardian_realtime', 'default': 'non', 'doc': u'Activer le transfert des logs de e2guardian en temps r\xe9el', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497530304}]})
    option_139789497530848 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'dansguardian_heure_debut', 'default': u'1', 'doc': u'Heure de d\xe9but du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497530576}]})
    option_139789497531120 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12', u'13', u'14', u'15', u'16', u'17', u'18', u'19', u'20', u'21', u'22', u'23', u'24'), 'name': 'dansguardian_heure_fin', 'default': u'1', 'doc': u'Heure de fin du transfert des logs', 'properties': ('normal',), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497530576}]})
    option_139789498044816 = OptionDescription(children=[option_139789498018544, option_139789498018816, option_139789498703056, option_139789498032208, option_139789498703376, option_139789498033024, option_139789498033296, option_139789498044496, option_139789498034112, option_139789498034384, option_139789498034928, option_139789498034656, option_139789498035200, option_139789498035472, option_139789498035744, option_139789497528400, option_139789497528672, option_139789497528944, option_139789497529216, option_139789497529488, option_139789497529760, option_139789497530032, option_139789497530304, option_139789497530576, option_139789497530848, option_139789497531120], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497954656}], **{'doc': u'logs', 'properties': ('basic',), 'name': 'logs'})
    option_139789498044816.impl_set_information("icon", u"""edit""")
    option_139789497531392 = UsernameOption(**{'doc': u'Nom du compte PPPoE', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'pppoe_user', "requires": [{'expected': u'pppoe', 'action': 'disabled', 'inverse': True, "option": option_139789497938272}]})
    option_139789497531664 = PasswordOption(**{'doc': u'Mot de passe PPPoE', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'pppoe_passwd', "requires": [{'expected': u'pppoe', 'action': 'disabled', 'inverse': True, "option": option_139789497938272}]})
    option_139789497531936 = UnicodeOption(**{'multi': True, 'name': 'nom_carte_eth0', 'doc': u"Nom de l'interface r\xe9seau", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_net_device, 'callback_params': Params(args=(ParamValue(0),), kwargs={})})
    option_139789497531936.impl_set_information("proposed_value", (u'enp0s3',))
    option_139789497536592 = UnicodeOption(**{'multi': True, 'name': 'nom_carte_eth1', 'doc': u"Nom de l'interface r\xe9seau", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_net_device, 'callback_params': Params(args=(ParamValue(1),), kwargs={})})
    option_139789497536592.impl_set_information("proposed_value", (u'enp0s3',))
    option_139789497536864 = UnicodeOption(**{'multi': True, 'name': 'nom_carte_eth2', 'doc': u"Nom de l'interface r\xe9seau", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_net_device, 'callback_params': Params(args=(ParamValue(2),), kwargs={})})
    option_139789497536864.impl_set_information("proposed_value", (u'enp0s3',))
    option_139789497537136 = UnicodeOption(**{'multi': True, 'name': 'nom_carte_eth3', 'doc': u"Nom de l'interface r\xe9seau", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_net_device, 'callback_params': Params(args=(ParamValue(3),), kwargs={})})
    option_139789497537136.impl_set_information("proposed_value", (u'enp0s3',))
    option_139789497537408 = UnicodeOption(**{'multi': True, 'name': 'nom_carte_eth4', 'doc': u"Nom de l'interface r\xe9seau", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_net_device, 'callback_params': Params(args=(ParamValue(4),), kwargs={})})
    option_139789497537408.impl_set_information("proposed_value", (u'enp0s3',))
    option_139789497537136.impl_add_consistency("not_equal", option_139789497537408, **{'transitive': False, 'warnings_only': True})
    option_139789497536864.impl_add_consistency("not_equal", option_139789497537136, **{'transitive': False, 'warnings_only': True})
    option_139789497536864.impl_add_consistency("not_equal", option_139789497537408, **{'transitive': False, 'warnings_only': True})
    option_139789497536592.impl_add_consistency("not_equal", option_139789497536864, **{'transitive': False, 'warnings_only': True})
    option_139789497536592.impl_add_consistency("not_equal", option_139789497537136, **{'transitive': False, 'warnings_only': True})
    option_139789497536592.impl_add_consistency("not_equal", option_139789497537408, **{'transitive': False, 'warnings_only': True})
    option_139789497531936.impl_add_consistency("not_equal", option_139789497536592, **{'transitive': False, 'warnings_only': True})
    option_139789497531936.impl_add_consistency("not_equal", option_139789497536864, **{'transitive': False, 'warnings_only': True})
    option_139789497531936.impl_add_consistency("not_equal", option_139789497537136, **{'transitive': False, 'warnings_only': True})
    option_139789497531936.impl_add_consistency("not_equal", option_139789497537408, **{'transitive': False, 'warnings_only': True})
    option_139789497537680 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bonding_eth0', 'doc': u'Param\xe9trer cette zone pour du bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_len_gt, 'callback_params': Params(args=None, kwargs={'max_len': ParamValue("1"), 'mismatch': ParamValue("non"), 'match': ParamValue("oui"), 'param': ParamOption(option_139789497531936, False)})})
    option_139789497537952 = ChoiceOption(**{'multi': False, 'name': 'zone_is_bridge_eth0', 'doc': u"L'interface r\xe9seau de la zone est un bridge", 'values': (u'oui', u'non'), 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name_bridge, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497531936, False), 'context': ParamContext()}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497537680}]})
    option_139789497538224 = UnicodeOption(**{'multi': False, 'name': 'nom_zone_eth0', 'doc': u"Nom de l'interface r\xe9seau de la zone", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497531936, False), 'interface_no': ParamValue("0"), 'method': ParamOption(option_139789497938272, False), 'zone_is_bridge': ParamOption(option_139789497537952, True)})})
    option_139789497538496 = UnicodeOption(**{'multi': False, 'name': 'pppoe_interface', 'doc': u'Interface o\xf9 PPPoE est connect\xe9', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497538224, False)}), "requires": [{'expected': u'pppoe', 'action': 'disabled', 'inverse': True, "option": option_139789497938272}]})
    option_139789497538768 = IPOption(**{'multi': False, 'name': 'adresse_ip_eth0', 'doc': u'Adresse IP de la carte', 'warnings_only': True, 'properties': ('mandatory', 'basic'), 'private_only': True, 'callback': eosfunc.auto_eth, 'callback_params': Params(args=(ParamOption(option_139789497538224, False),), kwargs={'parametre': ParamOption(option_139789497938272, False), 'condition': ParamValue("dhcp")}), "requires": [{'expected': u'statique', 'action': 'frozen', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'hidden', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'force_default_on_freeze', 'inverse': True, "option": option_139789497938272}]})
    option_139789497538768.impl_set_information("help", u"""Adresse IP de la première carte réseau (ex: 10.21.5.1)""")
    option_139789497539040 = NetmaskOption(**{'multi': False, 'name': 'adresse_netmask_eth0', 'doc': u'Masque de sous r\xe9seau de la carte', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.auto_netmask, 'callback_params': Params(args=(ParamOption(option_139789497538224, False),), kwargs={'parametre': ParamOption(option_139789497938272, False), 'condition': ParamValue("dhcp")}), "requires": [{'expected': u'statique', 'action': 'frozen', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'hidden', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'force_default_on_freeze', 'inverse': True, "option": option_139789497938272}]})
    option_139789497539040.impl_set_information("help", u"""Adresse du masque de sous réseau de la première carte réseau (ex: 255.255.255.0)""")
    option_139789497539040.impl_add_consistency("ip_netmask", option_139789497538768, **{'warnings_only': True})
    option_139789497539312 = NetworkOption(**{'multi': False, 'name': 'adresse_network_eth0', 'doc': u'Adresse r\xe9seau de la carte', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_or_auto_network, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497538224, False), 'parametre': ParamOption(option_139789497938272, False), 'netmask': ParamOption(option_139789497539040, False), 'condition': ParamValue("dhcp"), 'ip': ParamOption(option_139789497538768, False)})})
    option_139789497539312.impl_set_information("help", u"""'Adresse réseau de la carte de la première carte réseau (ex: 10.21.5.0)""")
    option_139789497539584 = BroadcastOption(**{'multi': False, 'name': 'adresse_broadcast_eth0', 'doc': u'Adresse broadcast de sous r\xe9seau de la carte', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_or_auto_broadcast, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497538224, False), 'parametre': ParamOption(option_139789497938272, False), 'netmask': ParamOption(option_139789497539040, False), 'condition': ParamValue("dhcp"), 'ip': ParamOption(option_139789497538768, False)})})
    option_139789497539584.impl_set_information("help", u"""Adresse de broadcast (diffusion) de la carte de la première carte réseau (ex: 10.21.5.255)""")
    option_139789497539856 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_gw', 'doc': u'Adresse IP de la passerelle par d\xe9faut', 'properties': ('basic',), 'callback': eosfunc.auto_defaultgw_ip, 'callback_params': Params(args=(ParamOption(option_139789497938272, False), ParamOption(option_139789497538224, False)), kwargs={}), "requires": [{'expected': u'statique', 'action': 'frozen', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'hidden', 'inverse': True, "option": option_139789497938272}, {'expected': u'statique', 'action': 'force_default_on_freeze', 'inverse': True, "option": option_139789497938272}]})
    option_139789497539856.impl_add_consistency("in_network", option_139789497539312, option_139789497539040, **{'warnings_only': True})
    option_139789497539856.impl_add_consistency("not_equal", option_139789497538768, **{})
    option_139789497540128 = UnicodeOption(**{'multi': False, 'name': 'interface_gw', 'doc': u'Interface de sortie', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789497538224, False),), kwargs={})})
    option_139789497557072 = ChoiceOption(**{'multi': False, 'values': (u'balance-rr', u'active-backup', u'balance-xor', u'broadcast', u'802.3ad', u'balance-tlb', u'balance-alb'), 'name': 'bonding_mode_eth0', 'default': u'balance-rr', 'doc': u'Mode de bonding', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497537680}]})
    option_139789497557072.impl_set_information("help", u"""Mode de fonctionnement du bond""")
    option_139789497557344 = IntOption(**{'multi': False, 'name': 'bonding_miimon_eth0', 'default': 100, 'doc': u'Fr\xe9quence des MII link monitoring en millisecondes', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497537680}]})
    option_139789497557344.impl_set_information("help", u"""Intervalle de temps pour le monitoring des interfaces""")
    option_139789497557616 = IntOption(**{'multi': False, 'name': 'bonding_downdelay_eth0', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e down", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497537680}]})
    option_139789497557888 = IntOption(**{'multi': False, 'name': 'bonding_updelay_eth0', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e comme active", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497537680}]})
    option_139789497558160 = ChoiceOption(**{'multi': False, 'values': (u'', u'speed 100 duplex full autoneg off', u'autoneg on', u'speed 10 duplex half autoneg off', u'speed 1000 duplex full autoneg off'), 'name': 'debit_carte_eth0', 'default': u'', 'doc': u"Mode de connexion pour l'interface", 'properties': ('expert',)})
    option_139789497558432 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_eth0', 'default': 'oui', 'doc': u'Autoriser les connexions SSH', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497558432.impl_set_information("separator", ("Administration distante sur l'interface", True))
    option_139789497558704 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_ssh_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497558432}]})
    option_139789497558976 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_ssh_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497558432}]})
    option_139789497558976.impl_add_consistency("network_netmask", option_139789497558704, **{})
    option_139789498045456 = MasterSlaves(children=[option_139789497558704, option_139789497558976], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'properties': ('basic',), 'name': 'ip_ssh_eth0'})
    option_139789497559248 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'admin_eth0', 'default': 'oui', 'doc': u'Autoriser les connexions pour administrer le serveur (EAD, phpMyAdmin, ...)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497559520 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_admin_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497559248}]})
    option_139789497559792 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_admin_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497559248}]})
    option_139789497559792.impl_add_consistency("network_netmask", option_139789497559520, **{})
    option_139789498045136 = MasterSlaves(children=[option_139789497559520, option_139789497559792], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'properties': ('basic',), 'name': 'ip_admin_eth0'})
    option_139789497560064 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'alias_eth0', 'default': 'non', 'doc': u"Ajouter des IP alias sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497560064.impl_set_information("separator", ("Configuration des alias sur l'interface", None))
    option_139789497560336 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_ip_eth0', 'doc': u"Adresse IP alias pour l'interface 0", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497560064}]})
    option_139789497560608 = NetmaskOption(**{'multi': True, 'name': 'alias_netmask_eth0', 'doc': u'Masque de sous r\xe9seau correspondant \xe0 cet alias', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497539040, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497560064}]})
    option_139789497573456 = NetworkOption(**{'multi': True, 'name': 'alias_network_eth0', 'doc': u'Adresse r\xe9seau correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497560336, False), 'netmask': ParamOption(option_139789497560608, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497560064}]})
    option_139789497573728 = BroadcastOption(**{'multi': True, 'name': 'alias_broadcast_eth0', 'doc': u'Adresse broadcast correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497560336, False), 'netmask': ParamOption(option_139789497560608, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497560064}]})
    option_139789497574000 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_agregation', 'default': 'non', 'doc': u'R\xe9partition de charge entre 2 lignes Internet', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497560064}]})
    option_139789497574000.impl_set_information("separator", (u'Agr\xe9gation de liens', None))
    option_139789497574000.impl_set_information("help", u"""L'agrégation de liens permet la mise en place d'une répartition de charge ou d'une haute disponibilité pour les sorties Internet""")
    option_139789497574272 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_gw_eth0', 'doc': u"Adresse de la passerelle pour cet alias (n\xe9cessaire \xe0 l'agr\xe9gation de liens)", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497574000}]})
    option_139789497574544 = ChoiceOption(**{'multi': False, 'values': (u'NTLM/SMB', u'Ldap', u'Ldap (Active Directory)', u'NTLM/KERBEROS', u'Fichier local'), 'name': 'type_squid_auth', 'default': u'NTLM/SMB', 'doc': u"Type d'authentification", 'properties': ('mandatory', 'normal')})
    option_139789497574816 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_cntlm', 'default': 'non', 'doc': u'Activer le proxy NTLM', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}, {'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789497574816.impl_set_information("help", u"""CNTLM est un proxy permettant de s'authentifier en NTLM / NTLM Session Response / NTLMv2. L'authentification se fera sur le premier domaine spécifié.""")
    option_139789497575088 = PortOption(**{'multi': False, 'name': 'cntlm_port', 'allow_private': True, 'default': 3127, 'doc': u"Port d'\xe9coute du proxy NTLM", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}]})
    option_139789497575360 = ChoiceOption(**{'multi': False, 'name': 'activer_cntlm_eth0', 'doc': u'Activer le proxy NTLM sur cette interface', 'values': (u'oui', u'non'), 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("1"),), kwargs={'condition_1': ParamOption(option_139789497891840, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}]})
    option_139789497575632 = PortOption(**{'multi': False, 'name': 'wpad_proxyport_eth0', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD', 'properties': ('disabled', 'mandatory', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamOption(option_139789497575088, True), 'condition_1': ParamOption(option_139789497575360, True), 'match': ParamValue("3128")})})
    option_139789497575632.impl_set_information("separator", (u'Configuration de la d\xe9tection automatique du proxy', None))
    option_139789497575904 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_alias_eth0', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour cet alias', 'properties': ('disabled', 'mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497575632, False)})})
    option_139789498045776 = MasterSlaves(children=[option_139789497560336, option_139789497560608, option_139789497573456, option_139789497573728, option_139789497574272, option_139789497575904], **{'doc': u"Adresse IP alias pour l'interface 0", 'properties': ('basic',), 'name': 'alias_ip_eth0'})
    option_139789497576176 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'vlan_eth0', 'default': 'non', 'doc': u"Activer le support des VLAN sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497576176.impl_set_information("separator", ("Configuration des VLAN sur l'interface", None))
    option_139789497576448 = IntOption(**{'doc': u"Num\xe9ro d'identifiant du VLAN", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'vlan_id_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497576720 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_ip_eth0', 'doc': u"Adresse IP de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497576992 = NetmaskOption(**{'multi': True, 'name': 'vlan_netmask_eth0', 'default_multi': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497593936 = NetworkOption(**{'multi': True, 'name': 'vlan_network_eth0', 'doc': u"Adresse r\xe9seau de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497576720, False), 'netmask': ParamOption(option_139789497576992, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497594208 = BroadcastOption(**{'multi': True, 'name': 'vlan_broadcast_eth0', 'doc': u"Adresse de broadcast de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497576720, False), 'netmask': ParamOption(option_139789497576992, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497594480 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_gw_eth0', 'doc': u'Adresse de la passerelle pour ce VLAN', 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497576176}]})
    option_139789497594752 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_vlan_eth0', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour ce VLAN', 'properties': ('disabled', 'mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497575632, False)})})
    option_139789498046096 = MasterSlaves(children=[option_139789497576448, option_139789497576720, option_139789497576992, option_139789497593936, option_139789497594208, option_139789497594480, option_139789497594752], **{'doc': u"Num\xe9ro d'identifiant du VLAN", 'properties': ('basic',), 'name': 'vlan_id_eth0'})
    option_139789497595024 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bonding_eth4', 'doc': u'Param\xe9trer cette zone pour du bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_len_gt, 'callback_params': Params(args=None, kwargs={'max_len': ParamValue("1"), 'mismatch': ParamValue("non"), 'match': ParamValue("oui"), 'param': ParamOption(option_139789497537408, False)})})
    option_139789497595296 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bonding_eth3', 'doc': u'Param\xe9trer cette zone pour du bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_len_gt, 'callback_params': Params(args=None, kwargs={'max_len': ParamValue("1"), 'mismatch': ParamValue("non"), 'match': ParamValue("oui"), 'param': ParamOption(option_139789497537136, False)})})
    option_139789497595568 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bonding_eth2', 'doc': u'Param\xe9trer cette zone pour du bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_len_gt, 'callback_params': Params(args=None, kwargs={'max_len': ParamValue("1"), 'mismatch': ParamValue("non"), 'match': ParamValue("oui"), 'param': ParamOption(option_139789497536864, False)})})
    option_139789497595840 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bonding_eth1', 'doc': u'Param\xe9trer cette zone pour du bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.list_len_gt, 'callback_params': Params(args=None, kwargs={'max_len': ParamValue("1"), 'mismatch': ParamValue("non"), 'match': ParamValue("oui"), 'param': ParamOption(option_139789497536592, False)})})
    option_139789497596112 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'bonding_is_active', 'doc': u'Au moins une interface est de type bonding', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'mismatch': ParamValue("non"), 'condition_5': ParamOption(option_139789497595024, True), 'condition_4': ParamOption(option_139789497595296, True), 'condition_1': ParamOption(option_139789497537680, True), 'condition_3': ParamOption(option_139789497595568, True), 'condition_2': ParamOption(option_139789497595840, True), 'operator': ParamValue("OR"), 'match': ParamValue("oui")})})
    option_139789497596384 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_dns_eth0', 'default': 'non', 'doc': u'Activer le serveur DNS sur cette zone', 'properties': ('mandatory', 'expert')})
    option_139789497596384.impl_set_information("separator", ("Configuration DNS sur l'interface", None))
    option_139789497596656 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_master_eth0', 'default': 'non', 'doc': u'Serveur master DNS sur cette zone', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497596384}]})
    option_139789497596928 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2'), 'name': 'dansguardian_eth0', 'default': u'1', 'doc': u'Filtre web \xe0 appliquer sur cette interface', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}, {'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789497596928.impl_set_information("help", u"""Instance e2guardian à utiliser pour l'interface 0 (1=Configuration 1, 2=Configuration 2)""")
    option_139789497597200 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_eth0_proxy_link', 'doc': u'Adresse IP pour le proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497597200.impl_set_information("separator", ('Adresse pour le proxy', None))
    option_139789497597200.impl_set_information("help", u"""Adresse IP supplémentaire sur cette interface réseau, utilisée pour accèder au proxy. Le serveur aura donc plusieurs adresses IP sur le réseau local.""")
    option_139789497597200.impl_add_consistency("in_network", option_139789497539312, option_139789497539040, **{'transitive': False, 'warnings_only': True})
    option_139789497597200.impl_add_consistency("not_equal", option_139789497538768, **{'transitive': False})
    option_139789497597472 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_eth0_proxy_link', 'doc': u'Masque de sous r\xe9seau du proxy', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497539040, False)}), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497602128 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_eth0_proxy_link', 'doc': u'Broadcast pour le proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497597200, False), 'netmask': ParamOption(option_139789497597472, False)}), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497602400 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_supp_proxy_eth0', 'default': 'non', 'doc': u'Autoriser des r\xe9seaux suppl\xe9mentaires \xe0 se connecter sur le proxy', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789497602400.impl_set_information("separator", (u'R\xe9seau suppl\xe9mentaire autoris\xe9 sur le proxy', None))
    option_139789497602672 = NetworkOption(**{'doc': u'R\xe9seaux suppl\xe9mentaires autoris\xe9s \xe0 se connecter sur le proxy', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_eth0_ip', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497602400}]})
    option_139789497602944 = NetmaskOption(**{'doc': u'Masque de sous r\xe9seau', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_eth0_netmask', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497602400}]})
    option_139789497602944.impl_add_consistency("network_netmask", option_139789497602672, **{})
    option_139789498046416 = MasterSlaves(children=[option_139789497602672, option_139789497602944], **{'doc': u'R\xe9seaux suppl\xe9mentaires autoris\xe9s \xe0 se connecter sur le proxy', 'properties': ('basic',), 'name': 'proxy_eth0_ip'})
    option_139789497603216 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_frontend_ead_distant_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965296}]})
    option_139789497603488 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau autoris\xe9 \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_frontend_ead_distant_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965296}]})
    option_139789497603488.impl_add_consistency("network_netmask", option_139789497603216, **{})
    option_139789498046736 = MasterSlaves(children=[option_139789497603216, option_139789497603488], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'properties': ('basic',), 'name': 'ip_frontend_ead_distant_eth0'})
    option_139789498047056 = OptionDescription(children=[option_139789497938272, option_139789497531392, option_139789497531664, option_139789497538496, option_139789497538768, option_139789497539040, option_139789497539312, option_139789497539584, option_139789497539856, option_139789497540128, option_139789497531936, option_139789497538224, option_139789497537680, option_139789497557072, option_139789497557344, option_139789497557616, option_139789497557888, option_139789497537952, option_139789497558160, option_139789497558432, option_139789498045456, option_139789497559248, option_139789498045136, option_139789497560064, option_139789498045776, option_139789497576176, option_139789498046096, option_139789497596112, option_139789497574000, option_139789497596384, option_139789497596656, option_139789497596928, option_139789497597200, option_139789497597472, option_139789497602128, option_139789497602400, option_139789498046416, option_139789497965296, option_139789498046736, option_139789497575632, option_139789497575360], **{'doc': u'Interface-0', 'properties': ('basic',), 'name': 'interface_0'})
    option_139789498047056.impl_set_information("help", u"""Configuration de l'interface 0""")
    option_139789498047056.impl_set_information("icon", u"""sitemap""")
    option_139789497603760 = ChoiceOption(**{'multi': False, 'values': (u'statique',), 'name': 'eth1_method', 'default': u'statique', 'doc': u"M\xe9thode d'attribution de l'adressage pour l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497603760.impl_set_information("separator", ("Configuration de l'interface", None))
    option_139789497604032 = IPOption(**{'multi': False, 'name': 'adresse_ip_eth1', 'doc': u'Adresse IP de la carte', 'properties': ('mandatory', 'basic'), 'private_only': True, 'warnings_only': True})
    option_139789497604304 = NetmaskOption(**{'default': u'255.255.255.0', 'doc': u'Masque de sous r\xe9seau de la carte', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'adresse_netmask_eth1'})
    option_139789497604304.impl_add_consistency("ip_netmask", option_139789497604032, **{'warnings_only': True})
    option_139789497604576 = NetworkOption(**{'multi': False, 'name': 'adresse_network_eth1', 'doc': u'Adresse r\xe9seau de la carte', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497604032, False), 'netmask': ParamOption(option_139789497604304, False)})})
    option_139789497604848 = BroadcastOption(**{'multi': False, 'name': 'adresse_broadcast_eth1', 'doc': u'Adresse broadcast de sous r\xe9seau de la carte', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497604032, False), 'netmask': ParamOption(option_139789497604304, False)})})
    option_139789497605120 = ChoiceOption(**{'multi': False, 'name': 'zone_is_bridge_eth1', 'doc': u"L'interface r\xe9seau de la zone est un bridge", 'values': (u'oui', u'non'), 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name_bridge, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497536592, False), 'context': ParamContext()}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497595840}]})
    option_139789497605392 = UnicodeOption(**{'multi': False, 'name': 'nom_zone_eth1', 'doc': u"Nom de l'interface r\xe9seau de la zone", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497536592, False), 'interface_no': ParamValue("1"), 'method': ParamOption(option_139789497603760, False), 'zone_is_bridge': ParamOption(option_139789497605120, True)})})
    option_139789497605664 = ChoiceOption(**{'multi': False, 'values': (u'balance-rr', u'active-backup', u'balance-xor', u'broadcast', u'802.3ad', u'balance-tlb', u'balance-alb'), 'name': 'bonding_mode_eth1', 'default': u'balance-rr', 'doc': u'Mode de bonding', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595840}]})
    option_139789497605664.impl_set_information("help", u"""Mode de fonctionnement du bond""")
    option_139789497634896 = IntOption(**{'multi': False, 'name': 'bonding_miimon_eth1', 'default': 100, 'doc': u'Fr\xe9quence des MII link monitoring en millisecondes', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595840}]})
    option_139789497634896.impl_set_information("help", u"""Intervalle de temps pour le monitoring des interfaces""")
    option_139789497635168 = IntOption(**{'multi': False, 'name': 'bonding_downdelay_eth1', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e down", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595840}]})
    option_139789497635440 = IntOption(**{'multi': False, 'name': 'bonding_updelay_eth1', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e comme active", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595840}]})
    option_139789497635712 = ChoiceOption(**{'multi': False, 'values': (u'', u'speed 100 duplex full autoneg off', u'autoneg on', u'speed 10 duplex half autoneg off', u'speed 1000 duplex full autoneg off'), 'name': 'debit_carte_eth1', 'default': u'', 'doc': u"Mode de connexion pour l'interface interne 1", 'properties': ('expert',)})
    option_139789497635984 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_eth1', 'default': 'oui', 'doc': u'Autoriser les connexions SSH', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497635984.impl_set_information("separator", ("Administration distante sur l'interface", None))
    option_139789497636256 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_ssh_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497635984}]})
    option_139789497636528 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_ssh_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497635984}]})
    option_139789497636528.impl_add_consistency("network_netmask", option_139789497636256, **{})
    option_139789498047376 = MasterSlaves(children=[option_139789497636256, option_139789497636528], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'properties': ('basic',), 'name': 'ip_ssh_eth1'})
    option_139789497636800 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'admin_eth1', 'default': 'oui', 'doc': u'Autoriser les connexions pour administrer le serveur (EAD, phpMyAdmin, ...)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497637072 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_admin_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497636800}]})
    option_139789497637344 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_admin_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497636800}]})
    option_139789497637344.impl_add_consistency("network_netmask", option_139789497637072, **{})
    option_139789498047696 = MasterSlaves(children=[option_139789497637072, option_139789497637344], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'properties': ('basic',), 'name': 'ip_admin_eth1'})
    option_139789497637616 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'alias_eth1', 'default': 'non', 'doc': u"Ajouter des IP alias sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497637616.impl_set_information("separator", ("Configuration des alias sur l'interface", None))
    option_139789497637888 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_ip_eth1', 'doc': u"Adresse IP alias pour l'interface interne 1", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}]})
    option_139789497638160 = NetmaskOption(**{'multi': True, 'name': 'alias_netmask_eth1', 'doc': u'Masque de sous r\xe9seau correspondant \xe0 cet alias', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497604304, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}]})
    option_139789497638432 = NetworkOption(**{'multi': True, 'name': 'alias_network_eth1', 'doc': u'Adresse r\xe9seau correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497637888, False), 'netmask': ParamOption(option_139789497638160, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}]})
    option_139789497655376 = BroadcastOption(**{'multi': True, 'name': 'alias_broadcast_eth1', 'doc': u'Adresse broadcast correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497637888, False), 'netmask': ParamOption(option_139789497638160, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}]})
    option_139789497655648 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'agriates_member', 'default': 'non', 'doc': u'Serveur membre du r\xe9seau AGRIATES', 'properties': ('mandatory', 'normal')})
    option_139789497655648.impl_set_information("separator", ('AGRIATES', None))
    option_139789497655920 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_alias_eth1', 'default_multi': 'oui', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497656192 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_alias_eth1', 'default_multi': 'oui', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497637616}]})
    option_139789497656464 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_squid_auth', 'default': 'oui', 'doc': u"Activer l'authentification web (proxy)", 'properties': ('mandatory', 'normal')})
    option_139789497656736 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'squid_auth_eth1', 'default': 'oui', 'doc': u"Activer l'authentification sur cette interface", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}]})
    option_139789497656736.impl_set_information("help", u"""L'authentification sur cette interface s'applique aussi aux VLAN et alias""")
    option_139789497657008 = ChoiceOption(**{'multi': False, 'name': 'activer_cntlm_eth1', 'doc': u'Activer le proxy NTLM sur cette interface', 'values': (u'oui', u'non'), 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497574816, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497656736}]})
    option_139789497657280 = PortOption(**{'multi': False, 'name': 'wpad_proxyport_eth1', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamOption(option_139789497575088, True), 'condition_1': ParamOption(option_139789497657008, True), 'match': ParamValue("3128")}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497657280.impl_set_information("separator", (u'Configuration de la d\xe9tection automatique du proxy', None))
    option_139789497657552 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_alias_eth1', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour cet alias', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497657280, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789498048016 = MasterSlaves(children=[option_139789497637888, option_139789497638160, option_139789497638432, option_139789497655376, option_139789497655920, option_139789497656192, option_139789497657552], **{'doc': u"Adresse IP alias pour l'interface interne 1", 'properties': ('basic',), 'name': 'alias_ip_eth1'})
    option_139789497657824 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'vlan_eth1', 'default': 'non', 'doc': u"Activer le support des VLAN sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497657824.impl_set_information("separator", ("Configuration des VLAN sur l'interface", None))
    option_139789497658096 = UnicodeOption(**{'doc': u"Num\xe9ro d'identifiant du VLAN", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'vlan_id_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497658368 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_ip_eth1', 'doc': u"Adresse IP de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497658640 = NetmaskOption(**{'multi': True, 'name': 'vlan_netmask_eth1', 'default_multi': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497658912 = NetworkOption(**{'multi': True, 'name': 'vlan_network_eth1', 'doc': u"Adresse r\xe9seau de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497658368, False), 'netmask': ParamOption(option_139789497658640, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497671760 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_broadcast_eth1', 'doc': u"Adresse de broadcast de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497658368, False), 'netmask': ParamOption(option_139789497658640, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497672032 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_vlan_eth1', 'default_multi': 'oui', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497672304 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_vlan_eth1', 'default_multi': 'oui', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497657824}]})
    option_139789497672576 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_vlan_eth1', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour ce VLAN', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497657280, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497675856 = MasterSlaves(children=[option_139789497658096, option_139789497658368, option_139789497658640, option_139789497658912, option_139789497671760, option_139789497672032, option_139789497672304, option_139789497672576], **{'doc': u"Num\xe9ro d'identifiant du VLAN", 'properties': ('basic',), 'name': 'vlan_id_eth1'})
    option_139789497672848 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_master_eth1', 'default': 'oui', 'doc': u'Serveur master DNS de cette zone', 'properties': ('mandatory', 'normal')})
    option_139789497672848.impl_set_information("separator", ("Configuration DNS sur l'interface", None))
    option_139789497673120 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_rvp_eth1', 'default': 'oui', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497673392 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_forward_eth1', 'default': 'oui', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal')})
    option_139789497673664 = DomainnameOption(**{'multi': False, 'name': 'nom_machine_eth1', 'allow_ip': False, 'type_': 'hostname', 'doc': u'Nom de la zone (pour r\xe9solution DNS)', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("2"),), kwargs={'mismatch': ParamValue("admin"), 'condition_1': ParamOption(option_139789497891840, False), 'match': ParamValue("pedago")})})
    option_139789497673936 = DomainnameOption(**{'multi': False, 'name': 'nom_machine_eth2', 'allow_ip': False, 'type_': 'hostname', 'doc': u'Nom de la zone (pour r\xe9solution DNS)', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("2"),), kwargs={'mismatch': ParamValue("pedago"), 'condition_1': ParamOption(option_139789497891840, False), 'match': ParamValue("notset")})})
    option_139789497674208 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_machine_eth3', 'doc': u'Nom de la zone (pour r\xe9solution DNS)', 'default': u'dmz-priv', 'allow_ip': False, 'multi': False, 'properties': ('mandatory', 'normal')})
    option_139789497674480 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_machine_eth4', 'doc': u'Nom de la zone (pour r\xe9solution DNS)', 'default': u'dmz-pub', 'allow_ip': False, 'multi': False, 'properties': ('mandatory', 'normal')})
    option_139789497674208.impl_add_consistency("not_equal", option_139789497674480, **{'transitive': False})
    option_139789497673936.impl_add_consistency("not_equal", option_139789497674208, **{'transitive': False})
    option_139789497673664.impl_add_consistency("not_equal", option_139789497673936, **{'transitive': False})
    option_139789497674752 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2'), 'name': 'dansguardian_eth1', 'default': u'1', 'doc': u'Filtre web \xe0 appliquer sur cette interface', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497674752.impl_set_information("separator", ('Configuration de la politique de filtrage', None))
    option_139789497674752.impl_set_information("help", u"""Instance e2guardian à utiliser pour l'interface 1 (1=Configuration 1, 2=Configuration 2)""")
    option_139789497675024 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_eth1_proxy_link', 'doc': u'Adresse IP pour le proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497675024.impl_set_information("separator", ('Adresse pour le proxy', None))
    option_139789497675024.impl_set_information("help", u"""Adresse IP supplémentaire sur cette interface réseau, utilisée pour accèder au proxy. Le serveur aura donc plusieurs adresses IP sur le réseau local.""")
    option_139789497675024.impl_add_consistency("in_network", option_139789497604576, option_139789497604304, **{'transitive': False, 'warnings_only': True})
    option_139789497675024.impl_add_consistency("not_equal", option_139789497604032, **{'transitive': False})
    option_139789497675296 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_eth1_proxy_link', 'doc': u'Masque de sous r\xe9seau du proxy', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497604304, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497692240 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_eth1_proxy_link', 'doc': u'Broadcast pour le proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497675024, False), 'netmask': ParamOption(option_139789497675296, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497692512 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_frontend_ead_distant_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965024}]})
    option_139789497692784 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau autoris\xe9 \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_frontend_ead_distant_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965024}]})
    option_139789497692784.impl_add_consistency("network_netmask", option_139789497692512, **{})
    option_139789497676176 = MasterSlaves(children=[option_139789497692512, option_139789497692784], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'properties': ('basic',), 'name': 'ip_frontend_ead_distant_eth1'})
    option_139789497693056 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_fichier_link', 'doc': u'Adresse IP pour le serveur de fichiers', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497693056.impl_set_information("separator", ('Adresse pour le serveur de fichier', None))
    option_139789497693056.impl_set_information("help", u"""Adresse IP supplémentaire sur cette interface réseau, utilisée pour accèder aux serveurs de fichiers. Le serveur aura donc plusieurs adresses IP sur le réseau local""")
    option_139789497693056.impl_add_consistency("in_network", option_139789497604576, option_139789497604304, **{'warnings_only': True})
    option_139789497693056.impl_add_consistency("not_equal", option_139789497604032, **{})
    option_139789497693056.impl_add_consistency("not_equal", option_139789497675024, **{})
    option_139789497693328 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_fichier_link', 'doc': u'Masque de sous r\xe9seau pour le serveur de fichiers', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497539040, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497693600 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_fichier_link', 'doc': u'Broadcast pour le serveur de fichiers', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497693056, False), 'netmask': ParamOption(option_139789497693328, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497676496 = OptionDescription(children=[option_139789497603760, option_139789497604032, option_139789497604304, option_139789497604576, option_139789497604848, option_139789497536592, option_139789497605392, option_139789497595840, option_139789497605664, option_139789497634896, option_139789497635168, option_139789497635440, option_139789497605120, option_139789497635712, option_139789497635984, option_139789498047376, option_139789497636800, option_139789498047696, option_139789497637616, option_139789498048016, option_139789497657824, option_139789497675856, option_139789497672848, option_139789497673120, option_139789497673392, option_139789497673664, option_139789497674752, option_139789497656736, option_139789497675024, option_139789497675296, option_139789497692240, option_139789497965024, option_139789497676176, option_139789497657280, option_139789497693056, option_139789497693328, option_139789497693600, option_139789497657008], **{'doc': u'Interface-1', 'properties': ('basic',), 'name': 'interface_1'})
    option_139789497676496.impl_set_information("help", u"""Configuration de l'interface 1""")
    option_139789497676496.impl_set_information("icon", u"""sitemap""")
    option_139789497693872 = ChoiceOption(**{'multi': False, 'values': (u'statique',), 'name': 'eth2_method', 'default': u'statique', 'doc': u"M\xe9thode d'attribution de l'adressage pour l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497693872.impl_set_information("separator", ("Configuration de l'interface", None))
    option_139789497694144 = IPOption(**{'multi': False, 'name': 'adresse_ip_eth2', 'doc': u"Adresse IP de l'interface", 'properties': ('mandatory', 'basic'), 'private_only': True, 'warnings_only': True})
    option_139789497694416 = NetmaskOption(**{'default': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'adresse_netmask_eth2'})
    option_139789497694416.impl_add_consistency("ip_netmask", option_139789497694144, **{'warnings_only': True})
    option_139789497694688 = NetworkOption(**{'multi': False, 'name': 'adresse_network_eth2', 'doc': u"Adresse r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497694144, False), 'netmask': ParamOption(option_139789497694416, False)})})
    option_139789497694960 = BroadcastOption(**{'multi': False, 'name': 'adresse_broadcast_eth2', 'doc': u"Adresse broadcast de sous r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497694144, False), 'netmask': ParamOption(option_139789497694416, False)})})
    option_139789497695232 = ChoiceOption(**{'multi': False, 'name': 'zone_is_bridge_eth2', 'doc': u"L'interface r\xe9seau de la zone est un bridge", 'values': (u'oui', u'non'), 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name_bridge, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497536864, False), 'context': ParamContext()}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497595568}]})
    option_139789497695504 = UnicodeOption(**{'multi': False, 'name': 'nom_zone_eth2', 'doc': u"Nom de l'interface r\xe9seau de la zone", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497536864, False), 'interface_no': ParamValue("2"), 'method': ParamOption(option_139789497693872, False), 'zone_is_bridge': ParamOption(option_139789497695232, True)})})
    option_139789497695776 = ChoiceOption(**{'multi': False, 'values': (u'balance-rr', u'active-backup', u'balance-xor', u'broadcast', u'802.3ad', u'balance-tlb', u'balance-alb'), 'name': 'bonding_mode_eth2', 'default': u'balance-rr', 'doc': u'Mode de bonding', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595568}]})
    option_139789497695776.impl_set_information("help", u"""Mode de fonctionnement du bond""")
    option_139789497712720 = IntOption(**{'multi': False, 'name': 'bonding_miimon_eth2', 'default': 100, 'doc': u'Fr\xe9quence des MII link monitoring en millisecondes', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595568}]})
    option_139789497712720.impl_set_information("help", u"""Intervalle de temps pour le monitoring des interfaces""")
    option_139789497712992 = IntOption(**{'multi': False, 'name': 'bonding_downdelay_eth2', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e down", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595568}]})
    option_139789497713264 = IntOption(**{'multi': False, 'name': 'bonding_updelay_eth2', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e comme active", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595568}]})
    option_139789497713536 = ChoiceOption(**{'multi': False, 'values': (u'', u'speed 100 duplex full autoneg off', u'autoneg on', u'speed 10 duplex half autoneg off', u'speed 1000 duplex full autoneg off'), 'name': 'debit_carte_eth2', 'default': u'', 'doc': u"Mode de connexion pour l'interface interne 2", 'properties': ('expert',)})
    option_139789497713808 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_eth2', 'default': 'non', 'doc': u'Autoriser les connexions SSH', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497713808.impl_set_information("separator", ("Administration distante sur l'interface", None))
    option_139789497714080 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_ssh_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497713808}]})
    option_139789497714352 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_ssh_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497713808}]})
    option_139789497714352.impl_add_consistency("network_netmask", option_139789497714080, **{})
    option_139789497676816 = MasterSlaves(children=[option_139789497714080, option_139789497714352], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'properties': ('basic',), 'name': 'ip_ssh_eth2'})
    option_139789497714624 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'admin_eth2', 'default': 'non', 'doc': u'Autoriser les connexions pour administrer le serveur (EAD, phpMyAdmin, ...)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497714896 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_admin_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497714624}]})
    option_139789497715168 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_admin_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497714624}]})
    option_139789497715168.impl_add_consistency("network_netmask", option_139789497714896, **{})
    option_139789497677136 = MasterSlaves(children=[option_139789497714896, option_139789497715168], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'properties': ('basic',), 'name': 'ip_admin_eth2'})
    option_139789497715440 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'alias_eth2', 'default': 'non', 'doc': u"Ajouter des IP alias sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497715440.impl_set_information("separator", ("Configuration des alias sur l'interface", None))
    option_139789497715712 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_ip_eth2', 'doc': u"Adresse IP alias pour l'interface", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}]})
    option_139789497715984 = NetmaskOption(**{'multi': True, 'name': 'alias_netmask_eth2', 'doc': u'Masque de sous r\xe9seau correspondant \xe0 cet alias', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497694416, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}]})
    option_139789497716256 = NetworkOption(**{'multi': True, 'name': 'alias_network_eth2', 'doc': u'Adresse r\xe9seau correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497715712, False), 'netmask': ParamOption(option_139789497715984, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}]})
    option_139789497729104 = BroadcastOption(**{'multi': True, 'name': 'alias_broadcast_eth2', 'doc': u'Adresse broadcast correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497715712, False), 'netmask': ParamOption(option_139789497715984, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}]})
    option_139789497729376 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_alias_eth2', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497729648 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_alias_eth2', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497715440}]})
    option_139789497729920 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'squid_auth_eth2', 'default': 'oui', 'doc': u"Activer l'authentification sur cette interface", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}]})
    option_139789497729920.impl_set_information("help", u"""L'authentification sur cette interface s'applique aussi aux VLAN et alias""")
    option_139789497730192 = ChoiceOption(**{'multi': False, 'name': 'activer_cntlm_eth2', 'doc': u'Activer le proxy NTLM sur cette interface', 'values': (u'oui', u'non'), 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497574816, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497729920}]})
    option_139789497730464 = PortOption(**{'multi': False, 'name': 'wpad_proxyport_eth2', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamOption(option_139789497575088, True), 'condition_1': ParamOption(option_139789497730192, True), 'match': ParamValue("3128")}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497730464.impl_set_information("separator", (u'Configuration de la d\xe9tection automatique du proxy', None))
    option_139789497730736 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_alias_eth2', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour cet alias', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497730464, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497677456 = MasterSlaves(children=[option_139789497715712, option_139789497715984, option_139789497716256, option_139789497729104, option_139789497729376, option_139789497729648, option_139789497730736], **{'doc': u"Adresse IP alias pour l'interface", 'properties': ('basic',), 'name': 'alias_ip_eth2'})
    option_139789497731008 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'vlan_eth2', 'default': 'non', 'doc': u"Activer le support des VLAN sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497731008.impl_set_information("separator", ("Configuration des VLAN sur l'interface", None))
    option_139789497731280 = UnicodeOption(**{'doc': u"Num\xe9ro d'identifiant du VLAN", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'vlan_id_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497731552 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_ip_eth2', 'doc': u"Adresse IP de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497731824 = NetmaskOption(**{'multi': True, 'name': 'vlan_netmask_eth2', 'default_multi': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497732096 = NetworkOption(**{'multi': True, 'name': 'vlan_network_eth2', 'doc': u"Adresse r\xe9seau de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497731552, False), 'netmask': ParamOption(option_139789497731824, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497732368 = BroadcastOption(**{'multi': True, 'name': 'vlan_broadcast_eth2', 'doc': u"Adresse de broadcast de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497731552, False), 'netmask': ParamOption(option_139789497731824, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497732640 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_vlan_eth2', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497745488 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_vlan_eth2', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497731008}]})
    option_139789497745760 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_vlan_eth2', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour ce VLAN', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497730464, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497677776 = MasterSlaves(children=[option_139789497731280, option_139789497731552, option_139789497731824, option_139789497732096, option_139789497732368, option_139789497732640, option_139789497745488, option_139789497745760], **{'doc': u"Num\xe9ro d'identifiant du VLAN", 'properties': ('basic',), 'name': 'vlan_id_eth2'})
    option_139789497746032 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_master_eth2', 'default': 'oui', 'doc': u'Serveur master DNS de cette zone', 'properties': ('mandatory', 'normal')})
    option_139789497746032.impl_set_information("separator", ("Configuration DNS sur l'interface", None))
    option_139789497746304 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_rvp_eth2', 'default': 'non', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497746576 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_forward_eth2', 'default': 'oui', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal')})
    option_139789497746848 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2'), 'name': 'dansguardian_eth2', 'default': u'1', 'doc': u'Filtre web \xe0 appliquer sur cette interface', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497746848.impl_set_information("separator", ('Configuration de la politique de filtrage', None))
    option_139789497746848.impl_set_information("help", u"""Instance e2guardian à utiliser pour l'interface 2 (1=Configuration 1, 2=Configuration 2)""")
    option_139789497747120 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_eth2_proxy_link', 'doc': u'Adresse IP pour le proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497747120.impl_set_information("separator", ('Adresse pour le proxy', None))
    option_139789497747120.impl_set_information("help", u"""Adresse IP supplémentaire sur cette interface réseau, utilisée pour accèder au proxy. Le serveur aura donc plusieurs adresses IP sur le réseau local.""")
    option_139789497747120.impl_add_consistency("in_network", option_139789497694688, option_139789497694416, **{'transitive': False, 'warnings_only': True})
    option_139789497747120.impl_add_consistency("not_equal", option_139789497694144, **{'transitive': False})
    option_139789497747392 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_eth2_proxy_link', 'doc': u'Masque de sous r\xe9seau du proxy', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497694416, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497747664 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_eth2_proxy_link', 'doc': u'Broadcast pour le proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497747120, False), 'netmask': ParamOption(option_139789497747392, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497747936 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_frontend_ead_distant_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965840}]})
    option_139789497748208 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau autoris\xe9 \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_frontend_ead_distant_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965840}]})
    option_139789497748208.impl_add_consistency("network_netmask", option_139789497747936, **{})
    option_139789497678096 = MasterSlaves(children=[option_139789497747936, option_139789497748208], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'properties': ('basic',), 'name': 'ip_frontend_ead_distant_eth2'})
    option_139789497678416 = OptionDescription(children=[option_139789497693872, option_139789497694144, option_139789497694416, option_139789497694688, option_139789497694960, option_139789497536864, option_139789497695504, option_139789497595568, option_139789497695776, option_139789497712720, option_139789497712992, option_139789497713264, option_139789497695232, option_139789497713536, option_139789497713808, option_139789497676816, option_139789497714624, option_139789497677136, option_139789497715440, option_139789497677456, option_139789497731008, option_139789497677776, option_139789497746032, option_139789497746304, option_139789497746576, option_139789497673936, option_139789497746848, option_139789497729920, option_139789497747120, option_139789497747392, option_139789497747664, option_139789497965840, option_139789497678096, option_139789497730464, option_139789497730192], requires=[{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}], **{'doc': u'Interface-2', 'properties': ('basic',), 'name': 'interface_2'})
    option_139789497678416.impl_set_information("help", u"""Configuration de l'interface 2""")
    option_139789497678416.impl_set_information("icon", u"""sitemap""")
    option_139789497748480 = ChoiceOption(**{'multi': False, 'values': (u'statique',), 'name': 'eth3_method', 'default': u'statique', 'doc': u"M\xe9thode d'attribution de l'adressage pour l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497748480.impl_set_information("separator", ("Configuration de l'interface", None))
    option_139789497748752 = IPOption(**{'multi': False, 'name': 'adresse_ip_eth3', 'doc': u"Adresse IP de l'interface", 'properties': ('mandatory', 'basic'), 'private_only': True, 'warnings_only': True})
    option_139789497749024 = NetmaskOption(**{'default': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'adresse_netmask_eth3'})
    option_139789497749024.impl_add_consistency("ip_netmask", option_139789497748752, **{'warnings_only': True})
    option_139789497765968 = NetworkOption(**{'multi': False, 'name': 'adresse_network_eth3', 'doc': u"Adresse r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497748752, False), 'netmask': ParamOption(option_139789497749024, False)})})
    option_139789497766240 = BroadcastOption(**{'multi': False, 'name': 'adresse_broadcast_eth3', 'doc': u"Adresse broadcast de sous r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497748752, False), 'netmask': ParamOption(option_139789497749024, False)})})
    option_139789497766512 = ChoiceOption(**{'multi': False, 'name': 'zone_is_bridge_eth3', 'doc': u"L'interface r\xe9seau de la zone est un bridge", 'values': (u'oui', u'non'), 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name_bridge, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497537136, False), 'context': ParamContext()}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497595296}]})
    option_139789497766784 = UnicodeOption(**{'multi': False, 'name': 'nom_zone_eth3', 'doc': u"Nom de l'interface r\xe9seau de la zone", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497537136, False), 'interface_no': ParamValue("3"), 'method': ParamOption(option_139789497748480, False), 'zone_is_bridge': ParamOption(option_139789497766512, True)})})
    option_139789497767056 = ChoiceOption(**{'multi': False, 'values': (u'balance-rr', u'active-backup', u'balance-xor', u'broadcast', u'802.3ad', u'balance-tlb', u'balance-alb'), 'name': 'bonding_mode_eth3', 'default': u'balance-rr', 'doc': u'Mode de bonding', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595296}]})
    option_139789497767056.impl_set_information("help", u"""Mode de fonctionnement du bond""")
    option_139789497767328 = IntOption(**{'multi': False, 'name': 'bonding_miimon_eth3', 'default': 100, 'doc': u'Fr\xe9quence des MII link monitoring en millisecondes', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595296}]})
    option_139789497767328.impl_set_information("help", u"""Intervalle de temps pour le monitoring des interfaces""")
    option_139789497767600 = IntOption(**{'multi': False, 'name': 'bonding_downdelay_eth3', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e down", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595296}]})
    option_139789497767872 = IntOption(**{'multi': False, 'name': 'bonding_updelay_eth3', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e comme active", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595296}]})
    option_139789497768144 = ChoiceOption(**{'multi': False, 'values': (u'', u'speed 100 duplex full autoneg off', u'autoneg on', u'speed 10 duplex half autoneg off', u'speed 1000 duplex full autoneg off'), 'name': 'debit_carte_eth3', 'default': u'', 'doc': u"Mode de connexion pour l'interface interne 3", 'properties': ('expert',)})
    option_139789497768416 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_eth3', 'default': 'non', 'doc': u'Autoriser les connexions SSH', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497768416.impl_set_information("separator", ("Administration distante sur l'interface", None))
    option_139789497768688 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_ssh_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497768416}]})
    option_139789497768960 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_ssh_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497768416}]})
    option_139789497768960.impl_add_consistency("network_netmask", option_139789497768688, **{})
    option_139789497678736 = MasterSlaves(children=[option_139789497768688, option_139789497768960], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'properties': ('basic',), 'name': 'ip_ssh_eth3'})
    option_139789497769232 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'admin_eth3', 'default': 'non', 'doc': u'Autoriser les connexions pour administrer le serveur (EAD, phpMyAdmin, ...)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497769504 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_admin_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497769232}]})
    option_139789497782352 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_admin_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497769232}]})
    option_139789497782352.impl_add_consistency("network_netmask", option_139789497769504, **{})
    option_139789497679056 = MasterSlaves(children=[option_139789497769504, option_139789497782352], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'properties': ('basic',), 'name': 'ip_admin_eth3'})
    option_139789497782624 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'alias_eth3', 'default': 'non', 'doc': u"Ajouter des IP alias sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497782624.impl_set_information("separator", ("Configuration des alias sur l'interface", None))
    option_139789497782896 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_ip_eth3', 'doc': u"Adresse IP alias pour l'interface", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}]})
    option_139789497783168 = NetmaskOption(**{'multi': True, 'name': 'alias_netmask_eth3', 'doc': u'Masque de sous r\xe9seau correspondant \xe0 cet alias', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497749024, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}]})
    option_139789497783440 = NetworkOption(**{'multi': True, 'name': 'alias_network_eth3', 'doc': u'Adresse r\xe9seau correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497782896, False), 'netmask': ParamOption(option_139789497783168, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}]})
    option_139789497783712 = BroadcastOption(**{'multi': True, 'name': 'alias_broadcast_eth3', 'doc': u'Adresse broadcast correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497782896, False), 'netmask': ParamOption(option_139789497783168, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}]})
    option_139789497783984 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_alias_eth3', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497784256 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_alias_eth3', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497782624}]})
    option_139789497784528 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'squid_auth_eth3', 'default': 'oui', 'doc': u"Activer l'authentification sur cette interface", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}]})
    option_139789497784528.impl_set_information("help", u"""L'authentification sur cette interface s'applique aussi aux VLAN et alias""")
    option_139789497784800 = ChoiceOption(**{'multi': False, 'name': 'activer_cntlm_eth3', 'doc': u'Activer le proxy NTLM sur cette interface', 'values': (u'oui', u'non'), 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497574816, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497784528}]})
    option_139789497785072 = PortOption(**{'multi': False, 'name': 'wpad_proxyport_eth3', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamOption(option_139789497575088, True), 'condition_1': ParamOption(option_139789497784800, True), 'match': ParamValue("3128")}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497785072.impl_set_information("separator", (u'Configuration de la d\xe9tection automatique du proxy', None))
    option_139789497785344 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_alias_eth3', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour cet alias', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497785072, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497679376 = MasterSlaves(children=[option_139789497782896, option_139789497783168, option_139789497783440, option_139789497783712, option_139789497783984, option_139789497784256, option_139789497785344], **{'doc': u"Adresse IP alias pour l'interface", 'properties': ('basic',), 'name': 'alias_ip_eth3'})
    option_139789497785616 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'vlan_eth3', 'default': 'non', 'doc': u"Activer le support des VLAN sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497785616.impl_set_information("separator", ("Configuration des VLAN sur l'interface", None))
    option_139789497785888 = UnicodeOption(**{'doc': u"Num\xe9ro d'identifiant du VLAN", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'vlan_id_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497270352 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_ip_eth3', 'doc': u"Adresse IP de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497270624 = NetmaskOption(**{'multi': True, 'name': 'vlan_netmask_eth3', 'default_multi': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497270896 = NetworkOption(**{'multi': True, 'name': 'vlan_network_eth3', 'doc': u"Adresse r\xe9seau de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497270352, False), 'netmask': ParamOption(option_139789497270624, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497271168 = BroadcastOption(**{'multi': True, 'name': 'vlan_broadcast_eth3', 'doc': u"Adresse de broadcast de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497270352, False), 'netmask': ParamOption(option_139789497270624, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497271440 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_vlan_eth3', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497271712 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_vlan_eth3', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497785616}]})
    option_139789497271984 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_vlan_eth3', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour ce VLAN', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497785072, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497278544 = MasterSlaves(children=[option_139789497785888, option_139789497270352, option_139789497270624, option_139789497270896, option_139789497271168, option_139789497271440, option_139789497271712, option_139789497271984], **{'doc': u"Num\xe9ro d'identifiant du VLAN", 'properties': ('basic',), 'name': 'vlan_id_eth3'})
    option_139789497272256 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_master_eth3', 'default': 'oui', 'doc': u'Serveur master DNS de cette zone', 'properties': ('mandatory', 'normal')})
    option_139789497272256.impl_set_information("separator", ("Configuration DNS sur l'interface", None))
    option_139789497272528 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_rvp_eth3', 'default': 'non', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497272800 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_forward_eth3', 'default': 'oui', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal')})
    option_139789497273072 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2'), 'name': 'dansguardian_eth3', 'default': u'1', 'doc': u'Filtre web \xe0 appliquer sur cette interface', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497273072.impl_set_information("separator", ('Configuration de la politique de filtrage', None))
    option_139789497273072.impl_set_information("help", u"""Instance e2guardian à utiliser pour l'interface 3 (1=Configuration 1, 2=Configuration 2)""")
    option_139789497273344 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_eth3_proxy_link', 'doc': u'Adresse IP pour le proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497273344.impl_set_information("separator", ('Adresse pour le proxy', None))
    option_139789497273344.impl_add_consistency("in_network", option_139789497765968, option_139789497749024, **{'transitive': False, 'warnings_only': True})
    option_139789497273344.impl_add_consistency("not_equal", option_139789497748752, **{'transitive': False})
    option_139789497273616 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_eth3_proxy_link', 'doc': u'Masque de sous r\xe9seau du proxy', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497749024, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497273888 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_eth3_proxy_link', 'doc': u'Broadcast pour le proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497273344, False), 'netmask': ParamOption(option_139789497273616, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497299024 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_frontend_ead_distant_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965568}]})
    option_139789497299296 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau autoris\xe9 \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_frontend_ead_distant_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497965568}]})
    option_139789497299296.impl_add_consistency("network_netmask", option_139789497299024, **{})
    option_139789497278864 = MasterSlaves(children=[option_139789497299024, option_139789497299296], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'properties': ('basic',), 'name': 'ip_frontend_ead_distant_eth3'})
    option_139789497279184 = OptionDescription(children=[option_139789497748480, option_139789497748752, option_139789497749024, option_139789497765968, option_139789497766240, option_139789497537136, option_139789497766784, option_139789497595296, option_139789497767056, option_139789497767328, option_139789497767600, option_139789497767872, option_139789497766512, option_139789497768144, option_139789497768416, option_139789497678736, option_139789497769232, option_139789497679056, option_139789497782624, option_139789497679376, option_139789497785616, option_139789497278544, option_139789497272256, option_139789497272528, option_139789497272800, option_139789497674208, option_139789497273072, option_139789497784528, option_139789497273344, option_139789497273616, option_139789497273888, option_139789497965568, option_139789497278864, option_139789497785072, option_139789497784800], requires=[{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}], **{'doc': u'Interface-3', 'properties': ('basic',), 'name': 'interface_3'})
    option_139789497279184.impl_set_information("help", u"""Configuration de l'interface 3""")
    option_139789497279184.impl_set_information("icon", u"""sitemap""")
    option_139789497299568 = ChoiceOption(**{'multi': False, 'values': (u'statique',), 'name': 'eth4_method', 'default': u'statique', 'doc': u"M\xe9thode d'attribution de l'adressage pour l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497299568.impl_set_information("separator", ("Configuration de l'interface", None))
    option_139789497299840 = IPOption(**{'multi': False, 'name': 'adresse_ip_eth4', 'doc': u"Adresse IP de l'interface", 'properties': ('mandatory', 'basic'), 'private_only': True, 'warnings_only': True})
    option_139789497300112 = NetmaskOption(**{'default': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'adresse_netmask_eth4'})
    option_139789497300112.impl_add_consistency("ip_netmask", option_139789497299840, **{'warnings_only': True})
    option_139789497300384 = NetworkOption(**{'multi': False, 'name': 'adresse_network_eth4', 'doc': u"Adresse r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497299840, False), 'netmask': ParamOption(option_139789497300112, False)})})
    option_139789497300656 = BroadcastOption(**{'multi': False, 'name': 'adresse_broadcast_eth4', 'doc': u"Adresse broadcast de sous r\xe9seau de l'interface", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497299840, False), 'netmask': ParamOption(option_139789497300112, False)})})
    option_139789497300928 = ChoiceOption(**{'multi': False, 'name': 'zone_is_bridge_eth4', 'doc': u"L'interface r\xe9seau de la zone est un bridge", 'values': (u'oui', u'non'), 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name_bridge, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497537408, False), 'context': ParamContext()}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497595024}]})
    option_139789497301200 = UnicodeOption(**{'multi': False, 'name': 'nom_zone_eth4', 'doc': u"Nom de l'interface r\xe9seau de la zone", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.get_zone_name, 'callback_params': Params(args=None, kwargs={'nom_carte': ParamOption(option_139789497537408, False), 'interface_no': ParamValue("4"), 'method': ParamOption(option_139789497299568, False), 'zone_is_bridge': ParamOption(option_139789497300928, True)})})
    option_139789497301472 = ChoiceOption(**{'multi': False, 'values': (u'balance-rr', u'active-backup', u'balance-xor', u'broadcast', u'802.3ad', u'balance-tlb', u'balance-alb'), 'name': 'bonding_mode_eth4', 'default': u'balance-rr', 'doc': u'Mode de bonding', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595024}]})
    option_139789497301472.impl_set_information("help", u"""Mode de fonctionnement du bond""")
    option_139789497301744 = IntOption(**{'multi': False, 'name': 'bonding_miimon_eth4', 'default': 100, 'doc': u'Fr\xe9quence des MII link monitoring en millisecondes', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595024}]})
    option_139789497301744.impl_set_information("help", u"""Intervalle de temps pour le monitoring des interfaces""")
    option_139789497302016 = IntOption(**{'multi': False, 'name': 'bonding_downdelay_eth4', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e down", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595024}]})
    option_139789497302288 = IntOption(**{'multi': False, 'name': 'bonding_updelay_eth4', 'default': 200, 'doc': u"Temps en millisecondes pour qu'une interface soit d\xe9tect\xe9e comme active", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497595024}]})
    option_139789497302560 = ChoiceOption(**{'multi': False, 'values': (u'', u'speed 100 duplex full autoneg off', u'autoneg on', u'speed 10 duplex half autoneg off', u'speed 1000 duplex full autoneg off'), 'name': 'debit_carte_eth4', 'default': u'', 'doc': u"Mode de connexion pour l'interface interne 4", 'properties': ('expert',)})
    option_139789497323600 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ssh_eth4', 'default': 'non', 'doc': u'Autoriser les connexions SSH', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497323600.impl_set_information("separator", ("Administration distante sur l'interface", None))
    option_139789497323872 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_ssh_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497323600}]})
    option_139789497324144 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions SSH', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_ssh_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497323600}]})
    option_139789497324144.impl_add_consistency("network_netmask", option_139789497323872, **{})
    option_139789497279504 = MasterSlaves(children=[option_139789497323872, option_139789497324144], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions SSH', 'properties': ('basic',), 'name': 'ip_ssh_eth4'})
    option_139789497324416 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'admin_eth4', 'default': 'non', 'doc': u'Autoriser les connexions pour administrer le serveur (EAD, phpMyAdmin, ...)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497966112}]})
    option_139789497324688 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_admin_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497324416}]})
    option_139789497324960 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour administrer le serveur', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_admin_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497324416}]})
    option_139789497324960.impl_add_consistency("network_netmask", option_139789497324688, **{})
    option_139789497279824 = MasterSlaves(children=[option_139789497324688, option_139789497324960], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour administrer le serveur', 'properties': ('basic',), 'name': 'ip_admin_eth4'})
    option_139789497325232 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'alias_eth4', 'default': 'non', 'doc': u"Ajouter des IP alias sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497325232.impl_set_information("separator", ("Configuration des alias sur l'interface", None))
    option_139789497325504 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'alias_ip_eth4', 'doc': u"Adresse IP alias pour l'interface", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}]})
    option_139789497325776 = NetmaskOption(**{'multi': True, 'name': 'alias_netmask_eth4', 'doc': u'Masque de sous r\xe9seau correspondant \xe0 cet alias', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497300112, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}]})
    option_139789497326048 = NetworkOption(**{'multi': True, 'name': 'alias_network_eth4', 'doc': u'Adresse r\xe9seau correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497325504, False), 'netmask': ParamOption(option_139789497325776, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}]})
    option_139789497326320 = BroadcastOption(**{'multi': True, 'name': 'alias_broadcast_eth4', 'doc': u'Adresse broadcast correspondant \xe0 cet alias', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497325504, False), 'netmask': ParamOption(option_139789497325776, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}]})
    option_139789497326592 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_alias_eth4', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497326864 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_alias_eth4', 'default_multi': 'non', 'doc': u'Autoriser cet alias \xe0 utiliser les DNS de zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497325232}]})
    option_139789497327136 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'squid_auth_eth4', 'default': 'oui', 'doc': u"Activer l'authentification sur cette interface", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}]})
    option_139789497327136.impl_set_information("help", u"""L'authentification sur cette interface s'applique aussi aux VLAN et alias""")
    option_139789497335888 = ChoiceOption(**{'multi': False, 'name': 'activer_cntlm_eth4', 'doc': u'Activer le proxy NTLM sur cette interface', 'values': (u'oui', u'non'), 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497574816, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497327136}]})
    option_139789497336160 = PortOption(**{'multi': False, 'name': 'wpad_proxyport_eth4', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamOption(option_139789497575088, True), 'condition_1': ParamOption(option_139789497335888, True), 'match': ParamValue("3128")}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497336160.impl_set_information("separator", (u'Configuration de la d\xe9tection automatique du proxy', None))
    option_139789497336432 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_alias_eth4', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour cet alias', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497336160, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497280144 = MasterSlaves(children=[option_139789497325504, option_139789497325776, option_139789497326048, option_139789497326320, option_139789497326592, option_139789497326864, option_139789497336432], **{'doc': u"Adresse IP alias pour l'interface", 'properties': ('basic',), 'name': 'alias_ip_eth4'})
    option_139789497336704 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'vlan_eth4', 'default': 'non', 'doc': u"Activer le support des VLAN sur l'interface", 'properties': ('mandatory', 'normal')})
    option_139789497336704.impl_set_information("separator", ("Configuration des VLAN sur l'interface", None))
    option_139789497336976 = UnicodeOption(**{'doc': u"Num\xe9ro d'identifiant du VLAN", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'vlan_id_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497337248 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'vlan_ip_eth4', 'doc': u"Adresse IP de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497337520 = NetmaskOption(**{'multi': True, 'name': 'vlan_netmask_eth4', 'default_multi': u'255.255.255.0', 'doc': u"Masque de sous r\xe9seau de l'interface dans ce VLAN", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497337792 = NetworkOption(**{'multi': True, 'name': 'vlan_network_eth4', 'doc': u"Adresse r\xe9seau de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_network, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497337248, False), 'netmask': ParamOption(option_139789497337520, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497338064 = BroadcastOption(**{'multi': True, 'name': 'vlan_broadcast_eth4', 'doc': u"Adresse de broadcast de l'interface dans ce VLAN", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497337248, False), 'netmask': ParamOption(option_139789497337520, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497338336 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_vlan_eth4', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497338608 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_vlan_eth4', 'default_multi': 'non', 'doc': u'Autoriser ce VLAN \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497336704}]})
    option_139789497338880 = PortOption(**{'multi': True, 'name': 'wpad_proxyport_vlan_eth4', 'allow_private': True, 'doc': u'Port du proxy diffus\xe9 par WPAD pour ce VLAN', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497336160, False)}), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789497280464 = MasterSlaves(children=[option_139789497336976, option_139789497337248, option_139789497337520, option_139789497337792, option_139789497338064, option_139789497338336, option_139789497338608, option_139789497338880], **{'doc': u"Num\xe9ro d'identifiant du VLAN", 'properties': ('basic',), 'name': 'vlan_id_eth4'})
    option_139789497339152 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_master_eth4', 'default': 'oui', 'doc': u'Serveur master DNS de cette zone', 'properties': ('mandatory', 'normal')})
    option_139789497339152.impl_set_information("separator", ("Configuration DNS sur l'interface", None))
    option_139789497339424 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_rvp_eth4', 'default': 'non', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497352272 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dns_forward_eth4', 'default': 'oui', 'doc': u'Autoriser cette zone \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'normal')})
    option_139789497352544 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2'), 'name': 'dansguardian_eth4', 'default': u'1', 'doc': u'Filtre web \xe0 appliquer sur cette interface', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497352544.impl_set_information("separator", ('Configuration de la politique de filtrage', None))
    option_139789497352544.impl_set_information("help", u"""Instance e2guardian à utiliser pour l'interface 4 (1=Configuration 1, 2=Configuration 2)""")
    option_139789497352816 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_eth4_proxy_link', 'doc': u'Adresse IP pour le proxy', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497352816.impl_set_information("separator", ('Adresse pour le proxy', None))
    option_139789497352816.impl_add_consistency("in_network", option_139789497300384, option_139789497300112, **{'transitive': False, 'warnings_only': True})
    option_139789497352816.impl_add_consistency("not_equal", option_139789497299840, **{'transitive': False})
    option_139789497353088 = NetmaskOption(**{'multi': False, 'name': 'adresse_mask_eth4_proxy_link', 'doc': u'Masque de sous r\xe9seau du proxy', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497300112, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497353360 = BroadcastOption(**{'multi': False, 'name': 'adresse_bcast_eth4_proxy_link', 'doc': u'Broadcast pour le proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_broadcast, 'callback_params': Params(args=None, kwargs={'ip': ParamOption(option_139789497352816, False), 'netmask': ParamOption(option_139789497353088, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497353632 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_frontend_ead_distant_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964752}]})
    option_139789497353904 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau autoris\xe9 \xe0 acc\xe9der au backend EAD', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'netmask_frontend_ead_distant_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964752}]})
    option_139789497353904.impl_add_consistency("network_netmask", option_139789497353632, **{})
    option_139789497280784 = MasterSlaves(children=[option_139789497353632, option_139789497353904], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e \xe0 acc\xe9der au backend EAD', 'properties': ('basic',), 'name': 'ip_frontend_ead_distant_eth4'})
    option_139789497281104 = OptionDescription(children=[option_139789497299568, option_139789497299840, option_139789497300112, option_139789497300384, option_139789497300656, option_139789497537408, option_139789497301200, option_139789497595024, option_139789497301472, option_139789497301744, option_139789497302016, option_139789497302288, option_139789497300928, option_139789497302560, option_139789497323600, option_139789497279504, option_139789497324416, option_139789497279824, option_139789497325232, option_139789497280144, option_139789497336704, option_139789497280464, option_139789497339152, option_139789497339424, option_139789497352272, option_139789497674480, option_139789497352544, option_139789497327136, option_139789497352816, option_139789497353088, option_139789497353360, option_139789497964752, option_139789497280784, option_139789497336160, option_139789497335888], requires=[{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}], **{'doc': u'Interface-4', 'properties': ('basic',), 'name': 'interface_4'})
    option_139789497281104.impl_set_information("help", u"""Configuration de l'interface 4""")
    option_139789497281104.impl_set_information("icon", u"""sitemap""")
    option_139789497354176 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'restrict_ping_request', 'default': 'non', 'doc': u'Restreindre le ping aux r\xe9seaux autoris\xe9s pour administrer le serveur', 'properties': ('disabled', 'mandatory', 'expert')})
    option_139789497354720 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ipv6', 'default': 'non', 'doc': u'Activer le support IPV6', 'properties': ('mandatory', 'expert')})
    option_139789497354448 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_routage_ipv4', 'default': 'oui', 'doc': u'Activer le routage IPv4 entre les interfaces', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497354448.impl_set_information("help", u"""Permet d’activer le routage IPv4 au niveau du noyau en passant à 1 la valeur de /proc/sys/net/ipv4/ip_forward. Valeur par défaut: « non ».""")
    option_139789497354992 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_routage_ipv6', 'default': 'non', 'doc': u'Activer le routage IPv6 entre les interfaces', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497354720}]})
    option_139789497354992.impl_set_information("help", u"""Permet d’activer le routage IPv6 au niveau du noyau en passant à 1 la valeur de /proc/sys/net/ipv6/conf/all/forwarding. Valeur par défaut: « non ».""")
    option_139789497355264 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_log_martian', 'default': 'non', 'doc': u'Journaliser les "martian sources"', 'properties': ('mandatory', 'expert')})
    option_139789497355264.impl_set_information("separator", (u'S\xe9curit\xe9', None))
    option_139789497355536 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_antispoofing', 'default': 'non', 'doc': u"Activer l'anti-spoofing sur toutes les interfaces", 'properties': ('mandatory', 'expert')})
    option_139789497355808 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ajout_hosts', 'default': 'non', 'doc': u"D\xe9clarer des noms d'h\xf4tes suppl\xe9mentaires", 'properties': ('mandatory', 'expert')})
    option_139789497355808.impl_set_information("separator", (u"Ajout d'h\xf4tes", None))
    option_139789497355808.impl_set_information("help", u"""Permet d'ajouter des entrées dans le fichier /etc/hosts""")
    option_139789497380944 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_ip_hosts', 'doc': u"Adresse IP de l'h\xf4te", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497355808}]})
    option_139789497381216 = DomainnameOption(**{'type_': 'domainname', 'name': 'nom_long_hosts', 'doc': u"Nom long de l'h\xf4te", 'allow_ip': False, 'multi': True, 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497355808}]})
    option_139789497381488 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_court_hosts', 'doc': u"Nom court de l'h\xf4te", 'allow_ip': False, 'multi': True, 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497355808}]})
    option_139789497281424 = MasterSlaves(children=[option_139789497380944, option_139789497381216, option_139789497381488], **{'doc': u"Adresse IP de l'h\xf4te", 'properties': ('expert',), 'name': 'adresse_ip_hosts'})
    option_139789497381760 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_route', 'default': 'non', 'doc': u'Ajouter des routes statiques', 'properties': ('mandatory', 'expert')})
    option_139789497381760.impl_set_information("separator", ('Ajout de routes statiques', None))
    option_139789497381760.impl_set_information("help", u"""Permet de déclarer des routes afin d'accéder à des adresses ou à des plages d'adresses par un chemin différent de celui par défaut""")
    option_139789497382032 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'route_adresse', 'doc': u'Adresse IP ou r\xe9seau \xe0 ajouter dans la table de routage', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497382304 = NetmaskOption(**{'doc': u'Masque de sous r\xe9seau (mettre \xe0 255.255.255.255 si adresse host)', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'route_netmask', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497382576 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'route_gw', 'doc': u'Adresse IP de la passerelle pour acc\xe9der \xe0 ce r\xe9seau', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497382848 = ChoiceOption(**{'multi': True, 'values': (u'0', u'1', u'2', u'3', u'4'), 'name': 'route_int', 'doc': u'Interface r\xe9seau reli\xe9e \xe0 la passerelle', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497383120 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_route', 'default_multi': 'oui', 'doc': u'Autoriser ce r\xe9seau \xe0 utiliser les DNS du serveur', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497383392 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_rvp_route', 'default_multi': 'oui', 'doc': u'Autoriser ce r\xe9seau \xe0 utiliser les DNS de Forward RVP/AGRIATES', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789497383664 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dns_forward_route', 'default_multi': 'oui', 'doc': u'Autoriser ce r\xe9seau \xe0 utiliser les DNS des zones forward additionnelles', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497381760}]})
    option_139789497281744 = MasterSlaves(children=[option_139789497382032, option_139789497382304, option_139789497382576, option_139789497382848, option_139789497383120, option_139789497383392, option_139789497383664], **{'doc': u'Adresse IP ou r\xe9seau \xe0 ajouter dans la table de routage', 'properties': ('expert',), 'name': 'route_adresse'})
    option_139789497383936 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ip_no_pmtu_disc', 'default': 'non', 'doc': u'D\xe9sactiver le path MTU discovery, le bit DF est positionn\xe9 \xe0 0', 'properties': ('mandatory', 'expert')})
    option_139789497383936.impl_set_information("separator", ('Configuration du MTU', None))
    option_139789497384208 = IntOption(**{'doc': u"Valeur du MTU pour l'interface 0 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_eth0'})
    option_139789497384480 = IntOption(**{'doc': u"Valeur du MTU pour l'interface 1 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_eth1'})
    option_139789497393232 = IntOption(**{'doc': u"Valeur du MTU pour l'interface 2 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_eth2', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789497393504 = IntOption(**{'doc': u"Valeur du MTU pour l'interface 3 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_eth3', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789497393776 = IntOption(**{'doc': u"Valeur du MTU pour l'interface 4 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_eth4', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789497394048 = IntOption(**{'doc': u"Valeur du MTU pour l'interface ppp0 : rien = valeur par d\xe9faut de l'interface", 'multi': False, 'properties': ('expert',), 'name': 'valeur_mtu_ppp0', "requires": [{'expected': u'pppoe', 'action': 'disabled', 'inverse': True, "option": option_139789497938272}]})
    option_139789497394320 = IntOption(**{'default': 128, 'doc': u'Neighbour table overflow stop culling limit', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipv4_neigh_default_gc_thresh1'})
    option_139789497394320.impl_set_information("separator", ('Configuration de la "neighbour table"', None))
    option_139789497394592 = IntOption(**{'default': 512, 'doc': u'Neighbour table overflow soft limit', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipv4_neigh_default_gc_thresh2'})
    option_139789497394864 = IntOption(**{'default': 1024, 'doc': u'Neighbour table overflow hard limit', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipv4_neigh_default_gc_thresh3'})
    option_139789497395136 = DomainnameOption(**{'multi': True, 'name': 'test_distant_domaine', 'default': [u'bp-eole.ac-dijon.fr', u'archive.ubuntu.com'], 'doc': u"Domaine utilis\xe9 pour le test de l'acc\xe8s distant", 'type_': 'domainname', 'allow_ip': False, 'default_multi': u'bp-eole.ac-dijon.fr', 'properties': ('mandatory', 'expert')})
    option_139789497395136.impl_set_information("separator", (u"Test de l'acc\xe8s distant", None))
    option_139789497282064 = OptionDescription(children=[option_139789497966112, option_139789497354176, option_139789497354720, option_139789497354448, option_139789497354992, option_139789497355264, option_139789497355536, option_139789497355808, option_139789497281424, option_139789497381760, option_139789497281744, option_139789497383936, option_139789497384208, option_139789497384480, option_139789497393232, option_139789497393504, option_139789497393776, option_139789497394048, option_139789497394320, option_139789497394592, option_139789497394864, option_139789497395136], **{'doc': u'r\xe9seau avanc\xe9', 'properties': ('expert',), 'name': 'reseau_avance'})
    option_139789497282064.impl_set_information("icon", u"""sitemap""")
    option_139789497395408 = IntOption(**{'multi': False, 'name': 'ssl_default_key_bits', 'default': 2048, 'doc': u'Taille de la cl\xe9', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497395408.impl_set_information("separator", (u'Param\xe8tres SSL', None))
    option_139789497395680 = IntOption(**{'multi': False, 'name': 'ssl_default_cert_time', 'default': 1096, 'doc': u'Dur\xe9e de validit\xe9 du certificat (en jours)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497395952 = UnicodeOption(**{'multi': False, 'name': 'ssl_country_name', 'doc': u'Nom du pays (C=)', 'properties': ('expert',), 'callback': eosfunc.calc_ssl_country_name, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497891568, False)}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}], "validator": eosfunc.valid_country})
    option_139789497395952.impl_set_information("separator", ('Subject (DN)', None))
    option_139789497396224 = UnicodeOption(**{'multi': False, 'name': 'ssl_organization_name', 'default': u'Ministere Education Nationale (MENESR)', 'doc': u"Nom de l'organisation (O=)", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497396496 = UnicodeOption(**{'multi': True, 'name': 'ssl_organization_unit_name', 'doc': u"Nom de l'unit\xe9 de l'organisation (OU=)", 'properties': ('expert',), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamValue("110 043 015"), ParamOption(option_139789497891296, False)), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497396768 = DomainnameOption(**{'multi': False, 'name': 'ssl_server_name', 'allow_ip': False, 'type_': 'domainname', 'doc': u'Nom DNS du serveur (de la forme nom-serveur.ac-acad.fr) (CN=)', 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789497891024, False),), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497413712 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'revprox_activate_http', 'default': 'non', 'doc': u'Activer le reverse proxy Nginx pour http/https', 'properties': ('mandatory', 'normal')})
    option_139789497413712.impl_set_information("separator", ('Redirection HTTP et HTTPS', None))
    option_139789497413984 = DomainnameOption(**{'multi': True, 'name': 'revprox_domainname', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom de domaine ou IP \xe0 rediriger', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789497413984.impl_set_information("help", u"""Exemple : pour rediriger \"http://domaine/\" saisir \"domaine\"""")
    option_139789497414256 = DomainnameOption(**{'type_': 'domainname', 'name': 'web_url', 'doc': u'Nom de domaine des applications web (sans http://)', 'allow_ip': False, 'multi': False, 'properties': ('auto_freeze', 'mandatory', 'basic')})
    option_139789497414256.impl_set_information("help", u"""Nom de domaine de votre établissement ex : etablissement.ac-acad.fr""")
    option_139789497414256.impl_add_consistency("not_equal", option_139789497890480, **{'warnings_only': True})
    option_139789497414528 = DomainnameOption(**{'multi': False, 'name': 'eolesso_adresse', 'allow_ip': False, 'type_': 'domainname', 'doc': u"Nom de domaine du serveur d'authentification SSO", 'properties': ('normal',), 'callback': eosfunc.calc_val_first_value, 'callback_params': Params(args=(ParamOption(option_139789497414256, True), ParamOption(option_139789497891024, False)), kwargs={})})
    option_139789497414528.impl_set_information("help", u"""Nom de domaine du serveur d'authentification, ne pas utiliser d'adresse IP ou localhost""")
    option_139789497414800 = DomainnameOption(**{'multi': True, 'name': 'ssl_subjectaltname', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Nom DNS/IP alternatif du serveur', 'properties': ('expert',), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamOption(option_139789497538768, False), ParamOption(option_139789497891024, False), ParamOption(option_139789497560336, True), ParamOption(option_139789497413984, True), ParamOption(option_139789497414528, True), ParamOption(option_139789497414256, True)), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'frozen', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'hidden', 'inverse': False, "option": option_139789497939360}, {'expected': u'letsencrypt', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497939360}]})
    option_139789497414800.impl_set_information("separator", ('Nom Alternatif de la machine (SubjectAltName)', None))
    option_139789497415072 = DomainnameOption(**{'type_': 'domainname', 'name': 'le_extra_names', 'doc': u'Nom de domaines suppl\xe9mentaires', 'allow_ip': False, 'multi': True, 'properties': ('expert',), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497415072.impl_set_information("separator", (u'Certificats suppl\xe9mentaires \xe0 demander', None))
    option_139789497415072.impl_set_information("help", u"""Liste des noms de domaine pour les certificats supplémentaires a demander lors de la requête""")
    option_139789497415344 = FilenameOption(**{'multi': False, 'name': 'le_config_dir', 'default': u'/etc/ssl/letsencrypt/conf', 'doc': u"R\xe9pertoire de configuration du client Let's Encrypt", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497415344.impl_set_information("separator", (u"Param\xe8tres du client Let's Encrypt", None))
    option_139789497415344.impl_set_information("help", u"""Répertoire de configuration du client ACME (Let's Encrypt)""")
    option_139789497415616 = FilenameOption(**{'multi': False, 'name': 'le_work_dir', 'default': u'/tmp/letsencrypt/work', 'doc': u"R\xe9pertoire de travail du client Let's Encrypt", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497415616.impl_set_information("help", u"""Répertoire de travail du client ACME""")
    option_139789497415888 = FilenameOption(**{'multi': False, 'name': 'le_logs_dir', 'default': u'/var/log/letsencrypt/', 'doc': u"R\xe9pertoire de journalisation du client Let's Encrypt", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497415888.impl_set_information("help", u"""Répertoire de journalisation du client ACME""")
    option_139789497416160 = UnicodeOption(**{'doc': u"Adresse du serveur Let's Encrypt", 'multi': False, 'properties': ('expert',), 'name': 'le_server_addr', "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497416160.impl_set_information("help", u"""Adresse du serveur ACME utilisé pour la génération automatique des certificats""")
    option_139789497416432 = PortOption(**{'multi': False, 'name': 'le_server_port', 'allow_private': True, 'doc': u"Port d'\xe9coute du serveur Let's Encrypt", 'properties': ('expert',), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497416432.impl_set_information("help", u"""Port d'écoute du serveur ACME utilisé pour la génération automatique des certificats""")
    option_139789497416704 = ChoiceOption(**{'multi': False, 'values': (u'webroot', u'standalone'), 'name': 'le_client_mode', 'default': u'webroot', 'doc': u"Mode de fonctionnement du client Let's Encrypt", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497416704.impl_set_information("help", u"""Mode de fonctionnement du client ACME pour la demande de certificat, (standalone ou webroot)""")
    option_139789497416976 = PortOption(**{'multi': False, 'name': 'le_http_01_port', 'allow_private': True, 'default': 80, 'doc': u"Port d'\xe9coute pour la requ\xeate http-01", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497416976.impl_set_information("help", u"""Port d'écoute à ouvrir pour la vérification http 01 du serveur ACME lors de la demande de certificat""")
    option_139789497417248 = PortOption(**{'multi': False, 'name': 'le_tls_sni_port', 'allow_private': True, 'default': 443, 'doc': u"Port d'\xe9coute pour la requ\xeat TLS-SNI", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497417248.impl_set_information("help", u"""Port d'écoute à ouvrir pour la vérification TLS-SNI du serveur ACME lors de la demande de certificat""")
    option_139789497426000 = FilenameOption(**{'multi': False, 'name': 'le_ssl_cert', 'doc': u'Chemin du certificat SSL par d\xe9faut', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamOption(option_139789497415344, False), ParamValue("/live/"), ParamOption(option_139789497891024, False), ParamValue("/cert.pem")), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497426272 = FilenameOption(**{'multi': False, 'name': 'le_ssl_key', 'doc': u'Chemin de l\xe0 cl\xe9 priv\xe9e SSL par d\xe9faut', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamOption(option_139789497415344, False), ParamValue("/live/"), ParamOption(option_139789497891024, False), ParamValue("/privkey.pem")), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497426544 = FilenameOption(**{'multi': False, 'name': 'le_ssl_pem', 'doc': u'Chemin de la chaine compl\xe8te SSL par d\xe9faut', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamOption(option_139789497415344, False), ParamValue("/live/"), ParamOption(option_139789497891024, False), ParamValue("/fullchain.pem")), kwargs={}), "requires": [{'expected': u'letsencrypt', 'action': 'disabled', 'inverse': True, "option": option_139789497939360}]})
    option_139789497434192 = OptionDescription(children=[option_139789497395408, option_139789497395680, option_139789497395952, option_139789497396224, option_139789497396496, option_139789497396768, option_139789497414800, option_139789497415072, option_139789497415344, option_139789497415616, option_139789497415888, option_139789497416160, option_139789497416432, option_139789497416704, option_139789497416976, option_139789497417248, option_139789497426000, option_139789497426272, option_139789497426544], **{'doc': u'certificats ssl', 'properties': ('expert',), 'name': 'certificats_ssl'})
    option_139789497434192.impl_set_information("icon", u"""lock""")
    option_139789497426816 = UnicodeOption(**{'doc': u'Libell\xe9 du d\xe9p\xf4t', 'multi': True, 'properties': ('expert',), 'name': 'additional_repository_name'})
    option_139789497426816.impl_set_information("separator", (u'Configuration des d\xe9p\xf4ts tiers', None))
    option_139789497427088 = UnicodeOption(**{'multi': True, 'name': 'additional_repository_source', 'doc': u'D\xe9claration du d\xe9p\xf4t', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^((deb)|(deb-src)) (\[ .* \] )?(((http)|(https)|(ftp)|(ftps))://\S+) (\S+)(( \S+)+)?"),), kwargs={'err_msg': ParamValue(u"La déclaration d'un dépôt doit respecter le format one-line-style (man 5 sources.list)")})})
    option_139789497427088.impl_set_information("help", u"""Déclaration du dépôt dans le style one-line attendu pour les fichiers .list : type options uri suite components (deb|deb-src [ option1=value1 option2=value2 ] uri suite [component1] [component2] [...])""")
    option_139789497427360 = ChoiceOption(**{'multi': True, 'values': (u'serveur de cl\xe9s', u'URL de la cl\xe9'), 'name': 'additional_repository_key_type', 'default_multi': u'serveur de cl\xe9s', 'doc': u'M\xe9thode de r\xe9cup\xe9ration de la cl\xe9 publique du d\xe9p\xf4t', 'properties': ('mandatory', 'expert')})
    option_139789497427632 = URLOption(**{'multi': True, 'name': 'additional_repository_key_url', 'doc': u'URL de la cl\xe9', 'allow_ip': True, 'allow_without_dot': True, 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'serveur de cl\xe9s', 'action': 'disabled', 'inverse': False, "option": option_139789497427360}]})
    option_139789497427904 = UnicodeOption(**{'doc': u'URL du serveur de cl\xe9s', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'additional_repository_key_signserver', "requires": [{'expected': u'URL de la cl\xe9', 'action': 'disabled', 'inverse': False, "option": option_139789497427360}]})
    option_139789497428176 = UnicodeOption(**{'doc': u'Empreinte de la cl\xe9', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'additional_repository_key_fingerprint', "requires": [{'expected': u'URL de la cl\xe9', 'action': 'disabled', 'inverse': False, "option": option_139789497427360}]})
    option_139789497434512 = MasterSlaves(children=[option_139789497426816, option_139789497427088, option_139789497427360, option_139789497427632, option_139789497427904, option_139789497428176], **{'doc': u'Libell\xe9 du d\xe9p\xf4t', 'properties': ('expert',), 'name': 'additional_repository_name'})
    option_139789497434832 = OptionDescription(children=[option_139789497434512], **{'doc': u'd\xe9p\xf4t tiers', 'properties': ('expert',), 'name': 'depot_tiers'})
    option_139789497434832.impl_set_information("help", u"""Ajout de nouveaux paquets absents des dépôts officiels""")
    option_139789497434832.impl_set_information("icon", u"""debian""")
    option_139789497428448 = PortOption(**{'multi': False, 'name': 'apt_cacher_port', 'allow_private': True, 'default': 3142, 'doc': u'Port d\u2019\xe9coute du service apt-cacher-ng', 'properties': ('mandatory', 'expert')})
    option_139789497435152 = OptionDescription(children=[option_139789497428448], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497954928}], **{'doc': u'apt-cacher', 'properties': ('expert',), 'name': 'apt_cacher'})
    option_139789497435152.impl_set_information("help", u"""Paramétrage avancé du service de mise en cache des paquets""")
    option_139789497435152.impl_set_information("icon", u"""debian""")
    option_139789497428720 = ChoiceOption(**{'multi': False, 'values': (u'mode_lb', u'mode_fo'), 'name': 'ag_mode', 'default': u'mode_lb', 'doc': u'Mode load balancing ou fail-over', 'properties': ('mandatory', 'normal')})
    option_139789497428720.impl_set_information("separator", (u"Mode d'agr\xe9gation", None))
    option_139789497428992 = IPOption(**{'doc': u'Destination forc\xe9e sur le lien 1', 'multi': True, 'allow_reserved': True, 'properties': ('normal',), 'name': 'ag_force_eth0'})
    option_139789497428992.impl_set_information("separator", ('Lien 1', None))
    option_139789497429264 = NetmaskOption(**{'doc': u'Masque pour destination forc\xe9e sur le lien 1', 'multi': True, 'properties': ('normal',), 'name': 'ag_force_netmask_eth0'})
    option_139789497435472 = MasterSlaves(children=[option_139789497428992, option_139789497429264], **{'doc': u'Destination forc\xe9e sur le lien 1', 'properties': ('normal',), 'name': 'ag_force_eth0'})
    option_139789497429536 = IPOption(**{'doc': u'Adresse du DNS sur le lien 1', 'multi': True, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'ag_dns_eth0'})
    option_139789497442384 = ChoiceOption(**{'multi': False, 'values': (u'actif', u'passif'), 'name': 'ag_fo_etat_eth0', 'default': u'actif', 'doc': u'Etat actif ou passif pour fail-over lien 1', 'properties': ('normal',), "requires": [{'expected': u'mode_lb', 'action': 'disabled', 'inverse': False, "option": option_139789497428720}]})
    option_139789497442656 = IntOption(**{'doc': u'D\xe9bit mesur\xe9 sur le lien 1 (entier en Mbps)', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ag_weight_eth0', "requires": [{'expected': u'mode_fo', 'action': 'disabled', 'inverse': False, "option": option_139789497428720}]})
    option_139789497442928 = IPOption(**{'doc': u'Destination forc\xe9e sur le lien 2', 'multi': True, 'allow_reserved': True, 'properties': ('normal',), 'name': 'ag_force_eth0_0'})
    option_139789497442928.impl_set_information("separator", ('Lien 2', None))
    option_139789497443200 = NetmaskOption(**{'doc': u'Masque pour destination forc\xe9e sur le lien 2', 'multi': True, 'properties': ('normal',), 'name': 'ag_force_netmask_eth0_0'})
    option_139789497435792 = MasterSlaves(children=[option_139789497442928, option_139789497443200], **{'doc': u'Destination forc\xe9e sur le lien 2', 'properties': ('normal',), 'name': 'ag_force_eth0_0'})
    option_139789497443472 = IPOption(**{'doc': u'Adresse du DNS sur le lien 2', 'multi': True, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'ag_dns_eth0_0'})
    option_139789497443744 = ChoiceOption(**{'multi': False, 'values': (u'actif', u'passif'), 'name': 'ag_fo_etat_eth0_0', 'default': u'actif', 'doc': u'Etat actif ou passif pour fail-over lien 2', 'properties': ('normal',), "requires": [{'expected': u'mode_lb', 'action': 'disabled', 'inverse': False, "option": option_139789497428720}]})
    option_139789497444016 = IntOption(**{'doc': u'D\xe9bit mesur\xe9 sur le lien 2 (entier en Mbps)', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ag_weight_eth0_0', "requires": [{'expected': u'mode_fo', 'action': 'disabled', 'inverse': False, "option": option_139789497428720}]})
    option_139789497444288 = IntOption(**{'default': 10, 'doc': u"D\xe9lai entre les tests d'\xe9tat (en secondes)", 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'ag_pause'})
    option_139789497444288.impl_set_information("separator", ('Divers', None))
    option_139789497444560 = IntOption(**{'default': 1, 'doc': u'Timeout de la requ\xeate DNS (en secondes)', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'ag_timeout'})
    option_139789497444832 = DomainnameOption(**{'multi': True, 'name': 'ag_testdns', 'default': [u'www.google.com'], 'doc': u'Adresse DNS test\xe9e', 'type_': 'domainname', 'allow_ip': False, 'default_multi': u'www.google.com', 'properties': ('mandatory', 'normal')})
    option_139789497445104 = IntOption(**{'default': 4, 'doc': u"Nombre de succ\xe8s avant changement d'\xe9tat", 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'ag_nbsucces'})
    option_139789497445376 = IntOption(**{'default': 1, 'doc': u"Nombre d'\xe9checs avant changement d'\xe9tat", 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'ag_nbechecs'})
    option_139789497445648 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ag_active_mail', 'default': 'non', 'doc': u'Activation des alertes mail', 'properties': ('mandatory', 'normal')})
    option_139789497445648.impl_set_information("separator", ('Alerte mail', None))
    option_139789497445920 = DomainnameOption(**{'multi': False, 'name': 'domaine_messagerie_etab', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u"Nom de domaine de la messagerie de l'\xe9tablissement (ex : monetab.ac-aca.fr)", 'properties': ('mandatory', 'basic'), 'callback': eosfunc.auto_copy_val, 'callback_params': Params(args=(ParamOption(option_139789497890752, False),), kwargs={})})
    option_139789497445920.impl_set_information("separator", (u"Serveur d'envoi/r\xe9ception (SMTP)", None))
    option_139789497445920.impl_set_information("help", u"""Nom de domaine de la messagerie de l’établissement, un domaine
            privé est automatiquement créé avec le préfixe « i- » si \"exim_mail_type\" est à \"satellite\".""")
    option_139789497462864 = UnicodeOption(**{'multi': False, 'name': 'system_mail_to', 'doc': u'Adresse \xe9lectronique recevant les courriers \xe9lectroniques \xe0 destination du compte root', 'properties': ('basic',), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamValue("admin@"), ParamOption(option_139789497445920, False)), kwargs={})})
    option_139789497462864.impl_set_information("help", u"""Adresse utilisée pour la réception des courriers électroniques à l'attention de l'utilisateur root""")
    option_139789497463136 = EmailOption(**{'multi': True, 'name': 'ag_mail_dest', 'doc': u"Adresse mail d'alerte", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamOption(option_139789497462864, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497445648}]})
    option_139789497436112 = OptionDescription(children=[option_139789497428720, option_139789497435472, option_139789497429536, option_139789497442384, option_139789497442656, option_139789497435792, option_139789497443472, option_139789497443744, option_139789497444016, option_139789497444288, option_139789497444560, option_139789497444832, option_139789497445104, option_139789497445376, option_139789497445648, option_139789497463136], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497574000}], **{'doc': u'agr\xe9gation', 'properties': ('basic',), 'name': 'agregation'})
    option_139789497436112.impl_set_information("help", u"""Paramétrage de la répartition de charge ou de la haute disponibilité pour les sorties Internet""")
    option_139789497436112.impl_set_information("icon", None)
    option_139789497463408 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'edb_local', 'default': 'oui', 'doc': u'Le serveur par d\xe9faut est local', 'properties': ('mandatory', 'expert')})
    option_139789497463680 = UnicodeOption(**{'doc': u'Adresse du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'edb_host', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497463408}]})
    option_139789497463680.impl_set_information("help", u"""Adresse du serveur de base de données par défaut de EoleDB, cette valeur sera utilisée pour toutes les applications qui ne définiront pas elles-mêmes un serveur de base de données""")
    option_139789497463952 = IntOption(**{'doc': u'Port du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'edb_port', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497463408}]})
    option_139789497463952.impl_set_information("help", u"""Port d'écoute du serveur de base de données par défaut de EoleDB""")
    option_139789497464224 = UnicodeOption(**{'doc': u"Compte d'administration du serveur de base de donn\xe9es", 'multi': False, 'properties': ('expert',), 'name': 'edb_root', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497463408}]})
    option_139789497464224.impl_set_information("help", u"""Identifiant du compte à utiliser pour administrer la base de données par défaut de EoleDB""")
    option_139789497464496 = UnicodeOption(**{'doc': u"Fichier contenant le mot de passe associ\xe9 au compte d'administration", 'multi': False, 'properties': ('expert',), 'name': 'edb_rootpw', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497463408}]})
    option_139789497464496.impl_set_information("help", u"""Chemin du fichier contenant le mot de passe de l'administrateur de la base de données par défaut de EoleDB""")
    option_139789497464768 = UnicodeOption(**{'doc': u'Machines qui peuvent utiliser le serveur de BDD', 'multi': True, 'properties': ('expert',), 'name': 'edb_allow_hosts', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497463408}]})
    option_139789497464768.impl_set_information("help", u"""Adresses IP avec lesquelles les utilisateurs de la base de données sont susceptibles de se connecter""")
    option_139789497436432 = OptionDescription(children=[option_139789497463408, option_139789497463680, option_139789497463952, option_139789497464224, option_139789497464496, option_139789497464768], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955200}], **{'doc': u'EoleDB', 'properties': ('expert',), 'name': 'eoledb'})
    option_139789497436432.impl_set_information("help", u"""Outil de gestion automatique des bases de données, simple et pratique""")
    option_139789497436432.impl_set_information("icon", u"""database""")
    option_139789497465040 = ChoiceOption(**{'multi': False, 'values': (u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'10', u'11', u'12'), 'name': 'smb_min_password_length', 'default': u'5', 'doc': u'Longueur minimale des mots de passe', 'properties': ('mandatory', 'normal')})
    option_139789497465040.impl_set_information("separator", ('Politique de mot de passe pour les utilisateurs LDAP', None))
    option_139789497465584 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4'), 'name': 'smb_min_password_class', 'default': u'2', 'doc': u'Nombre minimum de classes de caract\xe8res', 'properties': ('mandatory', 'normal')})
    option_139789497465584.impl_set_information("help", u"""Les classes de caractères sont : chiffres, lettres minuscules, lettres majuscules, et autres caractères""")
    option_139789497436752 = OptionDescription(children=[option_139789497465040, option_139789497465584], **{'doc': u'Mots de passe', 'properties': ('basic',), 'name': 'mots_de_passe'})
    option_139789497436752.impl_set_information("help", u"""Politique générale pour les utilisateurs des applications web et de Samba""")
    option_139789497436752.impl_set_information("icon", u"""keyboard""")
    option_139789497465312 = IntOption(**{'default': 10, 'doc': u'Taille maximum pour un fichier \xe0 scanner (en Mo)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_file_size'})
    option_139789497465312.impl_set_information("separator", ('ClamAV', None))
    option_139789497465856 = IntOption(**{'default': 50, 'doc': u'Quantit\xe9 de donn\xe9es maximum \xe0 scanner pour une archive (en Mo)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_scan_size'})
    option_139789497466128 = IntOption(**{'default': 16, 'doc': u'Profondeur maximale pour le scan des archives', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_recursion'})
    option_139789497466400 = IntOption(**{'default': 15, 'doc': u'Profondeur maximale pour le scan des r\xe9pertoires', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_directory_recursion'})
    option_139789497475152 = IntOption(**{'default': 5000, 'doc': u'Nombre maximum de fichiers \xe0 scanner dans une archive', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_files'})
    option_139789497475424 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_exit_on_oom', 'default': 'no', 'doc': u'Arr\xeater le d\xe9mon en cas de surcharge m\xe9moire', 'properties': ('mandatory', 'expert')})
    option_139789497475696 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_detect_pua', 'default': 'no', 'doc': u'D\xe9tection des applications ind\xe9sirables', 'properties': ('mandatory', 'expert')})
    option_139789497475968 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_scan_elf', 'default': 'no', 'doc': u'Scan du contenu des fichiers ELF', 'properties': ('mandatory', 'expert')})
    option_139789497475968.impl_set_information("help", u"""ELF (Executable and Linkable Format) est un format de fichier binaire utilisé pour l'enregistrement de code compilé""")
    option_139789497476240 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_scan_pdf', 'default': 'yes', 'doc': u'Scan du contenu des fichiers PDF', 'properties': ('mandatory', 'expert')})
    option_139789497476512 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_clamav', 'default': 'oui', 'doc': u"Activer l'anti-virus sur la messagerie", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}]})
    option_139789497476512.impl_set_information("help", u"""Gestion de l'antivirus sur la messagerie""")
    option_139789497476784 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_scan_mail', 'default': 'no', 'doc': u'Scan des fichiers courriels', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497476512}]})
    option_139789497477056 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'clam_broken_exe', 'default': 'no', 'doc': u'D\xe9tection des fichiers ex\xe9cutables corrompus', 'properties': ('mandatory', 'expert')})
    option_139789497477328 = DomainnameOption(**{'multi': False, 'name': 'clam_dns_database_info', 'allow_without_dot': True, 'default': u'current.cvd.clamav.net', 'doc': u'Nom de domaine du serveur DNS de mise \xe0 jour', 'type_': 'domainname', 'allow_ip': True, 'properties': ('mandatory', 'expert')})
    option_139789497477328.impl_set_information("separator", ('Freshclam', None))
    option_139789497477600 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'clam_forcer_mirror_database', 'default': 'non', 'doc': u'Forcer un serveur de mise \xe0 jour freshclam', 'properties': ('mandatory', 'expert')})
    option_139789497477872 = DomainnameOption(**{'multi': True, 'name': 'clam_mirror_database', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom de domaine du serveur de mise \xe0 jour', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497477600}]})
    option_139789497478144 = DomainnameOption(**{'multi': False, 'name': 'clam_iana', 'default': u'fr', 'allow_ip': False, 'type_': 'hostname', 'doc': u'Code IANA pour la mise \xe0 jour de la base de signature', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497477600}]})
    option_139789497478416 = IntOption(**{'default': 5, 'doc': u'Nombre de tentatives de mise \xe0 jour par miroir', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_max_attempts'})
    option_139789497478688 = IntOption(**{'default': 24, 'doc': u'Nombre de mises \xe0 jour quotidiennes', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'clam_checks'})
    option_139789497483344 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'clam_forcer_daemon', 'default': 'non', 'doc': u"Forcer l'activation du d\xe9mon clam sur le serveur", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789497483344.impl_set_information("separator", ('Services utilisant ClamAV', None))
    option_139789497483344.impl_set_information("help", u"""Permet d'activer le service ClamAV même s'il n'y a pas de scan temps réel activé""")
    option_139789497483616 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_vscan', 'default': 'non', 'doc': u"Activer l'anti-virus temps r\xe9el sur SMB", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497483888 = IntOption(**{'multi': False, 'name': 'clam_purge', 'default': 20, 'doc': u'Dur\xe9e de conservation des fichiers en quarantaine (en jours)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497483616}]})
    option_139789497484160 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dansguardian_clam', 'default': 'non', 'doc': u"Activer l'anti-virus sur le proxy", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789497484432 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ftp_scan', 'default': 'oui', 'doc': u"Activer l'anti-virus temps r\xe9el sur FTP", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}]})
    option_139789497437072 = OptionDescription(children=[option_139789497465312, option_139789497465856, option_139789497466128, option_139789497466400, option_139789497475152, option_139789497475424, option_139789497475696, option_139789497475968, option_139789497476240, option_139789497476784, option_139789497477056, option_139789497477328, option_139789497477600, option_139789497477872, option_139789497478144, option_139789497478416, option_139789497478688, option_139789497483344, option_139789497483616, option_139789497483888, option_139789497484160, option_139789497484432, option_139789497476512], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}], **{'doc': u'clamav', 'properties': ('basic',), 'name': 'clamav'})
    option_139789497437072.impl_set_information("icon", u"""shield""")
    option_139789497484704 = DomainnameOption(**{'multi': False, 'name': 'adresse_ip_ldap', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Adresse IP ou nom DNS du serveur LDAP', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("local"),), kwargs={'condition_1': ParamOption(option_139789497955744, False), 'default_mismatch': ParamValue("None"), 'match': ParamOption(option_139789497852256, False)}), "requires": [{'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}]})
    option_139789497484704.impl_set_information("help", u"""Nom de domaine ou l'adresse IP de l'annuaire distant""")
    option_139789497484976 = UnicodeOption(**{'multi': False, 'name': 'ldap_base_dn', 'default': u'o=gouv,c=fr', 'doc': u"Base DN de l'annuaire", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^o=|^dc=|^ou="),), kwargs={'err_msg': ParamValue(u"La racine doit débuter par une organisation (o=), une composante du domaine (dc=) ou une unité organisationnelle (ou=)")})})
    option_139789497485248 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ldap_tls', 'default': 'non', 'doc': u'Activer le support de TLS', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}]})
    option_139789497485520 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ldap_nss', 'default': 'oui', 'doc': u'Ajouter les utilisateurs LDAP aux utilisateurs locaux', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}]})
    option_139789497485792 = PortOption(**{'multi': False, 'name': 'ldap_port', 'allow_private': True, 'default': 389, 'doc': u'Port du serveur LDAP', 'properties': ('mandatory', 'normal')})
    option_139789497486064 = UnicodeOption(**{'multi': False, 'name': 'ldap_reader', 'doc': u'Utilisateur de lecture des comptes LDAP', 'properties': ('normal',), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamValue("cn=reader,"), ParamOption(option_139789497484976, False)), kwargs={}), "requires": [{'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}]})
    option_139789497486336 = FilenameOption(**{'multi': False, 'name': 'ldap_reader_passfile', 'default': u'/root/.reader', 'doc': u"Fichier de mot de passe de l'utilisateur de lecture", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497955744}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497955744}]})
    option_139789497486608 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_admin_passfile', 'default': 'non', 'doc': u'D\xe9finir le mot de passe admin de LDAP dans un fichier', 'properties': ('mandatory', 'normal')})
    option_139789497486880 = FilenameOption(**{'default': u'/root/.writer', 'doc': u"Fichier de mot de passe de l'utilisateur admin", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_admin_passfile'})
    option_139789497507920 = UnicodeOption(**{'default': u'uid', 'doc': u'Attribut de recherche des utilisateurs', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_match_attribute'})
    option_139789497508192 = UnicodeOption(**{'default': u'objectClass=person', 'doc': u"Filtre d'utilisateurs", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_filter_user'})
    option_139789497508464 = UnicodeOption(**{'default': u'objectClass=posixGroup', 'doc': u'Filtre de groupes', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_filter_group'})
    option_139789497508736 = UnicodeOption(**{'doc': u"DN racine de l'arbre utilisateurs", 'multi': False, 'properties': ('expert',), 'name': 'ldap_dntree_user'})
    option_139789497509008 = UnicodeOption(**{'doc': u"DN racine de l'arbre groupes", 'multi': False, 'properties': ('expert',), 'name': 'ldap_dntree_group'})
    option_139789497509280 = UnicodeOption(**{'default': u'displayName', 'doc': u"Champ 'nom d'affichage' de l'utilisateur", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_fill_displayname'})
    option_139789497509552 = UnicodeOption(**{'default': u'mail', 'doc': u"Champ 'mail' de l'utilisateur", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_fill_mail'})
    option_139789497509824 = UnicodeOption(**{'default': u'maildir', 'doc': u"Champ 'maildir' de l'utilisateur", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_fill_maildir'})
    option_139789497510096 = UnicodeOption(**{'doc': u"Champ 'fonction' de l'utilisateur", 'multi': False, 'properties': ('expert',), 'name': 'ldap_fill_fonction'})
    option_139789497510368 = UnicodeOption(**{'doc': u"Champ 'categorie' de l'utilisateur", 'multi': False, 'properties': ('expert',), 'name': 'ldap_fill_categorie'})
    option_139789497510640 = UnicodeOption(**{'doc': u"Champ 'rne' de l'utilisateur", 'multi': False, 'properties': ('expert',), 'name': 'ldap_fill_rne'})
    option_139789497510912 = UnicodeOption(**{'doc': u"Champ 'fredurne' de l'utilisateur", 'multi': False, 'properties': ('expert',), 'name': 'ldap_fill_fredurne'})
    option_139789497511184 = UnicodeOption(**{'default': u'cn', 'doc': u"Champ 'nom d'affichage' du groupe", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_fill_displaygroup'})
    option_139789497437392 = OptionDescription(children=[option_139789497484704, option_139789497484976, option_139789497485248, option_139789497485520, option_139789497485792, option_139789497486064, option_139789497486336, option_139789497486608, option_139789497486880, option_139789497507920, option_139789497508192, option_139789497508464, option_139789497508736, option_139789497509008, option_139789497509280, option_139789497509552, option_139789497509824, option_139789497510096, option_139789497510368, option_139789497510640, option_139789497510912, option_139789497511184], **{'doc': u'annuaire', 'properties': ('basic',), 'name': 'annuaire'})
    option_139789497437392.impl_set_information("help", u"""Configuration générale de l'annuaire""")
    option_139789497437392.impl_set_information("icon", u"""book""")
    option_139789497511456 = DomainnameOption(**{'type_': 'domainname', 'name': 'global_nom_domaine_dhcp', 'doc': u'Nom de domaine \xe0 renvoyer aux clients DHCP', 'allow_ip': False, 'multi': False, 'properties': ('expert',)})
    option_139789497511456.impl_set_information("separator", (u'Param\xe8tres globaux (peuvent \xeatre surcharg\xe9s pour un r\xe9seau sp\xe9cifique)', None))
    option_139789497511456.impl_set_information("help", u"""Nom de domaine à renvoyer aux clients DHCP""")
    option_139789497516112 = IPOption(**{'doc': u'Adresse IP du DNS \xe0 renvoyer aux clients DHCP', 'multi': False, 'allow_reserved': True, 'properties': ('expert',), 'name': 'global_adresse_ip_dns_dhcp'})
    option_139789497516112.impl_set_information("help", u"""Adresse IP du DNS à renvoyer aux clients DHCP""")
    option_139789497516384 = IPOption(**{'doc': u'Adresse IP du DNS secondaire \xe0 renvoyer aux clients DHCP', 'multi': False, 'allow_reserved': True, 'properties': ('expert',), 'name': 'global_adresse_ip_dns_secondaire_dhcp'})
    option_139789497516656 = IPOption(**{'doc': u'Adresse IP du serveur primaire Wins \xe0 renvoyer aux clients', 'multi': False, 'allow_reserved': True, 'properties': ('expert',), 'name': 'global_adresse_ip_wins_primaire_dhcp'})
    option_139789497516656.impl_set_information("help", u"""Adresse IP du serveur primaire WINS à renvoyer aux clients DHCP""")
    option_139789497516928 = IPOption(**{'doc': u'Adresse IP du serveurs secondaire Wins \xe0 renvoyer aux clients', 'multi': False, 'allow_reserved': True, 'properties': ('expert',), 'name': 'global_adresse_ip_wins_secondaire_dhcp'})
    option_139789497516928.impl_set_information("help", u"""Adresse IP du serveur secondaire WINS à renvoyer aux clients DHCP""")
    option_139789497517200 = IPOption(**{'doc': u'Adresse IP du serveur NTP \xe0 renvoyer aux clients', 'multi': False, 'allow_reserved': True, 'properties': ('expert',), 'name': 'global_adresse_ip_ntp_dhcp'})
    option_139789497517200.impl_set_information("help", u"""Adresse IP du serveur NTP à renvoyer aux clients DHCP""")
    option_139789497517472 = IntOption(**{'default': 36000, 'doc': u'Temps du bail par d\xe9faut (sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'global_dhcp_lease_default'})
    option_139789497517472.impl_set_information("help", u"""Temps du bail par défaut, en secondes, offert à un client n'ayant pas fait la demande d'une durée spécifique""")
    option_139789497517744 = IntOption(**{'default': 144000, 'doc': u'Temps maximum du bail (sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'global_dhcp_lease_max'})
    option_139789497517744.impl_set_information("help", u"""Temps du bail maximal, en secondes, accordé à un client ayant fait la demande d'une durée spécifique""")
    option_139789497518016 = DomainnameOption(**{'multi': False, 'name': 'global_domain_wpad_dhcp', 'allow_ip': False, 'type_': 'domainname', 'doc': u'Nom de domaine du serveur WPAD', 'properties': ('expert',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'default_match': ParamValue("None"), 'condition_1': ParamOption(option_139789497972128, False), 'default_mismatch': ParamValue("None"), 'mismatch': ParamOption(option_139789497890752, False)})})
    option_139789497518016.impl_set_information("help", u"""Nom de domaine du serveur WPAD à renvoyer aux clients du sous-réseau""")
    option_139789497518288 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_dhcp_failover', 'default': 'non', 'doc': u'Activer la continuit\xe9 de service', 'properties': ('mandatory', 'normal')})
    option_139789497518288.impl_set_information("separator", (u'Configurer la continuit\xe9 de service', None))
    option_139789497518288.impl_set_information("help", u"""Affiche les paramètres pour la configuration de la continuité de service (failover) de DHCP.""")
    option_139789497518560 = UnicodeOption(**{'doc': u'Nom de la grappe', 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'dhcp_failover_name', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497518560.impl_set_information("help", u"""Nom utilisé pour identifier une configuration de continuité de service et l’associer aux pools d’adresses.""")
    option_139789497518832 = ChoiceOption(**{'multi': False, 'values': (u'primary', u'secondary'), 'name': 'dhcp_failover_rank', 'default': u'primary', 'doc': u'Rang du serveur dans la grappe', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497518832.impl_set_information("help", u"""Rôle joué par le serveur dans le mécanisme de continuité de service (primaire ou secondaire).""")
    option_139789497519104 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'dhcp_failover_local_address', 'doc': u'Adresse IP du serveur DHCP local, en \xe9coute du serveur pair', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497519104.impl_set_information("help", u"""Adresse IP du serveur local failover, en écoute du serveur pair.""")
    option_139789497519376 = IntOption(**{'multi': False, 'name': 'dhcp_failover_port', 'doc': u'Port de communication du serveur DHCP local, en \xe9coute du serveur pair', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("primary"),), kwargs={'mismatch': ParamValue(847), 'condition_1': ParamOption(option_139789497518832, False), 'match': ParamValue(647)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497519376.impl_set_information("help", u"""Port utilisé pour recevoir les informations du serveur pair.""")
    option_139789497519648 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'dhcp_failover_peer_address', 'doc': u'Adresse IP du serveur pair', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497519648.impl_set_information("help", u"""Adresse IP du serveur pair.""")
    option_139789497008208 = IntOption(**{'multi': False, 'name': 'dhcp_failover_peer_port', 'doc': u'Port de communication du serveur pair', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("secondary"),), kwargs={'mismatch': ParamValue(847), 'condition_1': ParamOption(option_139789497518832, False), 'match': ParamValue(647)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497008208.impl_set_information("help", u"""Port utilisé pour contacter le serveur pair (peut être identique au port d’écoute du service hébergé).""")
    option_139789497008480 = IntOption(**{'multi': False, 'name': 'dhcp_failover_response_delay', 'default': 60, 'doc': u'D\xe9lai maximal de r\xe9ponse', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497008480.impl_set_information("help", u"""Seuil de temps (en secondes) à partir duquel un serveur pair ne répondant pas aux requêtes est supposé défaillant.""")
    option_139789497008752 = IntOption(**{'multi': False, 'name': 'dhcp_failover_unacked_updates', 'default': 10, 'doc': u'Nombre de messages BNDUPD', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497008752.impl_set_information("help", u"""Nombre limite de messages BNDUPD sans réponse BNDACK tolérés.""")
    option_139789497009024 = IntOption(**{'multi': False, 'name': 'dhcp_failover_balance_seconds', 'default': 5, 'doc': u'D\xe9lai avant passage de t\xe9moin', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789497009024.impl_set_information("help", u"""Temps limite (en secondes) après lequel un pair prend le pas sur l’autre si ce dernier ne répond plus aux requêtes des clients mais seulement aux messages d’appairage (outrepassement des paramètres de répartition de charge).""")
    option_139789497009296 = IntOption(**{'multi': False, 'name': 'dhcp_failover_mclt', 'default': 3600, 'doc': u'Temps maximum de d\xe9l\xe9gation', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'secondary', 'action': 'disabled', 'inverse': False, "option": option_139789497518832}]})
    option_139789497009296.impl_set_information("help", u"""Durée maximale (en secondes) pendant laquelle un serveur pair peut renouveler un bail sans concertation avec l’autre serveur (Maximum Client Lead Time).""")
    option_139789497009568 = IntOption(**{'multi': False, 'name': 'dhcp_failover_split', 'default': 128, 'doc': u'Seuil de prise en charge par le serveur primaire', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'secondary', 'action': 'disabled', 'inverse': False, "option": option_139789497518832}]})
    option_139789497009568.impl_set_information("help", u"""Valeur comprise entre 0 et 256 inclus faisant office de seuil et permettant d’associer les requêtes à l’un ou à l’autre serveur  pair (répartition de charge).""")
    option_139789497009840 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_omapi', 'default': 'non', 'doc': u'Activer OMAPI', 'properties': ('mandatory', 'expert')})
    option_139789497009840.impl_set_information("separator", ("Support de l'API OMAPI", None))
    option_139789497009840.impl_set_information("help", u"""Afficher les variables utilisées pour la configuration de OMAPI""")
    option_139789497010112 = IntOption(**{'multi': False, 'name': 'omapi_port', 'default': 7911, 'doc': u'Port d\u2019\xe9coute pour OMAPI', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497009840}]})
    option_139789497010112.impl_set_information("help", u"""Port à ouvrir et à utiliser pour OMAPI""")
    option_139789497010384 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'omapi_secret', 'doc': u'Secret partag\xe9 pour OMAPI', 'properties': ('force_store_value', 'basic'), 'callback': eosfunc.gen_random, "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497009840}]})
    option_139789497010384.impl_set_information("help", u"""Clé secrète partagée à utiliser dans la configuration des différents serveurs utilisant OMAPI""")
    option_139789497010656 = NetworkOption(**{'multi': True, 'name': 'adresse_network_dhcp', 'doc': u'Adresse r\xe9seau de la plage DHCP', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497604576, False)})})
    option_139789497010656.impl_set_information("separator", (u'D\xe9finition des sous-r\xe9seaux', None))
    option_139789497010656.impl_set_information("help", u"""Adresse réseau du sous-réseau""")
    option_139789497010928 = NetmaskOption(**{'multi': True, 'name': 'adresse_netmask_dhcp', 'doc': u'Masque de sous-r\xe9seau de la plage DHCP', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497604304, False)})})
    option_139789497010928.impl_set_information("help", u"""Masque de sous-réseau""")
    option_139789497011200 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_plage_dhcp', 'doc': u'Nom de la plage DHCP', 'allow_ip': False, 'multi': True, 'properties': ('mandatory', 'basic'), "validator": eosfunc.check_name_uniq})
    option_139789497011200.impl_set_information("help", u"""Nom permettant d'identifier facilement la plage DHCP, notamment dans l'interface d'administration""")
    option_139789497011472 = IPOption(**{'doc': u'IP basse de la plage DHCP', 'multi': True, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_basse_dhcp'})
    option_139789497011472.impl_set_information("help", u"""IP basse de la plage d'adresses attribuées dynamiquement pour le sous-réseau""")
    option_139789497011472.impl_add_consistency("in_network", option_139789497010656, option_139789497010928, **{})
    option_139789497011744 = IPOption(**{'doc': u'IP haute de la plage DHCP', 'multi': True, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'ip_haute_dhcp'})
    option_139789497011744.impl_set_information("help", u"""IP haute de la plage d'adresses attribuées dynamiquement pour le sous-réseau""")
    option_139789497011744.impl_add_consistency("in_network", option_139789497010656, option_139789497010928, **{})
    option_139789497024592 = DomainnameOption(**{'multi': True, 'name': 'nom_domaine_dhcp', 'allow_ip': False, 'type_': 'domainname', 'doc': u'Nom de domaine \xe0 renvoyer aux clients DHCP', 'properties': ('basic',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497890752, False)})})
    option_139789497024592.impl_set_information("help", u"""Nom de domaine à renvoyer aux clients DHCP du sous-réseau""")
    option_139789497024864 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_ip_gw_dhcp', 'doc': u'Adresse IP du routeur \xe0 renvoyer aux clients DHCP', 'properties': ('basic',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497604032, False)})})
    option_139789497024864.impl_set_information("help", u"""Adresse IP du routeur à renvoyer aux clients DHCP du sous-réseau""")
    option_139789497025136 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_ip_dns_dhcp', 'doc': u'Adresse IP du DNS \xe0 renvoyer aux clients DHCP', 'properties': ('basic',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497675024, False)})})
    option_139789497025136.impl_set_information("help", u"""Adresse IP du DNS à renvoyer aux clients DHCP du sous-réseau""")
    option_139789497025408 = IPOption(**{'doc': u'Adresse IP du DNS secondaire \xe0 renvoyer aux clients DHCP', 'multi': True, 'allow_reserved': True, 'properties': ('expert',), 'name': 'adresse_ip_dns_secondaire_dhcp'})
    option_139789497025408.impl_set_information("help", u"""Adresse IP d'un serveur DNS secondaire à renvoyer aux clients DHCP du sous-réseau""")
    option_139789497025680 = IPOption(**{'doc': u'Adresse IP du serveur primaire Wins \xe0 renvoyer aux clients', 'multi': True, 'allow_reserved': True, 'properties': ('expert',), 'name': 'adresse_ip_wins_primaire_dhcp'})
    option_139789497025680.impl_set_information("help", u"""Adresse IP du serveur primaire WINS à renvoyer aux clients du sous-réseau""")
    option_139789497025952 = IPOption(**{'doc': u'Adresse IP du serveur secondaire Wins \xe0 renvoyer aux clients', 'multi': True, 'allow_reserved': True, 'properties': ('expert',), 'name': 'adresse_ip_wins_secondaire_dhcp'})
    option_139789497025952.impl_set_information("help", u"""Adresse IP du serveur secondaire WINS à renvoyer aux clients du sous-réseau""")
    option_139789497026224 = IPOption(**{'doc': u'Adresse IP du serveur NTP \xe0 renvoyer aux clients', 'multi': True, 'allow_reserved': True, 'properties': ('expert',), 'name': 'adresse_ip_ntp_dhcp'})
    option_139789497026224.impl_set_information("help", u"""Adresse IP du serveur NTP à renvoyer aux clients du sous-réseau""")
    option_139789497026496 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'dhcp_pool_use_failover', 'doc': u'Utiliser la configuration de continuit\xe9 de service pour ce pool', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789497518288, False),), kwargs={})})
    option_139789497026768 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'interdire_hotes_inconnus', 'default_multi': 'non', 'doc': u'Interdire cette zone aux h\xf4tes inconnus', 'properties': ('mandatory', 'expert')})
    option_139789497026768.impl_set_information("help", u"""Le serveur attribuera des adresses uniquement aux stations déclarées""")
    option_139789497027040 = IntOption(**{'doc': u'Temps du bail par d\xe9faut (sec)', 'multi': True, 'properties': ('expert',), 'name': 'dhcp_lease_default'})
    option_139789497027040.impl_set_information("help", u"""Temps du bail par défaut, en secondes, offert à un client du sous-réseau n'ayant pas fait la demande d'une durée spécifique""")
    option_139789497027312 = IntOption(**{'doc': u'Temps maximum du bail (sec)', 'multi': True, 'properties': ('expert',), 'name': 'dhcp_lease_max'})
    option_139789497027312.impl_set_information("help", u"""Temps du bail maximal, en secondes, accordé à un client du sous-réseau ayant fait la demande d'une durée spécifique""")
    option_139789497437712 = MasterSlaves(children=[option_139789497010656, option_139789497010928, option_139789497011200, option_139789497011472, option_139789497011744, option_139789497024592, option_139789497024864, option_139789497025136, option_139789497025408, option_139789497025680, option_139789497025952, option_139789497026224, option_139789497026496, option_139789497026768, option_139789497027040, option_139789497027312], **{'doc': u'Adresse r\xe9seau de la plage DHCP', 'properties': ('basic',), 'name': 'adresse_network_dhcp'})
    option_139789497036880 = OptionDescription(children=[option_139789497511456, option_139789497516112, option_139789497516384, option_139789497516656, option_139789497516928, option_139789497517200, option_139789497517472, option_139789497517744, option_139789497518016, option_139789497518288, option_139789497518560, option_139789497518832, option_139789497519104, option_139789497519376, option_139789497519648, option_139789497008208, option_139789497008480, option_139789497008752, option_139789497009024, option_139789497009296, option_139789497009568, option_139789497009840, option_139789497010112, option_139789497010384, option_139789497437712], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956016}], **{'doc': u'dhcp', 'properties': ('basic',), 'name': 'dhcp'})
    option_139789497036880.impl_set_information("help", u"""Paramétrage du serveur DHCP local""")
    option_139789497036880.impl_set_information("icon", u"""bolt""")
    option_139789497027584 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_tftp', 'doc': u'Adresse IP du serveur PXE/TFTP', 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497693056, False)})})
    option_139789497027856 = FilenameOption(**{'default': u'/var/lib/tftpboot/', 'doc': u'R\xe9pertoire sur le serveur PXE/TFTP', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'repertoire_tftp'})
    option_139789497028128 = FilenameOption(**{'multi': False, 'name': 'chemin_fichier_pxe', 'default': u'/pxelinux.0', 'doc': u'Chemin vers le fichier de boot PXE initial', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956016}]})
    option_139789497037200 = OptionDescription(children=[option_139789497027584, option_139789497027856, option_139789497028128], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956288}], **{'doc': u'tftp', 'properties': ('basic',), 'name': 'tftp'})
    option_139789497037200.impl_set_information("help", u"""Configuration du serveur TFTP""")
    option_139789497037200.impl_set_information("icon", u"""cloud""")
    option_139789497045072 = ChoiceOption(**{'multi': True, 'values': (u'all', u'1', u'2', u'3', u'4'), 'name': 'dhcrelay_interfaces', 'default': [u'all'], 'doc': u"Num\xe9ro de l'interface derri\xe8re laquelle sont les clients DHCP", 'properties': ('mandatory', 'normal')})
    option_139789497045072.impl_set_information("help", u"""'all' relaiera les reqêtes DHCP depuis toutes les interfaces vers le serveur DHCP""")
    option_139789497045616 = IntOption(**{'doc': u'Num\xe9ro de VLAN des clients DHCP', 'multi': True, 'properties': ('normal',), 'name': 'dhcrelay_vlan'})
    option_139789497037520 = MasterSlaves(children=[option_139789497045072, option_139789497045616], **{'doc': u"Num\xe9ro de l'interface derri\xe8re laquelle sont les clients DHCP", 'properties': ('normal',), 'name': 'dhcrelay_interfaces'})
    option_139789497045344 = ChoiceOption(**{'multi': False, 'values': (u'1', u'2', u'3', u'4'), 'name': 'dhcrelay_server_interface', 'default': u'1', 'doc': u"Num\xe9ro de l'interface derri\xe8re laquelle est le serveur DHCP", 'properties': ('mandatory', 'basic')})
    option_139789497045344.impl_set_information("help", u"""Numéro de l'interface vers où relayer les requêtes DHCP""")
    option_139789497045888 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_dhcp_dhcrelay', 'doc': u'Adresse IP du serveur DHCP \xe0 relayer', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789497983600, True),), kwargs={})})
    option_139789497037840 = OptionDescription(children=[option_139789497037520, option_139789497045344, option_139789497045888], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956560}], **{'doc': u'relai dhcp', 'properties': ('basic',), 'name': 'relai_dhcp'})
    option_139789497037840.impl_set_information("help", u"""Paramétrage du relai DHCP""")
    option_139789497037840.impl_set_information("icon", u"""forward""")
    option_139789497046160 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'esu_proxy', 'default': 'oui', 'doc': u'Activer le param\xe9trage du proxy dans ESU', 'properties': ('mandatory', 'normal')})
    option_139789497046432 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'esu_proxy_default', 'default': 'oui', 'doc': u'Activer le proxy ESU dans les mod\xe8les par d\xe9faut', 'properties': ('auto_freeze', 'mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497046160}]})
    option_139789497046704 = DomainnameOption(**{'multi': False, 'name': 'esu_proxy_server', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Adresse du proxy par d\xe9faut dans ESU', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497675024, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497046160}]})
    option_139789497046976 = PortOption(**{'multi': False, 'name': 'esu_proxy_port', 'allow_private': True, 'default': 3128, 'doc': u'Port du proxy par d\xe9faut dans ESU', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497046160}]})
    option_139789497047248 = UnicodeOption(**{'multi': False, 'name': 'tmp_esu_proxy_bypass', 'doc': u'Valeur temporaire pour le calcul de esu_proxy_bypass', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_classe, 'callback_params': Params(args=(ParamOption(option_139789497604304, False),), kwargs={})})
    option_139789497047520 = UnicodeOption(**{'multi': False, 'name': 'tmp_esu_proxy_bypass2', 'doc': u'Valeur temporaire pour le calcul de esu_proxy_bypass2', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.concat, 'callback_params': Params(args=None, kwargs={'valeur2': ParamValue("/"), 'valeur3': ParamOption(option_139789497047248, False), 'valeur1': ParamOption(option_139789497604576, False)})})
    option_139789497047792 = UnicodeOption(**{'multi': True, 'name': 'esu_proxy_bypass', 'doc': u'Site accessible sans proxy dans ESU', 'properties': ('normal',), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamValue("127.0.0.1"), ParamOption(option_139789497047520, False)), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497046160}]})
    option_139789497047792.impl_set_information("help", u"""Liste des sites qui sont accessibles sans passer par le proxy""")
    option_139789497038160 = OptionDescription(children=[option_139789497046160, option_139789497046432, option_139789497046704, option_139789497046976, option_139789497047792, option_139789497047248, option_139789497047520], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956832}], **{'doc': u'esu', 'properties': ('basic',), 'name': 'esu'})
    option_139789497038160.impl_set_information("help", u"""Configuration du proxy ESU""")
    option_139789497038160.impl_set_information("icon", u"""windows""")
    option_139789497048064 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_winbind', 'default': 'non', 'doc': u'Activer winbind', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497048336 = UnicodeOption(**{'doc': u'Suffixe de machine LDAP', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'smb_ldap_machine_suffix'})
    option_139789497048608 = UnicodeOption(**{'doc': u'Suffixe de groupe LDAP', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'smb_ldap_group_suffix'})
    option_139789497053264 = IntOption(**{'default': 0, 'doc': u'\xc2ge maximal par d\xe9faut des mots de passe', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_ldap_max_pwd_age'})
    option_139789497053264.impl_set_information("help", u"""Définit la durée en jours avant expiration d’un mot de
            passe. Cette durée est compté à partir de la date
            d’enregistrement du mot de passe.""")
    option_139789497053536 = IntOption(**{'default': 120, 'doc': u'Dur\xe9e du cache des r\xe9sultats de requ\xeates n\xe9gatifs', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_idmap_negative_cache_time'})
    option_139789497053536.impl_set_information("help", u"""Durée exprimée en secondes (une valeur de 1 désactive le cache)""")
    option_139789497053808 = IntOption(**{'doc': u'LDAP replication sleep', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'smb_ldap_replication_sleep'})
    option_139789497054080 = IntOption(**{'doc': u"Nombre d'entr\xe9es par page dans une requ\xeate LDAP", 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'smb_ldap_page_size'})
    option_139789497054352 = IntOption(**{'doc': u'D\xe9lai avant abandon pour la connexion au LDAP', 'multi': False, 'properties': ('expert',), 'name': 'smb_ldap_connection_timeout'})
    option_139789497054624 = UnicodeOption(**{'multi': False, 'name': 'smb_ldap_suffix', 'doc': u"Base DN de l'annuaire utilis\xe9 par Samba", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497484976, False)})})
    option_139789497054896 = UnicodeOption(**{'default': u'cn=admin,o=gouv,c=fr', 'doc': u"Nom de l'administrateur du domaine LDAP", 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'smb_ldap_admin_dn'})
    option_139789497055168 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ead_support_multietab', 'default': 'non', 'doc': u'Support du multi-\xe9tablissement', 'properties': ('mandatory', 'normal')})
    option_139789497055168.impl_set_information("help", u"""Le mode multi-établissement permet de gérer plusieurs établissements au sein d'un seul module EOLE""")
    option_139789497055440 = UnicodeOption(**{'default': u'standard', 'doc': u'Mod\xe8le de partage par d\xe9faut', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'smb_share_model'})
    option_139789497055440.impl_set_information("proposed_value", (u'commun', u'devoirs', u'groupes', u'icones$', u'minedu', u'professeurs', u'standard'))
    option_139789497055712 = UnicodeOption(**{'default': u'\\\\%N\\%U', 'doc': u"R\xe9pertoire home distant de l'utilisateur", 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert'), 'name': 'smb_logon_home'})
    option_139789497055984 = UnicodeOption(**{'default': u'%U%a.bat', 'doc': u'Nom du script de logon', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert'), 'name': 'smb_logon_script'})
    option_139789497056256 = DomainnameOption(**{'type_': 'netbios', 'name': 'smb_workgroup', 'doc': u'Nom du domaine Samba (ex: mondomaine)', 'multi': False, 'warnings_only': True, 'properties': ('auto_freeze', 'mandatory', 'basic')})
    option_139789497056256.impl_set_information("help", u"""Nom du domaine (workgroup) Samba""")
    option_139789497056256.impl_add_consistency("not_equal", option_139789497890480, **{})
    option_139789497056528 = UnicodeOption(**{'default': u'445 139', 'doc': u'Ports sur lesquels Samba accepte les connexions', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_ports'})
    option_139789497056800 = UnicodeOption(**{'multi': False, 'name': 'smb_server_string', 'doc': u'Libell\xe9 du serveur Samba', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497889936, False)})})
    option_139789497061456 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_trash', 'default': 'non', 'doc': u'Activer la corbeille Samba', 'properties': ('mandatory', 'expert')})
    option_139789497061728 = FilenameOption(**{'multi': False, 'name': 'smb_trash_dir', 'default': u'perso/.corbeille', 'doc': u'Nom du r\xe9pertoire corbeille', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497061456}]})
    option_139789497062000 = IntOption(**{'multi': False, 'name': 'smb_trash_purge', 'default': 8, 'doc': u'Dur\xe9e de conservation des fichiers dans la corbeille (en jours)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497061456}]})
    option_139789497062272 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_quotawarn', 'default': 'non', 'doc': u"Activer l'envoi de courriel en cas de d\xe9passement des quotas", 'properties': ('mandatory', 'expert')})
    option_139789497062544 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_guest', 'default': 'oui', 'doc': u'Activer le mode invit\xe9 sur le partage', 'properties': ('mandatory', 'expert')})
    option_139789497062816 = IntOption(**{'default': 0, 'doc': u'Niveau de log', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_log_level'})
    option_139789497063088 = IntOption(**{'default': 15, 'doc': u"Nombre de minutes d'inactivit\xe9 avant d\xe9connexion automatique d'acc\xe8s \xe0 un fichier", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_deadtime'})
    option_139789497063360 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_activer_hide_files', 'default': 'oui', 'doc': u'Activer le masquage de fichiers', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497063632 = UnicodeOption(**{'multi': False, 'name': 'smb_hide_files', 'default': u'/desktop.ini/', 'doc': u'Fichiers \xe0 masquer dans le partage', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497063360}]})
    option_139789497063904 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_wins_support', 'default': 'yes', 'doc': u'D\xe9marrer le serveur Wins', 'properties': ('mandatory', 'expert')})
    option_139789497064176 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'smb_wins_server', 'doc': u'Serveur WINS distant', 'properties': ('normal',), "requires": [{'expected': u'yes', 'action': 'disabled', 'inverse': False, "option": option_139789497063904}]})
    option_139789497064448 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_dns_proxy', 'default': 'no', 'doc': u"Rechercher des noms d'h\xf4te dans le DNS", 'properties': ('mandatory', 'expert')})
    option_139789497064720 = UnicodeOption(**{'default': u'wins hosts bcast lmhosts', 'doc': u"Ordre de r\xe9solution de noms d'h\xf4te", 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'name': 'smb_name_resolve_order'})
    option_139789497064720.impl_set_information("proposed_value", (u'wins hosts bcast lmhosts', u'bcast wins hosts lmhosts', u'wins bcast hosts lmhosts'))
    option_139789497064992 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_oplocks', 'default': 'no', 'doc': u'Activer les verrous opportunistes (oplocks)', 'properties': ('mandatory', 'expert')})
    option_139789497069648 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_dos_attributes', 'default': 'no', 'doc': u'Activer le support des attributs DOS', 'properties': ('mandatory', 'expert')})
    option_139789497069920 = IntOption(**{'default': 99, 'doc': u"Niveau de candidature lors de l'\xe9lection d'un ma\xeetre explorateur", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_os_level'})
    option_139789497070192 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_domain_master', 'default': 'yes', 'doc': u'Contr\xf4leur de domaine principal', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497070464 = UnicodeOption(**{'default': u'default', 'doc': u'Niveau de protocole maximum support\xe9 par le serveur', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'smb_max_proto'})
    option_139789497070464.impl_set_information("proposed_value", (u'NT1', u'SMB2', u'SMB3', u'default'))
    option_139789497070736 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_unixextensions', 'default': 'no', 'doc': u'Activer les extensions Unix', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497071008 = FilenameOption(**{'default': u'/var/lib/samba/printers', 'doc': u"Chemin vers les drivers d'imprimantes Windows", 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'smb_printers_drivers_path'})
    option_139789497071552 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_control_print_access_with_acl', 'default': 'non', 'doc': u"Les contr\xf4les d'acc\xe8s au partage print$ sont g\xe9r\xe9s par les ACL", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497071280 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_spoolss_x64', 'default': 'non', 'doc': u'Annoncer Spoolss comme architecture x64', 'properties': ('mandatory', 'expert')})
    option_139789497071280.impl_set_information("help", u"""Spoolss est le service d'impression de Samba""")
    option_139789497071824 = FilenameOption(**{'default': u'/home', 'doc': u'Chemin de base vers les dossiers personnels', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'name': 'home_path'})
    option_139789497072096 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'smb_activer_partages', 'default': 'non', 'doc': u'Activer des partages suppl\xe9mentaires', 'properties': ('mandatory', 'expert')})
    option_139789497072368 = UnicodeOption(**{'doc': u'Nom du partage', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'smb_partage_nom', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497072096}]})
    option_139789497072640 = FilenameOption(**{'doc': u'Nom absolu du r\xe9pertoire \xe0 partager', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'smb_partage_path', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497072096}]})
    option_139789497072912 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'smb_partage_visibilite', 'default_multi': 'non', 'doc': u'Visibilit\xe9 du partage', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497072096}]})
    option_139789497073184 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'smb_partage_ecriture', 'default_multi': 'non', 'doc': u'Partage en lecture/\xe9criture', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497072096}]})
    option_139789497038800 = MasterSlaves(children=[option_139789497072368, option_139789497072640, option_139789497072912, option_139789497073184], **{'doc': u'Nom du partage', 'properties': ('basic',), 'name': 'smb_partage_nom'})
    option_139789497081936 = UnicodeOption(**{'default_multi': u'@DomainAdmins', 'multi': True, 'name': 'smb_admin_users', 'default': [u'@DomainAdmins'], 'doc': u"Utilisateurs ayant des privil\xe8ges d'administration sur tous les partages", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497082208 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_lanman_auth', 'default': 'yes', 'doc': u'Authentification LanManager', 'properties': ('mandatory', 'expert')})
    option_139789497082480 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'smb_nt_acl_support', 'default': 'yes', 'doc': u'Support NT ACL', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497082752 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_regles_filtrage_port_source', 'default': 'non', 'doc': u"Autoriser l'ouverture de flux \xe0 partir d'un port source ", 'properties': ('mandatory', 'expert')})
    option_139789497082752.impl_set_information("separator", (u"Autoriser l'ouverture de flux \xe0 partir d'un port source", None))
    option_139789497083024 = IntOption(**{'multi': True, 'name': 'fw_rule_port', 'default': [137], 'doc': u'Port source \xe0 partir duquel les flux sont autoris\xe9s', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497082752}]})
    option_139789497083296 = ChoiceOption(**{'multi': True, 'values': (u'tcp', u'udp'), 'name': 'fw_rule_protocole', 'default_multi': u'udp', 'doc': u'Protocole udp/tcp pour lequel les flux sont autoris\xe9s', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497082752}]})
    option_139789497083568 = ChoiceOption(**{'multi': True, 'values': (u'0', u'1', u'2', u'3', u'4'), 'name': 'fw_rule_int', 'default_multi': u'0', 'doc': u'Interface sur laquelle les flux sont autoris\xe9s', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497082752}]})
    option_139789497039120 = MasterSlaves(children=[option_139789497083024, option_139789497083296, option_139789497083568], **{'doc': u'Port source \xe0 partir duquel les flux sont autoris\xe9s', 'properties': ('normal',), 'name': 'fw_rule_port'})
    option_139789497083840 = IntOption(**{'default': 128, 'doc': u"Nombre maximum d'instances inotify pour un UID r\xe9el", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'fs_inotify_max_user_instances'})
    option_139789497083840.impl_set_information("separator", (u'Param\xe8tres syst\xe8me', None))
    option_139789497084112 = IntOption(**{'default': 8192, 'doc': u'Nombre maximum de surveillants associ\xe9s \xe0 une instance inotify', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'fs_inotify_max_user_watches'})
    option_139789497084384 = IntOption(**{'default': 16384, 'doc': u"Nombre maximum d'\xe9v\xe9nements mis en file d'attente dans une instance inotify", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'fs_inotify_max_queued_events'})
    option_139789497084656 = IntOption(**{'doc': u'Nombre maximum de partage utilisateurs', 'multi': False, 'properties': ('expert',), 'name': 'smb_usershare_max_shares'})
    option_139789497084656.impl_set_information("help", u"""Nombre maximum de partages pouvant être définis par l'utilisateur""")
    option_139789497084928 = UnicodeOption(**{'doc': u'Optimisations r\xe9seau', 'multi': False, 'properties': ('expert',), 'name': 'smb_socket_options'})
    option_139789497038480 = OptionDescription(children=[option_139789497048064, option_139789497048336, option_139789497048608, option_139789497053264, option_139789497053536, option_139789497053808, option_139789497054080, option_139789497054352, option_139789497054624, option_139789497054896, option_139789497055168, option_139789497055440, option_139789497055712, option_139789497055984, option_139789497890480, option_139789497056256, option_139789497056528, option_139789497056800, option_139789497061456, option_139789497061728, option_139789497062000, option_139789497062272, option_139789497062544, option_139789497062816, option_139789497063088, option_139789497063360, option_139789497063632, option_139789497063904, option_139789497064176, option_139789497064448, option_139789497064720, option_139789497064992, option_139789497069648, option_139789497069920, option_139789497070192, option_139789497070464, option_139789497070736, option_139789497071008, option_139789497071552, option_139789497071280, option_139789497071824, option_139789497072096, option_139789497038800, option_139789497081936, option_139789497082208, option_139789497082480, option_139789497082752, option_139789497039120, option_139789497083840, option_139789497084112, option_139789497084384, option_139789497084656, option_139789497084928], **{'doc': u'samba', 'properties': ('basic',), 'name': 'samba'})
    option_139789497038480.impl_set_information("help", u"""Configuration du serveur de fichier Samba""")
    option_139789497038480.impl_set_information("icon", u"""group""")
    option_139789497085200 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'nscd_passwd_enabled_cache', 'default': 'no', 'doc': u'Activer le cache NSCD pour passwd', 'properties': ('mandatory', 'expert')})
    option_139789497085472 = IntOption(**{'default': 0, 'doc': u'Dur\xe9e de vie du cache pour les groupes inexistants', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'nscd_group_negative_time_to_live'})
    option_139789497085472.impl_set_information("help", u"""Durée de vie en secondes""")
    option_139789497094224 = ChoiceOption(**{'multi': False, 'values': (u'yes', u'no'), 'name': 'nscd_group_persistent', 'default': 'no', 'doc': u'Activer la persistance pour les groupes', 'properties': ('mandatory', 'expert')})
    option_139789497039440 = OptionDescription(children=[option_139789497085200, option_139789497085472, option_139789497094224], **{'doc': u'nscd', 'properties': ('expert',), 'name': 'nscd'})
    option_139789497039440.impl_set_information("help", u"""Paramétrage de la mise en cache des données LDAP""")
    option_139789497039440.impl_set_information("icon", u"""retweet""")
    option_139789497094496 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'nut_ups_daemon', 'default': 'oui', 'doc': u'Configuration sur un serveur ma\xeetre', 'properties': ('mandatory', 'normal')})
    option_139789497094496.impl_set_information("help", u"""Activer la gestion d'onduleur. Ce service est a activer si ce serveur est connecté à un onduleur (cable RS232 ou USB). Sinon, le service se connecte à un autre serveur NUT.""")
    option_139789497094768 = UnicodeOption(**{'doc': u"Nom de l'onduleur distant", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_foreign_name', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497095040 = DomainnameOption(**{'multi': False, 'name': 'nut_monitor_foreign_host', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u"H\xf4te g\xe9rant l'onduleur", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497095312 = UsernameOption(**{'doc': u"Utilisateur de l'h\xf4te distant", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_foreign_user', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497095584 = PasswordOption(**{'doc': u"Mot de passe de l'h\xf4te distant", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_foreign_password', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497095856 = DomainnameOption(**{'type_': 'hostname', 'name': 'nut_ups_name', 'doc': u"Nom de l'onduleur", 'allow_ip': False, 'multi': True, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497095856.impl_set_information("help", u"""Nom de l'onduleur géré par le service NUT.""")
    option_139789497096128 = UnicodeOption(**{'multi': True, 'name': 'nut_ups_driver', 'default_multi': u'usbhid-ups', 'doc': u"Pilote de communication de l'onduleur", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497096128.impl_set_information("proposed_value", (u'al175', u'apcsmart', u'apcsmart-old', u'apcupsd-ups', u'bcmxcp', u'bcmxcp_usb', u'belkin', u'belkinunv', u'bestfcom', u'bestfortress', u'bestuferrups', u'bestups', u'blazer_ser', u'blazer_usb', u'clone', u'clone-outlet', u'dummy-ups', u'etapro', u'everups', u'gamatronic', u'genericups', u'isbmex', u'ivtscd', u'liebert', u'liebert-esp2', u'masterguard', u'metasys', u'mge-shut', u'mge-utalk', u'microdowell', u'nutdrv_atcl_usb', u'nutdrv_qx', u'oldmge-shut', u'oneac', u'optiups', u'powercom', u'powerpanel', u'rhino', u'richcomm_usb', u'riello_ser', u'riello_usb', u'safenet', u'solis', u'tripplite', u'tripplite_usb', u'tripplitesu', u'upscode2', u'usbhid-ups', u'victronups'))
    option_139789497096128.impl_set_information("help", u"""Pilote de communication de l'onduleur.""")
    option_139789497096400 = UnicodeOption(**{'multi': True, 'name': 'nut_ups_port', 'default_multi': u'auto', 'doc': u"Port de communication de l'onduleur", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497096400.impl_set_information("proposed_value", (u'auto', u'/dev/ttyS0', u'/dev/ttyS1'))
    option_139789497096400.impl_set_information("help", u"""Port de communication de l'onduleur. Pour les onduleurs USB ce port doit être \"auto\".""")
    option_139789497096672 = UnicodeOption(**{'doc': u"Num\xe9ro de s\xe9rie de l'onduleur (facultatif)", 'multi': True, 'properties': ('normal',), 'name': 'nut_ups_serial', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497096672.impl_set_information("help", u"""Valeur spécifique pour le champ \"serial\" associé à l'onduleur dans /etc/ups/ups.conf""")
    option_139789497096944 = UnicodeOption(**{'doc': u"Productid de l'onduleur (facultatif)", 'multi': True, 'properties': ('normal',), 'name': 'nut_ups_productid', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497096944.impl_set_information("help", u"""Valeur spécifique pour le champ \"productid\" associé à l'onduleur dans /etc/ups/ups.conf""")
    option_139789497097216 = UnicodeOption(**{'doc': u"Upstype de l'onduleur (facultatif)", 'multi': True, 'properties': ('normal',), 'name': 'nut_ups_upstype', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497097216.impl_set_information("help", u"""Valeur spécifique pour le champ \"upstype\" associé à l'onduleur dans /etc/ups/ups.conf""")
    option_139789497039760 = MasterSlaves(children=[option_139789497095856, option_139789497096128, option_139789497096400, option_139789497096672, option_139789497096944, option_139789497097216], **{'doc': u"Nom de l'onduleur", 'properties': ('basic',), 'name': 'nut_ups_name'})
    option_139789497097488 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'nut_ups_password', 'doc': u"Mot de passe de l'administrateur local de l'onduleur", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.gen_random})
    option_139789497097760 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'nut_monitor', 'default': 'non', 'doc': u'Autoriser des esclaves distants \xe0 se connecter', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497094496}]})
    option_139789497097760.impl_set_information("separator", ('Esclaves distants', None))
    option_139789497114704 = UsernameOption(**{'doc': u"Utilisateur de surveillance de l'onduleur", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_user', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497097760}]})
    option_139789497114704.impl_set_information("help", u"""Nom d'utilisateur de surveillance de l'onduleur.""")
    option_139789497114976 = PasswordOption(**{'doc': u"Mot de passe de surveillance de l'onduleur", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_password', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497097760}]})
    option_139789497114976.impl_set_information("help", u"""Mot de passe de l'utilisateur de surveillance de l'onduleur.""")
    option_139789497115248 = NetworkOption(**{'doc': u"Adresse IP du r\xe9seau de l'esclave", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_host', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497097760}]})
    option_139789497115520 = NetmaskOption(**{'doc': u"Masque de l'IP du r\xe9seau de l'esclave", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'nut_monitor_netmask', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497097760}]})
    option_139789497115520.impl_add_consistency("network_netmask", option_139789497115248, **{})
    option_139789497040080 = MasterSlaves(children=[option_139789497114704, option_139789497114976, option_139789497115248, option_139789497115520], **{'doc': u"Utilisateur de surveillance de l'onduleur", 'properties': ('basic',), 'name': 'nut_monitor_user'})
    option_139789497040400 = OptionDescription(children=[option_139789497094496, option_139789497094768, option_139789497095040, option_139789497095312, option_139789497095584, option_139789497039760, option_139789497097488, option_139789497097760, option_139789497040080], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957104}], **{'doc': u'onduleur', 'properties': ('basic',), 'name': 'onduleur'})
    option_139789497040400.impl_set_information("help", u"""Paramétrage de la gestion des onduleurs par NUT""")
    option_139789497040400.impl_set_information("icon", u"""bolt""")
    option_139789497115792 = UnicodeOption(**{'default': u'local', 'doc': u'Nom de domaine du minion', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'minion_domain_name'})
    option_139789497115792.impl_set_information("help", u"""La machine cliente SaltStack est appelé « minion »""")
    option_139789497116064 = PortOption(**{'multi': False, 'name': 'salt_api_port', 'allow_private': True, 'default': 8880, 'doc': u"Port d'acc\xe8s \xe0 l'API SaltStack", 'properties': ('mandatory', 'expert')})
    option_139789497126992 = OptionDescription(children=[option_139789497115792, option_139789497116064], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963664}], **{'doc': u'saltstack', 'properties': ('expert',), 'name': 'saltstack'})
    option_139789497126992.impl_set_information("help", u"""Personnalisation de la configuration SaltStack""")
    option_139789497126992.impl_set_information("icon", u"""cloud""")
    option_139789497116336 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'sw_database_mode', 'doc': u'Configuration des tunnels en mode database', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamValue("non")})})
    option_139789497116336.impl_set_information("separator", (u'Param\xe8tres strongSwan', None))
    option_139789497116336.impl_set_information("help", u"""Configuration des tunnels en mode database (oui -> ipsec.db)
ou fichier plat (non -> ipsec.conf)""")
    option_139789497116608 = IntOption(**{'default': 11, 'doc': u"Nombre d'essais de retransmission avant Dead Peer Detection", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_retransmit_tries'})
    option_139789497116880 = IntOption(**{'default': 0, 'doc': u'Timeout pour le process stroke', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_stroke_timeout'})
    option_139789497116880.impl_set_information("help", u"""Exemples de process pouvant se figer : \"ipsec stroke statusall\", \"ipsec stroke delete connexion_name\"""")
    option_139789497117152 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'sw_install_vpn_route', 'default': 'non', 'doc': u'Gestion des routes par strongSwan', 'properties': ('mandatory', 'expert')})
    option_139789497117152.impl_set_information("separator", ('Gestion des Routes VPN', None))
    option_139789497117152.impl_set_information("help", u"""Si 'oui', l'adresse IP d'une des interfaces sera mise en source route selon l'ordre de montée des tunnels;
Si 'non', l'adresse IP de l'interface spécifiée sera forcée comme source lors de l'utilisation des tunnels par le serveur lui-même.""")
    option_139789497117424 = ChoiceOption(**{'multi': False, 'values': (u'non', u'1', u'2', u'3', u'4'), 'name': 'sw_force_ip_src', 'default': u'1', 'doc': u"Forcer l'adresse IP source de l'interface", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497117152}]})
    option_139789497117424.impl_set_information("help", u"""Lorsque le serveur aura besoin de passer par un tunnel, il sera vu avec cette adresse IP à l'autre extrémité du tunnel (dans la mesure où le reseau source inclu cette adresse)""")
    option_139789497117696 = IntOption(**{'default': 32, 'doc': u'Nombre de threads disponibles pour strongSwan', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_threads'})
    option_139789497117696.impl_set_information("separator", ('Gestion des threads', None))
    option_139789497117968 = IntOption(**{'default': 2, 'doc': u'Nombre de threads \xe0 r\xe9server pour les jobs HIGH priority', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_high_priority_threads'})
    option_139789497118240 = IntOption(**{'default': 4, 'doc': u'Nombre de threads \xe0 r\xe9server pour les jobs MEDIUM priority', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_medium_priority_threads'})
    option_139789497135184 = IntOption(**{'default': 1280, 'doc': u"Taille maximum d'un fragment IKE", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_fragment_size'})
    option_139789497135184.impl_set_information("separator", ('Gestion de la fragmentation', None))
    option_139789497135184.impl_set_information("help", u"""Cette taille sera utilisée uniquement si la fragmentation est autorisée dans la configuration IPSec""")
    option_139789497135456 = IntOption(**{'default': 0, 'doc': u'MSS \xe0 positionner sur les routes (0 pour d\xe9sactiver)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_mss'})
    option_139789497135456.impl_set_information("help", u"""Contournement en cas de problème de MTU/MSS.""")
    option_139789497135728 = IntOption(**{'default': 0, 'doc': u'MTU \xe0 positionner sur les routes (0 pour d\xe9sactiver)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sw_mtu'})
    option_139789497135728.impl_set_information("help", u"""Contournement en cas de problème de MTU/MSS.""")
    option_139789497136000 = IPOption(**{'doc': u'Adresses IP \xe0 tester dans test-rvp', 'multi': True, 'allow_reserved': True, 'properties': ('normal',), 'name': 'ip_test_rvp'})
    option_139789497136000.impl_set_information("separator", (u'Param\xe8tres agent Z\xe9phir RVP et diagnose', None))
    option_139789497136272 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'sw_crl_check', 'default': 'oui', 'doc': u'Contr\xf4le du status des certificats dans la CRL', 'properties': ('mandatory', 'expert')})
    option_139789497136272.impl_set_information("separator", (u'Param\xe8tres IPsec', None))
    option_139789497136544 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'acces_proxy_zone_rvp', 'default': 'non', 'doc': u'Acc\xe8s RVP par le proxy', 'properties': ('mandatory', 'normal')})
    option_139789497136544.impl_set_information("separator", (u'Acc\xe8s RVP par le proxy', None))
    option_139789497136544.impl_set_information("help", u"""Autoriser les réseaux locaux à accéder à des zones RVP via le proxy""")
    option_139789497136816 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_network_zone_rvp', 'doc': u'Adresse r\xe9seau de la zone RVP', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497136544}]})
    option_139789497137088 = NetmaskOption(**{'doc': u'Masque de sous-r\xe9seau de la zone RVP', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'adresse_netmask_zone_rvp'})
    option_139789497137360 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'autoriser_rvp_autres', 'default_multi': 'non', 'doc': u"Autoriser d'autres zones que l'interface 1 \xe0 acc\xe9der \xe0 ce r\xe9seau", 'properties': ('mandatory', 'normal')})
    option_139789497127312 = MasterSlaves(children=[option_139789497136816, option_139789497137088, option_139789497137360], **{'doc': u'Adresse r\xe9seau de la zone RVP', 'properties': ('basic',), 'name': 'adresse_network_zone_rvp'})
    option_139789497137632 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'adresse_dns_agriates', 'doc': u'Adresse du DNS permettant de resoudre les in.ac-acad.fr', 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497137904 = DomainnameOption(**{'type_': 'domainname', 'name': 'nom_zone_forward_rvp', 'doc': u'Nom DNS de la zone resolue par le DNS AGRIATES', 'allow_ip': False, 'multi': True, 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497655648}]})
    option_139789497127632 = OptionDescription(children=[option_139789497116336, option_139789497116608, option_139789497116880, option_139789497117152, option_139789497117424, option_139789497117696, option_139789497117968, option_139789497118240, option_139789497135184, option_139789497135456, option_139789497135728, option_139789497136000, option_139789497136272, option_139789497136544, option_139789497127312, option_139789497655648, option_139789497137632, option_139789497137904], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}], **{'doc': u'rvp', 'properties': ('basic',), 'name': 'rvp'})
    option_139789497127632.impl_set_information("help", u"""Paramétrage du réseau virtuel privé""")
    option_139789497127632.impl_set_information("icon", u"""lock""")
    option_139789497138176 = UnicodeOption(**{'multi': False, 'name': 'envole_version', 'doc': u'Num\xe9ro de version majeure d\u2019Envole', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.get_version, 'callback_params': Params(args=(ParamValue("ENVOLE_VERSION"),), kwargs={})})
    option_139789497138448 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'force_envole', 'default': 'non', 'doc': u'Utiliser Envole comme application par d\xe9faut en frontal', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497138720 = ChoiceOption(**{'multi': False, 'values': (u'non', u'local'), 'name': 'activer_recuperation_courriel', 'default': u'local', 'doc': u'Activer le serveur de r\xe9cup\xe9ration de courrier \xe9lectronique', 'properties': ('mandatory', 'normal')})
    option_139789497138720.impl_set_information("separator", (u'Serveur de r\xe9cup\xe9ration de courrier \xe9lectronique (POP/IMAP)', None))
    option_139789497143376 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_roundcube', 'default': 'oui', 'doc': u'Activer Roundcube (webmail)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497138720}]})
    option_139789497143376.impl_set_information("help", u"""RoundCube est un client webmail Open Source""")
    option_139789497143648 = FilenameOption(**{'multi': False, 'name': 'web_redirection', 'doc': u'Application web par d\xe9faut (redirection)', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_webredirection, 'callback_params': Params(args=None, kwargs={'force_envole': ParamOption(option_139789497138448, True), 'roundcube': ParamOption(option_139789497143376, True)}), "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^/"),), kwargs={'err_msg': ParamValue(u"Les alias doivent débuter par un \"/\"")})})
    option_139789497143648.impl_set_information("help", u"""Application proposée par défaut lors de l'accès du serveur web""")
    option_139789497143920 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_web_behind_revproxy', 'default': 'oui', 'doc': u'Le serveur web est derri\xe8re un reverse proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497144192 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'web_behind_revproxy_ip', 'doc': u'Adresse IP du serveur reverse proxy', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789498664080, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497143920}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497143920}]})
    option_139789497144464 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_web_valider_ca', 'default': 'non', 'doc': u"Activer la v\xe9rification de l'autorit\xe9 de certification pour les applications web cassifi\xe9es", 'properties': ('mandatory', 'expert')})
    option_139789497144736 = FilenameOption(**{'multi': False, 'name': 'apache_cert', 'doc': u'Certificat utilis\xe9 par apache', 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497939632, False)})})
    option_139789497145008 = ChoiceOption(**{'multi': False, 'values': (u'mysql', u'sqlite3'), 'name': 'bareos_db_type', 'default': u'mysql', 'doc': u'Type de la base de donn\xe9es du catalogue', 'properties': ('auto_freeze', 'mandatory', 'basic')})
    option_139789497145280 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_bareoswebui', 'default': 'non', 'doc': u'Activer Bareos WebUI (gestion de la sauvegarde)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497971584}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497971312}, {'expected': u'mysql', 'action': 'disabled', 'inverse': True, "option": option_139789497145008}]})
    option_139789497145280.impl_set_information("help", u"""Bareos WebUI est une application web permettant de surveiller et gérer les sauvegardes Bareos""")
    option_139789497145552 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_phpmyadmin', 'default': 'non', 'doc': u'Activer phpMyAdmin (administration des bases MySQL)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}]})
    option_139789497145552.impl_set_information("help", u"""phpMyAdmin permet d'administrer en ligne les bases de données MySQL du serveur""")
    option_139789497145824 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_eoleapps', 'default': 'oui', 'doc': u'Activer le service eoleapps', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789497145824.impl_set_information("help", u"""Serveur d'applications flask EOLE""")
    option_139789497146096 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_eoe', 'default': 'oui', 'doc': u'Activer EOE (gestion de mot de passe \xe9l\xe8ve)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145824}]})
    option_139789497146096.impl_set_information("help", u"""EOE est une application web à destination des élèves""")
    option_139789497146368 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_eop', 'default': 'oui', 'doc': u'Activer EOP (EOLE Outils Profs)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145824}]})
    option_139789497146368.impl_set_information("help", u"""EOP est une application web indépendante de l'EAD destinée aux profs""")
    option_139789497146640 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eop_profs_can_change_all_passwords', 'default': 'non', 'doc': u'Permettre aux enseignants de changer le mot de passe de tous les \xe9l\xe8ves', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497146368}]})
    option_139789497146640.impl_set_information("help", u"""Par défaut, seuls les professeurs principaux peuvent changer le mot de passe de leurs élèves. En choisissant \"oui\" , les professeurs pourront changer le mot de passe de n'importe quel élève.""")
    option_139789497146912 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_roundcubepop', 'default': 'oui', 'doc': u"Permettre aux utilisateurs d'ajouter des comptes de courrier \xe9lectronique personnels (au travers d'un serveur pop)", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497143376}]})
    option_139789497146912.impl_set_information("help", u"""RoundCube permet aux utilisateurs d'ajouter des comptes de courrier électronique POP autres que ceux gérés par l'annuaire.""")
    option_139789497155664 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_pydio', 'default': 'oui', 'doc': u'Activer Pydio', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}]})
    option_139789497155664.impl_set_information("help", u"""Pydio est un gestionnaire de fichiers en ligne""")
    option_139789497155936 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_pydio_local', 'default': 'non', 'doc': u'Activer un repository Local', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497155664}]})
    option_139789497156208 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_pydio_ftp', 'default': 'non', 'doc': u'Activer un repository distant en FTP', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497155664}]})
    option_139789497156480 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'pydio_repository_ftp', 'doc': u'IP du repository distant FTP', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497156208}]})
    option_139789497156752 = UnicodeOption(**{'multi': False, 'name': 'pydio_ftp', 'doc': u'Adresse du serveur FTP utilis\xe9 par Pydio', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal'), 'callback': eosfunc.calc_container, 'callback_params': Params(args=(ParamOption(option_139789497889120, False), ParamOption(option_139789497854704, False)), kwargs={})})
    option_139789497127952 = OptionDescription(children=[option_139789497138176, option_139789497414256, option_139789497138448, option_139789497143648, option_139789497143920, option_139789497144192, option_139789497144464, option_139789497144736, option_139789497145280, option_139789497145552, option_139789497146096, option_139789497146368, option_139789497146640, option_139789497143376, option_139789497146912, option_139789497155664, option_139789497155936, option_139789497156208, option_139789497156480, option_139789497156752], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}], **{'doc': u'applications web', 'properties': ('basic',), 'name': 'applications_web'})
    option_139789497127952.impl_set_information("help", u"""Paramètrage et gestion des applications web""")
    option_139789497127952.impl_set_information("icon", u"""php-alt""")
    option_139789497157024 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'apache_plus', 'default': 'non', 'doc': u'D\xe9clarer des applications web suppl\xe9mentaires', 'properties': ('mandatory', 'expert')})
    option_139789497157024.impl_set_information("separator", ('Applications supplementaires', None))
    option_139789497157296 = FilenameOption(**{'doc': u"Chemin complet l'application (exemple : /var/www/html/appli)", 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'apache_dir', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497157024}]})
    option_139789497157568 = FilenameOption(**{'multi': True, 'name': 'apache_alias', 'doc': u"Alias de l'application (exemple : /appli)", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497157024}], "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^/"),), kwargs={'err_msg': ParamValue(u"Les alias doivent débuter par un \"/\"")})})
    option_139789497157840 = FilenameOption(**{'default_multi': u'index.php', 'doc': u"Fichier \xe0 rechercher lorsqu'un client envoie une requ\xeate pour l'index d'un r\xe9pertoire", 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'apache_directory_index'})
    option_139789497157840.impl_set_information("proposed_value", (u'index.php', u'index.html'))
    option_139789497128272 = MasterSlaves(children=[option_139789497157296, option_139789497157568, option_139789497157840], **{'doc': u"Chemin complet l'application (exemple : /var/www/html/appli)", 'properties': ('expert',), 'name': 'apache_dir'})
    option_139789497158112 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'apache_lister_repertoires', 'default': 'non', 'doc': u'Permettre de lister les r\xe9pertoires et leur contenu', 'properties': ('mandatory', 'expert')})
    option_139789497158112.impl_set_information("separator", ('Configuration Apache', None))
    option_139789497158384 = IntOption(**{'default': 300, 'doc': u"Temps en secondes pendant lequel le serveur va attendre des entr\xe9es/sorties avant de consid\xe9rer qu'une requ\xeate a \xe9chou\xe9", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'apache_timeout'})
    option_139789497158656 = ChoiceOption(**{'multi': False, 'values': (u'On', u'Off'), 'name': 'apache_keepalive', 'default': u'On', 'doc': u'Autoriser les connexions persistantes', 'properties': ('mandatory', 'expert')})
    option_139789497158928 = IntOption(**{'default': 5, 'doc': u'Nombre de processus enfants du serveur cr\xe9\xe9s au d\xe9marrage', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mpm_startservers'})
    option_139789497159200 = IntOption(**{'default': 5, 'doc': u'Nombre minimum de processus serveurs enfants inactifs', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mpm_minspareservers'})
    option_139789497167952 = IntOption(**{'default': 10, 'doc': u'Nombre maximum de processus serveurs enfants inactifs', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mpm_maxspareservers'})
    option_139789497167952.impl_set_information("help", u"""S'il y a plus de MaxSpareServers processus inactifs, le processus parent arrêtera les processus excédentaires""")
    option_139789497168224 = IntOption(**{'default': 150, 'doc': u'Nombre maximum de connexions pouvant \xeatre trait\xe9es simultan\xe9ment', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mpm_maxrequestworkers'})
    option_139789497168224.impl_set_information("help", u"""Si la limite MaxRequestWorkers est atteinte, toute tentative de connexion sera normalement mise dans une file d'attente""")
    option_139789497168496 = IntOption(**{'default': 0, 'doc': u"Nombre maximum de connexions qu'un processus enfant va traiter au cours de son fonctionnement", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mpm_maxconnectionsperchild'})
    option_139789497168496.impl_set_information("help", u"""Si MaxConnectionsPerChild est définie à 0, il n'y a plus aucune limite sur le nombre de connexions que le processus pourra traiter""")
    option_139789497168768 = IntOption(**{'default': 32, 'doc': u'Taille maximale des donn\xe9es re\xe7ues par la m\xe9thode POST (en Mo)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_post_max_size'})
    option_139789497168768.impl_set_information("separator", ('Configuration PHP', None))
    option_139789497169040 = IntOption(**{'default': 16, 'doc': u"Taille maximale d'un fichier \xe0 charger (en Mo)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_upload_max_filesize'})
    option_139789497169312 = IntOption(**{'default': 30, 'doc': u"Temps maximal d'ex\xe9cution d'un script (en secondes)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_max_execution_time'})
    option_139789497169584 = IntOption(**{'default': 60, 'doc': u"Dur\xe9e maximale pour analyser les donn\xe9es d'entr\xe9e (en secondes)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_max_input_time'})
    option_139789497169856 = IntOption(**{'default': 128, 'doc': u"Taille m\xe9moire maximale qu'un script est autoris\xe9 \xe0 allouer (en Mo)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_memory_limit'})
    option_139789497170128 = ChoiceOption(**{'multi': False, 'values': (u'On', u'Off'), 'name': 'php_display_errors', 'default': u'Off', 'doc': u"Affichage des erreurs \xe0 l'\xe9cran", 'properties': ('mandatory', 'expert')})
    option_139789497170400 = IntOption(**{'default': 3600, 'doc': u'Dur\xe9e de vie des donn\xe9es sur le serveur (en secondes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_session_gc_maxlifetime'})
    option_139789497170672 = IntOption(**{'default': 16, 'doc': u"Nombre d'octets \xe0 lire dans le fichier utilis\xe9 comme source additionnelle d'entropie", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'php_session_entropy_length'})
    option_139789497170672.impl_set_information("help", u"""Spécifie le nombre d'octets qui seront lus dans le fichier utilisé comme source additionnelle d'entropie pour la création de l'identifiant de session. Mettre à 0 pour le désactiver.""")
    option_139789497170944 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'php_browscap', 'default': 'non', 'doc': u'Activer la directive de configuration browscap', 'properties': ('mandatory', 'expert')})
    option_139789497170944.impl_set_information("help", u"""La directive de configuration browscap permet d'obtenir plus d'information sur les capacités du navigateur client grâce à la fonction get_browser()""")
    option_139789497128592 = OptionDescription(children=[option_139789497157024, option_139789497128272, option_139789497158112, option_139789497158384, option_139789497158656, option_139789497158928, option_139789497159200, option_139789497167952, option_139789497168224, option_139789497168496, option_139789497168768, option_139789497169040, option_139789497169312, option_139789497169584, option_139789497169856, option_139789497170128, option_139789497170400, option_139789497170672, option_139789497170944], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}], **{'doc': u'apache', 'properties': ('expert',), 'name': 'apache'})
    option_139789497128592.impl_set_information("help", u"""Paramètrage avancé du serveur web Apache""")
    option_139789497128592.impl_set_information("icon", u"""apache""")
    option_139789497171216 = UsernameOption(**{'doc': u"Utilisateur autoris\xe9 \xe0 se connecter \xe0 l'interface web de gestion de la sauvegarde", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'bareoswebui_user'})
    option_139789497171488 = PasswordOption(**{'doc': u"Mot de passe de l'utilisateur autoris\xe9 \xe0 se connecter \xe0 l'interface web de gestion de la sauvegarde", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'bareoswebui_password'})
    option_139789497128912 = MasterSlaves(children=[option_139789497171216, option_139789497171488], **{'doc': u"Utilisateur autoris\xe9 \xe0 se connecter \xe0 l'interface web de gestion de la sauvegarde", 'properties': ('basic',), 'name': 'bareoswebui_user'})
    option_139789497180240 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'bareoswebui_db_mysql_password', 'doc': u'Mot de passe de la base de donn\xe9es MySQL de la sauvegarde', 'properties': ('auto_freeze', 'basic'), 'callback': eosfunc.gen_random})
    option_139789497129232 = OptionDescription(children=[option_139789497128912, option_139789497180240], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145280}], **{'doc': u'bareos webui', 'properties': ('basic',), 'name': 'bareos_webui'})
    option_139789497129232.impl_set_information("help", u"""Paramétrage de l'application web Bareos WebUI""")
    option_139789497129232.impl_set_information("icon", u"""archive""")
    option_139789497180512 = PortOption(**{'multi': False, 'name': 'eolesso_port', 'allow_private': True, 'default': 8443, 'doc': u'Port utilis\xe9 par le service EoleSSO', 'properties': ('mandatory', 'normal')})
    option_139789497180784 = FilenameOption(**{'doc': u"Alias d'acc\xe8s au service SSO (param\xe8tre : __CAS_FOLDER)", 'multi': False, 'properties': ('expert',), 'name': 'eolesso_cas_folder'})
    option_139789497180784.impl_set_information("help", u"""Certains serveurs SSO tels que lemonLDAP ou keycloak ont besoin d'un alias spécifique en plus du domaine et du port, exemple : https://monserveursso:8443/CAS""")
    option_139789497181056 = UnicodeOption(**{'default': u'EoleSSOServer', 'doc': u'Nom du cookie EoleSSO', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'eolesso_cookie_name'})
    option_139789497181056.impl_set_information("help", u"""Nom du cookie identifiant la session SSO""")
    option_139789497181328 = UnicodeOption(**{'doc': u'Domaine du cookie EoleSSO', 'multi': False, 'properties': ('expert',), 'name': 'eolesso_cookie_domain'})
    option_139789497181328.impl_set_information("help", u"""Domaine du cookie SSO ( si rien: utilise le nom d'hôte du serveur)""")
    option_139789497181600 = DomainnameOption(**{'multi': True, 'name': 'eolesso_ldap', 'allow_without_dot': True, 'default': [u'localhost'], 'doc': u'Adresse du serveur LDAP utilis\xe9 par EoleSSO', 'type_': 'domainname', 'allow_ip': True, 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497182144 = PortOption(**{'multi': True, 'name': 'eolesso_port_ldap', 'allow_private': True, 'default_multi': 389, 'doc': u'Port du serveur LDAP utilis\xe9 par EoleSSO', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497181872 = UnicodeOption(**{'multi': True, 'name': 'eolesso_base_ldap', 'doc': u"Chemin de recherche dans l'annuaire", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val_first_value, 'callback_params': Params(args=(ParamOption(option_139789497484976, True), ParamValue("o=gouv,c=fr")), kwargs={}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497182416 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_label', 'doc': u"Libell\xe9 \xe0 pr\xe9senter aux utilisateurs en cas d'homonymes", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_libelle_annuaire, 'callback_params': Params(args=(ParamOption(option_139789497181600, False), ParamOption(option_139789497890208, False), ParamOption(option_139789497890752, False)), kwargs={}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497182416.impl_set_information("help", u"""Dans le cas ou un utilisateur aurait un homonyme dans un des annuaires configurés, une liste déroulante lui permet de choisir sa provenance (un des annuaires configurés, ou un établissement en cas d'annuaire multi établissements). Ce libellé est utilisé pour décrire cet annuaire. (si rien: Annuaire de 'adresse_serveur')""")
    option_139789497182688 = UnicodeOption(**{'doc': u"Informations suppl\xe9mentaire dans le cadre d'information sur les homonymes", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_infos', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497182688.impl_set_information("help", u"""Dans le cas ou des homonymes sont détectés, le contenu du fichier indiqué sera ajouté au code html du cadre affiché (seulement si l'utilisateur est présent dans cet annuaire). Le fichier doit être dans le répertoire /usr/share/sso/interface/infos_homonymes""")
    option_139789497182960 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_reader', 'doc': u'Utilisateur de lecture des comptes LDAP (n\xe9cessaire pour la f\xe9d\xe9ration)', 'properties': ('normal',), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamValue("cn=reader,"), ParamOption(option_139789497181872, False)), kwargs={}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497182960.impl_set_information("help", u"""La fédération nécessite un compte LDAP ayant accès en lecture aux attributs de tous les utilisateurs. Dans le cas de l'utilisation d'un annuaire fourni par le paquet eole-annuaire, l'utilisateur \"cn=reader,o=gouv,c=fr\" est disponible""")
    option_139789497183232 = FilenameOption(**{'multi': True, 'name': 'eolesso_ldap_reader_passfile', 'default_multi': u'/root/.reader', 'doc': u"Fichier de mot de passe de l'utilisateur de lecture", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497183232.impl_set_information("help", u"""Fichier contenant le mot de passe de l'utilisateur de lecture des comptes LDAP. si le fichier ou le compte n'existent pas, la recherche d'attributs en cas de fédération se fera de façon anonyme""")
    option_139789497183504 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_match_attribute', 'default_multi': u'uid', 'doc': u'Attribut de recherche des utilisateurs', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497183504.impl_set_information("help", u"""Attribut utilisé comme identifiant des utilisateurs pour cet annuaire ('uid' par défaut. Si autre valeur, les groupes de l'utilisateur ne seront pas détectés)""")
    option_139789497183776 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eolesso_pam_securid', 'default': 'non', 'doc': u"Gestion de l'authentification OTP (RSA SecurID)", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497196624 = ChoiceOption(**{'multi': True, 'values': (u'inactifs', u'identiques', u'configurables'), 'name': 'eolesso_ldap_login_otp', 'default_multi': u'inactifs', 'doc': u'Identifiants OTP pour cet annuaire', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497183776}]})
    option_139789497196624.impl_set_information("help", u"""Type d'identifiants OTP gérés pour les utilisateurs de cet annuaire. Inactifs : OTP non disponible; identiques : identifiant identique à l'identifiant LDAP; configurables : identifiant personnalisé renseigné par l'utilisateur à la première connexion en mode OTP""")
    option_139789497196896 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eolesso_ldap_apps_params', 'default': 'non', 'doc': u'Information LDAP suppl\xe9mentaires (applications)', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497196896.impl_set_information("help", u"""Permet de configurer des paramètres supplémentaires pour chaque annuaire LDAP. Utilisé par les applications accédant directement aux annuaires (ex: ownCloud)""")
    option_139789497197168 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_filter_user', 'default_multi': u'objectClass=person', 'doc': u"Filtre d'utilisateurs", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497197168.impl_set_information("help", u"""Sans élément de substitution, par exemple \"objectClass=person\".""")
    option_139789497197440 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_filter_group', 'default_multi': u'objectClass=posixGroup', 'doc': u'Filtre de groupes', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497197440.impl_set_information("help", u"""Sans élément de substitution, par exemple \"objectClass=posixGroup\".""")
    option_139789497197712 = UnicodeOption(**{'doc': u"DN racine de l'arbre utilisateurs", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_dntree_user', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497197984 = UnicodeOption(**{'doc': u"DN racine de l'arbre groupes", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_dntree_group', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497198256 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_fill_displayname', 'default_multi': u'displayName', 'doc': u"Champ 'nom d'affichage' de l'utilisateur", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497198256.impl_set_information("help", u"""Attribut utilisé comme nom complet pour l'utilisateur""")
    option_139789497198528 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_fill_mail', 'default_multi': u'mail', 'doc': u"Champ 'mail' de l'utilisateur", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497198528.impl_set_information("help", u"""Attribut utilisé comme mail pour l'utilisateur""")
    option_139789497198800 = UnicodeOption(**{'doc': u"Champ 'fonction' de l'utilisateur", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_fill_fonction', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497198800.impl_set_information("help", u"""Attribut utilisé comme fonction pour l'utilisateur""")
    option_139789497199072 = UnicodeOption(**{'doc': u"Champ 'categorie' de l'utilisateur", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_fill_categorie', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497199072.impl_set_information("help", u"""Attribut utilisé comme catégorie pour l'utilisateur""")
    option_139789497199344 = UnicodeOption(**{'doc': u"Champ 'rne' de l'utilisateur", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_fill_rne', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497199344.impl_set_information("help", u"""Attribut utilisé comme rne pour l'utilisateur""")
    option_139789497199616 = UnicodeOption(**{'doc': u"Champ 'fredurne' de l'utilisateur", 'multi': True, 'properties': ('normal',), 'name': 'eolesso_ldap_fill_fredurne', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497199616.impl_set_information("help", u"""Attribut utilisé comme fredurne pour l'utisateur""")
    option_139789497199888 = UnicodeOption(**{'multi': True, 'name': 'eolesso_ldap_fill_displaygroup', 'default_multi': u'cn', 'doc': u"Champ 'nom d'affichage' du groupe", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497196896}]})
    option_139789497199888.impl_set_information("help", u"""Attribut utilisé comme nom du groupe de l'utilisateur""")
    option_139789497129552 = MasterSlaves(children=[option_139789497181600, option_139789497182144, option_139789497181872, option_139789497182416, option_139789497182688, option_139789497182960, option_139789497183232, option_139789497183504, option_139789497196624, option_139789497197168, option_139789497197440, option_139789497197712, option_139789497197984, option_139789497198256, option_139789497198528, option_139789497198800, option_139789497199072, option_139789497199344, option_139789497199616, option_139789497199888], **{'doc': u'Adresse du serveur LDAP utilis\xe9 par EoleSSO', 'properties': ('normal',), 'name': 'eolesso_ldap'})
    option_139789497200160 = UnicodeOption(**{'doc': u'Adresse du serveur SSO parent', 'multi': False, 'properties': ('normal',), 'name': 'eolesso_adresse_parent', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497208912 = IntOption(**{'multi': False, 'name': 'eolesso_port_parent', 'default': 8443, 'doc': u'Port du serveur SSO parent', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497209184 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eolesso_metrics', 'default': 'non', 'doc': u"G\xe9n\xe9rer des statistiques d'usage du service", 'properties': ('mandatory', 'expert')})
    option_139789497209184.impl_set_information("help", u"""Génère des statistiques d'usage du service sur l'URL /metrics""")
    option_139789497209456 = UnicodeOption(**{'doc': u"Nom d'entit\xe9 SAML du serveur eole-sso (ou rien)", 'multi': False, 'properties': ('normal',), 'name': 'eolesso_entity_name', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497209456.impl_set_information("help", u"""Nom d'entité du serveur EoleSSO local à indiquer dans les messages SAML (si rien, une valeur est calculée depuis le nom de l'académie et le nom de machine)""")
    option_139789497209728 = IntOption(**{'multi': False, 'name': 'eolesso_otppass_minsize', 'default': 10, 'doc': u'Taille minimum du passcode OTP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497183776}]})
    option_139789497209728.impl_set_information("help", u"""Taille minimum des mots de passe OTP (code PIN + clé)""")
    option_139789497210000 = IntOption(**{'multi': False, 'name': 'eolesso_otppass_maxsize', 'default': 12, 'doc': u'Taille maximum du passcode OTP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497183776}]})
    option_139789497210000.impl_set_information("help", u"""Taille maximum des mots de passe OTP (code PIN + clé)""")
    option_139789497210272 = UnicodeOption(**{'multi': False, 'name': 'eolesso_otppass_regx', 'default': u'^[0-9]{10,12}$', 'doc': u'Expression r\xe9guli\xe8re de d\xe9tection des passcodes OTP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497183776}]})
    option_139789497210272.impl_set_information("help", u"""Expression régulière pour valider que le mot de passe saisi est de type OTP (vérifié quand la longueursaisie correspond au tailles min/max). Comprend le code PIN + la clé. Par défaut : chaîne de 12 caractères numériques.""")
    option_139789497210816 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eolesso_otp_desync', 'default': 'non', 'doc': u'Gestion locale des cl\xe9s OTP d\xe9synchronis\xe9es', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497183776}]})
    option_139789497210816.impl_set_information("help", u"""Choix du mode de fonctionnement en cas de clé OTP désynchronisée (par ex. suite à plusieurs tentatives échouées).Si non, l'utilisateur est invité à débloquer la situation en allant sur une URL particulière. Si oui, EoleSSO va demander la saisie d'un deuxième mot de passe pour débloquer la situation""")
    option_139789497210544 = UnicodeOption(**{'doc': u'Adresse de la mire OTP en cas d\xe9synchronisation de cl\xe9', 'multi': False, 'properties': ('normal',), 'name': 'eolesso_otp_portal', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497210816}]})
    option_139789497210544.impl_set_information("help", u"""En cas de désynchronisation d'une clé OTP, l'utilisateur sera redirigé sur cette adresse pour débloquer la situation. Si vide, un message par défaut est affiché""")
    option_139789497211088 = UnicodeOption(**{'multi': False, 'name': 'eolesso_cert', 'doc': u'Chemin du certificat SSL', 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497939632, False)}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497211088.impl_set_information("help", u"""Certificat utilisé par le serveur SSO""")
    option_139789497211360 = UnicodeOption(**{'multi': False, 'name': 'eolesso_key', 'doc': u'Chemin de la cl\xe9 priv\xe9e li\xe9e au certificat SSL', 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497939904, False)}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497211360.impl_set_information("help", u"""Valeur ignorée si le certificat n'est pas défini. si rien et certificat défini: 'nom_certificat.key' dans le même répertoire.""")
    option_139789497211632 = UnicodeOption(**{'doc': u"Chemin de l'autorit\xe9 de certification (ou rien)", 'multi': False, 'properties': ('normal',), 'name': 'eolesso_ca_location', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497211632.impl_set_information("help", u"""Certificat de l'autorité de certification validant le certificat du serveur SSO (dans le cas d'une chaine de certification, tous les certificats de la chaine doivent être intégés)""")
    option_139789497211904 = IntOption(**{'default': 7200, 'doc': u"Dur\xe9e de vie d'une session sur le serveur SSO (en secondes)", 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'eolesso_session_timeout'})
    option_139789497212176 = UnicodeOption(**{'doc': u'CSS par d\xe9faut du service SSO (sans le .css)', 'multi': False, 'properties': ('normal',), 'name': 'eolesso_css', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497212176.impl_set_information("help", u"""CSS par défaut pour les pages du service SSO (sans le .css, le fichier est à placer dans /usr/share/sso/interface/[nom_fichier].css)""")
    option_139789497212448 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'eolesso_responsive', 'default': 'non', 'doc': u'Activer la balise meta viewport (CSS responsive)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497212448.impl_set_information("help", u"""Inclut la balise meta 'viewport' dans les pages de l'application (avec content=\"width=device-width, initial-scale=1\"). A activer en cas d'utilisation d'une CSS 'responsive'.""")
    option_139789497229392 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'federation_transparente', 'default': 'non', 'doc': u"Cacher le formulaire lors de l'envoi des informations de f\xe9d\xe9ration", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789497229392.impl_set_information("help", u"""Lors de l'envoi d'attributs de l'utilisateur à un fournisseur tiers dans le cadre d'une fédération d'identité, un formulaire est présenté pour le prévenir. En choisissant 'oui', le formulaire sera envoyé automatiquement sans être affiché.""")
    option_139789497229664 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'cas_send_logout', 'default': 'oui', 'doc': u'Activer le logout centralis\xe9 du serveur SSO', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789497230208 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'cas_verify_service', 'default': 'non', 'doc': u'Ne pas r\xe9pondre aux demandes CAS des applications inconnues', 'properties': ('mandatory', 'expert')})
    option_139789497230208.impl_set_information("help", u"""Si ce paramètre est à oui, seules les applications renseignées dans les fichiers d'applications (/usr/share/sso/app_filters/*_apps.ini) sont autorisées à recevoir des réponses du serveur en mode CAS. Si il est à non, le filtre par défaut leur sera appliqué""")
    option_139789497229936 = IntOption(**{'default': -300, 'doc': u'D\xe9calage de temps (en secondes) dans les messages de f\xe9d\xe9ration SAML', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'sso_saml_time_adjust'})
    option_139789497229936.impl_set_information("help", u"""Décalage en secondes appliqué aux dates dans les messages de fédération SAML. Permet d'éviter le rejet des messages lorsque le serveur partenaire n'est pas tout à fait synchrone (par défaut, on décale de 5 minutes dans le passé). Ce délai est aussi pris en compte pour la validation des messages reçus.""")
    option_139789497230480 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ead_sso', 'default': 'oui', 'doc': u"Utiliser l'authentification SSO pour l'EAD", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}]})
    option_139789497230752 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_openid', 'default': 'non', 'doc': u"Autoriser l'authentification OpenID Connect", 'properties': ('mandatory', 'expert')})
    option_139789497230752.impl_set_information("separator", ('Authentification OpenID', None))
    option_139789497231024 = UnicodeOption(**{'doc': u"R\xe9f\xe9rence du fournisseur d'identit\xe9 OpenID", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'openid_providers', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497230752}]})
    option_139789497231024.impl_set_information("proposed_value", (u'fconnect',))
    option_139789497231024.impl_set_information("help", u"""nom du fournisseur d'identité. Non affiché, utilisé dans le nom des images (logos)""")
    option_139789497231296 = UnicodeOption(**{'multi': True, 'name': 'openid_providers_label', 'doc': u"Libell\xe9 du fournisseur d'identit\xe9 OpenID", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("France Connect")})})
    option_139789497231296.impl_set_information("help", u"""Libellé présenté aux utilisateurs pour décrire le fournisseur""")
    option_139789497231568 = URLOption(**{'multi': True, 'name': 'openid_providers_issuer', 'allow_ip': True, 'allow_without_dot': True, 'doc': u"URL d'acc\xe8s (issuer)", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/")})})
    option_139789497231568.impl_set_information("help", u"""URL de base du fournisseur d'identité (généralement appelée issuer)""")
    option_139789497231840 = URLOption(**{'multi': True, 'name': 'openid_providers_about_url', 'allow_ip': True, 'allow_without_dot': True, 'doc': u"URL d'information (A propos)", 'properties': ('normal',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/a-propos")})})
    option_139789497232112 = UnicodeOption(**{'multi': True, 'name': 'openid_providers_about_label', 'doc': u"Libell\xe9 de l'URL d'information (A propos)", 'properties': ('normal',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("Qu'est ce que FranceConnect ?")})})
    option_139789497232384 = URLOption(**{'multi': True, 'name': 'openid_providers_auth_endp', 'allow_ip': True, 'allow_without_dot': True, 'doc': u"URL de demande d'autorisation (authorization endpoint)", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/authorize")})})
    option_139789497232384.impl_set_information("help", u"""URL de réception des requêtes d'authentification.""")
    option_139789497232656 = URLOption(**{'multi': True, 'name': 'openid_providers_reg_endp', 'allow_ip': True, 'allow_without_dot': True, 'doc': u"URL d'enregistrement automatique (register endpoint)", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/register")})})
    option_139789497232656.impl_set_information("help", u"""URL d'enregistrement automatique du client (non géré)""")
    option_139789497232928 = URLOption(**{'multi': True, 'name': 'openid_providers_token_endp', 'allow_ip': True, 'allow_without_dot': True, 'doc': u"URL de r\xe9cup\xe9ration de jeton d'acc\xe8s (token endpoint)", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/token")})})
    option_139789497232928.impl_set_information("help", u"""URL de récupération de jeton d'accès (access token)""")
    option_139789497233488 = URLOption(**{'multi': True, 'name': 'openid_providers_logout_endp', 'allow_ip': True, 'allow_without_dot': True, 'doc': u'URL de d\xe9connexion (logout endpoint)', 'properties': ('normal',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/logout")})})
    option_139789497233488.impl_set_information("help", u"""URL de déconnexion du fournisseur d'identité (non utilisé pour Google,Facebook,Live)""")
    option_139789497233760 = URLOption(**{'multi': True, 'name': 'openid_providers_userinfo_endp', 'allow_ip': True, 'allow_without_dot': True, 'doc': u'URL de lecture des informations (userinfo endpoint)', 'properties': ('normal',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("fconnect"),), kwargs={'condition_1': ParamOption(option_139789497231024, False), 'default_mismatch': ParamValue("None"), 'match': ParamValue("https://fcp.integ01.dev-franceconnect.fr/api/v1/userinfo")})})
    option_139789497233760.impl_set_information("help", u"""URL de récupération des informations sur l'utilisateur (non utilisé si renvoyées avec le jeton d'accès)""")
    option_139789497234032 = URLOption(**{'multi': True, 'name': 'openid_providers_jwks_uri', 'doc': u'URL de description des certificats de signature (jwks URI)', 'allow_ip': True, 'allow_without_dot': True, 'properties': ('normal',)})
    option_139789497234032.impl_set_information("help", u"""URL décrivant les certificats utilisés pour la signature des jetons (si disponible)""")
    option_139789497129872 = MasterSlaves(children=[option_139789497231024, option_139789497231296, option_139789497231568, option_139789497231840, option_139789497232112, option_139789497232384, option_139789497232656, option_139789497232928, option_139789497233488, option_139789497233760, option_139789497234032], **{'doc': u"R\xe9f\xe9rence du fournisseur d'identit\xe9 OpenID", 'properties': ('basic',), 'name': 'openid_providers'})
    option_139789497130192 = OptionDescription(children=[option_139789497414528, option_139789497180512, option_139789497180784, option_139789497181056, option_139789497181328, option_139789497129552, option_139789497196896, option_139789497200160, option_139789497208912, option_139789497209184, option_139789497209456, option_139789497183776, option_139789497209728, option_139789497210000, option_139789497210272, option_139789497210816, option_139789497210544, option_139789497211088, option_139789497211360, option_139789497211632, option_139789497211904, option_139789497212176, option_139789497212448, option_139789497229392, option_139789497229664, option_139789497230208, option_139789497229936, option_139789497230480, option_139789497230752, option_139789497129872], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}], **{'doc': u'eole sso', 'properties': ('basic',), 'name': 'eole_sso'})
    option_139789497130192.impl_set_information("help", u"""Configuration du serveur d'authentification EoleSSO""")
    option_139789497130192.impl_set_information("icon", u"""group""")
    option_139789497234304 = DomainnameOption(**{'type_': 'domainname', 'name': 'nom_domaine_local_supp', 'doc': u'Nom domaine local suppl\xe9mentaire ou rien', 'allow_ip': False, 'multi': True, 'properties': ('expert',)})
    option_139789497234304.impl_set_information("separator", (u'Ajout de domaines locaux suppl\xe9mentaires (DNS master sur ces domaines)', None))
    option_139789497234576 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_zone_forward', 'default': 'non', 'doc': u'D\xe9clarer des zones DNS \xe0 forwarder', 'properties': ('mandatory', 'expert')})
    option_139789497234576.impl_set_information("separator", ('Forward de zones DNS', None))
    option_139789497234848 = DomainnameOption(**{'type_': 'domainname', 'name': 'nom_zone_forward', 'doc': u'Nom DNS de la zone', 'allow_ip': False, 'multi': True, 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497234576}]})
    option_139789497235120 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'ip_dns_zone_forward', 'doc': u'Adresse IP du serveur DNS de la zone', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497234576}]})
    option_139789497130512 = MasterSlaves(children=[option_139789497234848, option_139789497235120], **{'doc': u'Nom DNS de la zone', 'properties': ('expert',), 'name': 'nom_zone_forward'})
    option_139789497258064 = OptionDescription(children=[option_139789497234304, option_139789497234576, option_139789497130512], **{'doc': u'zones-dns', 'properties': ('expert',), 'name': 'zones_dns'})
    option_139789497258064.impl_set_information("help", u"""Personnalisation des zones DNS""")
    option_139789497258064.impl_set_information("icon", u"""random""")
    option_139789497235392 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ead_reverseproxy', 'default': 'non', 'doc': u"Activer l'interface web de l'EAD sur un second port", 'properties': ('mandatory', 'expert')})
    option_139789497235392.impl_set_information("help", u"""Ce second port peut, par exemple, permettre d'accéder à l'interface depuis l'extérieur si un proxy inverse est utilisé""")
    option_139789497235664 = PortOption(**{'multi': False, 'name': 'port_ead_reverseproxy', 'allow_private': True, 'default': 4203, 'doc': u"Port d'acc\xe8s EAD personnalis\xe9", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497235392}], "validator": eosfunc.valid_differ, 'validator_params': Params(args=(ParamValue(u"4200"),), kwargs={})})
    option_139789497258384 = OptionDescription(children=[option_139789497235392, option_139789497235664], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}], **{'doc': u'ead-web', 'properties': ('expert',), 'name': 'ead_web'})
    option_139789497258384.impl_set_information("help", u"""Paramétrage avancé de l'interface web EAD""")
    option_139789497258384.impl_set_information("icon", u"""gear""")
    option_139789497235936 = IntOption(**{'default': 200, 'doc': u'Nombre maximum de connexions simultan\xe9es', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'mysql_max_connexions'})
    option_139789497235936.impl_set_information("separator", ('Configuration', None))
    option_139789497236208 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'mysql_open_firewall', 'default': 'non', 'doc': u"Permettre l'acc\xe8s au serveur depuis l'ext\xe9rieur", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789497236480 = NetworkOption(**{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions distantes au serveur MYSQL', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'ip_my_dist', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497236208}]})
    option_139789497236752 = NetmaskOption(**{'doc': u'Masque du sous r\xe9seau pour les connexions distantes au serveur MySQL', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'mask_my_dist', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497236208}]})
    option_139789497236752.impl_add_consistency("network_netmask", option_139789497236480, **{'warnings_only': True})
    option_139789497237024 = ChoiceOption(**{'multi': True, 'values': (u'auto', u'all', u'eth0', u'eth1', u'eth2', u'eth3', u'eth4'), 'name': 'if_my_dist', 'default_multi': u'auto', 'doc': u'Interface pour les connexions distantes au serveur MySQL', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497236208}]})
    option_139789497258704 = MasterSlaves(children=[option_139789497236480, option_139789497236752, option_139789497237024], **{'doc': u'Adresse IP r\xe9seau autoris\xe9e pour les connexions distantes au serveur MYSQL', 'properties': ('expert',), 'name': 'ip_my_dist'})
    option_139789497259024 = OptionDescription(children=[option_139789497235936, option_139789497236208, option_139789497258704], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}], **{'doc': u'mysql', 'properties': ('expert',), 'name': 'mysql'})
    option_139789497259024.impl_set_information("help", u"""Paramétrage avancé du serveur de gestion de bases de données MySQL""")
    option_139789497259024.impl_set_information("icon", u"""mysql-alt""")
    option_139789496746064 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_spamassassin', 'default': 'oui', 'doc': u'Activer le service anti-spam SpamAssassin', 'properties': ('mandatory', 'normal')})
    option_139789496746064.impl_set_information("separator", ('Service anti-spam', None))
    option_139789496746064.impl_set_information("help", u"""Le but de ce logiciel est de filtrer le trafic des courriels pour éradiquer les courriels reconnus comme pourriels ou courriels non sollicités""")
    option_139789496746336 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'adresse_ip_mail', 'doc': u'Adresse IP du serveur de mail local', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'mismatch': ParamOption(option_139789497538768, False), 'condition_1': ParamOption(option_139789497889120, False), 'default_mismatch': ParamValue("None"), 'match': ParamOption(option_139789497853072, False)})})
    option_139789496746608 = DomainnameOption(**{'multi': False, 'name': 'adresse_imap', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Adresse du serveur de r\xe9cup\xe9ration de courrier \xe9lectronique IMAP', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("local"),), kwargs={'condition_1': ParamOption(option_139789497138720, False), 'default_mismatch': ParamValue("None"), 'match': ParamOption(option_139789496746336, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497138720}, {'expected': u'local', 'action': 'frozen', 'inverse': False, "option": option_139789497138720}, {'expected': u'local', 'action': 'hidden', 'inverse': False, "option": option_139789497138720}, {'expected': u'local', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497138720}]})
    option_139789496747152 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_courier_imap', 'default': 'oui', 'doc': u'Activer le serveur IMAP de Courier', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497138720}]})
    option_139789496747152.impl_set_information("help", u"""Courier est un serveur d'échange de courrier électronique via le protocole IMAP""")
    option_139789496746880 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_courier_pop', 'default': 'non', 'doc': u'Activer le serveur POP de Courier', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497138720}]})
    option_139789496746880.impl_set_information("help", u"""Courier est un serveur d'échange de courrier électronique via le protocole POP""")
    option_139789496747424 = ChoiceOption(**{'multi': False, 'name': 'activer_courier_commun', 'doc': u'Activer les services communs pour Courier', 'values': (u'oui', u'non'), 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("oui"), 'condition_1': ParamOption(option_139789496747152, False), 'match': ParamValue("non"), 'condition_2': ParamOption(option_139789496746880, False)}), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497138720}]})
    option_139789496747696 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_courier_imap_sso', 'default': 'oui', 'doc': u"Autoriser l'authentification CAS pour le serveur IMAP de Courier", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747152}]})
    option_139789496747968 = DomainnameOption(**{'multi': False, 'name': 'adresse_imap_sso', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Adresse du serveur IMAP utilis\xe9 pour le client CAS/IMAP', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=(ParamOption(option_139789496746608, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747696}]})
    option_139789496747968.impl_set_information("help", u"""Il faut renseigner l'adresse du serveur IMAP définit sur le client IMAP avec authentification CAS (par exemple roundcube)""")
    option_139789496748240 = UnicodeOption(**{'multi': False, 'name': 'proxy_cachemaster', 'doc': u'Adresse courriel du cachemaster', 'properties': ('normal',), 'callback': eosfunc.concat, 'callback_params': Params(args=(ParamValue("cachemaster@"), ParamOption(option_139789497891296, False), ParamValue("."), ParamOption(option_139789497891568, False)), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789496748240.impl_set_information("help", u"""Adresse électronique proposée pour les réclamations liées au filtrage des sites""")
    option_139789496748512 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_smarthost', 'default': 'oui', 'doc': u'G\xe9rer la distribution locale', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496748512.impl_set_information("help", u"""Gestion d’un domaine local et d’un domaine privé (préfixe \"i-\")""")
    option_139789496748784 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_sympa', 'default': 'oui', 'doc': u'Activer le serveur de listes de diffusion Sympa', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748512}]})
    option_139789496748784.impl_set_information("separator", ('Serveur de listes', None))
    option_139789496748784.impl_set_information("help", u"""Sympa (Système de Multi-Postage Automatique) est un gestionnaire de listes électroniques""")
    option_139789496749056 = EmailOption(**{'doc': u"Adresse \xe9lectronique d'envoi pour le compte root", 'multi': False, 'properties': ('normal',), 'name': 'system_mail_from'})
    option_139789496749056.impl_set_information("help", u"""Adresse utilisée comme expéditeur des courriers électroniques de l'utilisateur root""")
    option_139789496749328 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'system_mail_from_for_headers', 'default': 'non', 'doc': u"\xc9craser les ent\xeates 'From:', 'Reply-To:' et 'Sender:' du message", 'properties': ('mandatory', 'expert')})
    option_139789496749600 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'system_mail_to_for_headers', 'default': 'non', 'doc': u"\xc9craser les ent\xeates 'To:', 'Cc:' et 'Bcc:' du message", 'properties': ('mandatory', 'expert')})
    option_139789496758352 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_ldap_delivery', 'default': 'oui', 'doc': u'G\xe9rer la distribution pour les comptes LDAP', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496758624 = IntOption(**{'multi': False, 'name': 'exim_quota', 'default': 20, 'doc': u'Quota des bo\xeetes aux lettres en Mo', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748512}], "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"0")})})
    option_139789496758624.impl_set_information("help", u"""Taille par défaut, en Mo, des boîtes aux lettres.""")
    option_139789496758896 = IntOption(**{'multi': False, 'name': 'exim_quota_warn', 'default': 80, 'doc': u'Pourcentage d\u2019utilisation des bo\xeetes entra\xeenant un warning', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748512}], "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"0")})})
    option_139789496758896.impl_set_information("help", u"""Limite d’utilisation, en pourcent, d’une boîte aux lettres entraînant
            l’envoi d’un message d’alerte.""")
    option_139789496759168 = IntOption(**{'multi': False, 'name': 'exim_spam_score', 'default': 50, 'doc': u"Seuil de d\xe9tection d'un spam (multipli\xe9 par 10)", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746064}]})
    option_139789496759168.impl_set_information("help", u"""Seuil à partir duquel un courrier électronique est considéré
            comme spam. Le seuil fourni par SpamAssassin est multiplié
            par 10 afin de faire des comparaisons sur des entiers.""")
    option_139789496759440 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_use_tls', 'default': 'oui', 'doc': u'Activer le TLS pour les clients', 'properties': ('mandatory', 'expert')})
    option_139789496759440.impl_set_information("help", u"""Activer le support du TLS pour les sessions SMTP.
            Le serveur de courrier supportera alors STARTTLS sur le port 25 et écoutera en TLS sur le port 465 pour les clients qui le supportent.
            Passer cette variable à non rend l'authentification SMTP impossible ce qui empêche les utilisateurs d'envoyer des messages.""")
    option_139789496759712 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_exim_relay_smtp', 'default': 'oui', 'doc': u'Router les courriels par une passerelle SMTP', 'properties': ('mandatory', 'basic')})
    option_139789496759712.impl_set_information("separator", ('Relai des messages', None))
    option_139789496759712.impl_set_information("help", u"""Activer l’utilisation d’une passerelle SMTP pour l’envoi
            des courriers électroniques vers l’extérieurs. Si cette option est
            désactivée, le réseau doit autoriser le protocole SMTP
            depuis ce serveur vers Internet.""")
    option_139789496759984 = DomainnameOption(**{'multi': False, 'name': 'exim_relay_smtp', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Passerelle SMTP', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496759712}]})
    option_139789496759984.impl_set_information("help", u"""Passerelle SMTP utilisée pour l’envoi des courriers électroniques vers
            l’extérieur. Le protocole SMTP doit être autorisé entre
            le serveur local et cette passerelle.""")
    option_139789496760256 = ChoiceOption(**{'multi': False, 'values': (u'non', u'port 25', u'port 465'), 'name': 'tls_smtp', 'default': u'non', 'doc': u'Utilisation du TLS (SSL) par la passerelle SMTP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496759712}]})
    option_139789496760256.impl_set_information("help", u"""Si la passerelle SMTP accepte le TLS, choisir le port en
            fonction du support de la commande STARTTLS (port 25) ou
            non (port 465)""")
    option_139789496760528 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_relay', 'default': 'non', 'doc': u'Activer le relai des messages', 'properties': ('mandatory', 'expert')})
    option_139789496760528.impl_set_information("help", u"""Activer la configuration manuelle du relai des courriers électroniques.
            Cette variable permet d’activer :
            - Les listes d’adresses IP autorisées à utiliser ce serveur comme relai de messagerie.
            - La liste des noms de domaines autorisées à être relayés par ce serveur.
            Si vous n’êtes pas sûr, mettre la valeur « non ».""")
    option_139789496760800 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_relay_dhcp', 'default': 'non', 'doc': u'Relayer les courriers \xe9lectroniques pour toutes les plages d\xe9finies dans le DHCP', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956016}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496760528}]})
    option_139789496760800.impl_set_information("help", u"""Activer le relai des courriers électroniques pour les plages d’adresses
            définies dans la configuration DHCP.
            Si toutes les plages d’adresses ne sont pas autoriser à
            utiliser ce serveur comme relai de messagerie, vous devez
            spécifier « non » et activer le relai manuel.""")
    option_139789496761072 = UnicodeOption(**{'doc': u'Relayer les courriers \xe9lectroniques pour des plages d\u2019adresses IPv4', 'multi': True, 'properties': ('expert',), 'name': 'exim_relay_cidrv4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496760528}]})
    option_139789496761072.impl_set_information("help", u"""Liste des adresses IPv4 autorisées à utiliser ce serveur comme
            relai de messagerie.
            Les adresses doivent être spécifiés en notation CIDR.""")
    option_139789496761344 = UnicodeOption(**{'doc': u'Relayer les courriers \xe9lectroniques pour des plages d\u2019adresses IPv6', 'multi': True, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'exim_relay_cidrv6'})
    option_139789496761344.impl_set_information("help", u"""Liste des adresses IPv6 autorisées à utiliser ce serveur comme
            relai de messagerie.
            Les adresses doivent être spécifiés en notation CIDR.
            À l’heure actuelle, ce paramètre n’ayant aucun effet il est caché.""")
    option_139789496761616 = UnicodeOption(**{'doc': u'Relayer les courriers \xe9lectroniques pour des nom de domaines', 'multi': True, 'properties': ('expert',), 'name': 'exim_relay_domains', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496760528}]})
    option_139789496761616.impl_set_information("help", u"""Liste des noms de domaines autorisées à être relayés par ce
            serveur.
            Ce paramètre est utilisé pour des MX secondaires ou un frontal
            à plusieurs domaines de messagerie.
            La syntaxe autorise le joker « * » et bien plus encore
            (http://exim.org/exim-html-current/doc/html/spec_html/ch10.html#SECTdomainlist)
            Si vous n’êtes pas sûr, laissez vide.""")
    option_139789496761888 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_relay_manual_routes', 'default': 'non', 'doc': u'Activer le relai avec des routes manuelles (EAD)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496761888.impl_set_information("help", u"""Activation du routage manuel des messages en utilisant la
            liste de correspondance « domaine: passerelle SMTP »
            définie dans l’EAD.""")
    option_139789496770640 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_smtp_access', 'doc': u"V\xe9rifie si les ports SMTP doivent \xeatre accessibles depuis l'ext\xe9rieur", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'operator': ParamValue("OR"), 'condition_1': ParamOption(option_139789496748512, False), 'condition_2': ParamOption(option_139789496760528, False)})})
    option_139789496771184 = UnicodeOption(**{'default': u'automatique', 'doc': u'FQDN utilis\xe9 par Exim', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'exim_primary_hostname'})
    option_139789496771184.impl_set_information("proposed_value", (u'automatique', u'nom_machine.domaine_messagerie_etab', u'nom_machine.nom_domaine_local'))
    option_139789496771184.impl_set_information("separator", ('Configuration experte', None))
    option_139789496771184.impl_set_information("help", u"""Nom de domaine complètement qualifié utilisé par Exim dans
            le protocole SMTP. C'est utile pour les
            vérifications anti-spam des MX externes.
            Les valeurs possibles sont :
            - automatique : laisser Exim décider ;
            - nom_machine.domaine_messagerie_etab : utiliser le
              nom de la machine complété par le nom de domaine de la
              messagerie établissement ;
            - nom_machine.nom_domaine_local : utiliser le
              nom de la machine complété par le nom de domaine local.""")
    option_139789496770912 = ChoiceOption(**{'multi': False, 'values': (u'nom de domaine local', u'domaine priv\xe9 de messagerie \xe9tablissement', u'domaine public de messagerie \xe9tablissement'), 'name': 'exim_qualify_domain', 'default': u'nom de domaine local', 'doc': u'Domaine utilis\xe9 pour qualifier les adresses', 'properties': ('mandatory', 'expert')})
    option_139789496770912.impl_set_information("help", u"""Nom de domaine ajouté aux adresses :
            - non qualifiées (sans @DOMAIN) ;
            - qualifié avec un nom de machine sans domaine (@NOM_MACHINE).
            Les valeurs configurables sont :
            - nom de domaine local : correspond à « %%nom_domain_local » ;
            - domaine privé de messagerie établissement : correspond à « i-%%domaine_messagerie_etab » ;
            - domaine public de messagerie établissement : correspond à « %%domaine_messagerie_etab ».
            Si « %%domaine_messagerie_etab » est vide, « %%nom_domain_local » est utilisé.""")
    option_139789496771456 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_use_syslog', 'default': 'oui', 'doc': u'Envoyer les logs par rsyslog', 'properties': ('mandatory', 'expert')})
    option_139789496771456.impl_set_information("help", u"""Activer l’envoi des logs par rsyslog.""")
    option_139789496771728 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_use_log_files', 'default': 'non', 'doc': u'Dupliquer les logs dans des fichiers', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496771456}]})
    option_139789496771728.impl_set_information("help", u"""Dupliquer les logs dans des fichiers gérés directement par
            Exim.
            Si vous envoyez les logs par rsyslog, vous pouvez conserver la
            gestion des fichiers traditionnelles d’Exim.
            Ces fichiers étant gérés directement par Exim, ils se
            trouveront dans le conteneurs du service.""")
    option_139789496772000 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'exim_address_rewrite', 'default': 'non', 'doc': u'Activer les r\xe8gles de r\xe9\xe9criture \xe9tendue', 'properties': ('mandatory', 'expert')})
    option_139789496772000.impl_set_information("help", u"""Permettre de définir des règles de réécriture personnalisées. Si non, seuls les courriers électroniques en 'localhost' sont réécris avec le 'nom_domain_local'. Voir http://exim.org/exim-html-current/doc/html/spec_html/ch31.html.""")
    option_139789496772272 = UnicodeOption(**{'doc': u'Sch\xe9ma de r\xe9\xe9criture', 'multi': True, 'properties': ('expert',), 'name': 'exim_address_rewrite_pattern', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496772000}]})
    option_139789496772272.impl_set_information("help", u"""Modèle de correspondance des adresses courriers électroniques à réécrire.
            http://exim.org/exim-html-current/doc/html/spec_html/ch31.html#SECID151""")
    option_139789496772544 = UnicodeOption(**{'doc': u'Remplacement de r\xe9\xe9criture', 'multi': True, 'properties': ('expert',), 'name': 'exim_address_rewrite_replacement', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496772000}]})
    option_139789496772544.impl_set_information("help", u"""Valeur de remplacement des adresses électroniques.
            http://exim.org/exim-html-current/doc/html/spec_html/ch31.html#SECID152""")
    option_139789496772816 = UnicodeOption(**{'multi': True, 'name': 'exim_address_rewrite_flags', 'doc': u'Drapeau de r\xe9\xe9criture', 'properties': ('expert',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496772000}], "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^[EFTbcfhrstSQqRw\s]*$"),), kwargs={'err_msg': ParamValue(u"Les flags doivent être une série des caractères suivants: EFTbcfhrst S QqRw")})})
    option_139789496772816.impl_set_information("help", u"""Drapeau contrôlant la réécriture des adresses électroniques.
            Voir http://exim.org/exim-html-current/doc/html/spec_html/ch31.html#SECID153""")
    option_139789497259344 = MasterSlaves(children=[option_139789496772272, option_139789496772544, option_139789496772816], **{'doc': u'Sch\xe9ma de r\xe9\xe9criture', 'properties': ('expert',), 'name': 'exim_address_rewrite_pattern'})
    option_139789497259664 = OptionDescription(children=[option_139789496746064, option_139789497138720, option_139789496746608, option_139789496747152, option_139789496746880, option_139789496747424, option_139789496747696, option_139789496747968, option_139789496748240, option_139789496748784, option_139789496746336, option_139789497445920, option_139789496749056, option_139789496749328, option_139789497462864, option_139789496749600, option_139789496748512, option_139789496758352, option_139789496758624, option_139789496758896, option_139789496759168, option_139789496759440, option_139789496759712, option_139789496759984, option_139789496760256, option_139789496760528, option_139789496760800, option_139789496761072, option_139789496761344, option_139789496761616, option_139789496761888, option_139789496770640, option_139789496771184, option_139789496770912, option_139789496771456, option_139789496771728, option_139789496772000, option_139789497259344], **{'doc': u'messagerie', 'properties': ('basic',), 'name': 'messagerie'})
    option_139789497259664.impl_set_information("help", u"""Paramétrage du serveur de messagerie""")
    option_139789497259664.impl_set_information("icon", u"""envelope""")
    option_139789496773088 = ChoiceOption(**{'multi': False, 'values': (u'eole', u'sdet', u'zephir'), 'name': 'ldap_schema', 'default': u'eole', 'doc': u'Sch\xe9ma LDAP utilis\xe9', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496773360 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ldap_replication', 'default': 'non', 'doc': u'Activer la r\xe9plication LDAP (fournisseur)', 'properties': ('mandatory', 'expert')})
    option_139789496773632 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ldap_replication_client', 'default': 'non', 'doc': u'Activer la r\xe9plication LDAP (client)', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496774176 = IntOption(**{'default': 0, 'doc': u'Niveau de log', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_loglevel'})
    option_139789496773904 = IntOption(**{'default': 5000, 'doc': u"Nombre maximum d'entr\xe9es \xe0 retourner lors d'une requ\xeate", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_sizelimit'})
    option_139789496782928 = IntOption(**{'default': 3600, 'doc': u'Temps de r\xe9ponse maximum \xe0 une requ\xeate (en secondes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_timelimit'})
    option_139789496783200 = IntOption(**{'default': 1000, 'doc': u"Taille du cache (en nombre d'entr\xe9es)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ldap_cachesize'})
    option_139789496783472 = ChoiceOption(**{'multi': False, 'values': (u'non', u'oui', u'uniquement'), 'name': 'ldap_ssl', 'default': u'non', 'doc': u'Activer LDAP sur le port SSL', 'properties': ('mandatory', 'expert')})
    option_139789496783472.impl_set_information("help", u"""Permet d'activer LDAP sur le port SSL (636). Si 'uniquement' est choisi, le firewall ne rend accessible que ce port. Le service reste néanmoins accessible en local sur le port 389.""")
    option_139789496783744 = ChoiceOption(**{'multi': False, 'values': (u'tous', u'authentifi\xe9', u'aucun'), 'name': 'ldap_restrict_access', 'default': u'tous', 'doc': u'Utilisateur autoris\xe9 \xe0 acc\xe9der \xe0 distance au serveur LDAP', 'properties': ('mandatory', 'expert')})
    option_139789497259984 = OptionDescription(children=[option_139789496773088, option_139789496773360, option_139789496773632, option_139789496774176, option_139789496773904, option_139789496782928, option_139789496783200, option_139789496783472, option_139789496783744], requires=[{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497955744}], **{'doc': u'openldap', 'properties': ('expert',), 'name': 'openldap'})
    option_139789497259984.impl_set_information("help", u"""Paramétrage de l'annuaire OpenLDAP local""")
    option_139789497259984.impl_set_information("icon", u"""book""")
    option_139789496784016 = FilenameOption(**{'default': u'/var/lib/bareos', 'doc': u"R\xe9pertoire d'extraction de la base de donn\xe9es du catalogue", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'bareos_db_extract_dir'})
    option_139789496784288 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'bareos_db_mysql_password', 'doc': u'Mot de passe de la base de donn\xe9es MySQL de la sauvegarde', 'properties': ('auto_freeze', 'mandatory', 'expert'), 'callback': eosfunc.gen_random, "requires": [{'expected': u'mysql', 'action': 'disabled', 'inverse': True, "option": option_139789497145008}]})
    option_139789496784560 = UnicodeOption(**{'multi': False, 'name': 'bareos_dir_name', 'doc': u'Nom du directeur local', 'properties': ('auto_freeze', 'mandatory', 'basic'), 'callback': eosfunc.concat, 'callback_params': Params(args=None, kwargs={'valeur2': ParamValue("-dir"), 'valeur1': ParamOption(option_139789497890208, False)})})
    option_139789496784560.impl_set_information("help", u"""Nom identifiant le service bareos-dir""")
    option_139789496784832 = IntOption(**{'default': 6, 'doc': u'P\xe9riode de r\xe9tention des sauvegardes compl\xe8tes', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'bareos_full_retention'})
    option_139789496784832.impl_set_information("help", u"""Durée pendant laquelle le contenu des sauvegardes complètes est conservé avant écrasement""")
    option_139789496785104 = ChoiceOption(**{'multi': False, 'values': (u'years', u'months', u'weeks', u'days'), 'name': 'bareos_full_retention_unit', 'default': u'months', 'doc': u'Unit\xe9 de valeur pour la r\xe9tention des sauvegardes compl\xe8tes', 'properties': ('mandatory', 'normal')})
    option_139789496785104.impl_set_information("help", u"""Unité de la durée de rétention pour les sauvegardes complètes""")
    option_139789496785376 = IntOption(**{'default': 5, 'doc': u'P\xe9riode de r\xe9tention des sauvegardes diff\xe9rentielles', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'bareos_diff_retention'})
    option_139789496785376.impl_set_information("help", u"""Durée pendant laquelle le contenu des sauvegardes différentielles est conservé avant écrasement""")
    option_139789496785648 = ChoiceOption(**{'multi': False, 'values': (u'years', u'months', u'weeks', u'days'), 'name': 'bareos_diff_retention_unit', 'default': u'weeks', 'doc': u'Unit\xe9 de valeur pour la r\xe9tention des sauvegardes diff\xe9rentielles', 'properties': ('mandatory', 'normal')})
    option_139789496785648.impl_set_information("help", u"""Unité de la durée de rétention pour les sauvegardes différentielles""")
    option_139789496785920 = IntOption(**{'default': 10, 'doc': u'P\xe9riode de r\xe9tention des sauvegardes incr\xe9mentales', 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'bareos_inc_retention'})
    option_139789496785920.impl_set_information("help", u"""Durée pendant laquelle le contenu des sauvegardes incrémentales est conservé avant écrasement""")
    option_139789496786192 = ChoiceOption(**{'multi': False, 'values': (u'years', u'months', u'weeks', u'days'), 'name': 'bareos_inc_retention_unit', 'default': u'days', 'doc': u'Unit\xe9 de valeur pour la r\xe9tention des sauvegardes incr\xe9mentales', 'properties': ('mandatory', 'normal')})
    option_139789496786192.impl_set_information("help", u"""Unité de la durée de rétention pour les sauvegardes incrémentales""")
    option_139789496786464 = IntOption(**{'default': 86400, 'doc': u"Dur\xe9e maximale pour l'ex\xe9cution compl\xe8te d'une sauvegarde (en secondes)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'bareos_max_run_time'})
    option_139789496786464.impl_set_information("help", u"""Spécifie le délai, en secondes, alloué pour l'exécution complète d'un job depuis son lancement (pas nécessairement à l'heure de sa programmation) jusqu'à sa fin (0 pour pas de limite)""")
    option_139789496791120 = ChoiceOption(**{'multi': False, 'values': (u'Aucune', u'GZIP1', u'GZIP2', u'GZIP3', u'GZIP4', u'GZIP5', u'GZIP6', u'GZIP7', u'GZIP8', u'GZIP9'), 'name': 'bareos_compression', 'default': u'GZIP6', 'doc': u'Niveau de compression des sauvegardes', 'properties': ('mandatory', 'expert')})
    option_139789496791120.impl_set_information("help", u"""Niveau de compression gzip appliqué aux données sauvegardées""")
    option_139789496791392 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'bareos_dir_password', 'doc': u'Mot de passe du directeur', 'properties': ('force_store_value', 'expert'), 'callback': eosfunc.gen_random})
    option_139789496791392.impl_set_information("help", u"""Mot de passe à transmettre aux applications distantes pour leur permettre de s'authentifier auprès du directeur""")
    option_139789496791664 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'bareos_fd_password', 'doc': u'Mot de passe du serveur de fichiers', 'properties': ('force_store_value', 'frozen', 'hidden', 'basic'), 'callback': eosfunc.gen_random})
    option_139789496791936 = ChoiceOption(**{'multi': False, 'name': 'bareos_sd_local', 'doc': u'Le gestionnaire du stockage est local', 'values': (u'oui', u'non'), 'properties': ('normal',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497971040, False)}), "requires": [{'expected': u'non', 'action': 'frozen', 'inverse': False, "option": option_139789497971040}, {'expected': u'non', 'action': 'hidden', 'inverse': False, "option": option_139789497971040}, {'expected': u'non', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497971040}]})
    option_139789496791936.impl_set_information("separator", ('Gestion du stockage', None))
    option_139789496791936.impl_set_information("help", u"""Choix du service bareos-sd gérant l'écriture des volumes de sauvegardes""")
    option_139789496792208 = DomainnameOption(**{'multi': False, 'name': 'bareos_sd_adresse', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Adresse du serveur de stockage distant', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789496791936}]})
    option_139789496792208.impl_set_information("help", u"""Adresse du service bareos-sd gérant l'écriture des volumes de sauvegardes""")
    option_139789496792480 = PasswordOption(**{'callback_params': None, 'multi': False, 'name': 'bareos_sd_password', 'doc': u'Mot de passe du serveur de stockage distant', 'properties': ('force_store_value', 'mandatory', 'basic'), 'callback': eosfunc.gen_random, "requires": [{'expected': u'oui', 'action': 'frozen', 'inverse': False, "option": option_139789496791936}, {'expected': u'oui', 'action': 'hidden', 'inverse': False, "option": option_139789496791936}]})
    option_139789496792480.impl_set_information("help", u"""Mot de passe permettant d'identifier le service bareos-sd du serveur distant (ressource Storage de la configuration du service bareos-dir local)""")
    option_139789497260304 = OptionDescription(children=[option_139789497145008, option_139789496784016, option_139789496784288, option_139789496784560, option_139789496784832, option_139789496785104, option_139789496785376, option_139789496785648, option_139789496785920, option_139789496786192, option_139789496786464, option_139789496791120, option_139789496791392, option_139789496791664, option_139789496791936, option_139789496792208, option_139789496792480], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971584}], **{'doc': u'directeur bareos', 'properties': ('basic',), 'name': 'directeur_bareos'})
    option_139789497260304.impl_set_information("help", u"""Configuration de la sauvegarde du serveur""")
    option_139789497260304.impl_set_information("icon", u"""archive""")
    option_139789496792752 = UnicodeOption(**{'multi': False, 'name': 'bareos_sd_name', 'doc': u'Nom du serveur de stockage', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.concat, 'callback_params': Params(args=None, kwargs={'valeur2': ParamValue("-sd"), 'valeur1': ParamOption(option_139789497890208, False)})})
    option_139789496793024 = UnicodeOption(**{'doc': u'Nom du directeur Bareos distant', 'multi': True, 'properties': ('normal',), 'name': 'bareos_sd_remote_dir_name', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789496793024.impl_set_information("separator", (u'Configuration des acc\xe8s distants au stockage', None))
    option_139789496793024.impl_set_information("help", u"""Nom du service bareos-dir du serveur distant à sauvegarder""")
    option_139789496793296 = DomainnameOption(**{'multi': True, 'name': 'bareos_sd_remote_ip', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Adresse IP du directeur distant', 'properties': ('normal',), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789496793296.impl_set_information("help", u"""Adresse du serveur distant à sauvegarder""")
    option_139789496793568 = PasswordOption(**{'doc': u'Mot de passe Bareos distant', 'multi': True, 'properties': ('normal',), 'name': 'bareos_sd_remote_password'})
    option_139789496793568.impl_set_information("help", u"""Mot de passe permettant d'identifier le service bareos-dir du serveur distant à sauvegarder (ressource Director de la configuration du service bareos-sd local)""")
    option_139789497260624 = MasterSlaves(children=[option_139789496793024, option_139789496793296, option_139789496793568], **{'doc': u'Nom du directeur Bareos distant', 'properties': ('normal',), 'name': 'bareos_sd_remote_dir_name'})
    option_139789497260944 = OptionDescription(children=[option_139789496792752, option_139789497260624], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}], **{'doc': u'stockage bareos', 'properties': ('basic',), 'name': 'stockage_bareos'})
    option_139789497260944.impl_set_information("help", u"""Configuration du service bareos-sd""")
    option_139789497260944.impl_set_information("icon", u"""archive""")
    option_139789496793840 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_squid2', 'default': 'non', 'doc': u'Activer une deuxi\xe8me instance de Squid', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}]})
    option_139789496794112 = UnicodeOption(**{'multi': False, 'name': 'num_dansguardian_instance', 'doc': u'Nombre de filtres web (filtrage web et pare-feu) configurables', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("non"),), kwargs={'mismatch': ParamValue("3"), 'condition_1': ParamOption(option_139789496793840, True), 'match': ParamValue("2")})})
    option_139789496794384 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_freeradius', 'default': 'non', 'doc': u'Activer le service FreeRADIUS', 'properties': ('mandatory', 'normal')})
    option_139789496794384.impl_set_information("help", u"""RADIUS (Remote Authentication Dial-In User Service) est un protocole client-serveur permettant de centraliser des données d'authentification""")
    option_139789497261264 = OptionDescription(children=[option_139789496794112, option_139789497656464, option_139789496793840, option_139789496794384], **{'doc': u'authentification', 'properties': ('basic',), 'name': 'authentification'})
    option_139789497261264.impl_set_information("help", u"""Configuration des authentifications proxy et FreeRADIUS""")
    option_139789497261264.impl_set_information("icon", u"""key""")
    option_139789496794656 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dans_instance_1_active', 'doc': u'dans_instance_1_active', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("1"),), kwargs={'mismatch': ParamValue("non"), 'condition_5': ParamOption(option_139789497352544, True), 'condition_4': ParamOption(option_139789497273072, True), 'condition_1': ParamOption(option_139789497596928, True), 'condition_3': ParamOption(option_139789497746848, True), 'condition_2': ParamOption(option_139789497674752, True), 'operator': ParamValue("OR"), 'match': ParamValue("oui")})})
    option_139789496811600 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dans_instance_2_active', 'doc': u'dans_instance_2_active', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("2"),), kwargs={'mismatch': ParamValue("non"), 'condition_5': ParamOption(option_139789497352544, True), 'condition_4': ParamOption(option_139789497273072, True), 'condition_1': ParamOption(option_139789497596928, True), 'condition_3': ParamOption(option_139789497746848, True), 'condition_2': ParamOption(option_139789497674752, True), 'operator': ParamValue("OR"), 'match': ParamValue("oui")})})
    option_139789496811872 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'dans_instance_3_active', 'doc': u'dans_instance_3_active', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497656464, False), 'match': ParamValue("oui"), 'condition_2': ParamOption(option_139789496793840, True)})})
    option_139789496812144 = ChoiceOption(**{'multi': False, 'values': (u'0', u'1', u'2', u'3', u'4'), 'name': 'dans_num_opt_filters', 'default': u'3', 'doc': u'Nombre de politiques optionnelles de filtrage par zone', 'properties': ('mandatory', 'expert')})
    option_139789496812144.impl_set_information("separator", ('Configuration commune aux deux zones', None))
    option_139789496812144.impl_set_information("help", u"""Nombre de politiques optionnelles (1, 2 et 3) à activer, le diminuer permet un gain de performance""")
    option_139789496812416 = IntOption(**{'multi': False, 'name': 'docbodytimeout', 'default': 20, 'doc': u'Proxy Timeout (ex: Doc Body Timeout)', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"5"), 'maxi': ParamValue(u"100")})})
    option_139789496812416.impl_set_information("help", u"""Délai d'attente TCP entre le proxy et le guardian (Min 5, Max 100)""")
    option_139789496812688 = IntOption(**{'multi': False, 'name': 'docheadertimeout', 'default': 20, 'doc': u'Proxy header exchange (ex: Doc Header Timeout)', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"20"), 'maxi': ParamValue(u"300")})})
    option_139789496812688.impl_set_information("help", u"""Délai d'attente entre le proxy et le guardian (Min 20, Max 300)""")
    option_139789496812960 = IntOption(**{'multi': False, 'name': 'headertimeout', 'default': 55, 'doc': u'Pconn timeout (ex: Header Timeout)', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"5"), 'maxi': ParamValue(u"300")})})
    option_139789496812960.impl_set_information("help", u"""Combien de secondes une connection persistante attend de nouvelles requêtes (Min 5, Max 300)""")
    option_139789496813232 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non', u'admin seulement'), 'name': 'dansguardian_ead_log', 'default': u'non', 'doc': u"Autoriser la consultation des logs li\xe9s au filtrage web dans l'EAD", 'properties': ('mandatory', 'expert')})
    option_139789496813776 = UnicodeOption(**{'default': u'Filtre web 1', 'doc': u"Libell\xe9 du filtre web 1 dans l'EAD", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dansguardian_ead_filtre1'})
    option_139789496813776.impl_set_information("separator", ('Filtre web 1', None))
    option_139789496813504 = IntOption(**{'multi': False, 'name': 'guardian_httpworkers1', 'default': 1000, 'doc': u'Nombre de processus disponibles pour traiter les connexions', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"20"), 'maxi': ParamValue(u"20000")})})
    option_139789496813504.impl_set_information("help", u"""1000 processus convient pour une centaine d'utilisateurs, il est possible d'augmenter le nombre de processus à 5000 pour une structure de taille moyenne, 10000 pour une grosse structure. La valeur est également dépendante du nombre de règles et de la quantité de mémoire RAM disponible. Le nombre maximum de processus est limité à 20000.""")
    option_139789496814048 = FilenameOption(**{'default': u'/var/spool/guardian1', 'doc': u'R\xe9pertoire de cache', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_cachedir1'})
    option_139789496814320 = IntOption(**{'default': 5000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 en m\xe9moire (en Kibibytes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_maxramsize1'})
    option_139789496814592 = IntOption(**{'default': 20000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 sur le disque (en Kibibytes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_maxfilesize1'})
    option_139789496814864 = ChoiceOption(**{'multi': False, 'values': (u'---', u'oui', u'non'), 'name': 'unactive_dansguardian_auth1', 'default': u'---', 'doc': u"D\xe9sactiver les plugins qui logguent l'authentification sur la zone 1", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496815136 = IntOption(**{'default': 50, 'doc': u'Limite de pond\xe9ration du filtrage', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'naughtynesslimit1'})
    option_139789496815136.impl_set_information("help", u"""Limite de pondération du filtrage des pages, chaque élément de la page reçoit un score, la somme est faite et si le score est supérieur à cette limite la page est bloquée (jeunes enfants : 50, enfants : 100, jeunes adultes : 160)""")
    option_139789496819792 = UnicodeOption(**{'default': u'Filtre web 2', 'doc': u"Libell\xe9 du filtre web 2 dans l'EAD", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dansguardian_ead_filtre2'})
    option_139789496819792.impl_set_information("separator", ('Filtre web 2', None))
    option_139789496820064 = IntOption(**{'multi': False, 'name': 'guardian_httpworkers2', 'default': 1000, 'doc': u'Nombre de processus disponibles pour traiter les connexions', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"20"), 'maxi': ParamValue(u"20000")})})
    option_139789496820064.impl_set_information("help", u"""1000 processus convient pour une centaine d'utilisateurs, il est possible d'augmenter le nombre de processus à 5000 pour une structure de taille moyenne, 10000 pour une grosse structure. La valeur est également dépendante du nombre de règles et de la quantité de mémoire RAM disponible. Le nombre maximum de processus est limité à 20000.""")
    option_139789496820336 = FilenameOption(**{'default': u'/var/spool/guardian2', 'doc': u'R\xe9pertoire de cache', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_cachedir2'})
    option_139789496820608 = IntOption(**{'default': 5000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 en m\xe9moire (en Kibibytes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_maxramsize2'})
    option_139789496820880 = IntOption(**{'default': 20000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 sur le disque (en Kibibytes)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dans_maxfilesize2'})
    option_139789496821152 = ChoiceOption(**{'multi': False, 'values': (u'---', u'oui', u'non'), 'name': 'unactive_dansguardian_auth2', 'default': u'---', 'doc': u"D\xe9sactiver les plugins qui logguent l'authentification sur la zone 2", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496821424 = IntOption(**{'default': 50, 'doc': u'Limite de pond\xe9ration du filtrage', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'naughtynesslimit2'})
    option_139789496821424.impl_set_information("help", u"""Limite de pondération du filtrage des pages, chaque élément de la page reçoit un score, la somme est faite et si le score est supérieur à cette limite la page est bloquée (jeunes enfants : 50, enfants : 100, jeunes adultes : 160)""")
    option_139789496821696 = UnicodeOption(**{'multi': False, 'name': 'dansguardian_ead_filtre3', 'default': u'Filtre web 3', 'doc': u"Libell\xe9 du filtre web 3 dans l'EAD", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496821696.impl_set_information("separator", ('Filtre web 3', None))
    option_139789496821968 = IntOption(**{'multi': False, 'name': 'guardian_httpworkers3', 'default': 1000, 'doc': u'Nombre de processus disponibles pour traiter les connexions', 'properties': ('mandatory', 'expert'), "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"20"), 'maxi': ParamValue(u"20000")})})
    option_139789496821968.impl_set_information("help", u"""1000 processus convient pour une centaine d'utilisateurs, il est possible d'augmenter le nombre de processus à 5000 pour une structure de taille moyenne, 10000 pour une grosse structure. La valeur est également dépendante du nombre de règles et de la quantité de mémoire RAM disponible. Le nombre maximum de processus est limité à 20000.""")
    option_139789496822240 = PortOption(**{'multi': False, 'name': 'dansguardian_port3', 'allow_private': True, 'default': 3129, 'doc': u"Port d'\xe9coute pour le 3\xe8me filtre web", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496822512 = FilenameOption(**{'multi': False, 'name': 'dans_cachedir3', 'default': u'/var/spool/guardian3', 'doc': u'R\xe9pertoire de cache', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496822784 = IntOption(**{'multi': False, 'name': 'dans_maxramsize3', 'default': 5000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 en m\xe9moire (en Kibibytes)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496823056 = IntOption(**{'multi': False, 'name': 'dans_maxfilesize3', 'default': 20000, 'doc': u'Taille maximum de fichier \xe0 scanner conserv\xe9 sur le disque (en Kibibytes)', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496823328 = ChoiceOption(**{'multi': False, 'values': (u'---', u'oui', u'non'), 'name': 'unactive_dansguardian_auth3', 'default': u'---', 'doc': u"D\xe9sactiver les plugins qui logguent l'authentification sur la zone 3", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert')})
    option_139789496832080 = IntOption(**{'multi': False, 'name': 'naughtynesslimit3', 'default': 50, 'doc': u'Limite de pond\xe9ration du filtrage', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496832080.impl_set_information("help", u"""Limite de pondération du filtrage des pages, chaque élément de la page reçoit un score, la somme est faite et si le score est supérieur à cette limite la page est bloquée (jeunes enfants : 50, enfants : 100, jeunes adultes : 160)""")
    option_139789497261584 = OptionDescription(children=[option_139789496794656, option_139789496811600, option_139789496811872, option_139789496812144, option_139789496812416, option_139789496812688, option_139789496812960, option_139789496813232, option_139789496813776, option_139789496813504, option_139789496814048, option_139789496814320, option_139789496814592, option_139789496814864, option_139789496815136, option_139789496819792, option_139789496820064, option_139789496820336, option_139789496820608, option_139789496820880, option_139789496821152, option_139789496821424, option_139789496821696, option_139789496821968, option_139789496822240, option_139789496822512, option_139789496822784, option_139789496823056, option_139789496823328, option_139789496832080], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}], **{'doc': u'filtrage web', 'properties': ('expert',), 'name': 'filtrage_web'})
    option_139789497261584.impl_set_information("help", u"""Configuration avancée du logiciel de filtrage e2guardian""")
    option_139789497261584.impl_set_information("icon", u"""code-fork""")
    option_139789496832352 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'lightsquid_auto', 'default': 'non', 'doc': u'G\xe9n\xe9rer les statistiques Squid automatiquement', 'properties': ('mandatory', 'expert')})
    option_139789496832352.impl_set_information("help", u"""LightSquid est un analyseur de le log Squid permettant d'afficher sous forme de pages web l'utilisation du proxy""")
    option_139789496832624 = PortOption(**{'multi': False, 'name': 'lightsquid_port', 'allow_private': True, 'default': 8062, 'doc': u"Port d'\xe9coute du CGI LightSquid", 'properties': ('mandatory', 'expert')})
    option_139789496832896 = ChoiceOption(**{'multi': False, 'values': (u'aucune', u'par IP', u'anonyme'), 'name': 'lightsquid_anon_mode', 'default': u'aucune', 'doc': u'M\xe9thode d\u2019anonymisation des rapports LightSquid', 'properties': ('mandatory', 'expert')})
    option_139789496832896.impl_set_information("help", u"""Méthode d’anonimisation des rapports LightSquid :
        - aucune : le nom d’utilisateur est utilisé s’il est disponible
        - par IP : les rapports sont générés par adresse IP
        - anonyme : le nom « anonyme » est utilisé à la place du nom et de l’adresse IP""")
    option_139789496833168 = PortOption(**{'doc': u"Port d'\xe9coute HTTPS de Squid", 'multi': False, 'properties': ('expert',), 'allow_private': True, 'name': 'https_port'})
    option_139789496833440 = PortOption(**{'doc': u'"SSL_ports" suppl\xe9mentaire', 'multi': True, 'properties': ('expert',), 'allow_private': True, 'name': 'ssl_ports'})
    option_139789496833712 = PortOption(**{'doc': u'"Safe_ports" suppl\xe9mentaire', 'multi': True, 'properties': ('expert',), 'allow_private': True, 'name': 'safe_ports'})
    option_139789496833984 = IntOption(**{'default': 20, 'doc': u"Nombre de processus associ\xe9s au module d'authentification basique", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'number_of_basic_children'})
    option_139789496834256 = IntOption(**{'default': 20, 'doc': u"Nombre de processus associ\xe9s au module d'authentification NTLM", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'number_of_ntlm_children'})
    option_139789496834528 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'squid_nopeerproxy_url_regex', 'default': 'non', 'doc': u'Activer les exceptions de cache p\xe8re de type regexp', 'properties': ('mandatory', 'expert')})
    option_139789496834800 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_proxy_refresh_pattern', 'default': 'non', 'doc': u'Personnaliser s\xe9lectivement la dur\xe9e des caches', 'properties': ('mandatory', 'expert')})
    option_139789496834800.impl_set_information("help", u"""La directive refresh_pattern permet de personnaliser l'algorithme de gestion du rafraîchissement du cache par site""")
    option_139789496835072 = UnicodeOption(**{'doc': u'Expression rationnelle pour le site', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'proxy_refresh_pattern_regexp', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}]})
    option_139789496835344 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'proxy_refresh_pattern_case_sensitive', 'default_multi': 'non', 'doc': u"L'expression rationnelle est sensible \xe0 la casse", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}]})
    option_139789496835616 = IntOption(**{'doc': u'Temps minimum de cache (en minutes)', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'proxy_refresh_pattern_min', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}]})
    option_139789496835616.impl_set_information("help", u"""Temps minimum de cache d'un objet sans expiration explicite en-deça duquel l'objet est déclaré \"frais\"""")
    option_139789496840272 = IntOption(**{'multi': True, 'name': 'proxy_refresh_pattern_pourcent', 'doc': u"Rapport entre l'\xe2ge de l'objet dans le cache et son \xe2ge sur le site (en pourcent)", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}], "validator": eosfunc.valid_entier, 'validator_params': Params(args=None, kwargs={'mini': ParamValue(u"0"), 'maxi': ParamValue(u"100")})})
    option_139789496840272.impl_set_information("help", u"""Rapport entre l'âge de l'objet dans le cache et son âge sur le site en-deça duquel l'objet est déclaré \"frais\"""")
    option_139789496840544 = IntOption(**{'doc': u'Temps maximum de cache (en minutes)', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'proxy_refresh_pattern_max', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}]})
    option_139789496840544.impl_set_information("help", u"""Temps maximum de cache d'un objet sans expiration explicite au-delà duquel l'objet est déclaré \"périmé\"""")
    option_139789496840816 = UnicodeOption(**{'doc': u'Options', 'multi': True, 'properties': ('expert',), 'name': 'proxy_refresh_pattern_options', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496834800}]})
    option_139789496852560 = MasterSlaves(children=[option_139789496835072, option_139789496835344, option_139789496835616, option_139789496840272, option_139789496840544, option_139789496840816], **{'doc': u'Expression rationnelle pour le site', 'properties': ('expert',), 'name': 'proxy_refresh_pattern_regexp'})
    option_139789496841088 = PortOption(**{'multi': False, 'name': 'icp_port', 'allow_private': True, 'default': 3130, 'doc': u"Port d'\xe9coute pour les requ\xeates ICP", 'properties': ('mandatory', 'expert')})
    option_139789496841360 = PortOption(**{'multi': False, 'name': 'htcp_port', 'allow_private': True, 'default': 4827, 'doc': u"Port d'\xe9coute pour les requ\xeates HTCP", 'properties': ('mandatory', 'expert')})
    option_139789496841632 = IntOption(**{'default': 0, 'doc': u'Timout pour les requ\xeates ICP (en msec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'icp_query_timeout'})
    option_139789496841904 = IntOption(**{'default': 2000, 'doc': u'Maximum_icp_query_timeout (en msec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'maximum_icp_query_timeout'})
    option_139789496842176 = UnicodeOption(**{'doc': u'Groupe de serveurs multicast', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'expert'), 'name': 'mcast_groups'})
    option_139789496842448 = IntOption(**{'default': 2000, 'doc': u'Mcast_icp_query_timeout (en msec)', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert'), 'name': 'mcast_icp_query_timeout'})
    option_139789496842720 = IntOption(**{'default': 10, 'doc': u'Dead_peer_timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'dead_peer_timeout'})
    option_139789496842992 = IntOption(**{'default': 25, 'doc': u'Nombre maximum de redirections test\xe9es', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'forward_max_tries'})
    option_139789496843264 = IntOption(**{'default': 256, 'doc': u'Taille maximale de la m\xe9moire cache (en MB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cache_mem'})
    option_139789496843536 = IntOption(**{'default': 90, 'doc': u'Cache_swap_low (en %)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cache_swap_low'})
    option_139789496843808 = IntOption(**{'default': 95, 'doc': u'Cache_swap_high (en %)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cache_swap_high'})
    option_139789496856656 = IntOption(**{'default': 0, 'doc': u'Minimum_object_size (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'minimum_object_size'})
    option_139789496856928 = IntOption(**{'default': 32768, 'doc': u'Maximum_object_size (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'maximum_object_size'})
    option_139789496857200 = IntOption(**{'default': 512, 'doc': u"Taille maximum d'un objet \xe0 mettre en cache (en KB)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'maximum_object_size_in_memory'})
    option_139789496857472 = IntOption(**{'default': 1024, 'doc': u"Ipcache_size (en nombre d'entr\xe9es)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipcache_size'})
    option_139789496857744 = IntOption(**{'default': 90, 'doc': u'Ipcache_low (en %)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipcache_low'})
    option_139789496858016 = IntOption(**{'default': 95, 'doc': u'Ipcache_high (en %)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ipcache_high'})
    option_139789496858288 = IntOption(**{'default': 1024, 'doc': u"Fqdncache_size (en nombre d'entr\xe9es)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'fqdncache_size'})
    option_139789496858560 = ChoiceOption(**{'multi': False, 'values': (u'lru', u'heap GDSF', u'heap LFUDA', u'heap LRU'), 'name': 'cache_replacement_policy', 'default': u'lru', 'doc': u'Cache_replacement_policy', 'properties': ('mandatory', 'expert')})
    option_139789496858832 = ChoiceOption(**{'multi': False, 'values': (u'lru', u'heap GDSF', u'heap LFUDA', u'heap LRU'), 'name': 'memory_replacement_policy', 'default': u'lru', 'doc': u'Memory_replacement_policy', 'properties': ('mandatory', 'expert')})
    option_139789496859104 = FilenameOption(**{'default': [u'/var/spool/squid'], 'doc': u'Emplacement du cache', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir'})
    option_139789496859376 = ChoiceOption(**{'multi': True, 'values': (u'ufs',), 'name': 'cache_dir_type', 'default_multi': u'ufs', 'doc': u'Type de stockage utilis\xe9', 'properties': ('mandatory', 'expert')})
    option_139789496859648 = UnicodeOption(**{'default_multi': u'1000', 'doc': u'Taille du cache (en MBytes)', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_disk_space'})
    option_139789496859920 = UnicodeOption(**{'default_multi': u'16', 'doc': u'Nombre maximum de r\xe9pertoires de niveau 1', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_firstLevel'})
    option_139789496860192 = UnicodeOption(**{'default_multi': u'256', 'doc': u'Nombre maximum de r\xe9pertoires de niveau 2', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_secondLevel'})
    option_139789496852880 = MasterSlaves(children=[option_139789496859104, option_139789496859376, option_139789496859648, option_139789496859920, option_139789496860192], **{'doc': u'Emplacement du cache', 'properties': ('expert',), 'name': 'cache_dir'})
    option_139789496868944 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'log_mime_hdrs', 'default': 'off', 'doc': u'Log_mime_hdrs', 'properties': ('mandatory', 'expert')})
    option_139789496869216 = NetmaskOption(**{'default': u'255.255.255.255', 'doc': u'Masque r\xe9seau des clients ', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'client_netmask'})
    option_139789496869488 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'strip_query_terms', 'default': 'off', 'doc': u'Activer la r\xe9duction URLs dans les logs', 'properties': ('mandatory', 'expert')})
    option_139789496869760 = UsernameOption(**{'default': 'ftp', 'doc': u'Utilisateur FTP', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_user'})
    option_139789496870032 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'ftp_passive', 'default': 'on', 'doc': u'Autoriser les connexions FTP passives', 'properties': ('mandatory', 'expert')})
    option_139789496870304 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'ftp_sanitycheck', 'default': 'on', 'doc': u'Activer la v\xe9rification des connexions FTP', 'properties': ('mandatory', 'expert')})
    option_139789496870576 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'ftp_telnet_protocol', 'default': 'on', 'doc': u'Ftp_telnet_protocol', 'properties': ('mandatory', 'expert')})
    option_139789496870848 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'check_hostname', 'default': 'off', 'doc': u"Activer la v\xe9rification des noms d'h\xf4te", 'properties': ('mandatory', 'expert')})
    option_139789496871120 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'allow_underscore', 'default': 'on', 'doc': u"Autoriser les underscore dans les noms d'h\xf4te", 'properties': ('mandatory', 'expert')})
    option_139789496871392 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'dns_defnames', 'default': 'off', 'doc': u'Dns_defnames', 'properties': ('mandatory', 'expert')})
    option_139789496871664 = DomainnameOption(**{'type_': 'domainname', 'name': 'dns_nameservers', 'doc': u'Utiliser un DNS sp\xe9cifique', 'allow_ip': True, 'allow_without_dot': True, 'multi': True, 'properties': ('expert',)})
    option_139789496871936 = FilenameOption(**{'default': u'/etc/hosts', 'doc': u'Emplacement du fichier hosts', 'multi': False, 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'expert'), 'name': 'hosts_file'})
    option_139789496872208 = IntOption(**{'default': 64, 'doc': u'Taille maximum des en-t\xeates HTTP dans une requ\xeate (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'request_header_max_size'})
    option_139789496872480 = IntOption(**{'default': 0, 'doc': u"Taille maximum d'un corps de requ\xeate HTTP (en MB)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'request_body_max_size'})
    option_139789496877136 = IntOption(**{'default': 16, 'doc': u'Quick_abort_min (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'quick_abort_min'})
    option_139789496877408 = IntOption(**{'default': 16, 'doc': u'Quick_abort_max (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'quick_abort_max'})
    option_139789496877680 = IntOption(**{'default': 95, 'doc': u'Quick_abort_pct (en %)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'quick_abort_pct'})
    option_139789496877952 = IntOption(**{'default': 16, 'doc': u'Read_ahead_gap (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'read_ahead_gap'})
    option_139789496878224 = IntOption(**{'default': 0, 'doc': u'Time-to-Live par d\xe9faut pour les requ\xeates en \xe9chec (en min)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'negative_ttl'})
    option_139789496878496 = IntOption(**{'default': 6, 'doc': u'Positive_dns_ttl (en heures)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'positive_dns_ttl'})
    option_139789496878768 = IntOption(**{'default': 1, 'doc': u'Negative_dns_ttl (en min)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'negative_dns_ttl'})
    option_139789496879040 = IntOption(**{'default': 0, 'doc': u'Range_offset_limit (en KB)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'range_offset_limit'})
    option_139789496879312 = IntOption(**{'default': 240, 'doc': u'Forward timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'forward_timeout'})
    option_139789496879584 = IntOption(**{'default': 60, 'doc': u'Connect timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'connect_timeout'})
    option_139789496879856 = IntOption(**{'default': 30, 'doc': u'Peer connect timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'peer_connect_timeout'})
    option_139789496880128 = IntOption(**{'default': 900, 'doc': u'Read timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'read_timeout'})
    option_139789496880400 = IntOption(**{'default': 300, 'doc': u'Request timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'request_timeout'})
    option_139789496880672 = IntOption(**{'default': 120, 'doc': u'Persistent request timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'persistent_request_timeout'})
    option_139789496885328 = IntOption(**{'default': 1440, 'doc': u'Dur\xe9e maximum pendant laquelle un client peut rester connect\xe9 au cache (en min)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'client_lifetime'})
    option_139789496885600 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'half_closed_clients', 'default': 'off', 'doc': u'Half_closed_clients', 'properties': ('mandatory', 'expert')})
    option_139789496885872 = IntOption(**{'default': 60, 'doc': u'Timout pour les connexions persistantes (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'pconn_timeout'})
    option_139789496886144 = IntOption(**{'default': 10, 'doc': u'Ident_timeout (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ident_timeout'})
    option_139789496886416 = IntOption(**{'default': 30, 'doc': u'Shutdown_lifetime (en sec)', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'shutdown_lifetime'})
    option_139789496853200 = OptionDescription(children=[option_139789496832352, option_139789496832624, option_139789496832896, option_139789496833168, option_139789496833440, option_139789496833712, option_139789496833984, option_139789496834256, option_139789496834528, option_139789496834800, option_139789496852560, option_139789496841088, option_139789496841360, option_139789496841632, option_139789496841904, option_139789496842176, option_139789496842448, option_139789496842720, option_139789496842992, option_139789496843264, option_139789496843536, option_139789496843808, option_139789496856656, option_139789496856928, option_139789496857200, option_139789496857472, option_139789496857744, option_139789496858016, option_139789496858288, option_139789496858560, option_139789496858832, option_139789496852880, option_139789496868944, option_139789496869216, option_139789496869488, option_139789496869760, option_139789496870032, option_139789496870304, option_139789496870576, option_139789496870848, option_139789496871120, option_139789496871392, option_139789496871664, option_139789496871936, option_139789496872208, option_139789496872480, option_139789496877136, option_139789496877408, option_139789496877680, option_139789496877952, option_139789496878224, option_139789496878496, option_139789496878768, option_139789496879040, option_139789496879312, option_139789496879584, option_139789496879856, option_139789496880128, option_139789496880400, option_139789496880672, option_139789496885328, option_139789496885600, option_139789496885872, option_139789496886144, option_139789496886416], **{'doc': u'squid', 'properties': ('expert',), 'name': 'squid'})
    option_139789496853200.impl_set_information("help", u"""Configuration du proxy Squid""")
    option_139789496853200.impl_set_information("icon", u"""code-fork""")
    option_139789496886688 = PortOption(**{'multi': False, 'name': 'proxy2_port', 'allow_private': True, 'doc': u"Port d'\xe9coute de la seconde instance de Squid", 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_val_first_value, 'callback_params': Params(args=(ParamOption(option_139789496822240, True), ParamValue("3129")), kwargs={}), "requires": [{'expected': u'oui', 'action': 'frozen', 'inverse': False, "option": option_139789497941264}, {'expected': u'oui', 'action': 'hidden', 'inverse': False, "option": option_139789497941264}, {'expected': u'oui', 'action': 'force_default_on_freeze', 'inverse': False, "option": option_139789497941264}]})
    option_139789496886960 = FilenameOption(**{'default': [u'/var/spool/squid2'], 'doc': u'Emplacement du cache', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_2'})
    option_139789496887232 = ChoiceOption(**{'multi': True, 'values': (u'ufs',), 'name': 'cache_dir_type_2', 'default_multi': u'ufs', 'doc': u'Type de stockage utilis\xe9', 'properties': ('mandatory', 'expert')})
    option_139789496887504 = IntOption(**{'default_multi': 1000, 'doc': u'Taille du cache (en MBytes)', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_disk_space_2'})
    option_139789496887776 = IntOption(**{'default_multi': 16, 'doc': u'Nombre maximum de r\xe9pertoires de niveau 1', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_firstLevel_2'})
    option_139789496888048 = IntOption(**{'default_multi': 256, 'doc': u'Nombre maximum de r\xe9pertoires de niveau 2', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'cache_dir_secondLevel_2'})
    option_139789496853520 = MasterSlaves(children=[option_139789496886960, option_139789496887232, option_139789496887504, option_139789496887776, option_139789496888048], **{'doc': u'Emplacement du cache', 'properties': ('expert',), 'name': 'cache_dir_2'})
    option_139789496853840 = OptionDescription(children=[option_139789496886688, option_139789496853520], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}], **{'doc': u'squid2', 'properties': ('expert',), 'name': 'squid2'})
    option_139789496853840.impl_set_information("help", u"""Configuration de la seconde instance du proxy Squid""")
    option_139789496853840.impl_set_information("icon", u"""code-fork""")
    option_139789496888320 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldap1', 'doc': u'Adresse du premier serveur LDAP', 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_container, 'callback_params': Params(args=(ParamOption(option_139789497889120, False), ParamOption(option_139789497852256, False)), kwargs={}), "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496888592 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldap2', 'doc': u'Adresse du second serveur LDAP (si le 1er ne r\xe9pond pas)', 'properties': ('normal',), "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496888864 = UnicodeOption(**{'multi': False, 'name': 'proxy_ldap_base_dn', 'doc': u"Suffixe racine de l'annuaire LDAP (base DN)", 'properties': ('mandatory', 'basic'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497484976, False)}), "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496893520 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldapad', 'doc': u'Adresse IP du serveur LDAP (Active Directory)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496893792 = UnicodeOption(**{'doc': u"Suffixe racine de l'annuaire LDAP (base DN Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_base_dn', "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496894064 = UnicodeOption(**{'doc': u"Nom du compte n\xe9cessaire pour l'interrogation LDAP (Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_user', "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496894336 = PasswordOption(**{'doc': u"Mot de passe du compte n\xe9cessaire pour l'interrogation LDAP (Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_passwd', "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496894608 = DomainnameOption(**{'multi': False, 'name': 'nom_serveur_smb', 'doc': u'Nom du contr\xf4leur de domaine SMB', 'warnings_only': True, 'type_': 'netbios', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497890480, False)}), "requires": [{'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496894880 = DomainnameOption(**{'multi': False, 'name': 'nom_domaine_smb', 'doc': u'Nom du domaine SMB', 'warnings_only': True, 'type_': 'netbios', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497056256, False)}), "requires": [{'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496895152 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_smb', 'doc': u'Adresse IP du contr\xf4leur de domaine SMB', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_container, 'callback_params': Params(args=(ParamOption(option_139789497889120, False), ParamOption(option_139789497854704, False)), kwargs={}), "requires": [{'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496895424 = DomainnameOption(**{'type_': 'hostname', 'name': 'nom_serveur_krb', 'doc': u'Nom du contr\xf4leur de domaine KERBEROS', 'allow_ip': False, 'multi': False, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496895696 = DomainnameOption(**{'multi': False, 'name': 'nom_domaine_krb', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom du domaine KERBEROS (fqdn)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496895968 = DomainnameOption(**{'type_': 'netbios', 'name': 'nom_domaine_windows', 'doc': u'Nom du domaine Windows', 'multi': False, 'warnings_only': True, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496896240 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_krb', 'doc': u'Adresse IP du contr\xf4leur de domaine KERBEROS', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496854160 = OptionDescription(children=[option_139789497574544, option_139789496888320, option_139789496888592, option_139789496888864, option_139789496893520, option_139789496893792, option_139789496894064, option_139789496894336, option_139789496894608, option_139789496894880, option_139789496895152, option_139789496895424, option_139789496895696, option_139789496895968, option_139789496896240, option_139789497574816, option_139789497575088], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497656464}], **{'doc': u'proxy authentifi\xe9', 'properties': ('basic',), 'name': 'proxy_authentifie'})
    option_139789496854160.impl_set_information("help", u"""Configuration du proxy authentifié""")
    option_139789496854160.impl_set_information("icon", u"""key""")
    option_139789496896512 = ChoiceOption(**{'multi': False, 'values': (u'Ldap', u'Ldap (Active Directory)'), 'name': 'type_squid_auth_2', 'default': u'Ldap', 'doc': u"Type d'authentification", 'properties': ('mandatory', 'normal')})
    option_139789496896784 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldap1_2', 'doc': u'Adresse du premier serveur LDAP', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497484704, False)}), "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496897056 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldap2_2', 'doc': u'Adresse du second serveur LDAP (si le 1er ne r\xe9pond pas)', 'properties': ('normal',), "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496918096 = UnicodeOption(**{'multi': False, 'name': 'proxy_ldap_base_dn_2', 'doc': u"Suffixe racine de l'annuaire LDAP (base DN)", 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497484976, False)}), "requires": [{'expected': u'Ldap (Active Directory)', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496918368 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'ip_serveur_ldapad_2', 'doc': u'Adresse IP du serveur LDAP (Active Directory)', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496918640 = UnicodeOption(**{'doc': u"Suffixe racine de l'annuaire LDAP (base DN Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_base_dn_2', "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496918912 = UnicodeOption(**{'doc': u"Nom du compte n\xe9cessaire pour l'interrogation LDAP (Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_user_2', "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496919184 = PasswordOption(**{'doc': u"Mot de passe du compte n\xe9cessaire pour l'interrogation LDAP (Active Directory)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'ldapad_passwd_2', "requires": [{'expected': u'Ldap', 'action': 'disabled', 'inverse': False, "option": option_139789496896512}]})
    option_139789496854480 = OptionDescription(children=[option_139789496896512, option_139789496896784, option_139789496897056, option_139789496918096, option_139789496918368, option_139789496918640, option_139789496918912, option_139789496919184], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}], **{'doc': u'proxy authentifi\xe9 2', 'properties': ('basic',), 'name': 'proxy_authentifie_2'})
    option_139789496854480.impl_set_information("help", u"""Configuration de l'authentification sur la seconde instance du proxy Squid""")
    option_139789496854480.impl_set_information("icon", u"""key""")
    option_139789496919456 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'cups_pdf', 'default': 'oui', 'doc': u"Activation de l'imprimante virtuelle PDF", 'properties': ('mandatory', 'expert')})
    option_139789496919728 = UnicodeOption(**{'multi': False, 'name': 'cups_pdf_name', 'default': u'PDF', 'doc': u"Nom de l'imprimante virtuelle PDF", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496919456}], "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^[A-Za-z0-9_-]*$"),), kwargs={'err_msg': ParamValue(u"Seuls les caractères alphanumériques, _ et - sont autorisés")})})
    option_139789496920000 = ChoiceOption(**{'multi': False, 'values': (u'true', u'false'), 'name': 'cups_pdf_shared', 'default': u'true', 'doc': u"L'imprimante virtuelle PDF est partag\xe9e", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496919456}]})
    option_139789496920272 = ChoiceOption(**{'multi': False, 'values': (u'alert', u'crit', u'debug2', u'debug', u'emerg', u'error', u'info', u'none', u'notice', u'warn'), 'name': 'cups_loglevel', 'default': u'warn', 'doc': u'Niveau de log', 'properties': ('mandatory', 'expert')})
    option_139789496920816 = ChoiceOption(**{'multi': False, 'values': (u'on', u'off'), 'name': 'cups_browsing', 'default': 'on', 'doc': u'Activer la r\xe9cup\xe9ration des informations des imprimantes distantes', 'properties': ('mandatory', 'expert')})
    option_139789496920544 = IntOption(**{'default': 100, 'doc': u"Nombre maximum de copies qu'un utilisateur peut effectuer pour un travail d'impression", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cups_maxcopies'})
    option_139789496921088 = IntOption(**{'default': 500, 'doc': u'Nombre maximum de travaux simultan\xe9s', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cups_maxjobs'})
    option_139789496921360 = IntOption(**{'default': 100, 'doc': u'Nombre maximum de clients simultan\xe9s', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'cups_maxclients'})
    option_139789496921632 = ChoiceOption(**{'multi': False, 'values': (u'Yes', u'No'), 'name': 'cups_preservejobhistory', 'default': u'Yes', 'doc': u"Conserver l'historique des demandes d'impression", 'properties': ('mandatory', 'expert')})
    option_139789496930384 = ChoiceOption(**{'multi': False, 'values': (u'Yes', u'No'), 'name': 'cups_preservejobfiles', 'default': u'No', 'doc': u'Conserver les fichiers apr\xe8s impression', 'properties': ('mandatory', 'expert')})
    option_139789496930656 = ChoiceOption(**{'multi': False, 'values': (u'Yes', u'No'), 'name': 'cups_autopurgejobs', 'default': u'No', 'doc': u"Purger automatiquement l'historique des travaux", 'properties': ('mandatory', 'expert')})
    option_139789496930928 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'cups_printcap', 'default': 'non', 'doc': u'G\xe9n\xe9rer le fichier printcap', 'properties': ('mandatory', 'expert')})
    option_139789496931200 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'cups_lp', 'default': 'non', 'doc': u"Charger le module d'impression d'imprimante sur port parall\xe8le (incompatible avec les conteneurs)", 'properties': ('mandatory', 'expert')})
    option_139789496854800 = OptionDescription(children=[option_139789496919456, option_139789496919728, option_139789496920000, option_139789496920272, option_139789496920816, option_139789496920544, option_139789496921088, option_139789496921360, option_139789496921632, option_139789496930384, option_139789496930656, option_139789496930928, option_139789496931200], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971856}], **{'doc': u'cups', 'properties': ('expert',), 'name': 'cups'})
    option_139789496854800.impl_set_information("help", u"""Paramétrage avancé du serveur d'impression CUPS""")
    option_139789496854800.impl_set_information("icon", u"""print""")
    option_139789496931744 = DomainnameOption(**{'type_': 'domainname', 'name': 'proxy_bypass_domain_eth0', 'doc': u"Exceptions de type nom de domaine pour l'interface 0", 'allow_ip': False, 'multi': True, 'properties': ('disabled', 'normal')})
    option_139789496931744.impl_set_information("separator", ('Exceptions de proxy pour des domaines de destination', True))
    option_139789496931472 = DomainnameOption(**{'type_': 'domainname', 'name': 'proxy_bypass_domain_eth1', 'doc': u"Exceptions de type nom de domaine pour l'interface 1", 'allow_ip': False, 'multi': True, 'properties': ('normal',)})
    option_139789496932016 = DomainnameOption(**{'type_': 'domainname', 'name': 'proxy_bypass_domain_eth2', 'doc': u"Exceptions de type nom de domaine pour l'interface 2", 'allow_ip': False, 'multi': True, 'properties': ('normal',), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496932288 = DomainnameOption(**{'type_': 'domainname', 'name': 'proxy_bypass_domain_eth3', 'doc': u"Exceptions de type nom de domaine pour l'interface 3", 'allow_ip': False, 'multi': True, 'properties': ('normal',), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496932560 = DomainnameOption(**{'type_': 'domainname', 'name': 'proxy_bypass_domain_eth4', 'doc': u"Exceptions de type nom de domaine pour l'interface 4", 'allow_ip': False, 'multi': True, 'properties': ('normal',), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496932832 = UnicodeOption(**{'doc': u'Liste des domaines de destination \xe0 ne pas authentifier', 'multi': True, 'properties': ('normal',), 'name': 'proxy_noauth'})
    option_139789496932832.impl_set_information("separator", ('Ne pas authentifier des domaines de destination', None))
    option_139789496933104 = UnicodeOption(**{'multi': True, 'name': 'proxy_noauth_auto', 'doc': u'Agr\xe9gation des domaines de destination \xe0 ne pas authentifier', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamOption(option_139789497940448, False), ParamOption(option_139789497940720, False), ParamValue("eole.ac-dijon.fr"), ParamValue("eoleng.ac-dijon.fr"), ParamValue("bp-eole.ac-dijon.fr"), ParamValue("test-eole.ac-dijon.fr"), ParamValue("test-eoleng.ac-dijon.fr"), ParamValue("ftp.crihan.fr"), ParamValue(".archive.canonical.com"), ParamValue(".ubuntu.com"), ParamValue(".ppa.launchpad.net"), ParamValue(".database.clamav.net"), ParamValue(".db.fr.clamav.net"), ParamValue(".pool.ntp.org"), ParamValue(".services.openoffice.org"), ParamValue(".windowsupdate.com"), ParamValue(".wustat.windows.com"), ParamValue(".microsoft.com"), ParamValue(".pack.google.com"), ParamValue("eqos.orion.education.fr")), kwargs={})})
    option_139789496933376 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_bypass_eth0', 'default': 'non', 'doc': u"Ajouter des exceptions de destination pour l'interface 0", 'properties': ('disabled', 'mandatory', 'normal')})
    option_139789496933376.impl_set_information("separator", (u'Exceptions de proxy pour des IP et adresses r\xe9seaux de destination', True))
    option_139789496933648 = NetworkOption(**{'doc': u"Exceptions de type r\xe9seau pour l'interface 0", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_bypass_network_eth0', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496933376}]})
    option_139789496933920 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_netmask_eth0', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496933376}]})
    option_139789496933920.impl_add_consistency("network_netmask", option_139789496933648, **{})
    option_139789496855120 = MasterSlaves(children=[option_139789496933648, option_139789496933920], **{'doc': u"Exceptions de type r\xe9seau pour l'interface 0", 'properties': ('basic',), 'name': 'proxy_bypass_network_eth0'})
    option_139789496942672 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_bypass_eth1', 'default': 'non', 'doc': u"Ajouter des exceptions de destination pour l'interface 1", 'properties': ('mandatory', 'normal')})
    option_139789496942944 = NetworkOption(**{'doc': u"Exceptions de type r\xe9seau pour l'interface 1", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_bypass_network_eth1', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496942672}]})
    option_139789496943216 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_netmask_eth1', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496942672}]})
    option_139789496943216.impl_add_consistency("network_netmask", option_139789496942944, **{})
    option_139789496855440 = MasterSlaves(children=[option_139789496942944, option_139789496943216], **{'doc': u"Exceptions de type r\xe9seau pour l'interface 1", 'properties': ('basic',), 'name': 'proxy_bypass_network_eth1'})
    option_139789496943488 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_bypass_eth2', 'default': 'non', 'doc': u"Ajouter des exceptions de destination pour l'interface 2", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496943760 = NetworkOption(**{'doc': u"Exceptions de type r\xe9seau pour l'interface 2", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_bypass_network_eth2', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496943488}]})
    option_139789496944032 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_netmask_eth2', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496943488}]})
    option_139789496944032.impl_add_consistency("network_netmask", option_139789496943760, **{})
    option_139789496855760 = MasterSlaves(children=[option_139789496943760, option_139789496944032], **{'doc': u"Exceptions de type r\xe9seau pour l'interface 2", 'properties': ('basic',), 'name': 'proxy_bypass_network_eth2'})
    option_139789496944304 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_bypass_eth3', 'default': 'non', 'doc': u"Ajouter des exceptions de destination pour l'interface 3", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496944576 = NetworkOption(**{'doc': u"Exceptions de type r\xe9seau pour l'interface 3", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_bypass_network_eth3', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496944304}]})
    option_139789496944848 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_netmask_eth3', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496944304}]})
    option_139789496944848.impl_add_consistency("network_netmask", option_139789496944576, **{})
    option_139789496856080 = MasterSlaves(children=[option_139789496944576, option_139789496944848], **{'doc': u"Exceptions de type r\xe9seau pour l'interface 3", 'properties': ('basic',), 'name': 'proxy_bypass_network_eth3'})
    option_139789496945120 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_bypass_eth4', 'default': 'non', 'doc': u"Ajouter des exceptions de destination pour l'interface 4", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496945392 = NetworkOption(**{'doc': u"Exceptions de type r\xe9seau pour l'interface 4", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'proxy_bypass_network_eth4', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496945120}]})
    option_139789496945664 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_netmask_eth4', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496945120}]})
    option_139789496945664.impl_add_consistency("network_netmask", option_139789496945392, **{})
    option_139789496967248 = MasterSlaves(children=[option_139789496945392, option_139789496945664], **{'doc': u"Exceptions de type r\xe9seau pour l'interface 4", 'properties': ('basic',), 'name': 'proxy_bypass_network_eth4'})
    option_139789496945936 = NetworkOption(**{'doc': u"Exception source de type r\xe9seau pour l'interface 1", 'multi': True, 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth1'})
    option_139789496945936.impl_set_information("separator", (u'Exceptions de proxy pour des IP et adresses r\xe9seaux source', None))
    option_139789496946208 = NetmaskOption(**{'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'multi': True, 'properties': ('mandatory', 'normal'), 'name': 'proxy_bypass_src_netmask_eth1'})
    option_139789496946208.impl_add_consistency("network_netmask", option_139789496945936, **{})
    option_139789496967568 = MasterSlaves(children=[option_139789496945936, option_139789496946208], **{'doc': u"Exception source de type r\xe9seau pour l'interface 1", 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth1'})
    option_139789496979536 = NetworkOption(**{'doc': u"Exception source de type r\xe9seau pour l'interface 2", 'multi': True, 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth2', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496979808 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_src_netmask_eth2', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496979808.impl_add_consistency("network_netmask", option_139789496979536, **{})
    option_139789496967888 = MasterSlaves(children=[option_139789496979536, option_139789496979808], **{'doc': u"Exception source de type r\xe9seau pour l'interface 2", 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth2'})
    option_139789496980080 = NetworkOption(**{'doc': u"Exception source de type r\xe9seau pour l'interface 3", 'multi': True, 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth3', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496980352 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_src_netmask_eth3', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496980352.impl_add_consistency("network_netmask", option_139789496980080, **{})
    option_139789496968208 = MasterSlaves(children=[option_139789496980080, option_139789496980352], **{'doc': u"Exception source de type r\xe9seau pour l'interface 3", 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth3'})
    option_139789496980624 = NetworkOption(**{'doc': u"Exception source de type r\xe9seau pour l'interface 4", 'multi': True, 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth4', "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496980896 = NetmaskOption(**{'multi': True, 'name': 'proxy_bypass_src_netmask_eth4', 'default_multi': u'255.255.255.255', 'doc': u'Masque de sous-r\xe9seau associ\xe9', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789496980896.impl_add_consistency("network_netmask", option_139789496980624, **{})
    option_139789496968528 = MasterSlaves(children=[option_139789496980624, option_139789496980896], **{'doc': u"Exception source de type r\xe9seau pour l'interface 4", 'properties': ('normal',), 'name': 'proxy_bypass_src_network_eth4'})
    option_139789496981168 = UnicodeOption(**{'doc': u"Ne pas passer par le proxy pour l'h\xf4te ou le domaine", 'multi': True, 'properties': ('normal',), 'name': 'nom_host_wpad_exclude', "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789496981168.impl_set_information("separator", (u"Exceptions d'h\xf4te ou de domaine sp\xe9cifiques \xe0 WPAD", None))
    option_139789496981168.impl_set_information("help", u"""Les exclusions associées sont générées avec la fonction localHostOrDomainIs()""")
    option_139789496981440 = ChoiceOption(**{'multi': True, 'values': (u'Toutes', u'1', u'2', u'3', u'4'), 'name': 'nom_host_interface_wpad_exclude', 'doc': u'Interface(s) concern\xe9e(s)', 'properties': ('normal',), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': True, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': True, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': True, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': True, "option": option_139789497891840}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789496968848 = MasterSlaves(children=[option_139789496981168, option_139789496981440], **{'doc': u"Ne pas passer par le proxy pour l'h\xf4te ou le domaine", 'properties': ('normal',), 'name': 'nom_host_wpad_exclude'})
    option_139789496969168 = OptionDescription(children=[option_139789496931744, option_139789496931472, option_139789496932016, option_139789496932288, option_139789496932560, option_139789496932832, option_139789496933104, option_139789496933376, option_139789496855120, option_139789496942672, option_139789496855440, option_139789496943488, option_139789496855760, option_139789496944304, option_139789496856080, option_139789496945120, option_139789496967248, option_139789496967568, option_139789496967888, option_139789496968208, option_139789496968528, option_139789496968848], **{'doc': u'exceptions proxy', 'properties': ('basic',), 'name': 'exceptions_proxy'})
    option_139789496969168.impl_set_information("help", u"""Gestion des exceptions de proxy""")
    option_139789496969168.impl_set_information("icon", u"""code-fork""")
    option_139789496981712 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_cache_pere', 'default': 'non', 'doc': u'Utiliser un proxy web parent global', 'properties': ('mandatory', 'expert')})
    option_139789496981712.impl_set_information("separator", ('Proxy parent global', None))
    option_139789496981712.impl_set_information("help", u"""Déclarer un ou plusieurs serveurs proxy parents qui seront utilisés pour toutes les zones DNS""")
    option_139789496981984 = DomainnameOption(**{'multi': True, 'name': 'nom_cache_pere', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Adresse du serveur proxy web parent', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496981712}]})
    option_139789496982256 = PortOption(**{'multi': True, 'name': 'port_cache_pere', 'allow_private': True, 'doc': u'Port du serveur proxy web parent', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496981712}]})
    option_139789496982528 = PortOption(**{'multi': True, 'name': 'port_icp_cache_pere', 'allow_private': True, 'default_multi': 3130, 'doc': u'Port ICP du serveur proxy web parent', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496981712}]})
    option_139789496982800 = UnicodeOption(**{'multi': True, 'name': 'options_cache_pere', 'default_multi': u'no-query', 'doc': u'Options du serveur proxy web parent', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496981712}]})
    option_139789496982800.impl_set_information("help", u"""Options, séparées par des espaces, ajoutées à la configuration du serveur cache parent (exemple \"no-query no-netdb-exchange no-digest\"). Attention, l'option \"round-robin\" est ajoutée automatiquement si plusieurs serveurs père sont définis.""")
    option_139789496969488 = MasterSlaves(children=[option_139789496981984, option_139789496982256, option_139789496982528, option_139789496982800], **{'doc': u'Adresse du serveur proxy web parent', 'properties': ('expert',), 'name': 'nom_cache_pere'})
    option_139789496983072 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'proxy_pere_rvp', 'default': 'non', 'doc': u'Acc\xe8s aux zones RVP en passant par le serveur proxy web parent global', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496981712}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963936}]})
    option_139789496483920 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_cache_pere_zone', 'default': 'non', 'doc': u'Utiliser un proxy web parent par zone', 'properties': ('mandatory', 'expert')})
    option_139789496483920.impl_set_information("separator", ('Proxy parent par zone', None))
    option_139789496483920.impl_set_information("help", u"""Déclarer un ou plusieurs serveurs proxy parents associés à des zones DNS particulières""")
    option_139789496484192 = DomainnameOption(**{'multi': True, 'name': 'nom_cache_pere_zone', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Adresse du serveur proxy web parent pour la zone', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496484464 = PortOption(**{'multi': True, 'name': 'port_cache_pere_zone', 'allow_private': True, 'doc': u'Port du serveur web parent pour la zone', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496484736 = PortOption(**{'multi': True, 'name': 'port_icp_cache_pere_zone', 'allow_private': True, 'default_multi': 3130, 'doc': u'Port ICP du serveur web parent pour la zone', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496485008 = ChoiceOption(**{'multi': True, 'values': (u'DNS', u'nom fichier'), 'name': 'type_nom_zone_dns_cache', 'default_multi': u'DNS', 'doc': u"M\xe9thode d'utilisation de la zone accessible via ce serveur web parent", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496485008.impl_set_information("help", u"""Les zones DNS de destination peuvent être soit renseignées directement dans la variable, soit renseignées dans un fichier texte""")
    option_139789496485552 = UnicodeOption(**{'doc': u'Nom DNS ou nom de fichier de la zone accessible via ce serveur web parent', 'multi': True, 'properties': ('mandatory', 'expert'), 'name': 'nom_zone_dns_cache', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496485552.impl_set_information("help", u"""Le nom DNS commence généralement par un '.' (.example.net)""")
    option_139789496485280 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'autoriser_proxy_autres', 'default_multi': 'non', 'doc': u"Autoriser son utilisation par d'autres zones que celle de l'interface 1", 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496485824 = UnicodeOption(**{'multi': True, 'name': 'options_cache_pere_zone', 'default_multi': u'proxy-only no-query', 'doc': u'Options du serveur proxy web parent', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496483920}]})
    option_139789496485824.impl_set_information("help", u"""Options, séparées par des espaces, ajoutées à la configuration du serveur cache parent de la zone (exemple \"no-query no-netdb-exchange no-digest\").""")
    option_139789496969808 = MasterSlaves(children=[option_139789496484192, option_139789496484464, option_139789496484736, option_139789496485008, option_139789496485552, option_139789496485280, option_139789496485824], **{'doc': u'Adresse du serveur proxy web parent pour la zone', 'properties': ('expert',), 'name': 'nom_cache_pere_zone'})
    option_139789496486096 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_proxy_sibling', 'default': 'non', 'doc': u'Activer la coop\xe9ration des caches', 'properties': ('mandatory', 'expert')})
    option_139789496486096.impl_set_information("separator", (u'Coop\xe9ration des caches', None))
    option_139789496486096.impl_set_information("help", u"""Les serveurs frères (siblings) sont des serveurs de cache d'un niveau hiérarchique égal dont le but est de répartir la charge""")
    option_139789496486368 = IPOption(**{'multi': True, 'allow_reserved': True, 'name': 'proxy_sibling_ip', 'doc': u'Adresse IP du serveur proxy distant', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496486096}]})
    option_139789496486640 = PortOption(**{'multi': True, 'name': 'proxy_sibling_port', 'allow_private': True, 'doc': u'Port du serveur proxy distant', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496486096}]})
    option_139789496970128 = MasterSlaves(children=[option_139789496486368, option_139789496486640], **{'doc': u'Adresse IP du serveur proxy distant', 'properties': ('expert',), 'name': 'proxy_sibling_ip'})
    option_139789496970448 = OptionDescription(children=[option_139789496981712, option_139789496969488, option_139789496983072, option_139789496483920, option_139789496969808, option_139789496486096, option_139789496970128], **{'doc': u'proxy parent', 'properties': ('expert',), 'name': 'proxy_parent'})
    option_139789496970448.impl_set_information("help", u"""Configuration du chaînage du proxy""")
    option_139789496970448.impl_set_information("icon", u"""code-fork""")
    option_139789496486912 = DomainnameOption(**{'multi': True, 'name': 'wpad_domains', 'allow_ip': False, 'type_': 'domainname', 'doc': u'Nom de domaine du service WPAD', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497890752, False)})})
    option_139789496970768 = OptionDescription(children=[option_139789496486912], requires=[{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}], **{'doc': u'wpad', 'properties': ('basic',), 'name': 'wpad'})
    option_139789496970768.impl_set_information("help", u"""Paramètrage de la découverte automatique du proxy""")
    option_139789496970768.impl_set_information("icon", u"""code-fork""")
    option_139789496487184 = ChoiceOption(**{'multi': False, 'name': 'revprox_auto_config_local_web', 'doc': u'Activer la configuration automatique pour les applications locales', 'values': (u'oui', u'non'), 'properties': ('normal',), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497957376, False), 'match': ParamValue("oui"), 'condition_2': ParamOption(option_139789497972400, False)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789496487184.impl_set_information("help", u"""Configure automatiquement le reverse proxy afin de faire pointer web_url sur le conteneur web""")
    option_139789496487456 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'test_nginx_open_port', 'doc': u'Ouvrir les ports Nginx', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'mismatch': ParamValue("non"), 'condition_1': ParamOption(option_139789497413712, True), 'condition_3': ParamOption(option_139789497957920, True), 'condition_2': ParamOption(option_139789496487184, True), 'operator': ParamValue("OR"), 'match': ParamValue("oui")})})
    option_139789496487456.impl_set_information("help", u"""Vérifie que la publication d’application web par Nginx ou le reverse proxy HTTP ou la configuration automatique des applications locales est actif.""")
    option_139789496504400 = DomainnameOption(**{'type_': 'domainname', 'name': 'revprox_default', 'doc': u'Nom de domaine par d\xe9faut', 'allow_ip': False, 'multi': False, 'properties': ('normal',)})
    option_139789496504400.impl_set_information("help", u"""Si un client accède au serveur avec un nom de domaine non déclaré, le flux est redirigé vers ce domaine""")
    option_139789496504672 = ChoiceOption(**{'multi': False, 'values': (u'128', u'64', u'32'), 'name': 'revprox_hash_bucket_size', 'default': u'128', 'doc': u'Longueur maximum pour un nom de domaine', 'properties': ('mandatory', 'expert')})
    option_139789496508496 = OptionDescription(children=[option_139789496487456, option_139789496504400, option_139789497962848, option_139789496504672], requires=[{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497972672}], **{'doc': u'Nginx', 'properties': ('basic',), 'name': 'nginx'})
    option_139789496508496.impl_set_information("help", u"""Paramétrage global de Nginx""")
    option_139789496508496.impl_set_information("icon", u"""nginx""")
    option_139789496504944 = UnicodeOption(**{'multi': False, 'name': 'ead3_http_path', 'default': u'/ead', 'doc': u'Chemin d\u2019acc\xe8s de l\u2019application EAD3', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963392}]})
    option_139789496504944.impl_set_information("separator", ('EAD', None))
    option_139789496504944.impl_set_information("help", u"""Chemin absolu (commençant par un /) sous lequel le service EAD3 sera accessible""")
    option_139789496505216 = UnicodeOption(**{'multi': False, 'name': 'genconfig_http_path', 'default': u'/genconfig', 'doc': u'Chemin d\u2019acc\xe8s de l\u2019application GenConfig', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497974032}]})
    option_139789496505216.impl_set_information("separator", ('GenConfig', None))
    option_139789496505216.impl_set_information("help", u"""Chemin absolu (commençant par un /) sous lequel le service GenConfig sera accessible""")
    option_139789496508816 = OptionDescription(children=[option_139789496504944, option_139789496505216], **{'doc': u'Applications web Nginx', 'properties': ('basic',), 'name': 'applications_web_nginx'})
    option_139789496508816.impl_set_information("help", u"""Paramétrage des applications web publiées par Nginx""")
    option_139789496508816.impl_set_information("icon", u"""nginx""")
    option_139789496505488 = DomainnameOption(**{'multi': False, 'name': 'revprox_sso', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom de domaine du serveur SSO', 'properties': ('normal',), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}]})
    option_139789496505488.impl_set_information("separator", ('Redirection de services particuliers', True))
    option_139789496505488.impl_set_information("help", u"""Pour rediriger vers le SSO de la machine \"domainelocal\", taper \"domainelocal\"""")
    option_139789496505760 = DomainnameOption(**{'multi': False, 'name': 'revprox_eop', 'allow_ip': True, 'allow_without_dot': True, 'type_': 'domainname', 'doc': u'Nom de domaine du serveur EOP', 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'normal'), 'callback': eosfunc.calc_multi_condition, 'callback_params': Params(args=(ParamValue("oui"),), kwargs={'operator': ParamValue("OR"), 'condition_1': ParamOption(option_139789497146368, True), 'default_mismatch': ParamValue("None"), 'match': ParamOption(option_139789497854704, False)})})
    option_139789496505760.impl_set_information("help", u"""Pour rediriger vers EOP de la machine \"domainelocal\", taper \"domainelocal\"""")
    option_139789496506032 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_revprox_ead', 'default': 'non', 'doc': u"Activer la redirection de l'EAD Scribe", 'properties': ('force_default_on_freeze', 'frozen', 'hidden', 'mandatory', 'normal')})
    option_139789496506576 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'revprox_ead', 'doc': u'IP du Scribe pour la redirection EAD', 'properties': ('mandatory', 'normal'), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497983600, True)}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496506032}]})
    option_139789496506304 = PortOption(**{'multi': False, 'name': 'revprox_ead_port', 'allow_private': True, 'default': 4203, 'doc': u"Port de l'EAD sur le Scribe", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496506032}]})
    option_139789496506848 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'revprox_domain_wildcard', 'default_multi': 'non', 'doc': u'Activer la redirection pour tous les sous-domaines', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496506848.impl_set_information("help", u"""Exemple pour \"domaine\" : tous les sous-domaines de \"domaine\" seront redirigés""")
    option_139789496507120 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'revprox_le_cert', 'default_multi': 'oui', 'doc': u"Demander un certificat \xe0 Let's Encrypt pour ce domaine ?", 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'autosign\xe9', 'action': 'disabled', 'inverse': False, "option": option_139789497939360}, {'expected': u'manuel', 'action': 'disabled', 'inverse': False, "option": option_139789497939360}, {'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789496506848}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496507120.impl_set_information("help", u"""Demander un certificat SSL au serveur ACME (Let's Encrypt) pour ce domaine""")
    option_139789496507392 = UnicodeOption(**{'multi': True, 'name': 'revprox_rep', 'default_multi': u'/', 'doc': u'R\xe9pertoire ou nom de la page \xe0 rediriger', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496507392.impl_set_information("help", u"""URL relative (sans le nom de domaine) redirigée pour l'adresse définie dans la variable ci-dessus (exemple \"/mail\")""")
    option_139789496507664 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non', u'redirige vers https'), 'name': 'revprox_http', 'default_multi': u'redirige vers https', 'doc': u'Reverse proxy HTTP', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496507936 = ChoiceOption(**{'multi': True, 'values': (u'oui', u'non'), 'name': 'revprox_https', 'default_multi': 'oui', 'doc': u'Reverse proxy HTTPS', 'properties': ('mandatory', 'normal'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496520784 = URLOption(**{'multi': True, 'name': 'revprox_url', 'doc': u'IP ou domaine de destination (avec http:// ou https://) ou URI compl\xe8te', 'allow_ip': True, 'allow_without_dot': True, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497413712}]})
    option_139789496520784.impl_set_information("help", u"""Nom de domaine ou IP de destination, par exemple \"http://domainelocal\" ou URI, par exemple \"http://domainelocal/dir/\"""")
    option_139789496509136 = MasterSlaves(children=[option_139789497413984, option_139789496506848, option_139789496507120, option_139789496507392, option_139789496507664, option_139789496507936, option_139789496520784], **{'doc': u'Nom de domaine ou IP \xe0 rediriger', 'properties': ('basic',), 'name': 'revprox_domainname'})
    option_139789496521056 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_revprox_rewrite', 'default': 'non', 'doc': u"Activer la r\xe9\xe9criture d'URL", 'properties': ('mandatory', 'expert')})
    option_139789496521328 = DomainnameOption(**{'multi': True, 'name': 'revprox_rewrite_domaine', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom de domaine concern\xe9 par la r\xe9\xe9criture', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496521056}]})
    option_139789496521600 = ChoiceOption(**{'multi': True, 'values': (u'http/https', u'http', u'https'), 'name': 'revprox_rewrite_proto', 'default_multi': u'http/https', 'doc': u'Protocole', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496521056}]})
    option_139789496521872 = UnicodeOption(**{'doc': u'R\xe9pertoire de la r\xe9\xe9criture', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'revprox_rewrite_location', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496521056}]})
    option_139789496522144 = UnicodeOption(**{'doc': u'Regex de la r\xe9\xe9criture', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'revprox_rewrite_regex', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496521056}]})
    option_139789496522416 = UnicodeOption(**{'doc': u'La valeur de remplacement', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'revprox_rewrite_replacement', "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496521056}]})
    option_139789496509456 = MasterSlaves(children=[option_139789496521328, option_139789496521600, option_139789496521872, option_139789496522144, option_139789496522416], **{'doc': u'Nom de domaine concern\xe9 par la r\xe9\xe9criture', 'properties': ('basic',), 'name': 'revprox_rewrite_domaine'})
    option_139789496522688 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'revprox_redirection_http', 'default': 'non', 'doc': u'Activer la redirection des domaines', 'properties': ('mandatory', 'normal')})
    option_139789496522960 = DomainnameOption(**{'multi': True, 'name': 'revprox_redirection', 'allow_without_dot': True, 'allow_ip': True, 'type_': 'domainname', 'doc': u'Nom de domaine \xe0 rediriger', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496522688}]})
    option_139789496523232 = UnicodeOption(**{'multi': True, 'name': 'revprox_redirection_rep', 'default_multi': u'/', 'doc': u'Nom du r\xe9pertoire du domaine \xe0 rediriger', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496522688}]})
    option_139789496523504 = URLOption(**{'multi': True, 'name': 'revprox_redirection_destination', 'doc': u'Nom de domaine de destination', 'allow_ip': True, 'allow_without_dot': True, 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496522688}]})
    option_139789496509776 = MasterSlaves(children=[option_139789496522960, option_139789496523232, option_139789496523504], **{'doc': u'Nom de domaine \xe0 rediriger', 'properties': ('basic',), 'name': 'revprox_redirection'})
    option_139789496510096 = OptionDescription(children=[option_139789496505488, option_139789496505760, option_139789496506032, option_139789496506576, option_139789496506304, option_139789496487184, option_139789497413712, option_139789496509136, option_139789496521056, option_139789496509456, option_139789496522688, option_139789496509776], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972400}], **{'doc': u'Reverse proxy', 'properties': ('basic',), 'name': 'reverse_proxy'})
    option_139789496510096.impl_set_information("help", u"""Paramètrage du proxy inverse""")
    option_139789496510096.impl_set_information("icon", u"""nginx""")
    option_139789496523776 = UnicodeOption(**{'multi': False, 'name': 'ftp_servername', 'doc': u'Nom du serveur FTP', 'properties': ('expert',), 'callback': eosfunc.calc_val, 'callback_params': Params(args=None, kwargs={'valeur': ParamOption(option_139789497889936, False)})})
    option_139789496524048 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ftp_tls', 'default': 'non', 'doc': u'Activer le chiffrement TLS', 'properties': ('mandatory', 'expert')})
    option_139789496524320 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ftp_anonymous_access', 'default': 'non', 'doc': u"Activer l'acc\xe8s anonyme", 'properties': ('mandatory', 'expert')})
    option_139789496545360 = FilenameOption(**{'multi': False, 'name': 'ftp_anonymous_directory', 'doc': u'Chemin du r\xe9pertoire anonyme', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496524320}], "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^/"),), kwargs={'err_msg': ParamValue(u"Renseigner un chemin absolu")})})
    option_139789496545632 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_ftp_access', 'default': 'non', 'doc': u'Activer des acc\xe8s FTP suppl\xe9mentaires', 'properties': ('mandatory', 'expert')})
    option_139789496545904 = FilenameOption(**{'multi': True, 'name': 'ftp_access_directory', 'doc': u'Chemin du r\xe9pertoire FTP suppl\xe9mentaire', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496545632}], "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^/"),), kwargs={'err_msg': ParamValue(u"Renseigner un chemin absolu")})})
    option_139789496546176 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ftp_pam_ldap', 'default': 'oui', 'doc': u'Autoriser les comptes LDAP \xe0 se connecter en acc\xe8s FTP', 'properties': ('mandatory', 'expert')})
    option_139789496546448 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ftp_pam_sso', 'default': 'oui', 'doc': u'Autoriser CAS en acc\xe8s FTP', 'properties': ('mandatory', 'expert'), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496546176}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964208}]})
    option_139789496546720 = IntOption(**{'default': 50, 'doc': u"Nombre maximum d'utilisateurs simultan\xe9s", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_maxclients'})
    option_139789496546992 = IntOption(**{'default': 40, 'doc': u'Nombre maximum de processus pour ProFTPD', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_maxinstances'})
    option_139789496547264 = IntOption(**{'default': 500, 'doc': u'Taille maximum du fichier r\xe9cup\xe9r\xe9 (download) en Mb', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_maxretrievefilesize'})
    option_139789496547536 = IntOption(**{'default': 100, 'doc': u'Taille maximum du fichier d\xe9pos\xe9 (upload) en Mb', 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_maxstorefilesize'})
    option_139789496547808 = IntOption(**{'default': 1200, 'doc': u"Temps maximum d'inactivit\xe9 avant d\xe9connexion (en secondes)", 'multi': False, 'properties': ('mandatory', 'expert'), 'name': 'ftp_timeoutidle'})
    option_139789496548080 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ftp_perso_ele', 'default': 'non', 'doc': u"Activer l'acc\xe8s aux dossiers personnels des \xe9l\xe8ves pour les professeurs", 'properties': ('mandatory', 'expert')})
    option_139789496510416 = OptionDescription(children=[option_139789496523776, option_139789496524048, option_139789496524320, option_139789496545360, option_139789496545632, option_139789496545904, option_139789496546176, option_139789496546448, option_139789496546720, option_139789496546992, option_139789496547264, option_139789496547536, option_139789496547808, option_139789496548080], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}], **{'doc': u'proftpd', 'properties': ('expert',), 'name': 'proftpd'})
    option_139789496510416.impl_set_information("help", u"""Paramétrage avancé du serveur FTP""")
    option_139789496510416.impl_set_information("icon", u"""cloud-download""")
    option_139789496548352 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'activer_proxy_radius', 'default': 'non', 'doc': u'Activer le proxy radius', 'properties': ('mandatory', 'normal')})
    option_139789496548352.impl_set_information("help", u"""Permet de transmettre les requêtes du client à d'autres serveurs RADIUS""")
    option_139789496548624 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ttls_copy_request_to_tunnel', 'default': 'oui', 'doc': u"Copier les attributs dans la requ\xeate d'authentification du tunnel pour le protocole TTLS", 'properties': ('mandatory', 'expert')})
    option_139789496548896 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'ttls_use_tunneled_reply', 'default': 'oui', 'doc': u'R\xe9pondre dans la requ\xeate de tunnel pour le protocole TTLS', 'properties': ('mandatory', 'expert')})
    option_139789496549456 = ChoiceOption(**{'multi': False, 'values': (u'802.1x', u'accounting'), 'name': 'freerad_mode', 'default': u'802.1x', 'doc': u"Mode d'utilisation de FreeRADIUS", 'properties': ('mandatory', 'normal')})
    option_139789496549456.impl_set_information("help", u"""802.1x : mode filaire
accounting : mode wifi""")
    option_139789496549728 = ChoiceOption(**{'multi': False, 'values': (u'0', u'1', u'2', u'3', u'4'), 'name': 'freerad_listen_int', 'default': u'0', 'doc': u"Num\xe9ro de l'interface sur laquelle FreeRADIUS \xe9coutera", 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'accounting', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496550000 = IPOption(**{'multi': False, 'allow_reserved': True, 'name': 'freerad_listen_addr', 'doc': u'Adresse IP sur laquelle FreeRADIUS \xe9coutera', 'properties': ('mandatory', 'basic'), "requires": [{'expected': u'802.1x', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496550272 = IPOption(**{'doc': u"Adresse IP du serveur d'acc\xe8s (NAS)", 'multi': True, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_nas_ip'})
    option_139789496550272.impl_set_information("separator", ('Configuration des NAS', None))
    option_139789496550544 = IntOption(**{'doc': u"Masque de sous r\xe9seau (notation CIDR) du serveur d'acc\xe8s (NAS)", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_nas_cidr_netmask', "requires": [{'expected': u'802.1x', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496550544.impl_set_information("help", u"""Masque au format CIDR (255.255.255.0 -> 24)""")
    option_139789496550816 = UnicodeOption(**{'doc': u"Nom court du serveur d'acc\xe8s (NAS)", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_nas_name'})
    option_139789496551088 = PasswordOption(**{'doc': u"Secret partag\xe9 avec le serveur d'acc\xe8s (NAS)", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_nas_passwd'})
    option_139789496551360 = ChoiceOption(**{'multi': True, 'values': (u'cisco', u'computone', u'livingston', u'max40xx', u'multitech', u'netserver', u'pathras', u'patton', u'portslave', u'tc', u'usrhiper', u'other'), 'name': 'freerad_nas_type', 'default_multi': u'other', 'doc': u"Type du serveur d'acc\xe8s (NAS)", 'properties': ('mandatory', 'basic')})
    option_139789496510736 = MasterSlaves(children=[option_139789496550272, option_139789496550544, option_139789496550816, option_139789496551088, option_139789496551360], **{'doc': u"Adresse IP du serveur d'acc\xe8s (NAS)", 'properties': ('basic',), 'name': 'freerad_nas_ip'})
    option_139789496551632 = IPOption(**{'doc': u'Adresse IP du serveur LDAP permettant de r\xe9cup\xe9rer les comptes utilisateurs', 'multi': False, 'allow_reserved': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_ldap_ip'})
    option_139789496551632.impl_set_information("separator", ('Configuration LDAP', None))
    option_139789496551904 = UnicodeOption(**{'default': u'o=gouv,c=fr', 'doc': u"Suffixe racine de l'annuaire LDAP (base DN)", 'multi': False, 'properties': ('mandatory', 'normal'), 'name': 'freerad_ldap_base_dn'})
    option_139789496552176 = PasswordOption(**{'doc': u"Cl\xe9 d'acc\xe8s reader \xe0 la base LDAP sur Scribe (/root/.reader)", 'multi': False, 'properties': ('mandatory', 'basic'), 'name': 'freerad_cle_ldap_scribe', "requires": [{'expected': u'802.1x', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496552448 = UsernameOption(**{'doc': u"Groupe d'utilisateurs \xe0 r\xe9cup\xe9rer dans l'annuaire LDAP", 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_ldap_group', "requires": [{'expected': u'accounting', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496552448.impl_set_information("proposed_value", (u'eleves', u'professeurs'))
    option_139789496552448.impl_set_information("separator", ('Configuration des groupes et des VLAN', None))
    option_139789496552720 = IntOption(**{'doc': u'Num\xe9ro de VLAN \xe0 attribuer \xe0 ce groupe', 'multi': True, 'properties': ('mandatory', 'basic'), 'name': 'freerad_group_vlan', "requires": [{'expected': u'accounting', 'action': 'disabled', 'inverse': False, "option": option_139789496549456}]})
    option_139789496511056 = MasterSlaves(children=[option_139789496552448, option_139789496552720], **{'doc': u"Groupe d'utilisateurs \xe0 r\xe9cup\xe9rer dans l'annuaire LDAP", 'properties': ('basic',), 'name': 'freerad_ldap_group'})
    option_139789496511376 = OptionDescription(children=[option_139789496548352, option_139789496548624, option_139789496548896, option_139789496549456, option_139789496549728, option_139789496550000, option_139789496510736, option_139789496551632, option_139789496551904, option_139789496552176, option_139789496511056], requires=[{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496794384}], **{'doc': u'freeradius', 'properties': ('basic',), 'name': 'freeradius'})
    option_139789496511376.impl_set_information("help", u"""Paramétrage de l'authentification RADIUS""")
    option_139789496511376.impl_set_information("icon", u"""bullseye""")
    option_139789496552992 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'listen_from_network', 'default': 'oui', 'doc': u"En \xe9coute depuis l'ext\xe9rieur", 'properties': ('mandatory', 'expert')})
    option_139789496552992.impl_set_information("help", u"""Le serveur eoleflask doit il être accessible depuis l'extérieur ?""")
    option_139789496511696 = OptionDescription(children=[option_139789496552992, option_139789497145824], **{'doc': u'eoleflask', 'properties': ('expert',), 'name': 'eoleflask'})
    option_139789496511696.impl_set_information("help", u"""Paramétrage du framework d'application web Flask""")
    option_139789496511696.impl_set_information("icon", u"""python""")
    option_139789496561744 = ChoiceOption(**{'multi': False, 'values': (u'automatique', u'manuel'), 'name': 'synchro_aaf', 'default': u'manuel', 'doc': u'Mode de synchronisation AAF', 'properties': ('mandatory', 'expert')})
    option_139789496561744.impl_set_information("help", u"""Le module Zéphir permet de synchroniser les comptes depuis l'Annuaire Académique Fédérateur""")
    option_139789496562016 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'synchro_aaf_sendmail', 'default': 'non', 'doc': u"Envoi d'un courrier \xe9lectronique en cas d'erreur", 'properties': ('mandatory', 'expert')})
    option_139789496562016.impl_set_information("help", u"""Active l'envoi d'un courrier électronique en cas d'erreur lors de l'import AAF automatisé""")
    option_139789496562288 = EmailOption(**{'multi': True, 'name': 'synchro_aaf_mail', 'doc': u'Adresse(s) \xe9lectronique(s) \xe0 utiliser', 'properties': ('mandatory', 'expert'), 'callback': eosfunc.calc_multi_val, 'callback_params': Params(args=(ParamOption(option_139789497462864, False),), kwargs={}), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496562016}]})
    option_139789496562560 = UnicodeOption(**{'multi': False, 'name': 'code_ent', 'doc': u"Code de l'ENT (tel que d\xe9fini par le SDET v2.0)", 'properties': ('expert',), "validator": eosfunc.valid_regexp, 'validator_params': Params(args=(ParamValue(u"^[A-Z][0-9]$"),), kwargs={'err_msg': ParamValue(u"L'identifiant doit etre compose d'une lettre et d'un chiffre")})})
    option_139789496562560.impl_set_information("help", u"""Le module Zéphir permet de distribuer des plages d'identifiants ENT aux établissements""")
    option_139789496512016 = OptionDescription(children=[option_139789496561744, option_139789496562016, option_139789496562288, option_139789496562560], **{'doc': u'ent', 'properties': ('expert',), 'name': 'ent'})
    option_139789496512016.impl_set_information("icon", None)
    option_139789496562832 = ChoiceOption(**{'multi': False, 'values': (u'oui', u'non'), 'name': 'roundcube_tls', 'default': 'non', 'doc': u'Serveur de courrier \xe9lectronique est en TLS', 'properties': ('mandatory', 'expert')})
    option_139789496563104 = ChoiceOption(**{'multi': False, 'values': (u'default', u'externe', u'local'), 'name': 'roundcube_db_mode', 'default': u'default', 'doc': u'Serveur de base de donn\xe9es \xe0 utiliser', 'properties': ('expert',)})
    option_139789496563104.impl_set_information("separator", (u'Base de donn\xe9es', None))
    option_139789496563104.impl_set_information("help", u"""Utilisation ou non d'un paramètrage spécifique de base de données pour roundcube""")
    option_139789496563376 = UnicodeOption(**{'doc': u'Adresse du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'roundcube_dbserver', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}]})
    option_139789496563376.impl_set_information("help", u"""Adresse du serveur de base de données par défaut de roundcube""")
    option_139789496563648 = IntOption(**{'doc': u"Port d'\xe9coute du serveur de base de donn\xe9es", 'multi': False, 'properties': ('expert',), 'name': 'roundcube_dbport', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}]})
    option_139789496563648.impl_set_information("help", u"""Port d'écoute du serveur de base de données par défaut de roundcube""")
    option_139789496563920 = UnicodeOption(**{'doc': u'H\xf4tes autoris\xe9s \xe0 utiliser la base de donn\xe9es', 'multi': True, 'properties': ('expert',), 'name': 'roundcube_allow_hosts', "requires": [{'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}]})
    option_139789496563920.impl_set_information("help", u"""Adresses IP avec lesquelles les utilisateurs de la base de données de roundcube sont suceptibles de se connecter""")
    option_139789496564192 = UnicodeOption(**{'doc': u'Utilisateur du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'roundcube_dbuser', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}]})
    option_139789496564192.impl_set_information("help", u"""Nom d'utilisateur d'administration du serveur de base de données par défaut de roundcube""")
    option_139789496564464 = UnicodeOption(**{'doc': u'Fichier de mot de passe du serveur', 'multi': False, 'properties': ('expert',), 'name': 'roundcube_dbpass', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496563104}]})
    option_139789496564464.impl_set_information("help", u"""Fichier contenant le mot de passe de l'administrateur du serveur de base de données par défaut de roundcube""")
    option_139789496574032 = OptionDescription(children=[option_139789496562832, option_139789496563104, option_139789496563376, option_139789496563648, option_139789496563920, option_139789496564192, option_139789496564464], **{'doc': u'roundcube', 'properties': ('expert',), 'name': 'roundcube'})
    option_139789496574032.impl_set_information("help", u"""Outil de gestion automatique des base de données de roundcube""")
    option_139789496574032.impl_set_information("icon", u"""envelope""")
    option_139789496564736 = ChoiceOption(**{'multi': False, 'values': (u'default', u'externe', u'local'), 'name': 'pydio_db_mode', 'default': u'default', 'doc': u'Serveur de bases de donn\xe9es \xe0 utiliser', 'properties': ('expert',)})
    option_139789496565008 = UnicodeOption(**{'doc': u'Adresse du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'pydio_dbserver', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}]})
    option_139789496565280 = IntOption(**{'doc': u"Port d'\xe9coute du serveur de base de donn\xe9es", 'multi': False, 'properties': ('expert',), 'name': 'pydio_dbport', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}]})
    option_139789496582224 = UnicodeOption(**{'doc': u'H\xf4tes authoris\xe9s \xe0 utiliser la base de donn\xe9es', 'multi': True, 'properties': ('expert',), 'name': 'pydio_allow_hosts', "requires": [{'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}]})
    option_139789496582496 = UnicodeOption(**{'doc': u'Utilisateur du serveur de base de donn\xe9es', 'multi': False, 'properties': ('expert',), 'name': 'pydio_dbuser', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}]})
    option_139789496582768 = UnicodeOption(**{'doc': u'Fichier de mot de passe du serveur', 'multi': False, 'properties': ('expert',), 'name': 'pydio_dbpass', "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}, {'expected': u'default', 'action': 'disabled', 'inverse': False, "option": option_139789496564736}]})
    option_139789496574352 = OptionDescription(children=[option_139789496564736, option_139789496565008, option_139789496565280, option_139789496582224, option_139789496582496, option_139789496582768], **{'doc': u'pydio', 'properties': ('expert',), 'name': 'pydio'})
    option_139789496574352.impl_set_information("icon", None)
    option_139789496574672 = OptionDescription(children=[option_139789498700496, option_139789498700816, option_139789498701136, option_139789498701456, option_139789498702416, option_139789498702736, option_139789498044816, option_139789498047056, option_139789497676496, option_139789497678416, option_139789497279184, option_139789497281104, option_139789497282064, option_139789497434192, option_139789497434832, option_139789497435152, option_139789497436112, option_139789497436432, option_139789497436752, option_139789497437072, option_139789497437392, option_139789497036880, option_139789497037200, option_139789497037840, option_139789497038160, option_139789497038480, option_139789497039440, option_139789497040400, option_139789497126992, option_139789497127632, option_139789497127952, option_139789497128592, option_139789497129232, option_139789497130192, option_139789497258064, option_139789497258384, option_139789497259024, option_139789497259664, option_139789497259984, option_139789497260304, option_139789497260944, option_139789497261264, option_139789497261584, option_139789496853200, option_139789496853840, option_139789496854160, option_139789496854480, option_139789496854800, option_139789496969168, option_139789496970448, option_139789496970768, option_139789496508496, option_139789496508816, option_139789496510096, option_139789496510416, option_139789496511376, option_139789496511696, option_139789496512016, option_139789496574032, option_139789496574352], **{'doc': u'', 'properties': (), 'name': 'creole'})
    option_139789496583040 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496583312 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496583584 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496583856 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496584128 = IntOption(**{'default': 1, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496578968 = SymLinkOption(**{'name': 'ip', "opt": option_139789498665440})
    option_139789496579528 = SymLinkOption(**{'name': 'path', "opt": option_139789498665168})
    option_139789496574992 = OptionDescription(children=[option_139789496583040, option_139789496583312, option_139789496583584, option_139789496583856, option_139789496584128, option_139789496578968, option_139789496579528], **{'doc': u'', 'properties': (), 'name': 'container0'})
    option_139789496584400 = UnicodeOption(**{'default': u'all', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496584672 = UnicodeOption(**{'default': u'all', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496584944 = UnicodeOption(**{'default': u'all', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496585216 = UnicodeOption(**{'default': u'all', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496580088 = SymLinkOption(**{'name': 'ip', "opt": option_139789498666256})
    option_139789496580648 = SymLinkOption(**{'name': 'path', "opt": option_139789498665984})
    option_139789496575312 = OptionDescription(children=[option_139789496584400, option_139789496584672, option_139789496584944, option_139789496585216, option_139789496580088, option_139789496580648], **{'doc': u'', 'properties': (), 'name': 'container1'})
    option_139789496585488 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496585760 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496586320 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496586592 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496586864 = IntOption(**{'default': 52, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496581208 = SymLinkOption(**{'name': 'ip', "opt": option_139789497867264})
    option_139789496581768 = SymLinkOption(**{'name': 'path', "opt": option_139789497866992})
    option_139789496575632 = OptionDescription(children=[option_139789496585488, option_139789496585760, option_139789496586320, option_139789496586592, option_139789496586864, option_139789496581208, option_139789496581768], **{'doc': u'', 'properties': (), 'name': 'container10'})
    option_139789496587136 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496587408 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496587680 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496587952 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496588224 = IntOption(**{'default': 53, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496591256 = SymLinkOption(**{'name': 'ip', "opt": option_139789497872464})
    option_139789496591816 = SymLinkOption(**{'name': 'path', "opt": option_139789497867808})
    option_139789496575952 = OptionDescription(children=[option_139789496587136, option_139789496587408, option_139789496587680, option_139789496587952, option_139789496588224, option_139789496591256, option_139789496591816], **{'doc': u'', 'properties': (), 'name': 'container11'})
    option_139789496588496 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496588768 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496589040 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496589312 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496589584 = IntOption(**{'default': 50, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496594056 = SymLinkOption(**{'name': 'ip', "opt": option_139789497873280})
    option_139789496594792 = SymLinkOption(**{'name': 'path', "opt": option_139789497873008})
    option_139789496576272 = OptionDescription(children=[option_139789496588496, option_139789496588768, option_139789496589040, option_139789496589312, option_139789496589584, option_139789496594056, option_139789496594792], **{'doc': u'', 'properties': (), 'name': 'container12'})
    option_139789496589856 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496598608 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496598880 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496599152 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496599424 = IntOption(**{'default': 51, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496597032 = SymLinkOption(**{'name': 'ip', "opt": option_139789497874096})
    option_139789496597592 = SymLinkOption(**{'name': 'path', "opt": option_139789497873824})
    option_139789496576592 = OptionDescription(children=[option_139789496589856, option_139789496598608, option_139789496598880, option_139789496599152, option_139789496599424, option_139789496597032, option_139789496597592], **{'doc': u'', 'properties': (), 'name': 'container13'})
    option_139789496599696 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496599968 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496600240 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496600512 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496600784 = IntOption(**{'default': 52, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496604104 = SymLinkOption(**{'name': 'ip', "opt": option_139789497874912})
    option_139789496604664 = SymLinkOption(**{'name': 'path', "opt": option_139789497874640})
    option_139789496576912 = OptionDescription(children=[option_139789496599696, option_139789496599968, option_139789496600240, option_139789496600512, option_139789496600784, option_139789496604104, option_139789496604664], **{'doc': u'', 'properties': (), 'name': 'container14'})
    option_139789496601056 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496601328 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496601600 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496601872 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496602144 = IntOption(**{'default': 50, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496607080 = SymLinkOption(**{'name': 'ip', "opt": option_139789497852256})
    option_139789496607640 = SymLinkOption(**{'name': 'path', "opt": option_139789497851984})
    option_139789496577232 = OptionDescription(children=[option_139789496601056, option_139789496601328, option_139789496601600, option_139789496601872, option_139789496602144, option_139789496607080, option_139789496607640], **{'doc': u'', 'properties': (), 'name': 'container2'})
    option_139789496610896 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496611168 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496611440 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496611712 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496611984 = IntOption(**{'default': 51, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496609880 = SymLinkOption(**{'name': 'ip', "opt": option_139789497853072})
    option_139789496610440 = SymLinkOption(**{'name': 'path', "opt": option_139789497852800})
    option_139789496577552 = OptionDescription(children=[option_139789496610896, option_139789496611168, option_139789496611440, option_139789496611712, option_139789496611984, option_139789496609880, option_139789496610440], **{'doc': u'', 'properties': (), 'name': 'container3'})
    option_139789496612256 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496612528 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496612800 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496613072 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496613344 = IntOption(**{'default': 52, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496616952 = SymLinkOption(**{'name': 'ip', "opt": option_139789497853888})
    option_139789496617512 = SymLinkOption(**{'name': 'path', "opt": option_139789497853616})
    option_139789496619088 = OptionDescription(children=[option_139789496612256, option_139789496612528, option_139789496612800, option_139789496613072, option_139789496613344, option_139789496616952, option_139789496617512], **{'doc': u'', 'properties': (), 'name': 'container4'})
    option_139789496613616 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496613888 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496614160 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496614432 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496627280 = IntOption(**{'default': 52, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496624024 = SymLinkOption(**{'name': 'ip', "opt": option_139789497854704})
    option_139789496624584 = SymLinkOption(**{'name': 'path', "opt": option_139789497854432})
    option_139789496619408 = OptionDescription(children=[option_139789496613616, option_139789496613888, option_139789496614160, option_139789496614432, option_139789496627280, option_139789496624024, option_139789496624584], **{'doc': u'', 'properties': (), 'name': 'container5'})
    option_139789496627552 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496627824 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496628096 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496628368 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496628640 = IntOption(**{'default': 51, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496626824 = SymLinkOption(**{'name': 'ip', "opt": option_139789497855520})
    option_139789496631656 = SymLinkOption(**{'name': 'path', "opt": option_139789497855248})
    option_139789496619728 = OptionDescription(children=[option_139789496627552, option_139789496627824, option_139789496628096, option_139789496628368, option_139789496628640, option_139789496626824, option_139789496631656], **{'doc': u'', 'properties': (), 'name': 'container6'})
    option_139789496628912 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496629184 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496629456 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496629728 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496630000 = IntOption(**{'default': 53, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496633896 = SymLinkOption(**{'name': 'ip', "opt": option_139789497864816})
    option_139789496634456 = SymLinkOption(**{'name': 'path', "opt": option_139789497864544})
    option_139789496620048 = OptionDescription(children=[option_139789496628912, option_139789496629184, option_139789496629456, option_139789496629728, option_139789496630000, option_139789496633896, option_139789496634456], **{'doc': u'', 'properties': (), 'name': 'container7'})
    option_139789496630272 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496630544 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496630816 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496643664 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496643936 = IntOption(**{'default': 50, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496640968 = SymLinkOption(**{'name': 'ip', "opt": option_139789497865632})
    option_139789496641528 = SymLinkOption(**{'name': 'path', "opt": option_139789497865360})
    option_139789496620368 = OptionDescription(children=[option_139789496630272, option_139789496630544, option_139789496630816, option_139789496643664, option_139789496643936, option_139789496640968, option_139789496641528], **{'doc': u'', 'properties': (), 'name': 'container8'})
    option_139789496644208 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496644480 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496644752 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'group'})
    option_139789496645024 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496645296 = IntOption(**{'default': 53, 'doc': u'', 'multi': False, 'properties': (), 'name': 'id'})
    option_139789496648040 = SymLinkOption(**{'name': 'ip', "opt": option_139789497866448})
    option_139789496648600 = SymLinkOption(**{'name': 'path', "opt": option_139789497866176})
    option_139789496620688 = OptionDescription(children=[option_139789496644208, option_139789496644480, option_139789496644752, option_139789496645024, option_139789496645296, option_139789496648040, option_139789496648600], **{'doc': u'', 'properties': (), 'name': 'container9'})
    option_139789496621008 = OptionDescription(children=[option_139789496574992, option_139789496575312, option_139789496575632, option_139789496575952, option_139789496576272, option_139789496576592, option_139789496576912, option_139789496577232, option_139789496577552, option_139789496619088, option_139789496619408, option_139789496619728, option_139789496620048, option_139789496620368, option_139789496620688], **{'doc': u'', 'properties': (), 'name': 'containers'})
    option_139789496649720 = SymLinkOption(**{'name': 'adresse_ip_br0', "opt": option_139789498664080})
    option_139789496650280 = SymLinkOption(**{'name': 'adresse_netmask_br0', "opt": option_139789498664352})
    option_139789496650840 = SymLinkOption(**{'name': 'adresse_network_br0', "opt": option_139789498664624})
    option_139789496651400 = SymLinkOption(**{'name': 'adresse_broadcast_br0', "opt": option_139789498664896})
    option_139789496621328 = OptionDescription(children=[option_139789496649720, option_139789496650280, option_139789496650840, option_139789496651400], **{'doc': u'', 'properties': (), 'name': 'network'})
    option_139789496645568 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496645840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496646112 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496646384 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'network', 'doc': u'', 'properties': ()})
    option_139789496646656 = UnicodeOption(**{'default': u'networking', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496646928 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496621648 = OptionDescription(children=[option_139789496645568, option_139789496645840, option_139789496646112, option_139789496646384, option_139789496646656, option_139789496646928], **{'doc': u'', 'properties': (), 'name': 'service0'})
    option_139789496647200 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496655952 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496656224 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496656496 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496656768 = UnicodeOption(**{'default': u'cron', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496657040 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496621968 = OptionDescription(children=[option_139789496647200, option_139789496655952, option_139789496656224, option_139789496656496, option_139789496656768, option_139789496657040], **{'doc': u'', 'properties': (), 'name': 'service1'})
    option_139789496657312 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496657584 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496657856 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496658128 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496658400 = UnicodeOption(**{'default': u'rng-tools', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496658672 = UnicodeOption(**{'default': u'rngd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496658944 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497985232}]})
    option_139789496622288 = OptionDescription(children=[option_139789496657312, option_139789496657584, option_139789496657856, option_139789496658128, option_139789496658400, option_139789496658672, option_139789496658944], **{'doc': u'', 'properties': (), 'name': 'service2'})
    option_139789496659216 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496659488 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496664144 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496664416 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496664688 = UnicodeOption(**{'default': u'ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496664960 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496622608 = OptionDescription(children=[option_139789496659216, option_139789496659488, option_139789496664144, option_139789496664416, option_139789496664688, option_139789496664960], **{'doc': u'', 'properties': (), 'name': 'service3'})
    option_139789496665232 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496665504 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496665776 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496666048 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496666320 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496666592 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496666864 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497955744}]})
    option_139789496676432 = OptionDescription(children=[option_139789496665232, option_139789496665504, option_139789496665776, option_139789496666048, option_139789496666320, option_139789496666592, option_139789496666864], **{'doc': u'', 'properties': (), 'name': 'service4'})
    option_139789496667136 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496667408 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496667680 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496680528 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496680800 = UnicodeOption(**{'default': u'clamav-freshclam', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496681072 = UnicodeOption(**{'default': u'clamav', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496681344 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}]})
    option_139789496676752 = OptionDescription(children=[option_139789496667136, option_139789496667408, option_139789496667680, option_139789496680528, option_139789496680800, option_139789496681072, option_139789496681344], **{'doc': u'', 'properties': (), 'name': 'service5'})
    option_139789496681616 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496681888 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496682160 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496682432 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496682704 = UnicodeOption(**{'default': u'clamav-daemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496682976 = UnicodeOption(**{'default': u'force_clamav', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496683248 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497483344}]})
    option_139789496677072 = OptionDescription(children=[option_139789496681616, option_139789496681888, option_139789496682160, option_139789496682432, option_139789496682704, option_139789496682976, option_139789496683248], **{'doc': u'', 'properties': (), 'name': 'service6'})
    option_139789496683520 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496683792 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496684064 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496692816 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496693088 = UnicodeOption(**{'default': u'clamav-daemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496693360 = UnicodeOption(**{'default': u'clamav_mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496693632 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497476512}]})
    option_139789496677392 = OptionDescription(children=[option_139789496683520, option_139789496683792, option_139789496684064, option_139789496692816, option_139789496693088, option_139789496693360, option_139789496693632], **{'doc': u'', 'properties': (), 'name': 'service7'})
    option_139789496693904 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496694176 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496694448 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496694720 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496694992 = UnicodeOption(**{'default': u'clamav-daemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496695264 = UnicodeOption(**{'default': u'antivirus_samba', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496695536 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497483616}]})
    option_139789496677712 = OptionDescription(children=[option_139789496693904, option_139789496694176, option_139789496694448, option_139789496694720, option_139789496694992, option_139789496695264, option_139789496695536], **{'doc': u'', 'properties': (), 'name': 'service8'})
    option_139789496695808 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496696080 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496696352 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496705104 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496705376 = UnicodeOption(**{'default': u'clamav-daemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496705648 = UnicodeOption(**{'default': u'clamav_proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496705920 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497484160}]})
    option_139789496678032 = OptionDescription(children=[option_139789496695808, option_139789496696080, option_139789496696352, option_139789496705104, option_139789496705376, option_139789496705648, option_139789496705920], **{'doc': u'', 'properties': (), 'name': 'service9'})
    option_139789496706192 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496706464 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496706736 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496707008 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496707280 = UnicodeOption(**{'default': u'clamav-daemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496707552 = UnicodeOption(**{'default': u'antivirus_ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496707824 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497955472}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497484432}]})
    option_139789496678352 = OptionDescription(children=[option_139789496706192, option_139789496706464, option_139789496706736, option_139789496707008, option_139789496707280, option_139789496707552, option_139789496707824], **{'doc': u'', 'properties': (), 'name': 'service10'})
    option_139789496708096 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496708368 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496708640 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496713296 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496713568 = UnicodeOption(**{'default': u'isc-dhcp-server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496713840 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496714112 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956016}]})
    option_139789496678672 = OptionDescription(children=[option_139789496708096, option_139789496708368, option_139789496708640, option_139789496713296, option_139789496713568, option_139789496713840, option_139789496714112], **{'doc': u'', 'properties': (), 'name': 'service11'})
    option_139789496714384 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496714656 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496714928 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496715200 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496715472 = UnicodeOption(**{'default': u'tftpd-hpa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496715744 = UnicodeOption(**{'default': u'tftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496716016 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956288}]})
    option_139789496678992 = OptionDescription(children=[option_139789496714384, option_139789496714656, option_139789496714928, option_139789496715200, option_139789496715472, option_139789496715744, option_139789496716016], **{'doc': u'', 'properties': (), 'name': 'service12'})
    option_139789496716288 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496716560 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496716832 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496721488 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496721760 = UnicodeOption(**{'default': u'isc-dhcp-relay', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496722032 = UnicodeOption(**{'default': u'dhrelay', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496722304 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497956560}]})
    option_139789496679312 = OptionDescription(children=[option_139789496716288, option_139789496716560, option_139789496716832, option_139789496721488, option_139789496721760, option_139789496722032, option_139789496722304], **{'doc': u'', 'properties': (), 'name': 'service13'})
    option_139789496722576 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496722848 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496723120 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496723392 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496723664 = UnicodeOption(**{'default': u'winbind', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496723936 = UnicodeOption(**{'default': u'winbind', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496724208 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497048064}]})
    option_139789496679632 = OptionDescription(children=[option_139789496722576, option_139789496722848, option_139789496723120, option_139789496723392, option_139789496723664, option_139789496723936, option_139789496724208], **{'doc': u'', 'properties': (), 'name': 'service14'})
    option_139789496724480 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496724752 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496725024 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496733776 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496734048 = UnicodeOption(**{'default': u'winbind', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496734320 = UnicodeOption(**{'default': u'ntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496734592 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}, {'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496679952 = OptionDescription(children=[option_139789496724480, option_139789496724752, option_139789496725024, option_139789496733776, option_139789496734048, option_139789496734320, option_139789496734592], **{'doc': u'', 'properties': (), 'name': 'service15'})
    option_139789496734864 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496735136 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496735408 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496735680 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496735952 = UnicodeOption(**{'default': u'smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496736224 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496217680 = OptionDescription(children=[option_139789496734864, option_139789496735136, option_139789496735408, option_139789496735680, option_139789496735952, option_139789496736224], **{'doc': u'', 'properties': (), 'name': 'service16'})
    option_139789496736496 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496736768 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496737040 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496737312 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496221776 = UnicodeOption(**{'default': u'smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496222048 = UnicodeOption(**{'default': u'ntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496222320 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}, {'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496218000 = OptionDescription(children=[option_139789496736496, option_139789496736768, option_139789496737040, option_139789496737312, option_139789496221776, option_139789496222048, option_139789496222320], **{'doc': u'', 'properties': (), 'name': 'service17'})
    option_139789496222592 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496222864 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496223136 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496223408 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496223680 = UnicodeOption(**{'default': u'nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496223952 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496218320 = OptionDescription(children=[option_139789496222592, option_139789496222864, option_139789496223136, option_139789496223408, option_139789496223680, option_139789496223952], **{'doc': u'', 'properties': (), 'name': 'service18'})
    option_139789496224224 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496224496 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496224768 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496225040 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496225312 = UnicodeOption(**{'default': u'nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496229968 = UnicodeOption(**{'default': u'ntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496230240 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'NTLM/KERBEROS', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}, {'expected': u'NTLM/SMB', 'action': 'disabled', 'inverse': True, "option": option_139789497574544}]})
    option_139789496218640 = OptionDescription(children=[option_139789496224224, option_139789496224496, option_139789496224768, option_139789496225040, option_139789496225312, option_139789496229968, option_139789496230240], **{'doc': u'', 'properties': (), 'name': 'service19'})
    option_139789496230512 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496230784 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496231056 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496231328 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496231600 = UnicodeOption(**{'default': u'nscd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496231872 = UnicodeOption(**{'default': u'nscd_service', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496232144 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496218960 = OptionDescription(children=[option_139789496230512, option_139789496230784, option_139789496231056, option_139789496231328, option_139789496231600, option_139789496231872, option_139789496232144], **{'doc': u'', 'properties': (), 'name': 'service20'})
    option_139789496232416 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496232688 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496232960 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496233232 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496233504 = UnicodeOption(**{'default': u'nut-server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496246352 = UnicodeOption(**{'default': u'nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496246624 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957104}]})
    option_139789496219280 = OptionDescription(children=[option_139789496232416, option_139789496232688, option_139789496232960, option_139789496233232, option_139789496233504, option_139789496246352, option_139789496246624], **{'doc': u'', 'properties': (), 'name': 'service21'})
    option_139789496246896 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496247168 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496247440 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496247712 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496247984 = UnicodeOption(**{'default': u'salt-api', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496248256 = UnicodeOption(**{'default': u'saltstack', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496248528 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963664}]})
    option_139789496219600 = OptionDescription(children=[option_139789496246896, option_139789496247168, option_139789496247440, option_139789496247712, option_139789496247984, option_139789496248256, option_139789496248528], **{'doc': u'', 'properties': (), 'name': 'service22'})
    option_139789496248800 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496249072 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496249344 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496249616 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496249888 = UnicodeOption(**{'default': u'salt-master', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496258640 = UnicodeOption(**{'default': u'saltstack', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496258912 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963664}]})
    option_139789496219920 = OptionDescription(children=[option_139789496248800, option_139789496249072, option_139789496249344, option_139789496249616, option_139789496249888, option_139789496258640, option_139789496258912], **{'doc': u'', 'properties': (), 'name': 'service23'})
    option_139789496259184 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496259456 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496259728 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496260000 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496260272 = UnicodeOption(**{'default': u'salt-minion', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496260544 = UnicodeOption(**{'default': u'saltstack', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496260816 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963664}]})
    option_139789496220240 = OptionDescription(children=[option_139789496259184, option_139789496259456, option_139789496259728, option_139789496260000, option_139789496260272, option_139789496260544, option_139789496260816], **{'doc': u'', 'properties': (), 'name': 'service24'})
    option_139789496261088 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496261360 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496261632 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496261904 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496262176 = UnicodeOption(**{'default': u'apache2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496266832 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496267104 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496220560 = OptionDescription(children=[option_139789496261088, option_139789496261360, option_139789496261632, option_139789496261904, option_139789496262176, option_139789496266832, option_139789496267104], **{'doc': u'', 'properties': (), 'name': 'service25'})
    option_139789496267376 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496267648 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496267920 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496268192 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496268464 = UnicodeOption(**{'default': u'apache2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496268736 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496269008 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789496220880 = OptionDescription(children=[option_139789496267376, option_139789496267648, option_139789496267920, option_139789496268192, option_139789496268464, option_139789496268736, option_139789496269008], **{'doc': u'', 'properties': (), 'name': 'service26'})
    option_139789496269280 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496269552 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496269824 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496270096 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496270368 = UnicodeOption(**{'default': u'default', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496275024 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496275296 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496221200 = OptionDescription(children=[option_139789496269280, option_139789496269552, option_139789496269824, option_139789496270096, option_139789496270368, option_139789496275024, option_139789496275296], **{'doc': u'', 'properties': (), 'name': 'service27'})
    option_139789496275568 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496275840 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496276112 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496276384 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496276656 = UnicodeOption(**{'default': u'Vhost', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496276928 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496277200 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496283216 = OptionDescription(children=[option_139789496275568, option_139789496275840, option_139789496276112, option_139789496276384, option_139789496276656, option_139789496276928, option_139789496277200], **{'doc': u'', 'properties': (), 'name': 'service28'})
    option_139789496277472 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496277744 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496278016 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496278288 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496278560 = UnicodeOption(**{'default': u'Vhost-ssl', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496287312 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496287584 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496283536 = OptionDescription(children=[option_139789496277472, option_139789496277744, option_139789496278016, option_139789496278288, option_139789496278560, option_139789496287312, option_139789496287584], **{'doc': u'', 'properties': (), 'name': 'service29'})
    option_139789496287856 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496288128 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496288400 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496288672 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496288944 = UnicodeOption(**{'default': u'eole', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496289216 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496289488 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496283856 = OptionDescription(children=[option_139789496287856, option_139789496288128, option_139789496288400, option_139789496288672, option_139789496288944, option_139789496289216, option_139789496289488], **{'doc': u'', 'properties': (), 'name': 'service30'})
    option_139789496289760 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496290032 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496290304 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496290576 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496290848 = UnicodeOption(**{'default': u'bareos-webui', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496295504 = UnicodeOption(**{'default': u'bareoswebui', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496295776 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145280}]})
    option_139789496284176 = OptionDescription(children=[option_139789496289760, option_139789496290032, option_139789496290304, option_139789496290576, option_139789496290848, option_139789496295504, option_139789496295776], **{'doc': u'', 'properties': (), 'name': 'service31'})
    option_139789496296048 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496296320 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496296592 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496296864 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496297136 = UnicodeOption(**{'default': u'eole-sso', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496297408 = UnicodeOption(**{'default': u'sso', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496297680 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789496284496 = OptionDescription(children=[option_139789496296048, option_139789496296320, option_139789496296592, option_139789496296864, option_139789496297136, option_139789496297408, option_139789496297680], **{'doc': u'', 'properties': (), 'name': 'service32'})
    option_139789496297952 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496298224 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496298496 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496298768 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496299040 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496303696 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496284816 = OptionDescription(children=[option_139789496297952, option_139789496298224, option_139789496298496, option_139789496298768, option_139789496299040, option_139789496303696], **{'doc': u'', 'properties': (), 'name': 'service33'})
    option_139789496303968 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496304240 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496304512 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496304784 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496305056 = UnicodeOption(**{'default': u'ead-server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496305328 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496285136 = OptionDescription(children=[option_139789496303968, option_139789496304240, option_139789496304512, option_139789496304784, option_139789496305056, option_139789496305328], **{'doc': u'', 'properties': (), 'name': 'service34'})
    option_139789496305600 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496305872 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496306144 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496306416 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496306688 = UnicodeOption(**{'default': u'ead-web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496306960 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496307232 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789496285456 = OptionDescription(children=[option_139789496305600, option_139789496305872, option_139789496306144, option_139789496306416, option_139789496306688, option_139789496306960, option_139789496307232], **{'doc': u'', 'properties': (), 'name': 'service35'})
    option_139789496320080 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496320352 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496320624 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496320896 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496321168 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496321440 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496321712 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}]})
    option_139789496285776 = OptionDescription(children=[option_139789496320080, option_139789496320352, option_139789496320624, option_139789496320896, option_139789496321168, option_139789496321440, option_139789496321712], **{'doc': u'', 'properties': (), 'name': 'service36'})
    option_139789496321984 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496322256 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496322528 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496322800 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496323072 = UnicodeOption(**{'default': u'spamassassin', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496323344 = UnicodeOption(**{'default': u'spamassassin', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496323616 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746064}]})
    option_139789496286096 = OptionDescription(children=[option_139789496321984, option_139789496322256, option_139789496322528, option_139789496322800, option_139789496323072, option_139789496323344, option_139789496323616], **{'doc': u'', 'properties': (), 'name': 'service37'})
    option_139789496332368 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496332640 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496332912 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496333184 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496333456 = UnicodeOption(**{'default': u'bareos-dir', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496333728 = UnicodeOption(**{'default': u'bareos', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496334000 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971584}]})
    option_139789496286416 = OptionDescription(children=[option_139789496332368, option_139789496332640, option_139789496332912, option_139789496333184, option_139789496333456, option_139789496333728, option_139789496334000], **{'doc': u'', 'properties': (), 'name': 'service38'})
    option_139789496334272 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496334544 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496334816 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496335088 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496335360 = UnicodeOption(**{'default': u'bareos-fd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496335632 = UnicodeOption(**{'default': u'bareos', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496335904 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971584}]})
    option_139789496286736 = OptionDescription(children=[option_139789496334272, option_139789496334544, option_139789496334816, option_139789496335088, option_139789496335360, option_139789496335632, option_139789496335904], **{'doc': u'', 'properties': (), 'name': 'service39'})
    option_139789496344656 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496344928 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496345200 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496345472 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496345744 = UnicodeOption(**{'default': u'bareos-sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496346016 = UnicodeOption(**{'default': u'bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496346288 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789496348752 = OptionDescription(children=[option_139789496344656, option_139789496344928, option_139789496345200, option_139789496345472, option_139789496345744, option_139789496346016, option_139789496346288], **{'doc': u'', 'properties': (), 'name': 'service40'})
    option_139789496346560 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496346832 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496347104 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496347376 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496347648 = UnicodeOption(**{'default': u'courier-imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496347920 = UnicodeOption(**{'default': u'courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496348192 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747152}]})
    option_139789496349072 = OptionDescription(children=[option_139789496346560, option_139789496346832, option_139789496347104, option_139789496347376, option_139789496347648, option_139789496347920, option_139789496348192], **{'doc': u'', 'properties': (), 'name': 'service41'})
    option_139789496356944 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496357216 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496357488 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496357760 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496358032 = UnicodeOption(**{'default': u'courier-imap-ssl', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496358304 = UnicodeOption(**{'default': u'courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496358576 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747152}]})
    option_139789496349392 = OptionDescription(children=[option_139789496356944, option_139789496357216, option_139789496357488, option_139789496357760, option_139789496358032, option_139789496358304, option_139789496358576], **{'doc': u'', 'properties': (), 'name': 'service42'})
    option_139789496358848 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496359120 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496359392 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496359664 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496359936 = UnicodeOption(**{'default': u'courier-pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496360208 = UnicodeOption(**{'default': u'courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496360480 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746880}]})
    option_139789496349712 = OptionDescription(children=[option_139789496358848, option_139789496359120, option_139789496359392, option_139789496359664, option_139789496359936, option_139789496360208, option_139789496360480], **{'doc': u'', 'properties': (), 'name': 'service43'})
    option_139789496365136 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496365408 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496365680 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496365952 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496366224 = UnicodeOption(**{'default': u'courier-pop-ssl', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496366496 = UnicodeOption(**{'default': u'courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496366768 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746880}]})
    option_139789496350032 = OptionDescription(children=[option_139789496365136, option_139789496365408, option_139789496365680, option_139789496365952, option_139789496366224, option_139789496366496, option_139789496366768], **{'doc': u'', 'properties': (), 'name': 'service44'})
    option_139789496367040 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496367312 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496367584 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496367856 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496368128 = UnicodeOption(**{'default': u'courier-authdaemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496368400 = UnicodeOption(**{'default': u'courier_authdaemon', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496368672 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789496747424}]})
    option_139789496350352 = OptionDescription(children=[option_139789496367040, option_139789496367312, option_139789496367584, option_139789496367856, option_139789496368128, option_139789496368400, option_139789496368672], **{'doc': u'', 'properties': (), 'name': 'service45'})
    option_139789496377424 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496377696 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496377968 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496378240 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496378512 = UnicodeOption(**{'default': u'phpmyadmin', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496378784 = UnicodeOption(**{'default': u'myadmin', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496379056 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145552}]})
    option_139789496350672 = OptionDescription(children=[option_139789496377424, option_139789496377696, option_139789496377968, option_139789496378240, option_139789496378512, option_139789496378784, option_139789496379056], **{'doc': u'', 'properties': (), 'name': 'service46'})
    option_139789496379328 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496379600 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496379872 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496380144 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496380416 = UnicodeOption(**{'default': u'squid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496380688 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496350992 = OptionDescription(children=[option_139789496379328, option_139789496379600, option_139789496379872, option_139789496380144, option_139789496380416, option_139789496380688], **{'doc': u'', 'properties': (), 'name': 'service47'})
    option_139789496380960 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496389712 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496389984 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496390256 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496390528 = UnicodeOption(**{'default': u'squid3-2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496390800 = UnicodeOption(**{'default': u'squid2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496391072 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496793840}]})
    option_139789496351312 = OptionDescription(children=[option_139789496380960, option_139789496389712, option_139789496389984, option_139789496390256, option_139789496390528, option_139789496390800, option_139789496391072], **{'doc': u'', 'properties': (), 'name': 'service48'})
    option_139789496391344 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496391616 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496391888 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496392160 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496392432 = UnicodeOption(**{'default': u'eole-guardian', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496392704 = UnicodeOption(**{'default': u'guardian', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496392976 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497941264}]})
    option_139789496351632 = OptionDescription(children=[option_139789496391344, option_139789496391616, option_139789496391888, option_139789496392160, option_139789496392432, option_139789496392704, option_139789496392976], **{'doc': u'', 'properties': (), 'name': 'service49'})
    option_139789496393248 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496397904 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496398176 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496398448 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496398720 = UnicodeOption(**{'default': u'cups', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496398992 = UnicodeOption(**{'default': u'cups', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496399264 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971856}]})
    option_139789496351952 = OptionDescription(children=[option_139789496393248, option_139789496397904, option_139789496398176, option_139789496398448, option_139789496398720, option_139789496398992, option_139789496399264], **{'doc': u'', 'properties': (), 'name': 'service50'})
    option_139789496399536 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496399808 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496400080 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496400352 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496400624 = UnicodeOption(**{'default': u'cups-browsed', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496400896 = UnicodeOption(**{'default': u'cups', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496401168 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971856}]})
    option_139789496352272 = OptionDescription(children=[option_139789496399536, option_139789496399808, option_139789496400080, option_139789496400352, option_139789496400624, option_139789496400896, option_139789496401168], **{'doc': u'', 'properties': (), 'name': 'service51'})
    option_139789496401440 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496406096 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496406368 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496406640 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496406912 = UnicodeOption(**{'default': u'proftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496407184 = UnicodeOption(**{'default': u'proftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496407456 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}]})
    option_139789496410192 = OptionDescription(children=[option_139789496401440, option_139789496406096, option_139789496406368, option_139789496406640, option_139789496406912, option_139789496407184, option_139789496407456], **{'doc': u'', 'properties': (), 'name': 'service52'})
    option_139789496407728 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496408000 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496408272 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496408544 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496408816 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496409088 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496409360 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789496410512 = OptionDescription(children=[option_139789496407728, option_139789496408000, option_139789496408272, option_139789496408544, option_139789496408816, option_139789496409088, option_139789496409360], **{'doc': u'', 'properties': (), 'name': 'service53'})
    option_139789496409632 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496418384 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496418656 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496418928 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496419200 = UnicodeOption(**{'default': u'wwsympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496419472 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496419744 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789496410832 = OptionDescription(children=[option_139789496409632, option_139789496418384, option_139789496418656, option_139789496418928, option_139789496419200, option_139789496419472, option_139789496419744], **{'doc': u'', 'properties': (), 'name': 'service54'})
    option_139789496420016 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496420288 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496420560 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496420832 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496421104 = UnicodeOption(**{'default': u'controle-vnc', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496421376 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496411152 = OptionDescription(children=[option_139789496420016, option_139789496420288, option_139789496420560, option_139789496420832, option_139789496421104, option_139789496421376], **{'doc': u'', 'properties': (), 'name': 'service55'})
    option_139789496421648 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496421920 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496430672 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496430944 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496431216 = UnicodeOption(**{'default': u'freeradius', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496431488 = UnicodeOption(**{'default': u'freeradius', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496431760 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496794384}]})
    option_139789496411472 = OptionDescription(children=[option_139789496421648, option_139789496421920, option_139789496430672, option_139789496430944, option_139789496431216, option_139789496431488, option_139789496431760], **{'doc': u'', 'properties': (), 'name': 'service56'})
    option_139789496432032 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496432304 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496432576 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496432848 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496433120 = UnicodeOption(**{'default': u'exim4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496433392 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496411792 = OptionDescription(children=[option_139789496432032, option_139789496432304, option_139789496432576, option_139789496432848, option_139789496433120, option_139789496433392], **{'doc': u'', 'properties': (), 'name': 'service57'})
    option_139789496433664 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496433936 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496434208 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496438864 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496439136 = UnicodeOption(**{'default': u'eoleflask', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496439408 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496412112 = OptionDescription(children=[option_139789496433664, option_139789496433936, option_139789496434208, option_139789496438864, option_139789496439136, option_139789496439408], **{'doc': u'', 'properties': (), 'name': 'service58'})
    option_139789496439680 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496439952 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496440224 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496440496 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496440768 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496441040 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496412432 = OptionDescription(children=[option_139789496439680, option_139789496439952, option_139789496440224, option_139789496440496, option_139789496440768, option_139789496441040], **{'doc': u'', 'properties': (), 'name': 'service59'})
    option_139789496441312 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496441584 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496441856 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496442128 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496442400 = UnicodeOption(**{'default': u'ead3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496451152 = UnicodeOption(**{'default': u'ead3_apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496451424 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497963392}, {'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497957648}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496412752 = OptionDescription(children=[option_139789496441312, option_139789496441584, option_139789496441856, option_139789496442128, option_139789496442400, option_139789496451152, option_139789496451424], **{'doc': u'', 'properties': (), 'name': 'service60'})
    option_139789496451696 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496451968 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496452240 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496452512 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496452784 = UnicodeOption(**{'default': u'eoleapps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496453056 = UnicodeOption(**{'default': u'eoleapps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496453328 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145824}]})
    option_139789496413072 = OptionDescription(children=[option_139789496451696, option_139789496451968, option_139789496452240, option_139789496452512, option_139789496452784, option_139789496453056, option_139789496453328], **{'doc': u'', 'properties': (), 'name': 'service61'})
    option_139789496453600 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496453872 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496454144 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496454416 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496454688 = UnicodeOption(**{'default': u'eoleapps-apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496463440 = UnicodeOption(**{'default': u'eoleapps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496463712 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497145824}]})
    option_139789496413392 = OptionDescription(children=[option_139789496453600, option_139789496453872, option_139789496454144, option_139789496454416, option_139789496454688, option_139789496463440, option_139789496463712], **{'doc': u'', 'properties': (), 'name': 'service62'})
    option_139789496463984 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496464256 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496464528 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496464800 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789496465072 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496465344 = UnicodeOption(**{'default': u'genconfig_apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789496465616 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497974032}, {'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497957920}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496413712 = OptionDescription(children=[option_139789496463984, option_139789496464256, option_139789496464528, option_139789496464800, option_139789496465072, option_139789496465344, option_139789496465616], **{'doc': u'', 'properties': (), 'name': 'service63'})
    option_139789496465888 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496466160 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496466432 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496466704 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789496466976 = UnicodeOption(**{'default': u'websockify', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495955536 = UnicodeOption(**{'default': u'websockify', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789495955808 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497146368}]})
    option_139789495959632 = OptionDescription(children=[option_139789496465888, option_139789496466160, option_139789496466432, option_139789496466704, option_139789496466976, option_139789495955536, option_139789495955808], **{'doc': u'', 'properties': (), 'name': 'service64'})
    option_139789495956080 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495956352 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495956624 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495956896 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789495957168 = UnicodeOption(**{'default': u'roundcube', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495957440 = UnicodeOption(**{'default': u'roundcube', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789495957712 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497143376}]})
    option_139789495959952 = OptionDescription(children=[option_139789495956080, option_139789495956352, option_139789495956624, option_139789495956896, option_139789495957168, option_139789495957440, option_139789495957712], **{'doc': u'', 'properties': (), 'name': 'service65'})
    option_139789495957984 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495958256 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495958528 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495958800 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789495959072 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495967824 = UnicodeOption(**{'default': u'cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789495968096 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497574816}]})
    option_139789495960272 = OptionDescription(children=[option_139789495957984, option_139789495958256, option_139789495958528, option_139789495958800, option_139789495959072, option_139789495967824, option_139789495968096], **{'doc': u'', 'properties': (), 'name': 'service66'})
    option_139789495968368 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495968640 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495968912 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495969184 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'apache', 'doc': u'', 'properties': ()})
    option_139789495969456 = UnicodeOption(**{'default': u'pydio', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495969728 = UnicodeOption(**{'default': u'pydio', 'doc': u'', 'multi': False, 'properties': (), 'name': 'servicelist'})
    option_139789495970000 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497155664}]})
    option_139789495960592 = OptionDescription(children=[option_139789495968368, option_139789495968640, option_139789495968912, option_139789495969184, option_139789495969456, option_139789495969728, option_139789495970000], **{'doc': u'', 'properties': (), 'name': 'service67'})
    option_139789495970272 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495970544 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495970816 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495971088 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789495971360 = UnicodeOption(**{'default': u'bastion', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495976016 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495960912 = OptionDescription(children=[option_139789495970272, option_139789495970544, option_139789495970816, option_139789495971088, option_139789495971360, option_139789495976016], **{'doc': u'', 'properties': (), 'name': 'service68'})
    option_139789495976288 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495976560 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495976832 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495977104 = ChoiceOption(**{'multi': False, 'values': (u'systemd', u'upstart', u'apache', u'network'), 'name': 'method', 'default': 'systemd', 'doc': u'', 'properties': ()})
    option_139789495977376 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495977648 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495961232 = OptionDescription(children=[option_139789495976288, option_139789495976560, option_139789495976832, option_139789495977104, option_139789495977376, option_139789495977648], **{'doc': u'', 'properties': (), 'name': 'service69'})
    option_139789495961552 = OptionDescription(children=[option_139789496621648, option_139789496621968, option_139789496622288, option_139789496622608, option_139789496676432, option_139789496676752, option_139789496677072, option_139789496677392, option_139789496677712, option_139789496678032, option_139789496678352, option_139789496678672, option_139789496678992, option_139789496679312, option_139789496679632, option_139789496679952, option_139789496217680, option_139789496218000, option_139789496218320, option_139789496218640, option_139789496218960, option_139789496219280, option_139789496219600, option_139789496219920, option_139789496220240, option_139789496220560, option_139789496220880, option_139789496221200, option_139789496283216, option_139789496283536, option_139789496283856, option_139789496284176, option_139789496284496, option_139789496284816, option_139789496285136, option_139789496285456, option_139789496285776, option_139789496286096, option_139789496286416, option_139789496286736, option_139789496348752, option_139789496349072, option_139789496349392, option_139789496349712, option_139789496350032, option_139789496350352, option_139789496350672, option_139789496350992, option_139789496351312, option_139789496351632, option_139789496351952, option_139789496352272, option_139789496410192, option_139789496410512, option_139789496410832, option_139789496411152, option_139789496411472, option_139789496411792, option_139789496412112, option_139789496412432, option_139789496412752, option_139789496413072, option_139789496413392, option_139789496413712, option_139789495959632, option_139789495959952, option_139789495960272, option_139789495960592, option_139789495960912, option_139789495961232], **{'doc': u'', 'properties': (), 'name': 'services'})
    option_139789495977920 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495978192 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495978464 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495978736 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 123, 'doc': u'', 'properties': ()})
    option_139789495979008 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495979280 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789495979552 = UnicodeOption(**{'default': u'ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495984208 = UnicodeOption(**{'default': u'___auto_ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495984480 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495961872 = OptionDescription(children=[option_139789495977920, option_139789495978192, option_139789495978464, option_139789495978736, option_139789495979008, option_139789495979280, option_139789495979552, option_139789495984208, option_139789495984480], **{'doc': u'', 'properties': (), 'name': 'service_access0'})
    option_139789495984752 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495985024 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495985296 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495985568 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 123, 'doc': u'', 'properties': ()})
    option_139789495985840 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495986112 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789495986384 = UnicodeOption(**{'default': u'ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495986656 = UnicodeOption(**{'default': u'___auto_ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495986928 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495962192 = OptionDescription(children=[option_139789495984752, option_139789495985024, option_139789495985296, option_139789495985568, option_139789495985840, option_139789495986112, option_139789495986384, option_139789495986656, option_139789495986928], **{'doc': u'', 'properties': (), 'name': 'service_access1'})
    option_139789495987200 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495987472 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495987744 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495992400 = UnicodeOption(**{'default': u'ntpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495992672 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495992944 = UnicodeOption(**{'default': u'ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495993216 = UnicodeOption(**{'default': u'___auto_ntp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495993488 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495962512 = OptionDescription(children=[option_139789495987200, option_139789495987472, option_139789495987744, option_139789495992400, option_139789495992672, option_139789495992944, option_139789495993216, option_139789495993488], **{'doc': u'', 'properties': (), 'name': 'service_access2'})
    option_139789495993760 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495994032 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495994304 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495994576 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 514, 'doc': u'', 'properties': ()})
    option_139789495994848 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495995120 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789495995392 = UnicodeOption(**{'default': u'rsyslog_udp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495995664 = UnicodeOption(**{'default': u'___auto_rsyslog_udp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495995936 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495962832 = OptionDescription(children=[option_139789495993760, option_139789495994032, option_139789495994304, option_139789495994576, option_139789495994848, option_139789495995120, option_139789495995392, option_139789495995664, option_139789495995936], **{'doc': u'', 'properties': (), 'name': 'service_access3'})
    option_139789496004688 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496004960 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496005232 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496005504 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 10514, 'doc': u'', 'properties': ()})
    option_139789496005776 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496006048 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496006320 = UnicodeOption(**{'default': u'rsyslog_tcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496006592 = UnicodeOption(**{'default': u'___auto_rsyslog_tcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496006864 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495963152 = OptionDescription(children=[option_139789496004688, option_139789496004960, option_139789496005232, option_139789496005504, option_139789496005776, option_139789496006048, option_139789496006320, option_139789496006592, option_139789496006864], **{'doc': u'', 'properties': (), 'name': 'service_access4'})
    option_139789496007136 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496007408 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496007680 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496007952 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 20514, 'doc': u'', 'properties': ()})
    option_139789496008224 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496012880 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496013152 = UnicodeOption(**{'default': u'rsyslog_relp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496013424 = UnicodeOption(**{'default': u'___auto_rsyslog_relp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496013696 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496016976 = OptionDescription(children=[option_139789496007136, option_139789496007408, option_139789496007680, option_139789496007952, option_139789496008224, option_139789496012880, option_139789496013152, option_139789496013424, option_139789496013696], **{'doc': u'', 'properties': (), 'name': 'service_access5'})
    option_139789496013968 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496014240 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496014512 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496014784 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 22, 'doc': u'', 'properties': ()})
    option_139789496015056 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496015328 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496015600 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496015872 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496016144 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496017296 = OptionDescription(children=[option_139789496013968, option_139789496014240, option_139789496014512, option_139789496014784, option_139789496015056, option_139789496015328, option_139789496015600, option_139789496015872, option_139789496016144], **{'doc': u'', 'properties': (), 'name': 'service_access6'})
    option_139789496016416 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496025168 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496025440 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496025712 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496025984 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496026256 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496026528 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496026800 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496017616 = OptionDescription(children=[option_139789496016416, option_139789496025168, option_139789496025440, option_139789496025712, option_139789496025984, option_139789496026256, option_139789496026528, option_139789496026800], **{'doc': u'', 'properties': (), 'name': 'service_access7'})
    option_139789496027072 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496027344 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496027616 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496027888 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 7000, 'doc': u'', 'properties': ()})
    option_139789496028160 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496028432 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496028704 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496033360 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496033632 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496017936 = OptionDescription(children=[option_139789496027072, option_139789496027344, option_139789496027616, option_139789496027888, option_139789496028160, option_139789496028432, option_139789496028704, option_139789496033360, option_139789496033632], **{'doc': u'', 'properties': (), 'name': 'service_access8'})
    option_139789496033904 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496034176 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496034448 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496034720 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 389, 'doc': u'', 'properties': ()})
    option_139789496034992 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496035264 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496035536 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496035808 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496036080 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'tous', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'authentifi\xe9', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'non', 'action': 'disabled', 'inverse': True, "option": option_139789496783472}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789496783472}, {'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497955744}]})
    option_139789496018256 = OptionDescription(children=[option_139789496033904, option_139789496034176, option_139789496034448, option_139789496034720, option_139789496034992, option_139789496035264, option_139789496035536, option_139789496035808, option_139789496036080], **{'doc': u'', 'properties': (), 'name': 'service_access9'})
    option_139789496036352 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496036624 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496036896 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496041552 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 636, 'doc': u'', 'properties': ()})
    option_139789496041824 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496042096 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496042368 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496042640 = UnicodeOption(**{'default': u'slapd_ssl', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496042912 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'tous', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'authentifi\xe9', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789496783472}, {'expected': u'uniquement', 'action': 'disabled', 'inverse': True, "option": option_139789496783472}, {'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497955744}]})
    option_139789496018576 = OptionDescription(children=[option_139789496036352, option_139789496036624, option_139789496036896, option_139789496041552, option_139789496041824, option_139789496042096, option_139789496042368, option_139789496042640, option_139789496042912], **{'doc': u'', 'properties': (), 'name': 'service_access10'})
    option_139789496043184 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496043456 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496043728 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496044000 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496044272 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496044544 = UnicodeOption(**{'default': u'slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496044816 = UnicodeOption(**{'default': u'tcpw_slapd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496045088 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'tous', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'authentifi\xe9', 'action': 'disabled', 'inverse': True, "option": option_139789496783744}, {'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497955744}]})
    option_139789496018896 = OptionDescription(children=[option_139789496043184, option_139789496043456, option_139789496043728, option_139789496044000, option_139789496044272, option_139789496044544, option_139789496044816, option_139789496045088], **{'doc': u'', 'properties': (), 'name': 'service_access11'})
    option_139789496053840 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496054112 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496054384 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496051424 = SymLinkOption(**{'name': 'name', "opt": option_139789497519376})
    option_139789496054656 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496054928 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496055200 = UnicodeOption(**{'default': u'failover_dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496055472 = UnicodeOption(**{'default': u'failover_dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496055744 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789496019216 = OptionDescription(children=[option_139789496053840, option_139789496054112, option_139789496054384, option_139789496051424, option_139789496054656, option_139789496054928, option_139789496055200, option_139789496055472, option_139789496055744], **{'doc': u'', 'properties': (), 'name': 'service_access12'})
    option_139789496056016 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496056288 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496056560 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496056832 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 69, 'doc': u'', 'properties': ()})
    option_139789496057104 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496057376 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789496066128 = UnicodeOption(**{'default': u'tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496066400 = UnicodeOption(**{'default': u'___auto_tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496066672 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496019536 = OptionDescription(children=[option_139789496056016, option_139789496056288, option_139789496056560, option_139789496056832, option_139789496057104, option_139789496057376, option_139789496066128, option_139789496066400, option_139789496066672], **{'doc': u'', 'properties': (), 'name': 'service_access13'})
    option_139789496066944 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496067216 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496067488 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496067760 = UnicodeOption(**{'default': u'in.tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496068032 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496068304 = UnicodeOption(**{'default': u'tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496068576 = UnicodeOption(**{'default': u'___auto_tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496068848 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496019856 = OptionDescription(children=[option_139789496066944, option_139789496067216, option_139789496067488, option_139789496067760, option_139789496068032, option_139789496068304, option_139789496068576, option_139789496068848], **{'doc': u'', 'properties': (), 'name': 'service_access14'})
    option_139789496069120 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496069392 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496069664 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496072744 = SymLinkOption(**{'name': 'name', "opt": option_139789497010112})
    option_139789496074320 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496074592 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496074864 = UnicodeOption(**{'default': u'omap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496075136 = UnicodeOption(**{'default': u'omapi', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496075408 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497009840}]})
    option_139789496020176 = OptionDescription(children=[option_139789496069120, option_139789496069392, option_139789496069664, option_139789496072744, option_139789496074320, option_139789496074592, option_139789496074864, option_139789496075136, option_139789496075408], **{'doc': u'', 'properties': (), 'name': 'service_access15'})
    option_139789496075680 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496075952 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496076224 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496076496 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 139, 'doc': u'', 'properties': ()})
    option_139789496076768 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496077040 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496077312 = UnicodeOption(**{'default': u'smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496077584 = UnicodeOption(**{'default': u'___auto_smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496077856 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496020496 = OptionDescription(children=[option_139789496075680, option_139789496075952, option_139789496076224, option_139789496076496, option_139789496076768, option_139789496077040, option_139789496077312, option_139789496077584, option_139789496077856], **{'doc': u'', 'properties': (), 'name': 'service_access16'})
    option_139789496086608 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496086880 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496087152 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496087424 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 445, 'doc': u'', 'properties': ()})
    option_139789496087696 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496087968 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496088240 = UnicodeOption(**{'default': u'smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496088512 = UnicodeOption(**{'default': u'___auto_smbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496088784 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496094800 = OptionDescription(children=[option_139789496086608, option_139789496086880, option_139789496087152, option_139789496087424, option_139789496087696, option_139789496087968, option_139789496088240, option_139789496088512, option_139789496088784], **{'doc': u'', 'properties': (), 'name': 'service_access17'})
    option_139789496089056 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496089328 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496089600 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496089872 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 137, 'doc': u'', 'properties': ()})
    option_139789496090144 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496102992 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789496103264 = UnicodeOption(**{'default': u'nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496103536 = UnicodeOption(**{'default': u'___auto_nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496103808 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496095120 = OptionDescription(children=[option_139789496089056, option_139789496089328, option_139789496089600, option_139789496089872, option_139789496090144, option_139789496102992, option_139789496103264, option_139789496103536, option_139789496103808], **{'doc': u'', 'properties': (), 'name': 'service_access18'})
    option_139789496104080 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496104352 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496104624 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496104896 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 138, 'doc': u'', 'properties': ()})
    option_139789496105168 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496105440 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789496105712 = UnicodeOption(**{'default': u'nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496105984 = UnicodeOption(**{'default': u'___auto_nmbd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496106256 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496095440 = OptionDescription(children=[option_139789496104080, option_139789496104352, option_139789496104624, option_139789496104896, option_139789496105168, option_139789496105440, option_139789496105712, option_139789496105984, option_139789496106256], **{'doc': u'', 'properties': (), 'name': 'service_access19'})
    option_139789496106528 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496111184 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496111456 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496111728 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 3493, 'doc': u'', 'properties': ()})
    option_139789496112000 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496112272 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496112544 = UnicodeOption(**{'default': u'nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496112816 = UnicodeOption(**{'default': u'___auto_nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496113088 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957104}]})
    option_139789496095760 = OptionDescription(children=[option_139789496106528, option_139789496111184, option_139789496111456, option_139789496111728, option_139789496112000, option_139789496112272, option_139789496112544, option_139789496112816, option_139789496113088], **{'doc': u'', 'properties': (), 'name': 'service_access20'})
    option_139789496113360 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496113632 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496113904 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496114176 = UnicodeOption(**{'default': u'upsd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496114448 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496114720 = UnicodeOption(**{'default': u'nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496119376 = UnicodeOption(**{'default': u'___auto_nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496119648 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957104}]})
    option_139789496096080 = OptionDescription(children=[option_139789496113360, option_139789496113632, option_139789496113904, option_139789496114176, option_139789496114448, option_139789496114720, option_139789496119376, option_139789496119648], **{'doc': u'', 'properties': (), 'name': 'service_access21'})
    option_139789496119920 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496120192 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496120464 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496120736 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 80, 'doc': u'', 'properties': ()})
    option_139789496121008 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496121280 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496121552 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496121824 = UnicodeOption(**{'default': u'___auto_apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496122096 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496096400 = OptionDescription(children=[option_139789496119920, option_139789496120192, option_139789496120464, option_139789496120736, option_139789496121008, option_139789496121280, option_139789496121552, option_139789496121824, option_139789496122096], **{'doc': u'', 'properties': (), 'name': 'service_access22'})
    option_139789496122368 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496122640 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496122912 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496131664 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 80, 'doc': u'', 'properties': ()})
    option_139789496131936 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496132208 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496132480 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496132752 = UnicodeOption(**{'default': u'wpad', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496133024 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': True, "option": option_139789497972128}]})
    option_139789496096720 = OptionDescription(children=[option_139789496122368, option_139789496122640, option_139789496122912, option_139789496131664, option_139789496131936, option_139789496132208, option_139789496132480, option_139789496132752, option_139789496133024], **{'doc': u'', 'properties': (), 'name': 'service_access23'})
    option_139789496133296 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496133568 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496133840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496134112 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 80, 'doc': u'', 'properties': ()})
    option_139789496134384 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496134656 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496134928 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496135200 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496139856 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496487456}]})
    option_139789496097040 = OptionDescription(children=[option_139789496133296, option_139789496133568, option_139789496133840, option_139789496134112, option_139789496134384, option_139789496134656, option_139789496134928, option_139789496135200, option_139789496139856], **{'doc': u'', 'properties': (), 'name': 'service_access24'})
    option_139789496140128 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496140400 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496140672 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496140944 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 443, 'doc': u'', 'properties': ()})
    option_139789496141216 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496141488 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496141760 = UnicodeOption(**{'default': u'apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496142032 = UnicodeOption(**{'default': u'___auto_apache', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496142304 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957376}]})
    option_139789496097360 = OptionDescription(children=[option_139789496140128, option_139789496140400, option_139789496140672, option_139789496140944, option_139789496141216, option_139789496141488, option_139789496141760, option_139789496142032, option_139789496142304], **{'doc': u'', 'properties': (), 'name': 'service_access25'})
    option_139789496142576 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496142848 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496143120 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496143392 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 443, 'doc': u'', 'properties': ()})
    option_139789496152144 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496152416 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496152688 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496152960 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496153232 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496487456}]})
    option_139789496097680 = OptionDescription(children=[option_139789496142576, option_139789496142848, option_139789496143120, option_139789496143392, option_139789496152144, option_139789496152416, option_139789496152688, option_139789496152960, option_139789496153232], **{'doc': u'', 'properties': (), 'name': 'service_access26'})
    option_139789496153504 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496153776 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496154048 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496151688 = SymLinkOption(**{'name': 'name', "opt": option_139789497180512})
    option_139789496154320 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496154592 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496154864 = UnicodeOption(**{'default': u'sso', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496155136 = UnicodeOption(**{'default': u'___auto_sso', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496155408 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'local', 'action': 'disabled', 'inverse': True, "option": option_139789497964208}]})
    option_139789496098000 = OptionDescription(children=[option_139789496153504, option_139789496153776, option_139789496154048, option_139789496151688, option_139789496154320, option_139789496154592, option_139789496154864, option_139789496155136, option_139789496155408], **{'doc': u'', 'properties': (), 'name': 'service_access27'})
    option_139789496155680 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496160336 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496160608 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496160880 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 53, 'doc': u'', 'properties': ()})
    option_139789496161152 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496161424 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496161696 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496161968 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496162240 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496098320 = OptionDescription(children=[option_139789496155680, option_139789496160336, option_139789496160608, option_139789496160880, option_139789496161152, option_139789496161424, option_139789496161696, option_139789496161968, option_139789496162240], **{'doc': u'', 'properties': (), 'name': 'service_access28'})
    option_139789496162512 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496162784 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496163056 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496163328 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 53, 'doc': u'', 'properties': ()})
    option_139789496163600 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496163872 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789496168528 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496168800 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496169072 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789496172624 = OptionDescription(children=[option_139789496162512, option_139789496162784, option_139789496163056, option_139789496163328, option_139789496163600, option_139789496163872, option_139789496168528, option_139789496168800, option_139789496169072], **{'doc': u'', 'properties': (), 'name': 'service_access29'})
    option_139789496169344 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496169616 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496169888 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496170160 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 4201, 'doc': u'', 'properties': ()})
    option_139789496170432 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496170704 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496170976 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496171248 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496171520 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497970768}]})
    option_139789496172944 = OptionDescription(children=[option_139789496169344, option_139789496169616, option_139789496169888, option_139789496170160, option_139789496170432, option_139789496170704, option_139789496170976, option_139789496171248, option_139789496171520], **{'doc': u'', 'properties': (), 'name': 'service_access30'})
    option_139789496171792 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496172064 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496180816 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496181088 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 4202, 'doc': u'', 'properties': ()})
    option_139789496181360 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496181632 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496181904 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496182176 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496182448 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497970768}]})
    option_139789496173264 = OptionDescription(children=[option_139789496171792, option_139789496172064, option_139789496180816, option_139789496181088, option_139789496181360, option_139789496181632, option_139789496181904, option_139789496182176, option_139789496182448], **{'doc': u'', 'properties': (), 'name': 'service_access31'})
    option_139789496182720 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496182992 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496183264 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496183536 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 4200, 'doc': u'', 'properties': ()})
    option_139789496183808 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496184080 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496184352 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496193104 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496193376 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789496173584 = OptionDescription(children=[option_139789496182720, option_139789496182992, option_139789496183264, option_139789496183536, option_139789496183808, option_139789496184080, option_139789496184352, option_139789496193104, option_139789496193376], **{'doc': u'', 'properties': (), 'name': 'service_access32'})
    option_139789496193648 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496193920 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496194192 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496191528 = SymLinkOption(**{'name': 'name', "opt": option_139789497235664})
    option_139789496194464 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496194736 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496195008 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496195280 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496195552 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789496173904 = OptionDescription(children=[option_139789496193648, option_139789496193920, option_139789496194192, option_139789496191528, option_139789496194464, option_139789496194736, option_139789496195008, option_139789496195280, option_139789496195552], **{'doc': u'', 'properties': (), 'name': 'service_access33'})
    option_139789496195824 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496196096 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496196368 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496196640 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 3306, 'doc': u'', 'properties': ()})
    option_139789496205392 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496205664 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789496205936 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496206208 = UnicodeOption(**{'default': u'myPort', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496206480 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497236208}]})
    option_139789496174224 = OptionDescription(children=[option_139789496195824, option_139789496196096, option_139789496196368, option_139789496196640, option_139789496205392, option_139789496205664, option_139789496205936, option_139789496206208, option_139789496206480], **{'doc': u'', 'properties': (), 'name': 'service_access34'})
    option_139789496206752 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789496207024 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789496207296 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789496207568 = UnicodeOption(**{'default': u'mysqld', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789496207840 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789496208112 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789496208384 = UnicodeOption(**{'default': u'myPort', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789496208656 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497236208}]})
    option_139789496174544 = OptionDescription(children=[option_139789496206752, option_139789496207024, option_139789496207296, option_139789496207568, option_139789496207840, option_139789496208112, option_139789496208384, option_139789496208656], **{'doc': u'', 'properties': (), 'name': 'service_access35'})
    option_139789496208928 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495693392 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495693664 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495693936 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 9103, 'doc': u'', 'properties': ()})
    option_139789495694208 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495694480 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495694752 = UnicodeOption(**{'default': u'bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495695024 = UnicodeOption(**{'default': u'___auto_bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495695296 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789496174864 = OptionDescription(children=[option_139789496208928, option_139789495693392, option_139789495693664, option_139789495693936, option_139789495694208, option_139789495694480, option_139789495694752, option_139789495695024, option_139789495695296], **{'doc': u'', 'properties': (), 'name': 'service_access36'})
    option_139789495695568 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495695840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495696112 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495700008 = SymLinkOption(**{'name': 'name', "opt": option_139789496792752})
    option_139789495696384 = UnicodeOption(**{'default': u'tcpwrapper', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495696656 = UnicodeOption(**{'default': u'bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495696928 = UnicodeOption(**{'default': u'___auto_bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495701584 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789496175184 = OptionDescription(children=[option_139789495695568, option_139789495695840, option_139789495696112, option_139789495700008, option_139789495696384, option_139789495696656, option_139789495696928, option_139789495701584], **{'doc': u'', 'properties': (), 'name': 'service_access37'})
    option_139789495701856 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495702128 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495702400 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495702672 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 143, 'doc': u'', 'properties': ()})
    option_139789495702944 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495703216 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495703488 = UnicodeOption(**{'default': u'courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495703760 = UnicodeOption(**{'default': u'___auto_courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495704032 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747152}]})
    option_139789496175504 = OptionDescription(children=[option_139789495701856, option_139789495702128, option_139789495702400, option_139789495702672, option_139789495702944, option_139789495703216, option_139789495703488, option_139789495703760, option_139789495704032], **{'doc': u'', 'properties': (), 'name': 'service_access38'})
    option_139789495704304 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495704576 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495704848 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495705120 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 993, 'doc': u'', 'properties': ()})
    option_139789495717968 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495718240 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495718512 = UnicodeOption(**{'default': u'courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495718784 = UnicodeOption(**{'default': u'___auto_courier_imap', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495719056 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496747152}]})
    option_139789496175824 = OptionDescription(children=[option_139789495704304, option_139789495704576, option_139789495704848, option_139789495705120, option_139789495717968, option_139789495718240, option_139789495718512, option_139789495718784, option_139789495719056], **{'doc': u'', 'properties': (), 'name': 'service_access39'})
    option_139789495719328 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495719600 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495719872 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495720144 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 110, 'doc': u'', 'properties': ()})
    option_139789495720416 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495720688 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495720960 = UnicodeOption(**{'default': u'courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495721232 = UnicodeOption(**{'default': u'___auto_courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495721504 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746880}]})
    option_139789496176144 = OptionDescription(children=[option_139789495719328, option_139789495719600, option_139789495719872, option_139789495720144, option_139789495720416, option_139789495720688, option_139789495720960, option_139789495721232, option_139789495721504], **{'doc': u'', 'properties': (), 'name': 'service_access40'})
    option_139789495726160 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495726432 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495726704 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495726976 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 995, 'doc': u'', 'properties': ()})
    option_139789495727248 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495727520 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495727792 = UnicodeOption(**{'default': u'courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495728064 = UnicodeOption(**{'default': u'___auto_courier_pop', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495728336 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496746880}]})
    option_139789495742544 = OptionDescription(children=[option_139789495726160, option_139789495726432, option_139789495726704, option_139789495726976, option_139789495727248, option_139789495727520, option_139789495727792, option_139789495728064, option_139789495728336], **{'doc': u'', 'properties': (), 'name': 'service_access41'})
    option_139789495728608 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495728880 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495729152 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495732216 = SymLinkOption(**{'name': 'name', "opt": option_139789496832624})
    option_139789495729424 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495729696 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495746640 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495746912 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495747184 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495742864 = OptionDescription(children=[option_139789495728608, option_139789495728880, option_139789495729152, option_139789495732216, option_139789495729424, option_139789495729696, option_139789495746640, option_139789495746912, option_139789495747184], **{'doc': u'', 'properties': (), 'name': 'service_access42'})
    option_139789495747456 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495747728 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495748000 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495748272 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 3128, 'doc': u'', 'properties': ()})
    option_139789495748544 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495748816 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495749088 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495749360 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495749632 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495743184 = OptionDescription(children=[option_139789495747456, option_139789495747728, option_139789495748000, option_139789495748272, option_139789495748544, option_139789495748816, option_139789495749088, option_139789495749360, option_139789495749632], **{'doc': u'', 'properties': (), 'name': 'service_access43'})
    option_139789495749904 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495750176 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495754832 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495759208 = SymLinkOption(**{'name': 'name', "opt": option_139789496886688})
    option_139789495755104 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495755376 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495755648 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495755920 = UnicodeOption(**{'default': u'squid3-2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495756192 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495743504 = OptionDescription(children=[option_139789495749904, option_139789495750176, option_139789495754832, option_139789495759208, option_139789495755104, option_139789495755376, option_139789495755648, option_139789495755920, option_139789495756192], **{'doc': u'', 'properties': (), 'name': 'service_access44'})
    option_139789495756464 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495756736 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495757008 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495757280 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 631, 'doc': u'', 'properties': ()})
    option_139789495757552 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495757824 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495758096 = UnicodeOption(**{'default': u'cups', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495758368 = UnicodeOption(**{'default': u'___auto_cups', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495767120 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971856}]})
    option_139789495743824 = OptionDescription(children=[option_139789495756464, option_139789495756736, option_139789495757008, option_139789495757280, option_139789495757552, option_139789495757824, option_139789495758096, option_139789495758368, option_139789495767120], **{'doc': u'', 'properties': (), 'name': 'service_access45'})
    option_139789495767392 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495767664 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495767936 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495765544 = SymLinkOption(**{'name': 'name', "opt": option_139789496841088})
    option_139789495768208 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495768480 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'udp', 'doc': u'', 'properties': ()})
    option_139789495768752 = UnicodeOption(**{'default': u'squid3sibling', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495769024 = UnicodeOption(**{'default': u'___auto_squid3sibling', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495769296 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495744144 = OptionDescription(children=[option_139789495767392, option_139789495767664, option_139789495767936, option_139789495765544, option_139789495768208, option_139789495768480, option_139789495768752, option_139789495769024, option_139789495769296], **{'doc': u'', 'properties': (), 'name': 'service_access46'})
    option_139789495769568 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495769840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495770112 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495770384 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8443, 'doc': u'', 'properties': ()})
    option_139789495770656 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495775312 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495775584 = UnicodeOption(**{'default': u'nginx', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495775856 = UnicodeOption(**{'default': u'revsso', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495776128 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': None, 'action': 'disabled', 'inverse': False, "option": option_139789496505488}]})
    option_139789495744464 = OptionDescription(children=[option_139789495769568, option_139789495769840, option_139789495770112, option_139789495770384, option_139789495770656, option_139789495775312, option_139789495775584, option_139789495775856, option_139789495776128], **{'doc': u'', 'properties': (), 'name': 'service_access47'})
    option_139789495776400 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495776672 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495776944 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495777216 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 21, 'doc': u'', 'properties': ()})
    option_139789495777488 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495777760 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495778032 = UnicodeOption(**{'default': u'proftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495778304 = UnicodeOption(**{'default': u'proftpd_container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495778576 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}, {'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497972944}, {'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495744784 = OptionDescription(children=[option_139789495776400, option_139789495776672, option_139789495776944, option_139789495777216, option_139789495777488, option_139789495777760, option_139789495778032, option_139789495778304, option_139789495778576], **{'doc': u'', 'properties': (), 'name': 'service_access48'})
    option_139789495778848 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495783504 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495783776 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495784048 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8787, 'doc': u'', 'properties': ()})
    option_139789495784320 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495784592 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495784864 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495785136 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495785408 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495745104 = OptionDescription(children=[option_139789495778848, option_139789495783504, option_139789495783776, option_139789495784048, option_139789495784320, option_139789495784592, option_139789495784864, option_139789495785136, option_139789495785408], **{'doc': u'', 'properties': (), 'name': 'service_access49'})
    option_139789495785680 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495785952 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495786224 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495786496 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8888, 'doc': u'', 'properties': ()})
    option_139789495786768 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495787040 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495795792 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495796064 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495796336 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495745424 = OptionDescription(children=[option_139789495785680, option_139789495785952, option_139789495786224, option_139789495786496, option_139789495786768, option_139789495787040, option_139789495795792, option_139789495796064, option_139789495796336], **{'doc': u'', 'properties': (), 'name': 'service_access50'})
    option_139789495796608 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495796880 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495797152 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495797424 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8789, 'doc': u'', 'properties': ()})
    option_139789495797696 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495797968 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495798240 = UnicodeOption(**{'default': u'controle-vnc', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495798512 = UnicodeOption(**{'default': u'___auto_controle-vnc', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495798784 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495745744 = OptionDescription(children=[option_139789495796608, option_139789495796880, option_139789495797152, option_139789495797424, option_139789495797696, option_139789495797968, option_139789495798240, option_139789495798512, option_139789495798784], **{'doc': u'', 'properties': (), 'name': 'service_access51'})
    option_139789495799056 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495799328 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495808080 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495808352 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8790, 'doc': u'', 'properties': ()})
    option_139789495808624 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495808896 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495809168 = UnicodeOption(**{'default': u'controle-vnc', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495809440 = UnicodeOption(**{'default': u'___auto_controle-vnc', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495809712 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495746064 = OptionDescription(children=[option_139789495799056, option_139789495799328, option_139789495808080, option_139789495808352, option_139789495808624, option_139789495808896, option_139789495809168, option_139789495809440, option_139789495809712], **{'doc': u'', 'properties': (), 'name': 'service_access52'})
    option_139789495809984 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495810256 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495810528 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495810800 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 25, 'doc': u'', 'properties': ()})
    option_139789495811072 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495811344 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495811616 = UnicodeOption(**{'default': u'exim4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495816272 = UnicodeOption(**{'default': u'smtp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495816544 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496770640}]})
    option_139789495820368 = OptionDescription(children=[option_139789495809984, option_139789495810256, option_139789495810528, option_139789495810800, option_139789495811072, option_139789495811344, option_139789495811616, option_139789495816272, option_139789495816544], **{'doc': u'', 'properties': (), 'name': 'service_access53'})
    option_139789495816816 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495817088 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495817360 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495817632 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 465, 'doc': u'', 'properties': ()})
    option_139789495817904 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495818176 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495818448 = UnicodeOption(**{'default': u'exim4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495818720 = UnicodeOption(**{'default': u'smtp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495818992 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496770640}]})
    option_139789495820688 = OptionDescription(children=[option_139789495816816, option_139789495817088, option_139789495817360, option_139789495817632, option_139789495817904, option_139789495818176, option_139789495818448, option_139789495818720, option_139789495818992], **{'doc': u'', 'properties': (), 'name': 'service_access54'})
    option_139789495819264 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495819536 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495819808 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495828560 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 6080, 'doc': u'', 'properties': ()})
    option_139789495828832 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495829104 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495829376 = UnicodeOption(**{'default': u'websockify', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495829648 = UnicodeOption(**{'default': u'___auto_websockify', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495829920 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497146368}]})
    option_139789495821008 = OptionDescription(children=[option_139789495819264, option_139789495819536, option_139789495819808, option_139789495828560, option_139789495828832, option_139789495829104, option_139789495829376, option_139789495829648, option_139789495829920], **{'doc': u'', 'properties': (), 'name': 'service_access55'})
    option_139789495830192 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495830464 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495830736 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495834616 = SymLinkOption(**{'name': 'name', "opt": option_139789497575088})
    option_139789495831008 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495831280 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495831552 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495831824 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495832096 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495821328 = OptionDescription(children=[option_139789495830192, option_139789495830464, option_139789495830736, option_139789495834616, option_139789495831008, option_139789495831280, option_139789495831552, option_139789495831824, option_139789495832096], **{'doc': u'', 'properties': (), 'name': 'service_access56'})
    option_139789495840848 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495841120 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495841392 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495841664 = PortOption(**{'multi': False, 'name': 'name', 'allow_private': True, 'default': 8090, 'doc': u'', 'properties': ()})
    option_139789495841936 = UnicodeOption(**{'default': u'port', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495842208 = ChoiceOption(**{'multi': False, 'values': (u'tcp', u'udp'), 'name': 'protocol', 'default': 'tcp', 'doc': u'', 'properties': ()})
    option_139789495842480 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495842752 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_accesslist'})
    option_139789495843024 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495821648 = OptionDescription(children=[option_139789495840848, option_139789495841120, option_139789495841392, option_139789495841664, option_139789495841936, option_139789495842208, option_139789495842480, option_139789495842752, option_139789495843024], **{'doc': u'', 'properties': (), 'name': 'service_access57'})
    option_139789495821968 = OptionDescription(children=[option_139789495961872, option_139789495962192, option_139789495962512, option_139789495962832, option_139789495963152, option_139789496016976, option_139789496017296, option_139789496017616, option_139789496017936, option_139789496018256, option_139789496018576, option_139789496018896, option_139789496019216, option_139789496019536, option_139789496019856, option_139789496020176, option_139789496020496, option_139789496094800, option_139789496095120, option_139789496095440, option_139789496095760, option_139789496096080, option_139789496096400, option_139789496096720, option_139789496097040, option_139789496097360, option_139789496097680, option_139789496098000, option_139789496098320, option_139789496172624, option_139789496172944, option_139789496173264, option_139789496173584, option_139789496173904, option_139789496174224, option_139789496174544, option_139789496174864, option_139789496175184, option_139789496175504, option_139789496175824, option_139789496176144, option_139789495742544, option_139789495742864, option_139789495743184, option_139789495743504, option_139789495743824, option_139789495744144, option_139789495744464, option_139789495744784, option_139789495745104, option_139789495745424, option_139789495745744, option_139789495746064, option_139789495820368, option_139789495820688, option_139789495821008, option_139789495821328, option_139789495821648], **{'doc': u'', 'properties': (), 'name': 'service_accesss'})
    option_139789495843296 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495843568 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495843840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495844112 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495845784 = SymLinkOption(**{'name': 'name', "opt": option_139789498032480})
    option_139789495846344 = SymLinkOption(**{'name': 'netmask', "opt": option_139789498032752})
    option_139789495844384 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495849040 = UnicodeOption(**{'default': u'rsyslog_udp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495849312 = UnicodeOption(**{'default': u'___auto_rsyslog_udp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495849584 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495822288 = OptionDescription(children=[option_139789495843296, option_139789495843568, option_139789495843840, option_139789495844112, option_139789495845784, option_139789495846344, option_139789495844384, option_139789495849040, option_139789495849312, option_139789495849584], **{'doc': u'', 'properties': (), 'name': 'service_restriction0'})
    option_139789495849856 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495850128 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495850400 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495850672 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495853696 = SymLinkOption(**{'name': 'name', "opt": option_139789498033568})
    option_139789495854256 = SymLinkOption(**{'name': 'netmask', "opt": option_139789498033840})
    option_139789495850944 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495851216 = UnicodeOption(**{'default': u'rsyslog_tcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495851488 = UnicodeOption(**{'default': u'___auto_rsyslog_tcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495851760 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495822608 = OptionDescription(children=[option_139789495849856, option_139789495850128, option_139789495850400, option_139789495850672, option_139789495853696, option_139789495854256, option_139789495850944, option_139789495851216, option_139789495851488, option_139789495851760], **{'doc': u'', 'properties': (), 'name': 'service_restriction1'})
    option_139789495852032 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495852304 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495852576 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495861328 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495865704 = SymLinkOption(**{'name': 'name', "opt": option_139789498019088})
    option_139789495866264 = SymLinkOption(**{'name': 'netmask', "opt": option_139789498019360})
    option_139789495861600 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495861872 = UnicodeOption(**{'default': u'rsyslog_relp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495862144 = UnicodeOption(**{'default': u'___auto_rsyslog_relp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495862416 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495822928 = OptionDescription(children=[option_139789495852032, option_139789495852304, option_139789495852576, option_139789495861328, option_139789495865704, option_139789495866264, option_139789495861600, option_139789495861872, option_139789495862144, option_139789495862416], **{'doc': u'', 'properties': (), 'name': 'service_restriction2'})
    option_139789495862688 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495862960 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495863232 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495863504 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495869520 = SymLinkOption(**{'name': 'name', "opt": option_139789497558704})
    option_139789495870080 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497558976})
    option_139789495863776 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495864048 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495864320 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495864592 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495823248 = OptionDescription(children=[option_139789495862688, option_139789495862960, option_139789495863232, option_139789495863504, option_139789495869520, option_139789495870080, option_139789495863776, option_139789495864048, option_139789495864320, option_139789495864592], **{'doc': u'', 'properties': (), 'name': 'service_restriction3'})
    option_139789495864864 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495873616 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495873888 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495874160 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495873160 = SymLinkOption(**{'name': 'name', "opt": option_139789497558704})
    option_139789495877992 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497558976})
    option_139789495874432 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495874704 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495874976 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495875248 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495823568 = OptionDescription(children=[option_139789495864864, option_139789495873616, option_139789495873888, option_139789495874160, option_139789495873160, option_139789495877992, option_139789495874432, option_139789495874704, option_139789495874976, option_139789495875248], **{'doc': u'', 'properties': (), 'name': 'service_restriction4'})
    option_139789495875520 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495875792 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495876064 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495876336 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495881072 = SymLinkOption(**{'name': 'name', "opt": option_139789497636256})
    option_139789495881808 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497636528})
    option_139789495876608 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495876880 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495877152 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495885904 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495823888 = OptionDescription(children=[option_139789495875520, option_139789495875792, option_139789495876064, option_139789495876336, option_139789495881072, option_139789495881808, option_139789495876608, option_139789495876880, option_139789495877152, option_139789495885904], **{'doc': u'', 'properties': (), 'name': 'service_restriction5'})
    option_139789495886176 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495886448 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495886720 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495886992 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495884888 = SymLinkOption(**{'name': 'name', "opt": option_139789497636256})
    option_139789495885448 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497636528})
    option_139789495887264 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495887536 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495887808 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495888080 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495894096 = OptionDescription(children=[option_139789495886176, option_139789495886448, option_139789495886720, option_139789495886992, option_139789495884888, option_139789495885448, option_139789495887264, option_139789495887536, option_139789495887808, option_139789495888080], **{'doc': u'', 'properties': (), 'name': 'service_restriction6'})
    option_139789495888352 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495888624 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495888896 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495889168 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495892800 = SymLinkOption(**{'name': 'name', "opt": option_139789497714080})
    option_139789495893360 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497714352})
    option_139789495889440 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495902288 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495902560 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495902832 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495894416 = OptionDescription(children=[option_139789495888352, option_139789495888624, option_139789495888896, option_139789495889168, option_139789495892800, option_139789495893360, option_139789495889440, option_139789495902288, option_139789495902560, option_139789495902832], **{'doc': u'', 'properties': (), 'name': 'service_restriction7'})
    option_139789495903104 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495903376 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495903648 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495903920 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495900712 = SymLinkOption(**{'name': 'name', "opt": option_139789497714080})
    option_139789495901272 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497714352})
    option_139789495904192 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495904464 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495904736 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495905008 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495894736 = OptionDescription(children=[option_139789495903104, option_139789495903376, option_139789495903648, option_139789495903920, option_139789495900712, option_139789495901272, option_139789495904192, option_139789495904464, option_139789495904736, option_139789495905008], **{'doc': u'', 'properties': (), 'name': 'service_restriction8'})
    option_139789495905280 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495905552 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495905824 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495910480 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495908624 = SymLinkOption(**{'name': 'name', "opt": option_139789497768688})
    option_139789495909184 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497768960})
    option_139789495910752 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495911024 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495911296 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495911568 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495895056 = OptionDescription(children=[option_139789495905280, option_139789495905552, option_139789495905824, option_139789495910480, option_139789495908624, option_139789495909184, option_139789495910752, option_139789495911024, option_139789495911296, option_139789495911568], **{'doc': u'', 'properties': (), 'name': 'service_restriction9'})
    option_139789495911840 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495912112 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495912384 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495912656 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495916536 = SymLinkOption(**{'name': 'name', "opt": option_139789497768688})
    option_139789495917096 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497768960})
    option_139789495912928 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495913200 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495913472 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495913744 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495895376 = OptionDescription(children=[option_139789495911840, option_139789495912112, option_139789495912384, option_139789495912656, option_139789495916536, option_139789495917096, option_139789495912928, option_139789495913200, option_139789495913472, option_139789495913744], **{'doc': u'', 'properties': (), 'name': 'service_restriction10'})
    option_139789495914016 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495922768 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495923040 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495923312 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495920352 = SymLinkOption(**{'name': 'name', "opt": option_139789497323872})
    option_139789495920912 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324144})
    option_139789495923584 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495923856 = UnicodeOption(**{'default': u'sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495924128 = UnicodeOption(**{'default': u'___auto_sshd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495924400 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495895696 = OptionDescription(children=[option_139789495914016, option_139789495922768, option_139789495923040, option_139789495923312, option_139789495920352, option_139789495920912, option_139789495923584, option_139789495923856, option_139789495924128, option_139789495924400], **{'doc': u'', 'properties': (), 'name': 'service_restriction11'})
    option_139789495924672 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495924944 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495925216 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495925488 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495928264 = SymLinkOption(**{'name': 'name', "opt": option_139789497323872})
    option_139789495928824 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324144})
    option_139789495925760 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495926032 = UnicodeOption(**{'default': u'genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495926304 = UnicodeOption(**{'default': u'___auto_genconfig', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495930960 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495896016 = OptionDescription(children=[option_139789495924672, option_139789495924944, option_139789495925216, option_139789495925488, option_139789495928264, option_139789495928824, option_139789495925760, option_139789495926032, option_139789495926304, option_139789495930960], **{'doc': u'', 'properties': (), 'name': 'service_restriction12'})
    option_139789495931232 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495931504 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495931776 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495932048 = UnicodeOption(**{'default': u'auto', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495936176 = SymLinkOption(**{'name': 'name', "opt": option_139789497519648})
    option_139789495932320 = NetmaskOption(**{'default': u'255.255.255.255', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495932592 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495932864 = UnicodeOption(**{'default': u'failover_dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495933136 = UnicodeOption(**{'default': u'failover_dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495933408 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497518288}]})
    option_139789495896336 = OptionDescription(children=[option_139789495931232, option_139789495931504, option_139789495931776, option_139789495932048, option_139789495936176, option_139789495932320, option_139789495932592, option_139789495932864, option_139789495933136, option_139789495933408], **{'doc': u'', 'properties': (), 'name': 'service_restriction13'})
    option_139789495933680 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495933952 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495934224 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495934496 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495943248 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495943520 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495943792 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495944064 = UnicodeOption(**{'default': u'tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495944336 = UnicodeOption(**{'default': u'tftp_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495944608 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': ('disabled',), 'name': 'activate'})
    option_139789495896656 = OptionDescription(children=[option_139789495933680, option_139789495933952, option_139789495934224, option_139789495934496, option_139789495943248, option_139789495943520, option_139789495943792, option_139789495944064, option_139789495944336, option_139789495944608], **{'doc': u'', 'properties': (), 'name': 'service_restriction14'})
    option_139789495944880 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495945152 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495945424 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495945696 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495945968 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495946240 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495946512 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495946784 = UnicodeOption(**{'default': u'tftpd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495951440 = UnicodeOption(**{'default': u'tftp_eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495951712 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495896976 = OptionDescription(children=[option_139789495944880, option_139789495945152, option_139789495945424, option_139789495945696, option_139789495945968, option_139789495946240, option_139789495946512, option_139789495946784, option_139789495951440, option_139789495951712], **{'doc': u'', 'properties': (), 'name': 'service_restriction15'})
    option_139789495951984 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495952256 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495952528 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495952800 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495953072 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495953344 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495953616 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495953888 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495954160 = UnicodeOption(**{'default': u'bind9_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495954432 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497596384}]})
    option_139789495897296 = OptionDescription(children=[option_139789495951984, option_139789495952256, option_139789495952528, option_139789495952800, option_139789495953072, option_139789495953344, option_139789495953616, option_139789495953888, option_139789495954160, option_139789495954432], **{'doc': u'', 'properties': (), 'name': 'service_restriction16'})
    option_139789495954704 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495954976 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495439440 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495439712 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495439984 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495440256 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495440528 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495440800 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495441072 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495441344 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495897616 = OptionDescription(children=[option_139789495954704, option_139789495954976, option_139789495439440, option_139789495439712, option_139789495439984, option_139789495440256, option_139789495440528, option_139789495440800, option_139789495441072, option_139789495441344], **{'doc': u'', 'properties': (), 'name': 'service_restriction17'})
    option_139789495441616 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495441888 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495442160 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495442432 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495442704 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495442976 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495447632 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495447904 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495448176 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495448448 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495451728 = OptionDescription(children=[option_139789495441616, option_139789495441888, option_139789495442160, option_139789495442432, option_139789495442704, option_139789495442976, option_139789495447632, option_139789495447904, option_139789495448176, option_139789495448448], **{'doc': u'', 'properties': (), 'name': 'service_restriction18'})
    option_139789495448720 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495448992 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495449264 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495449536 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495449808 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495450080 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495450352 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495450624 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495450896 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495451168 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495452048 = OptionDescription(children=[option_139789495448720, option_139789495448992, option_139789495449264, option_139789495449536, option_139789495449808, option_139789495450080, option_139789495450352, option_139789495450624, option_139789495450896, option_139789495451168], **{'doc': u'', 'properties': (), 'name': 'service_restriction19'})
    option_139789495459920 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495460192 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495460464 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495460736 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495461008 = NetworkOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495461280 = NetmaskOption(**{'default': u'0.0.0.0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495461552 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495461824 = UnicodeOption(**{'default': u'bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495462096 = UnicodeOption(**{'default': u'___auto_bind9', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495462368 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495452368 = OptionDescription(children=[option_139789495459920, option_139789495460192, option_139789495460464, option_139789495460736, option_139789495461008, option_139789495461280, option_139789495461552, option_139789495461824, option_139789495462096, option_139789495462368], **{'doc': u'', 'properties': (), 'name': 'service_restriction20'})
    option_139789495462640 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495462912 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495463184 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495463456 = UnicodeOption(**{'default': u'auto', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495466536 = SymLinkOption(**{'name': 'name', "opt": option_139789497115248})
    option_139789495467096 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497115520})
    option_139789495468112 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495468384 = UnicodeOption(**{'default': u'nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495468656 = UnicodeOption(**{'default': u'___auto_nut', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495468928 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497957104}]})
    option_139789495452688 = OptionDescription(children=[option_139789495462640, option_139789495462912, option_139789495463184, option_139789495463456, option_139789495466536, option_139789495467096, option_139789495468112, option_139789495468384, option_139789495468656, option_139789495468928], **{'doc': u'', 'properties': (), 'name': 'service_restriction21'})
    option_139789495469200 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495469472 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495469744 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495470016 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495474448 = SymLinkOption(**{'name': 'name', "opt": option_139789497603216})
    option_139789495475008 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497603488})
    option_139789495470288 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495470560 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495470832 = UnicodeOption(**{'default': u'___auto_ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495471104 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495453008 = OptionDescription(children=[option_139789495469200, option_139789495469472, option_139789495469744, option_139789495470016, option_139789495474448, option_139789495475008, option_139789495470288, option_139789495470560, option_139789495470832, option_139789495471104], **{'doc': u'', 'properties': (), 'name': 'service_restriction22'})
    option_139789495471376 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495471648 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495480400 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495480672 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495478264 = SymLinkOption(**{'name': 'name', "opt": option_139789497692512})
    option_139789495478824 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497692784})
    option_139789495480944 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495481216 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495481488 = UnicodeOption(**{'default': u'___auto_ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495481760 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495453328 = OptionDescription(children=[option_139789495471376, option_139789495471648, option_139789495480400, option_139789495480672, option_139789495478264, option_139789495478824, option_139789495480944, option_139789495481216, option_139789495481488, option_139789495481760], **{'doc': u'', 'properties': (), 'name': 'service_restriction23'})
    option_139789495482032 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495482304 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495482576 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495482848 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495486176 = SymLinkOption(**{'name': 'name', "opt": option_139789497747936})
    option_139789495486736 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497748208})
    option_139789495483120 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495483392 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495483664 = UnicodeOption(**{'default': u'___auto_ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495483936 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495453648 = OptionDescription(children=[option_139789495482032, option_139789495482304, option_139789495482576, option_139789495482848, option_139789495486176, option_139789495486736, option_139789495483120, option_139789495483392, option_139789495483664, option_139789495483936], **{'doc': u'', 'properties': (), 'name': 'service_restriction24'})
    option_139789495492688 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495492960 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495493232 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495493504 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495489992 = SymLinkOption(**{'name': 'name', "opt": option_139789497299024})
    option_139789495490552 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497299296})
    option_139789495493776 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495494048 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495494320 = UnicodeOption(**{'default': u'___auto_ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495494592 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495453968 = OptionDescription(children=[option_139789495492688, option_139789495492960, option_139789495493232, option_139789495493504, option_139789495489992, option_139789495490552, option_139789495493776, option_139789495494048, option_139789495494320, option_139789495494592], **{'doc': u'', 'properties': (), 'name': 'service_restriction25'})
    option_139789495494864 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495495136 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495495408 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495495680 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495497904 = SymLinkOption(**{'name': 'name', "opt": option_139789497353632})
    option_139789495498464 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497353904})
    option_139789495495952 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495496224 = UnicodeOption(**{'default': u'ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495500880 = UnicodeOption(**{'default': u'___auto_ead_server', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495501152 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495454288 = OptionDescription(children=[option_139789495494864, option_139789495495136, option_139789495495408, option_139789495495680, option_139789495497904, option_139789495498464, option_139789495495952, option_139789495496224, option_139789495500880, option_139789495501152], **{'doc': u'', 'properties': (), 'name': 'service_restriction26'})
    option_139789495501424 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495501696 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495501968 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495502240 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495505816 = SymLinkOption(**{'name': 'name', "opt": option_139789497559520})
    option_139789495506376 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497559792})
    option_139789495502512 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495502784 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495503056 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495503328 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789495454608 = OptionDescription(children=[option_139789495501424, option_139789495501696, option_139789495501968, option_139789495502240, option_139789495505816, option_139789495506376, option_139789495502512, option_139789495502784, option_139789495503056, option_139789495503328], **{'doc': u'', 'properties': (), 'name': 'service_restriction27'})
    option_139789495503600 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495503872 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495504144 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495504416 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495509632 = SymLinkOption(**{'name': 'name', "opt": option_139789497559520})
    option_139789495510192 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497559792})
    option_139789495513168 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495513440 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495513712 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495513984 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495454928 = OptionDescription(children=[option_139789495503600, option_139789495503872, option_139789495504144, option_139789495504416, option_139789495509632, option_139789495510192, option_139789495513168, option_139789495513440, option_139789495513712, option_139789495513984], **{'doc': u'', 'properties': (), 'name': 'service_restriction28'})
    option_139789495514256 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495514528 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495514800 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495515072 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495517544 = SymLinkOption(**{'name': 'name', "opt": option_139789497559520})
    option_139789495518104 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497559792})
    option_139789495515344 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495515616 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495515888 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495516160 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495455248 = OptionDescription(children=[option_139789495514256, option_139789495514528, option_139789495514800, option_139789495515072, option_139789495517544, option_139789495518104, option_139789495515344, option_139789495515616, option_139789495515888, option_139789495516160], **{'doc': u'', 'properties': (), 'name': 'service_restriction29'})
    option_139789495516432 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495516704 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495525456 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495525728 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495529552 = SymLinkOption(**{'name': 'name', "opt": option_139789497559520})
    option_139789495530112 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497559792})
    option_139789495526000 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495526272 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495526544 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495526816 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495533648 = OptionDescription(children=[option_139789495516432, option_139789495516704, option_139789495525456, option_139789495525728, option_139789495529552, option_139789495530112, option_139789495526000, option_139789495526272, option_139789495526544, option_139789495526816], **{'doc': u'', 'properties': (), 'name': 'service_restriction30'})
    option_139789495527088 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495527360 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495527632 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495527904 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495533192 = SymLinkOption(**{'name': 'name', "opt": option_139789497637072})
    option_139789495542120 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497637344})
    option_139789495528176 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495528448 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495528720 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495528992 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789495533968 = OptionDescription(children=[option_139789495527088, option_139789495527360, option_139789495527632, option_139789495527904, option_139789495533192, option_139789495542120, option_139789495528176, option_139789495528448, option_139789495528720, option_139789495528992], **{'doc': u'', 'properties': (), 'name': 'service_restriction31'})
    option_139789495545936 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495546208 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495546480 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495546752 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495545200 = SymLinkOption(**{'name': 'name', "opt": option_139789497637072})
    option_139789495550032 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497637344})
    option_139789495547024 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495547296 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495547568 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495547840 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495534288 = OptionDescription(children=[option_139789495545936, option_139789495546208, option_139789495546480, option_139789495546752, option_139789495545200, option_139789495550032, option_139789495547024, option_139789495547296, option_139789495547568, option_139789495547840], **{'doc': u'', 'properties': (), 'name': 'service_restriction32'})
    option_139789495548112 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495548384 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495548656 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495548928 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495553112 = SymLinkOption(**{'name': 'name', "opt": option_139789497637072})
    option_139789495553672 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497637344})
    option_139789495549200 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495549472 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495558224 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495558496 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495534608 = OptionDescription(children=[option_139789495548112, option_139789495548384, option_139789495548656, option_139789495548928, option_139789495553112, option_139789495553672, option_139789495549200, option_139789495549472, option_139789495558224, option_139789495558496], **{'doc': u'', 'properties': (), 'name': 'service_restriction33'})
    option_139789495558768 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495559040 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495559312 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495559584 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495556928 = SymLinkOption(**{'name': 'name', "opt": option_139789497637072})
    option_139789495557488 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497637344})
    option_139789495559856 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495560128 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495560400 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495560672 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495534928 = OptionDescription(children=[option_139789495558768, option_139789495559040, option_139789495559312, option_139789495559584, option_139789495556928, option_139789495557488, option_139789495559856, option_139789495560128, option_139789495560400, option_139789495560672], **{'doc': u'', 'properties': (), 'name': 'service_restriction34'})
    option_139789495560944 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495561216 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495561488 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495561760 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495564840 = SymLinkOption(**{'name': 'name', "opt": option_139789497714896})
    option_139789495565400 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497715168})
    option_139789495566416 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495566688 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495566960 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495567232 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789495535248 = OptionDescription(children=[option_139789495560944, option_139789495561216, option_139789495561488, option_139789495561760, option_139789495564840, option_139789495565400, option_139789495566416, option_139789495566688, option_139789495566960, option_139789495567232], **{'doc': u'', 'properties': (), 'name': 'service_restriction35'})
    option_139789495567504 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495567776 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495568048 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495568320 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495572752 = SymLinkOption(**{'name': 'name', "opt": option_139789497714896})
    option_139789495573312 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497715168})
    option_139789495568592 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495568864 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495569136 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495569408 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495535568 = OptionDescription(children=[option_139789495567504, option_139789495567776, option_139789495568048, option_139789495568320, option_139789495572752, option_139789495573312, option_139789495568592, option_139789495568864, option_139789495569136, option_139789495569408], **{'doc': u'', 'properties': (), 'name': 'service_restriction36'})
    option_139789495569680 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495569952 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495578704 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495578976 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495576568 = SymLinkOption(**{'name': 'name', "opt": option_139789497714896})
    option_139789495577128 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497715168})
    option_139789495579248 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495579520 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495579792 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495580064 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495535888 = OptionDescription(children=[option_139789495569680, option_139789495569952, option_139789495578704, option_139789495578976, option_139789495576568, option_139789495577128, option_139789495579248, option_139789495579520, option_139789495579792, option_139789495580064], **{'doc': u'', 'properties': (), 'name': 'service_restriction37'})
    option_139789495580336 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495580608 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495580880 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495581152 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495588576 = SymLinkOption(**{'name': 'name', "opt": option_139789497714896})
    option_139789495589136 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497715168})
    option_139789495581424 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495581696 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495581968 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495582240 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495536208 = OptionDescription(children=[option_139789495580336, option_139789495580608, option_139789495580880, option_139789495581152, option_139789495588576, option_139789495589136, option_139789495581424, option_139789495581696, option_139789495581968, option_139789495582240], **{'doc': u'', 'properties': (), 'name': 'service_restriction38'})
    option_139789495595088 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495595360 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495595632 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495595904 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495592392 = SymLinkOption(**{'name': 'name', "opt": option_139789497769504})
    option_139789495592952 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497782352})
    option_139789495596176 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495596448 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495596720 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495596992 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789495536528 = OptionDescription(children=[option_139789495595088, option_139789495595360, option_139789495595632, option_139789495595904, option_139789495592392, option_139789495592952, option_139789495596176, option_139789495596448, option_139789495596720, option_139789495596992], **{'doc': u'', 'properties': (), 'name': 'service_restriction39'})
    option_139789495597264 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495597536 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495597808 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495598080 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495600304 = SymLinkOption(**{'name': 'name', "opt": option_139789497769504})
    option_139789495600864 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497782352})
    option_139789495598352 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495598624 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495603280 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495603552 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495536848 = OptionDescription(children=[option_139789495597264, option_139789495597536, option_139789495597808, option_139789495598080, option_139789495600304, option_139789495600864, option_139789495598352, option_139789495598624, option_139789495603280, option_139789495603552], **{'doc': u'', 'properties': (), 'name': 'service_restriction40'})
    option_139789495603824 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495604096 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495604368 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495604640 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495608216 = SymLinkOption(**{'name': 'name', "opt": option_139789497769504})
    option_139789495608776 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497782352})
    option_139789495604912 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495605184 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495605456 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495605728 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495537168 = OptionDescription(children=[option_139789495603824, option_139789495604096, option_139789495604368, option_139789495604640, option_139789495608216, option_139789495608776, option_139789495604912, option_139789495605184, option_139789495605456, option_139789495605728], **{'doc': u'', 'properties': (), 'name': 'service_restriction41'})
    option_139789495606000 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495606272 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495606544 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495606816 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495612032 = SymLinkOption(**{'name': 'name', "opt": option_139789497769504})
    option_139789495612592 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497782352})
    option_139789495615568 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495615840 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495616112 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495616384 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495619664 = OptionDescription(children=[option_139789495606000, option_139789495606272, option_139789495606544, option_139789495606816, option_139789495612032, option_139789495612592, option_139789495615568, option_139789495615840, option_139789495616112, option_139789495616384], **{'doc': u'', 'properties': (), 'name': 'service_restriction42'})
    option_139789495616656 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495616928 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495617200 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495617472 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495624040 = SymLinkOption(**{'name': 'name', "opt": option_139789497324688})
    option_139789495624600 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324960})
    option_139789495617744 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495618016 = UnicodeOption(**{'default': u'ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495618288 = UnicodeOption(**{'default': u'___auto_ead_web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495618560 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497964480}]})
    option_139789495619984 = OptionDescription(children=[option_139789495616656, option_139789495616928, option_139789495617200, option_139789495617472, option_139789495624040, option_139789495624600, option_139789495617744, option_139789495618016, option_139789495618288, option_139789495618560], **{'doc': u'', 'properties': (), 'name': 'service_restriction43'})
    option_139789495618832 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495619104 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495627856 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495628128 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495631952 = SymLinkOption(**{'name': 'name', "opt": option_139789497324688})
    option_139789495632512 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324960})
    option_139789495628400 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495628672 = UnicodeOption(**{'default': u'lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495628944 = UnicodeOption(**{'default': u'___auto_lightsquid', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495629216 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495620304 = OptionDescription(children=[option_139789495618832, option_139789495619104, option_139789495627856, option_139789495628128, option_139789495631952, option_139789495632512, option_139789495628400, option_139789495628672, option_139789495628944, option_139789495629216], **{'doc': u'', 'properties': (), 'name': 'service_restriction44'})
    option_139789495629488 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495629760 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495630032 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495630304 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495635592 = SymLinkOption(**{'name': 'name', "opt": option_139789497324688})
    option_139789495640424 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324960})
    option_139789495630576 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495630848 = UnicodeOption(**{'default': u'sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495631120 = UnicodeOption(**{'default': u'___auto_sympa', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495631392 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789496748784}]})
    option_139789495620624 = OptionDescription(children=[option_139789495629488, option_139789495629760, option_139789495630032, option_139789495630304, option_139789495635592, option_139789495640424, option_139789495630576, option_139789495630848, option_139789495631120, option_139789495631392], **{'doc': u'', 'properties': (), 'name': 'service_restriction45'})
    option_139789495648336 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495648608 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495648880 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495649152 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495643504 = SymLinkOption(**{'name': 'name', "opt": option_139789497324688})
    option_139789495652432 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497324960})
    option_139789495649424 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495649696 = UnicodeOption(**{'default': u'z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495649968 = UnicodeOption(**{'default': u'___auto_z_stats', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495650240 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495620944 = OptionDescription(children=[option_139789495648336, option_139789495648608, option_139789495648880, option_139789495649152, option_139789495643504, option_139789495652432, option_139789495649424, option_139789495649696, option_139789495649968, option_139789495650240], **{'doc': u'', 'properties': (), 'name': 'service_restriction46'})
    option_139789495650512 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495650784 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495651056 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495655232 = SymLinkOption(**{'name': 'interface', "opt": option_139789497237024})
    option_139789495655792 = SymLinkOption(**{'name': 'name', "opt": option_139789497236480})
    option_139789495656528 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497236752})
    option_139789495651328 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495651600 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495651872 = UnicodeOption(**{'default': u'___auto_mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495660624 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971312}]})
    option_139789495621264 = OptionDescription(children=[option_139789495650512, option_139789495650784, option_139789495651056, option_139789495655232, option_139789495655792, option_139789495656528, option_139789495651328, option_139789495651600, option_139789495651872, option_139789495660624], **{'doc': u'', 'properties': (), 'name': 'service_restriction47'})
    option_139789495660896 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495661168 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495661440 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495661712 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495659608 = SymLinkOption(**{'name': 'name', "opt": option_139789496793296})
    option_139789495661984 = NetmaskOption(**{'default': u'255.255.255.255', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495662256 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495662528 = UnicodeOption(**{'default': u'bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495662800 = UnicodeOption(**{'default': u'___auto_bareos_sd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495663072 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497971040}]})
    option_139789495621584 = OptionDescription(children=[option_139789495660896, option_139789495661168, option_139789495661440, option_139789495661712, option_139789495659608, option_139789495661984, option_139789495662256, option_139789495662528, option_139789495662800, option_139789495663072], **{'doc': u'', 'properties': (), 'name': 'service_restriction48'})
    option_139789495663344 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495663616 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495663888 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495664160 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495667240 = SymLinkOption(**{'name': 'name', "opt": option_139789497539312})
    option_139789495667800 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497539040})
    option_139789495668816 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495669088 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495669360 = UnicodeOption(**{'default': u'proxy_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495669632 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789495621904 = OptionDescription(children=[option_139789495663344, option_139789495663616, option_139789495663888, option_139789495664160, option_139789495667240, option_139789495667800, option_139789495668816, option_139789495669088, option_139789495669360, option_139789495669632], **{'doc': u'', 'properties': (), 'name': 'service_restriction49'})
    option_139789495669904 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495670176 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495670448 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495670720 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495675152 = SymLinkOption(**{'name': 'name', "opt": option_139789497539312})
    option_139789495675712 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497539040})
    option_139789495670992 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495671264 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495671536 = UnicodeOption(**{'default': u'cntlm_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495671808 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': ('disabled',), 'name': 'activate'})
    option_139789495622224 = OptionDescription(children=[option_139789495669904, option_139789495670176, option_139789495670448, option_139789495670720, option_139789495675152, option_139789495675712, option_139789495670992, option_139789495671264, option_139789495671536, option_139789495671808], **{'doc': u'', 'properties': (), 'name': 'service_restriction50'})
    option_139789495672080 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495672352 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495681104 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495681376 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495678968 = SymLinkOption(**{'name': 'name', "opt": option_139789497602672})
    option_139789495679528 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497602944})
    option_139789495681648 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495681920 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495682192 = UnicodeOption(**{'default': u'proxy_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495682464 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789495622544 = OptionDescription(children=[option_139789495672080, option_139789495672352, option_139789495681104, option_139789495681376, option_139789495678968, option_139789495679528, option_139789495681648, option_139789495681920, option_139789495682192, option_139789495682464], **{'doc': u'', 'properties': (), 'name': 'service_restriction51'})
    option_139789495682736 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495683008 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495683280 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495683552 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495686880 = SymLinkOption(**{'name': 'name', "opt": option_139789497602672})
    option_139789495687440 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497602944})
    option_139789495683824 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495684096 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495684368 = UnicodeOption(**{'default': u'cntlm_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495684640 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': ('disabled',), 'name': 'activate'})
    option_139789495622864 = OptionDescription(children=[option_139789495682736, option_139789495683008, option_139789495683280, option_139789495683552, option_139789495686880, option_139789495687440, option_139789495683824, option_139789495684096, option_139789495684368, option_139789495684640], **{'doc': u'', 'properties': (), 'name': 'service_restriction52'})
    option_139789495169104 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495169376 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495169648 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495169920 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495690696 = SymLinkOption(**{'name': 'name', "opt": option_139789497604576})
    option_139789495691256 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497604304})
    option_139789495170192 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495170464 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495170736 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495171008 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495623184 = OptionDescription(children=[option_139789495169104, option_139789495169376, option_139789495169648, option_139789495169920, option_139789495690696, option_139789495691256, option_139789495170192, option_139789495170464, option_139789495170736, option_139789495171008], **{'doc': u'', 'properties': (), 'name': 'service_restriction53'})
    option_139789495171280 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495171552 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495171824 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495172096 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495174320 = SymLinkOption(**{'name': 'name', "opt": option_139789497604576})
    option_139789495174880 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497604304})
    option_139789495172368 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495172640 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495177296 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495177568 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495181392 = OptionDescription(children=[option_139789495171280, option_139789495171552, option_139789495171824, option_139789495172096, option_139789495174320, option_139789495174880, option_139789495172368, option_139789495172640, option_139789495177296, option_139789495177568], **{'doc': u'', 'properties': (), 'name': 'service_restriction54'})
    option_139789495177840 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495178112 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495178384 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495178656 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495186328 = SymLinkOption(**{'name': 'name', "opt": option_139789497694688})
    option_139789495186888 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497694416})
    option_139789495178928 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495179200 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495179472 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495179744 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495181712 = OptionDescription(children=[option_139789495177840, option_139789495178112, option_139789495178384, option_139789495178656, option_139789495186328, option_139789495186888, option_139789495178928, option_139789495179200, option_139789495179472, option_139789495179744], **{'doc': u'', 'properties': (), 'name': 'service_restriction55'})
    option_139789495180016 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495180288 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495180560 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495180832 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495190144 = SymLinkOption(**{'name': 'name', "opt": option_139789497694688})
    option_139789495190704 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497694416})
    option_139789495193680 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495193952 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495194224 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495194496 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495182032 = OptionDescription(children=[option_139789495180016, option_139789495180288, option_139789495180560, option_139789495180832, option_139789495190144, option_139789495190704, option_139789495193680, option_139789495193952, option_139789495194224, option_139789495194496], **{'doc': u'', 'properties': (), 'name': 'service_restriction56'})
    option_139789495194768 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495195040 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495195312 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495195584 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495198056 = SymLinkOption(**{'name': 'name', "opt": option_139789497765968})
    option_139789495198616 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497749024})
    option_139789495195856 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495196128 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495196400 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495196672 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495182352 = OptionDescription(children=[option_139789495194768, option_139789495195040, option_139789495195312, option_139789495195584, option_139789495198056, option_139789495198616, option_139789495195856, option_139789495196128, option_139789495196400, option_139789495196672], **{'doc': u'', 'properties': (), 'name': 'service_restriction57'})
    option_139789495196944 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495197216 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495201872 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495202144 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495205968 = SymLinkOption(**{'name': 'name', "opt": option_139789497765968})
    option_139789495206528 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497749024})
    option_139789495202416 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495202688 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495202960 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495203232 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495182672 = OptionDescription(children=[option_139789495196944, option_139789495197216, option_139789495201872, option_139789495202144, option_139789495205968, option_139789495206528, option_139789495202416, option_139789495202688, option_139789495202960, option_139789495203232], **{'doc': u'', 'properties': (), 'name': 'service_restriction58'})
    option_139789495203504 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495203776 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495204048 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495204320 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495209608 = SymLinkOption(**{'name': 'name', "opt": option_139789497300384})
    option_139789495210344 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497300112})
    option_139789495204592 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495204864 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495205136 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495205408 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495182992 = OptionDescription(children=[option_139789495203504, option_139789495203776, option_139789495204048, option_139789495204320, option_139789495209608, option_139789495210344, option_139789495204592, option_139789495204864, option_139789495205136, option_139789495205408], **{'doc': u'', 'properties': (), 'name': 'service_restriction59'})
    option_139789495218256 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495218528 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495218800 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495219072 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495213424 = SymLinkOption(**{'name': 'name', "opt": option_139789497300384})
    option_139789495222352 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497300112})
    option_139789495219344 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495219616 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495219888 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495220160 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495183312 = OptionDescription(children=[option_139789495218256, option_139789495218528, option_139789495218800, option_139789495219072, option_139789495213424, option_139789495222352, option_139789495219344, option_139789495219616, option_139789495219888, option_139789495220160], **{'doc': u'', 'properties': (), 'name': 'service_restriction60'})
    option_139789495220432 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495220704 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495220976 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495221248 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495225432 = SymLinkOption(**{'name': 'name', "opt": option_139789497593936})
    option_139789495225992 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497576992})
    option_139789495221520 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495221792 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495230544 = UnicodeOption(**{'default': u'proxy_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495230816 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789495183632 = OptionDescription(children=[option_139789495220432, option_139789495220704, option_139789495220976, option_139789495221248, option_139789495225432, option_139789495225992, option_139789495221520, option_139789495221792, option_139789495230544, option_139789495230816], **{'doc': u'', 'properties': (), 'name': 'service_restriction61'})
    option_139789495231088 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495231360 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495231632 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495231904 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495229248 = SymLinkOption(**{'name': 'name', "opt": option_139789497593936})
    option_139789495229808 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497576992})
    option_139789495232176 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495232448 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495232720 = UnicodeOption(**{'default': u'cntlm_eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495232992 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': ('disabled',), 'name': 'activate'})
    option_139789495183952 = OptionDescription(children=[option_139789495231088, option_139789495231360, option_139789495231632, option_139789495231904, option_139789495229248, option_139789495229808, option_139789495232176, option_139789495232448, option_139789495232720, option_139789495232992], **{'doc': u'', 'properties': (), 'name': 'service_restriction62'})
    option_139789495233264 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495233536 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495233808 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495234080 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495237160 = SymLinkOption(**{'name': 'name', "opt": option_139789497658912})
    option_139789495237720 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497658640})
    option_139789495238736 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495239008 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495239280 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495239552 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495184272 = OptionDescription(children=[option_139789495233264, option_139789495233536, option_139789495233808, option_139789495234080, option_139789495237160, option_139789495237720, option_139789495238736, option_139789495239008, option_139789495239280, option_139789495239552], **{'doc': u'', 'properties': (), 'name': 'service_restriction63'})
    option_139789495239824 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495240096 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495240368 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495240640 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495245072 = SymLinkOption(**{'name': 'name', "opt": option_139789497658912})
    option_139789495245632 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497658640})
    option_139789495240912 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495241184 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495241456 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495241728 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495184592 = OptionDescription(children=[option_139789495239824, option_139789495240096, option_139789495240368, option_139789495240640, option_139789495245072, option_139789495245632, option_139789495240912, option_139789495241184, option_139789495241456, option_139789495241728], **{'doc': u'', 'properties': (), 'name': 'service_restriction64'})
    option_139789495242000 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495242272 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495251024 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495251296 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495248888 = SymLinkOption(**{'name': 'name', "opt": option_139789497732096})
    option_139789495249448 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497731824})
    option_139789495251568 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495251840 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495252112 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495252384 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495184912 = OptionDescription(children=[option_139789495242000, option_139789495242272, option_139789495251024, option_139789495251296, option_139789495248888, option_139789495249448, option_139789495251568, option_139789495251840, option_139789495252112, option_139789495252384], **{'doc': u'', 'properties': (), 'name': 'service_restriction65'})
    option_139789495252656 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495252928 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495253200 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495253472 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495256800 = SymLinkOption(**{'name': 'name', "opt": option_139789497732096})
    option_139789495257360 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497731824})
    option_139789495253744 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495254016 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495254288 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495254560 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495259216 = OptionDescription(children=[option_139789495252656, option_139789495252928, option_139789495253200, option_139789495253472, option_139789495256800, option_139789495257360, option_139789495253744, option_139789495254016, option_139789495254288, option_139789495254560], **{'doc': u'', 'properties': (), 'name': 'service_restriction66'})
    option_139789495267408 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495267680 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495267952 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495268224 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495264712 = SymLinkOption(**{'name': 'name', "opt": option_139789497270896})
    option_139789495265272 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497270624})
    option_139789495268496 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495268768 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495269040 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495269312 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495259536 = OptionDescription(children=[option_139789495267408, option_139789495267680, option_139789495267952, option_139789495268224, option_139789495264712, option_139789495265272, option_139789495268496, option_139789495268768, option_139789495269040, option_139789495269312], **{'doc': u'', 'properties': (), 'name': 'service_restriction67'})
    option_139789495269584 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495269856 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495270128 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495270400 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495272624 = SymLinkOption(**{'name': 'name', "opt": option_139789497270896})
    option_139789495273184 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497270624})
    option_139789495270672 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495270944 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495275600 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495275872 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495259856 = OptionDescription(children=[option_139789495269584, option_139789495269856, option_139789495270128, option_139789495270400, option_139789495272624, option_139789495273184, option_139789495270672, option_139789495270944, option_139789495275600, option_139789495275872], **{'doc': u'', 'properties': (), 'name': 'service_restriction68'})
    option_139789495276144 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495276416 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495276688 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495276960 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495280536 = SymLinkOption(**{'name': 'name', "opt": option_139789497337792})
    option_139789495281096 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497337520})
    option_139789495277232 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495277504 = UnicodeOption(**{'default': u'squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495277776 = UnicodeOption(**{'default': u'___auto_squid3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495278048 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495260176 = OptionDescription(children=[option_139789495276144, option_139789495276416, option_139789495276688, option_139789495276960, option_139789495280536, option_139789495281096, option_139789495277232, option_139789495277504, option_139789495277776, option_139789495278048], **{'doc': u'', 'properties': (), 'name': 'service_restriction69'})
    option_139789495278320 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495278592 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495278864 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495279136 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495284352 = SymLinkOption(**{'name': 'name', "opt": option_139789497337792})
    option_139789495284912 = SymLinkOption(**{'name': 'netmask', "opt": option_139789497337520})
    option_139789495287888 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495288160 = UnicodeOption(**{'default': u'eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495288432 = UnicodeOption(**{'default': u'___auto_eole-cntlm', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495288704 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495260496 = OptionDescription(children=[option_139789495278320, option_139789495278592, option_139789495278864, option_139789495279136, option_139789495284352, option_139789495284912, option_139789495287888, option_139789495288160, option_139789495288432, option_139789495288704], **{'doc': u'', 'properties': (), 'name': 'service_restriction70'})
    option_139789495288976 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495289248 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495289520 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495289792 = UnicodeOption(**{'default': u'auto', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interface'})
    option_139789495292264 = SymLinkOption(**{'name': 'name', "opt": option_139789496486368})
    option_139789495290064 = NetmaskOption(**{'default': u'255.255.255.255', 'doc': u'', 'multi': False, 'properties': (), 'name': 'netmask'})
    option_139789495290336 = UnicodeOption(**{'default': u'ip', 'doc': u'', 'multi': False, 'properties': (), 'name': 'node_name'})
    option_139789495290608 = UnicodeOption(**{'default': u'squid3sibling', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service'})
    option_139789495290880 = UnicodeOption(**{'default': u'___auto_squid3sibling', 'doc': u'', 'multi': False, 'properties': (), 'name': 'service_restrictionlist'})
    option_139789495291152 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495260816 = OptionDescription(children=[option_139789495288976, option_139789495289248, option_139789495289520, option_139789495289792, option_139789495292264, option_139789495290064, option_139789495290336, option_139789495290608, option_139789495290880, option_139789495291152], **{'doc': u'', 'properties': (), 'name': 'service_restriction71'})
    option_139789495261136 = OptionDescription(children=[option_139789495822288, option_139789495822608, option_139789495822928, option_139789495823248, option_139789495823568, option_139789495823888, option_139789495894096, option_139789495894416, option_139789495894736, option_139789495895056, option_139789495895376, option_139789495895696, option_139789495896016, option_139789495896336, option_139789495896656, option_139789495896976, option_139789495897296, option_139789495897616, option_139789495451728, option_139789495452048, option_139789495452368, option_139789495452688, option_139789495453008, option_139789495453328, option_139789495453648, option_139789495453968, option_139789495454288, option_139789495454608, option_139789495454928, option_139789495455248, option_139789495533648, option_139789495533968, option_139789495534288, option_139789495534608, option_139789495534928, option_139789495535248, option_139789495535568, option_139789495535888, option_139789495536208, option_139789495536528, option_139789495536848, option_139789495537168, option_139789495619664, option_139789495619984, option_139789495620304, option_139789495620624, option_139789495620944, option_139789495621264, option_139789495621584, option_139789495621904, option_139789495622224, option_139789495622544, option_139789495622864, option_139789495623184, option_139789495181392, option_139789495181712, option_139789495182032, option_139789495182352, option_139789495182672, option_139789495182992, option_139789495183312, option_139789495183632, option_139789495183952, option_139789495184272, option_139789495184592, option_139789495184912, option_139789495259216, option_139789495259536, option_139789495259856, option_139789495260176, option_139789495260496, option_139789495260816], **{'doc': u'', 'properties': (), 'name': 'service_restrictions'})
    option_139789495294784 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495291424 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495296080 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495296352 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495300456 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495301016 = SymLinkOption(**{'name': 'ip', "opt": option_139789497852256})
    option_139789495296624 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495301856 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495296896 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495297168 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495297440 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495261456 = OptionDescription(children=[option_139789495294784, option_139789495291424, option_139789495296080, option_139789495296352, option_139789495300456, option_139789495301016, option_139789495296624, option_139789495301856, option_139789495296896, option_139789495297168, option_139789495297440], **{'doc': u'', 'properties': (), 'name': 'interface0'})
    option_139789495303536 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495297712 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495297984 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495298256 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495305112 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495305672 = SymLinkOption(**{'name': 'ip', "opt": option_139789497853072})
    option_139789495298528 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495306512 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495298800 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495299072 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495299344 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495261776 = OptionDescription(children=[option_139789495303536, option_139789495297712, option_139789495297984, option_139789495298256, option_139789495305112, option_139789495305672, option_139789495298528, option_139789495306512, option_139789495298800, option_139789495299072, option_139789495299344], **{'doc': u'', 'properties': (), 'name': 'interface1'})
    option_139789495308368 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495299616 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495312464 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495312736 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495309768 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495310328 = SymLinkOption(**{'name': 'ip', "opt": option_139789497853888})
    option_139789495313008 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495311168 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495313280 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495313552 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495313824 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495262096 = OptionDescription(children=[option_139789495308368, option_139789495299616, option_139789495312464, option_139789495312736, option_139789495309768, option_139789495310328, option_139789495313008, option_139789495311168, option_139789495313280, option_139789495313552, option_139789495313824], **{'doc': u'', 'properties': (), 'name': 'interface2'})
    option_139789495317120 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495314096 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495314368 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495314640 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495318520 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495319080 = SymLinkOption(**{'name': 'ip', "opt": option_139789497854704})
    option_139789495314912 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495319920 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495315184 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495315456 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495315728 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495262416 = OptionDescription(children=[option_139789495317120, option_139789495314096, option_139789495314368, option_139789495314640, option_139789495318520, option_139789495319080, option_139789495314912, option_139789495319920, option_139789495315184, option_139789495315456, option_139789495315728], **{'doc': u'', 'properties': (), 'name': 'interface3'})
    option_139789495321776 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495316000 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495324752 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495325024 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495323176 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495323736 = SymLinkOption(**{'name': 'ip', "opt": option_139789497855520})
    option_139789495325296 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495328848 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495325568 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495325840 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495326112 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495262736 = OptionDescription(children=[option_139789495321776, option_139789495316000, option_139789495324752, option_139789495325024, option_139789495323176, option_139789495323736, option_139789495325296, option_139789495328848, option_139789495325568, option_139789495325840, option_139789495326112], **{'doc': u'', 'properties': (), 'name': 'interface4'})
    option_139789495330528 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495326384 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495326656 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495326928 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495331928 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495332488 = SymLinkOption(**{'name': 'ip', "opt": option_139789497864816})
    option_139789495327200 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495333504 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495327472 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495327744 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495328016 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495337040 = OptionDescription(children=[option_139789495330528, option_139789495326384, option_139789495326656, option_139789495326928, option_139789495331928, option_139789495332488, option_139789495327200, option_139789495333504, option_139789495327472, option_139789495327744, option_139789495328016], **{'doc': u'', 'properties': (), 'name': 'interface5'})
    option_139789495335184 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495328288 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495341136 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495341408 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495336584 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495345512 = SymLinkOption(**{'name': 'ip', "opt": option_139789497865632})
    option_139789495341680 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495346352 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495341952 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495342224 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495342496 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495337360 = OptionDescription(children=[option_139789495335184, option_139789495328288, option_139789495341136, option_139789495341408, option_139789495336584, option_139789495345512, option_139789495341680, option_139789495346352, option_139789495341952, option_139789495342224, option_139789495342496], **{'doc': u'', 'properties': (), 'name': 'interface6'})
    option_139789495348032 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495342768 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495343040 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495343312 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495353704 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495354264 = SymLinkOption(**{'name': 'ip', "opt": option_139789497866448})
    option_139789495343584 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495355104 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495343856 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495344128 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495344400 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495337680 = OptionDescription(children=[option_139789495348032, option_139789495342768, option_139789495343040, option_139789495343312, option_139789495353704, option_139789495354264, option_139789495343584, option_139789495355104, option_139789495343856, option_139789495344128, option_139789495344400], **{'doc': u'', 'properties': (), 'name': 'interface7'})
    option_139789495356784 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495344672 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495361616 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495361888 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495358360 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495358920 = SymLinkOption(**{'name': 'ip', "opt": option_139789497867264})
    option_139789495362160 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495359760 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495362432 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495362704 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495362976 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495338000 = OptionDescription(children=[option_139789495356784, option_139789495344672, option_139789495361616, option_139789495361888, option_139789495358360, option_139789495358920, option_139789495362160, option_139789495359760, option_139789495362432, option_139789495362704, option_139789495362976], **{'doc': u'', 'properties': (), 'name': 'interface8'})
    option_139789495365712 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495363248 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495363520 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495363792 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495367112 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495367672 = SymLinkOption(**{'name': 'ip', "opt": option_139789497872464})
    option_139789495364064 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495368512 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495364336 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495364608 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495364880 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495338320 = OptionDescription(children=[option_139789495365712, option_139789495363248, option_139789495363520, option_139789495363792, option_139789495367112, option_139789495367672, option_139789495364064, option_139789495368512, option_139789495364336, option_139789495364608, option_139789495364880], **{'doc': u'', 'properties': (), 'name': 'interface9'})
    option_139789495370368 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495365152 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495373904 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495374176 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495371768 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495372328 = SymLinkOption(**{'name': 'ip', "opt": option_139789497873280})
    option_139789495374448 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495373168 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495374720 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495374992 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495375264 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495338640 = OptionDescription(children=[option_139789495370368, option_139789495365152, option_139789495373904, option_139789495374176, option_139789495371768, option_139789495372328, option_139789495374448, option_139789495373168, option_139789495374720, option_139789495374992, option_139789495375264], **{'doc': u'', 'properties': (), 'name': 'interface10'})
    option_139789495379120 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495375536 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495375808 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495376080 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495380520 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495381080 = SymLinkOption(**{'name': 'ip', "opt": option_139789497874096})
    option_139789495376352 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495382096 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495376624 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495376896 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495377168 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495338960 = OptionDescription(children=[option_139789495379120, option_139789495375536, option_139789495375808, option_139789495376080, option_139789495380520, option_139789495381080, option_139789495376352, option_139789495382096, option_139789495376624, option_139789495376896, option_139789495377168], **{'doc': u'', 'properties': (), 'name': 'interface11'})
    option_139789495383776 = SymLinkOption(**{'name': 'bcast', "opt": option_139789498664896})
    option_139789495377440 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495386192 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495386464 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495385176 = SymLinkOption(**{'name': 'gateway', "opt": option_139789498664080})
    option_139789495385736 = SymLinkOption(**{'name': 'ip', "opt": option_139789497874912})
    option_139789495386736 = UnicodeOption(**{'default': u'br0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495390848 = SymLinkOption(**{'name': 'mask', "opt": option_139789498664352})
    option_139789495387008 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'bridge', 'doc': u'', 'properties': ()})
    option_139789495387280 = UnicodeOption(**{'default': u'containers', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495387552 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495339280 = OptionDescription(children=[option_139789495383776, option_139789495377440, option_139789495386192, option_139789495386464, option_139789495385176, option_139789495385736, option_139789495386736, option_139789495390848, option_139789495387008, option_139789495387280, option_139789495387552], **{'doc': u'', 'properties': (), 'name': 'interface12'})
    option_139789495392528 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497693600})
    option_139789495387824 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495388096 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495388368 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495393928 = SymLinkOption(**{'name': 'ip', "opt": option_139789497693056})
    option_139789495388640 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495394944 = SymLinkOption(**{'name': 'mask', "opt": option_139789497693328})
    option_139789495388912 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495389184 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495389456 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495339600 = OptionDescription(children=[option_139789495392528, option_139789495387824, option_139789495388096, option_139789495388368, option_139789495393928, option_139789495388640, option_139789495394944, option_139789495388912, option_139789495389184, option_139789495389456], **{'doc': u'', 'properties': (), 'name': 'interface13'})
    option_139789495396624 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497692240})
    option_139789495389728 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495398480 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495398752 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495399024 = UnicodeOption(**{'default': u'eth1_proxy_link', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interfacelist'})
    option_139789495402576 = SymLinkOption(**{'name': 'ip', "opt": option_139789497675024})
    option_139789495399296 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495403416 = SymLinkOption(**{'name': 'mask', "opt": option_139789497675296})
    option_139789495399568 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495399840 = UnicodeOption(**{'default': u'eth1', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495400112 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495339920 = OptionDescription(children=[option_139789495396624, option_139789495389728, option_139789495398480, option_139789495398752, option_139789495399024, option_139789495402576, option_139789495399296, option_139789495403416, option_139789495399568, option_139789495399840, option_139789495400112], **{'doc': u'', 'properties': (), 'name': 'interface14'})
    option_139789495405096 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497602128})
    option_139789495400384 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495400656 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495400928 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495401200 = UnicodeOption(**{'default': u'eth0_proxy_link', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interfacelist'})
    option_139789495411048 = SymLinkOption(**{'name': 'ip', "opt": option_139789497597200})
    option_139789495401472 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495411888 = SymLinkOption(**{'name': 'mask', "opt": option_139789497597472})
    option_139789495401744 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495402016 = UnicodeOption(**{'default': u'eth0', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495414864 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'5', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789495340240 = OptionDescription(children=[option_139789495405096, option_139789495400384, option_139789495400656, option_139789495400928, option_139789495401200, option_139789495411048, option_139789495401472, option_139789495411888, option_139789495401744, option_139789495402016, option_139789495414864], **{'doc': u'', 'properties': (), 'name': 'interface15'})
    option_139789495413568 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497747664})
    option_139789495415136 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495415408 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495415680 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495415952 = UnicodeOption(**{'default': u'eth2_proxy_link', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interfacelist'})
    option_139789495419520 = SymLinkOption(**{'name': 'ip', "opt": option_139789497747120})
    option_139789495416224 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495420360 = SymLinkOption(**{'name': 'mask', "opt": option_139789497747392})
    option_139789495416496 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495416768 = UnicodeOption(**{'default': u'eth2', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495417040 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789495340560 = OptionDescription(children=[option_139789495413568, option_139789495415136, option_139789495415408, option_139789495415680, option_139789495415952, option_139789495419520, option_139789495416224, option_139789495420360, option_139789495416496, option_139789495416768, option_139789495417040], **{'doc': u'', 'properties': (), 'name': 'interface16'})
    option_139789495422040 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497273888})
    option_139789495417312 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495417584 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495417856 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495418128 = UnicodeOption(**{'default': u'eth3_proxy_link', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interfacelist'})
    option_139789495423896 = SymLinkOption(**{'name': 'ip', "opt": option_139789497273344})
    option_139789495418400 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789495424736 = SymLinkOption(**{'name': 'mask', "opt": option_139789497273616})
    option_139789495427152 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495427424 = UnicodeOption(**{'default': u'eth3', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495427696 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789494906960 = OptionDescription(children=[option_139789495422040, option_139789495417312, option_139789495417584, option_139789495417856, option_139789495418128, option_139789495423896, option_139789495418400, option_139789495424736, option_139789495427152, option_139789495427424, option_139789495427696], **{'doc': u'', 'properties': (), 'name': 'interface17'})
    option_139789495426416 = SymLinkOption(**{'name': 'bcast', "opt": option_139789497353360})
    option_139789495427968 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495428240 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495428512 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495428784 = UnicodeOption(**{'default': u'eth4_proxy_link', 'doc': u'', 'multi': False, 'properties': (), 'name': 'interfacelist'})
    option_139789494912176 = SymLinkOption(**{'name': 'ip', "opt": option_139789497352816})
    option_139789495429056 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'linkto'})
    option_139789494913016 = SymLinkOption(**{'name': 'mask', "opt": option_139789497353088})
    option_139789495429328 = ChoiceOption(**{'multi': False, 'values': (u'bridge', u'macvlan'), 'name': 'method', 'default': 'macvlan', 'doc': u'', 'properties': ()})
    option_139789495429600 = UnicodeOption(**{'default': u'eth4', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495429872 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'2', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'3', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}, {'expected': u'4', 'action': 'disabled', 'inverse': False, "option": option_139789497891840}]})
    option_139789494907280 = OptionDescription(children=[option_139789495426416, option_139789495427968, option_139789495428240, option_139789495428512, option_139789495428784, option_139789494912176, option_139789495429056, option_139789494913016, option_139789495429328, option_139789495429600, option_139789495429872], **{'doc': u'', 'properties': (), 'name': 'interface18'})
    option_139789494907600 = OptionDescription(children=[option_139789495261456, option_139789495261776, option_139789495262096, option_139789495262416, option_139789495262736, option_139789495337040, option_139789495337360, option_139789495337680, option_139789495338000, option_139789495338320, option_139789495338640, option_139789495338960, option_139789495339280, option_139789495339600, option_139789495339920, option_139789495340240, option_139789495340560, option_139789494906960, option_139789494907280], **{'doc': u'', 'properties': (), 'name': 'interfaces'})
    option_139789495430144 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495430416 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495430688 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494919248 = UnicodeOption(**{'default': u'eole-antivirus-container-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494907920 = OptionDescription(children=[option_139789495430144, option_139789495430416, option_139789495430688, option_139789494919248], **{'doc': u'', 'properties': (), 'name': 'package0'})
    option_139789494919520 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494919792 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494920064 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494920336 = UnicodeOption(**{'default': u'eole-antivirus-container-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494908240 = OptionDescription(children=[option_139789494919520, option_139789494919792, option_139789494920064, option_139789494920336], **{'doc': u'', 'properties': (), 'name': 'package1'})
    option_139789494920608 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494920880 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494921152 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494921424 = UnicodeOption(**{'default': u'eole-antivirus-container-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494908560 = OptionDescription(children=[option_139789494920608, option_139789494920880, option_139789494921152, option_139789494921424], **{'doc': u'', 'properties': (), 'name': 'package2'})
    option_139789494921696 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494921968 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494922240 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494922512 = UnicodeOption(**{'default': u'eole-antivirus-container-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494908880 = OptionDescription(children=[option_139789494921696, option_139789494921968, option_139789494922240, option_139789494922512], **{'doc': u'', 'properties': (), 'name': 'package3'})
    option_139789494922784 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494927440 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494927712 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494927984 = UnicodeOption(**{'default': u'eole-dhcp-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494909200 = OptionDescription(children=[option_139789494922784, option_139789494927440, option_139789494927712, option_139789494927984], **{'doc': u'', 'properties': (), 'name': 'package4'})
    option_139789494928256 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494928528 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494928800 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494929072 = UnicodeOption(**{'default': u'eole-fichier-primaire-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494909520 = OptionDescription(children=[option_139789494928256, option_139789494928528, option_139789494928800, option_139789494929072], **{'doc': u'', 'properties': (), 'name': 'package5'})
    option_139789494929344 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494929616 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494929888 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494930160 = UnicodeOption(**{'default': u'eole-fichier-common-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494909840 = OptionDescription(children=[option_139789494929344, option_139789494929616, option_139789494929888, option_139789494930160], **{'doc': u'', 'properties': (), 'name': 'package6'})
    option_139789494930432 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494930704 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494930976 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494935632 = UnicodeOption(**{'default': u'eole-web-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494910160 = OptionDescription(children=[option_139789494930432, option_139789494930704, option_139789494930976, option_139789494935632], **{'doc': u'', 'properties': (), 'name': 'package7'})
    option_139789494935904 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494936176 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494936448 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494936720 = UnicodeOption(**{'default': u'eole-bareoswebui-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494910480 = OptionDescription(children=[option_139789494935904, option_139789494936176, option_139789494936448, option_139789494936720], **{'doc': u'', 'properties': (), 'name': 'package8'})
    option_139789494936992 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494937264 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494937536 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494937808 = UnicodeOption(**{'default': u'eole-dns-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494943824 = OptionDescription(children=[option_139789494936992, option_139789494937264, option_139789494937536, option_139789494937808], **{'doc': u'', 'properties': (), 'name': 'package9'})
    option_139789494938080 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494938352 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494938624 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494938896 = UnicodeOption(**{'default': u'eole-mysql-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494944144 = OptionDescription(children=[option_139789494938080, option_139789494938352, option_139789494938624, option_139789494938896], **{'doc': u'', 'properties': (), 'name': 'package10'})
    option_139789494939168 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494952016 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494952288 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494952560 = UnicodeOption(**{'default': u'eole-spamassassin-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494944464 = OptionDescription(children=[option_139789494939168, option_139789494952016, option_139789494952288, option_139789494952560], **{'doc': u'', 'properties': (), 'name': 'package11'})
    option_139789494952832 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494953104 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494953376 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494953648 = UnicodeOption(**{'default': u'eole-annuaire-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494944784 = OptionDescription(children=[option_139789494952832, option_139789494953104, option_139789494953376, option_139789494953648], **{'doc': u'', 'properties': (), 'name': 'package12'})
    option_139789494953920 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494954192 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494954464 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494954736 = UnicodeOption(**{'default': u'eole-courier-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494945104 = OptionDescription(children=[option_139789494953920, option_139789494954192, option_139789494954464, option_139789494954736], **{'doc': u'', 'properties': (), 'name': 'package13'})
    option_139789494955008 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494955280 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494955552 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494964304 = UnicodeOption(**{'default': u'eole-phpmyadmin-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494945424 = OptionDescription(children=[option_139789494955008, option_139789494955280, option_139789494955552, option_139789494964304], **{'doc': u'', 'properties': (), 'name': 'package14'})
    option_139789494964576 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494964848 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494965120 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494965392 = UnicodeOption(**{'default': u'eole-proxy-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494945744 = OptionDescription(children=[option_139789494964576, option_139789494964848, option_139789494965120, option_139789494965392], **{'doc': u'', 'properties': (), 'name': 'package15'})
    option_139789494965664 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494965936 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494966208 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494966480 = UnicodeOption(**{'default': u'eole-cups-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494946064 = OptionDescription(children=[option_139789494965664, option_139789494965936, option_139789494966208, option_139789494966480], **{'doc': u'', 'properties': (), 'name': 'package16'})
    option_139789494966752 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494967024 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494967296 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494967568 = UnicodeOption(**{'default': u'eole-proftpd-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494946384 = OptionDescription(children=[option_139789494966752, option_139789494967024, option_139789494967296, option_139789494967568], **{'doc': u'', 'properties': (), 'name': 'package17'})
    option_139789494967840 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494972496 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494972768 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494973040 = UnicodeOption(**{'default': u'eole-sympa-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494946704 = OptionDescription(children=[option_139789494967840, option_139789494972496, option_139789494972768, option_139789494973040], **{'doc': u'', 'properties': (), 'name': 'package18'})
    option_139789494973312 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494973584 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494973856 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494974128 = UnicodeOption(**{'default': u'eole-controle-vnc-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494947024 = OptionDescription(children=[option_139789494973312, option_139789494973584, option_139789494973856, option_139789494974128], **{'doc': u'', 'properties': (), 'name': 'package19'})
    option_139789494974400 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494974672 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494974944 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494975216 = UnicodeOption(**{'default': u'eole-exim-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494947344 = OptionDescription(children=[option_139789494974400, option_139789494974672, option_139789494974944, option_139789494975216], **{'doc': u'', 'properties': (), 'name': 'package20'})
    option_139789494975488 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494975760 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494976032 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494980688 = UnicodeOption(**{'default': u'eole-exim-auth-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494984784 = OptionDescription(children=[option_139789494975488, option_139789494975760, option_139789494976032, option_139789494980688], **{'doc': u'', 'properties': (), 'name': 'package21'})
    option_139789494980960 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494981232 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494981504 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494981776 = UnicodeOption(**{'default': u'eole-scribe-backend', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494985104 = OptionDescription(children=[option_139789494980960, option_139789494981232, option_139789494981504, option_139789494981776], **{'doc': u'', 'properties': (), 'name': 'package22'})
    option_139789494982048 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494982320 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494982592 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494982864 = UnicodeOption(**{'default': u'eole-eoe-apps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494985424 = OptionDescription(children=[option_139789494982048, option_139789494982320, option_139789494982592, option_139789494982864], **{'doc': u'', 'properties': (), 'name': 'package23'})
    option_139789494983136 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494983408 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494983680 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494983952 = UnicodeOption(**{'default': u'eole-eop-apps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494985744 = OptionDescription(children=[option_139789494983136, option_139789494983408, option_139789494983680, option_139789494983952], **{'doc': u'', 'properties': (), 'name': 'package24'})
    option_139789494984224 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494992976 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494993248 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494993520 = UnicodeOption(**{'default': u'eole-websockify-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494986064 = OptionDescription(children=[option_139789494984224, option_139789494992976, option_139789494993248, option_139789494993520], **{'doc': u'', 'properties': (), 'name': 'package25'})
    option_139789494993792 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494994064 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494994336 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494994608 = UnicodeOption(**{'default': u'roundcube-apps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494986384 = OptionDescription(children=[option_139789494993792, option_139789494994064, option_139789494994336, option_139789494994608], **{'doc': u'', 'properties': (), 'name': 'package26'})
    option_139789494994880 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494995152 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494995424 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494995696 = UnicodeOption(**{'default': u'eole-cntlm-pkg', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494986704 = OptionDescription(children=[option_139789494994880, option_139789494995152, option_139789494995424, option_139789494995696], **{'doc': u'', 'properties': (), 'name': 'package27'})
    option_139789494995968 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494996240 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494996512 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495005264 = UnicodeOption(**{'default': u'libpam-cas-eole', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494987024 = OptionDescription(children=[option_139789494995968, option_139789494996240, option_139789494996512, option_139789495005264], **{'doc': u'', 'properties': (), 'name': 'package28'})
    option_139789495005536 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495005808 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495006080 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495006352 = UnicodeOption(**{'default': u'pydio-apps', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494987344 = OptionDescription(children=[option_139789495005536, option_139789495005808, option_139789495006080, option_139789495006352], **{'doc': u'', 'properties': (), 'name': 'package29'})
    option_139789494987664 = OptionDescription(children=[option_139789494907920, option_139789494908240, option_139789494908560, option_139789494908880, option_139789494909200, option_139789494909520, option_139789494909840, option_139789494910160, option_139789494910480, option_139789494943824, option_139789494944144, option_139789494944464, option_139789494944784, option_139789494945104, option_139789494945424, option_139789494945744, option_139789494946064, option_139789494946384, option_139789494946704, option_139789494947024, option_139789494947344, option_139789494984784, option_139789494985104, option_139789494985424, option_139789494985744, option_139789494986064, option_139789494986384, option_139789494986704, option_139789494987024, option_139789494987344], **{'doc': u'', 'properties': (), 'name': 'packages'})
    option_139789495006624 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495006896 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495007168 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495007440 = UnicodeOption(**{'default': u'/etc/eole/release', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495007712 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495007984 = UnicodeOption(**{'default': u'/etc/eole/release', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495008256 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495008528 = UnicodeOption(**{'default': u'/var/lib/creole/release', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495008800 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789494987984 = OptionDescription(children=[option_139789495006624, option_139789495006896, option_139789495007168, option_139789495007440, option_139789495007712, option_139789495007984, option_139789495008256, option_139789495008528, option_139789495008800], **{'doc': u'', 'properties': (), 'name': 'file0'})
    option_139789495013456 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495013728 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495014000 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495014272 = UnicodeOption(**{'default': u'container_disabled', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495014544 = UnicodeOption(**{'default': u'/etc/eole/.VirtDisabled.lock', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495014816 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495015088 = UnicodeOption(**{'default': u'/etc/eole/.VirtDisabled.lock', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495015360 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495015632 = UnicodeOption(**{'default': u'/var/lib/creole/container.lockfile', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495015904 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'oui', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494988304 = OptionDescription(children=[option_139789495013456, option_139789495013728, option_139789495014000, option_139789495014272, option_139789495014544, option_139789495014816, option_139789495015088, option_139789495015360, option_139789495015632, option_139789495015904], **{'doc': u'', 'properties': (), 'name': 'file1'})
    option_139789495016176 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495016448 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495016720 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495016992 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495025744 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495026016 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495026288 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495026560 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495026832 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495029840 = OptionDescription(children=[option_139789495016176, option_139789495016448, option_139789495016720, option_139789495016992, option_139789495025744, option_139789495026016, option_139789495026288, option_139789495026560, option_139789495026832], **{'doc': u'', 'properties': (), 'name': 'file2'})
    option_139789495027104 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495027376 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495027648 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495027920 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495028192 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495028464 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495028736 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495029008 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495029280 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495038032 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495030160 = OptionDescription(children=[option_139789495027104, option_139789495027376, option_139789495027648, option_139789495027920, option_139789495028192, option_139789495028464, option_139789495028736, option_139789495029008, option_139789495029280, option_139789495038032], **{'doc': u'', 'properties': (), 'name': 'file3'})
    option_139789495038304 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495038576 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495038848 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495039120 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495039392 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495039664 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495039936 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495040208 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495040480 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495040752 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495030480 = OptionDescription(children=[option_139789495038304, option_139789495038576, option_139789495038848, option_139789495039120, option_139789495039392, option_139789495039664, option_139789495039936, option_139789495040208, option_139789495040480, option_139789495040752], **{'doc': u'', 'properties': (), 'name': 'file4'})
    option_139789495041024 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495041296 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495041568 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495050320 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495050592 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495050864 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495051136 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495051408 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495051680 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495051952 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495030800 = OptionDescription(children=[option_139789495041024, option_139789495041296, option_139789495041568, option_139789495050320, option_139789495050592, option_139789495050864, option_139789495051136, option_139789495051408, option_139789495051680, option_139789495051952], **{'doc': u'', 'properties': (), 'name': 'file5'})
    option_139789495052224 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495052496 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495052768 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495053040 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495053312 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495053584 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495053856 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495062608 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495062880 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495063152 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495031120 = OptionDescription(children=[option_139789495052224, option_139789495052496, option_139789495052768, option_139789495053040, option_139789495053312, option_139789495053584, option_139789495053856, option_139789495062608, option_139789495062880, option_139789495063152], **{'doc': u'', 'properties': (), 'name': 'file6'})
    option_139789495063424 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495063696 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495063968 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495064240 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495064512 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495064784 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495065056 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495065328 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495065600 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495065872 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495031440 = OptionDescription(children=[option_139789495063424, option_139789495063696, option_139789495063968, option_139789495064240, option_139789495064512, option_139789495064784, option_139789495065056, option_139789495065328, option_139789495065600, option_139789495065872], **{'doc': u'', 'properties': (), 'name': 'file7'})
    option_139789495066144 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495070800 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495071072 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495071344 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495071616 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495071888 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495072160 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495072432 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495072704 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495072976 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495031760 = OptionDescription(children=[option_139789495066144, option_139789495070800, option_139789495071072, option_139789495071344, option_139789495071616, option_139789495071888, option_139789495072160, option_139789495072432, option_139789495072704, option_139789495072976], **{'doc': u'', 'properties': (), 'name': 'file8'})
    option_139789495073248 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495073520 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495073792 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495074064 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495074336 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495083088 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495083360 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495083632 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495083904 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495084176 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495032080 = OptionDescription(children=[option_139789495073248, option_139789495073520, option_139789495073792, option_139789495074064, option_139789495074336, option_139789495083088, option_139789495083360, option_139789495083632, option_139789495083904, option_139789495084176], **{'doc': u'', 'properties': (), 'name': 'file9'})
    option_139789495084448 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495084720 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495084992 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495085264 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495085536 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495085808 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495086080 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495086352 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495086624 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495091280 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495032400 = OptionDescription(children=[option_139789495084448, option_139789495084720, option_139789495084992, option_139789495085264, option_139789495085536, option_139789495085808, option_139789495086080, option_139789495086352, option_139789495086624, option_139789495091280], **{'doc': u'', 'properties': (), 'name': 'file10'})
    option_139789495091552 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495091824 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495092096 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495092368 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495092640 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495092912 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495093184 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495093456 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495093728 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495094000 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495032720 = OptionDescription(children=[option_139789495091552, option_139789495091824, option_139789495092096, option_139789495092368, option_139789495092640, option_139789495092912, option_139789495093184, option_139789495093456, option_139789495093728, option_139789495094000], **{'doc': u'', 'properties': (), 'name': 'file11'})
    option_139789495094272 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495094544 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495094816 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495099472 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495099744 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495100016 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495100288 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495100560 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495100832 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495101104 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495033040 = OptionDescription(children=[option_139789495094272, option_139789495094544, option_139789495094816, option_139789495099472, option_139789495099744, option_139789495100016, option_139789495100288, option_139789495100560, option_139789495100832, option_139789495101104], **{'doc': u'', 'properties': (), 'name': 'file12'})
    option_139789495101376 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495101648 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495101920 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495102192 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495102464 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495102736 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495103008 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495107664 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495107936 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495108208 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495033360 = OptionDescription(children=[option_139789495101376, option_139789495101648, option_139789495101920, option_139789495102192, option_139789495102464, option_139789495102736, option_139789495103008, option_139789495107664, option_139789495107936, option_139789495108208], **{'doc': u'', 'properties': (), 'name': 'file13'})
    option_139789495108480 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495108752 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495109024 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495109296 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495109568 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495109840 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495110112 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495110384 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495110656 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495110928 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495115856 = OptionDescription(children=[option_139789495108480, option_139789495108752, option_139789495109024, option_139789495109296, option_139789495109568, option_139789495109840, option_139789495110112, option_139789495110384, option_139789495110656, option_139789495110928], **{'doc': u'', 'properties': (), 'name': 'file14'})
    option_139789495111200 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495119952 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495120224 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495120496 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495120768 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495121040 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495121312 = UnicodeOption(**{'default': u'/etc/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495121584 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495121856 = UnicodeOption(**{'default': u'/var/lib/creole/timezone', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495122128 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495116176 = OptionDescription(children=[option_139789495111200, option_139789495119952, option_139789495120224, option_139789495120496, option_139789495120768, option_139789495121040, option_139789495121312, option_139789495121584, option_139789495121856, option_139789495122128], **{'doc': u'', 'properties': (), 'name': 'file15'})
    option_139789495122400 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495122672 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495122944 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495123216 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495123488 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495132240 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495132512 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495132784 = UnicodeOption(**{'default': u'/var/lib/creole/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495133056 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789495116496 = OptionDescription(children=[option_139789495122400, option_139789495122672, option_139789495122944, option_139789495123216, option_139789495123488, option_139789495132240, option_139789495132512, option_139789495132784, option_139789495133056], **{'doc': u'', 'properties': (), 'name': 'file16'})
    option_139789495133328 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495133600 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495133872 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495134144 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495134416 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495134688 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495134960 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495135232 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495135504 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495135776 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495116816 = OptionDescription(children=[option_139789495133328, option_139789495133600, option_139789495133872, option_139789495134144, option_139789495134416, option_139789495134688, option_139789495134960, option_139789495135232, option_139789495135504, option_139789495135776], **{'doc': u'', 'properties': (), 'name': 'file17'})
    option_139789495144528 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495144800 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495145072 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495145344 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495145616 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495145888 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495146160 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495146432 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495146704 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495146976 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495117136 = OptionDescription(children=[option_139789495144528, option_139789495144800, option_139789495145072, option_139789495145344, option_139789495145616, option_139789495145888, option_139789495146160, option_139789495146432, option_139789495146704, option_139789495146976], **{'doc': u'', 'properties': (), 'name': 'file18'})
    option_139789495147248 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495147520 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495147792 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495148064 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495156816 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495157088 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495157360 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495157632 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495157904 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495158176 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495117456 = OptionDescription(children=[option_139789495147248, option_139789495147520, option_139789495147792, option_139789495148064, option_139789495156816, option_139789495157088, option_139789495157360, option_139789495157632, option_139789495157904, option_139789495158176], **{'doc': u'', 'properties': (), 'name': 'file19'})
    option_139789495158448 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495158720 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495158992 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495159264 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495159536 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495159808 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495160080 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495160352 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495165008 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495165280 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495117776 = OptionDescription(children=[option_139789495158448, option_139789495158720, option_139789495158992, option_139789495159264, option_139789495159536, option_139789495159808, option_139789495160080, option_139789495160352, option_139789495165008, option_139789495165280], **{'doc': u'', 'properties': (), 'name': 'file20'})
    option_139789495165552 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495165824 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789495166096 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789495166368 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789495166640 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789495166912 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789495167184 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789495167456 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789495167728 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789495168000 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495118096 = OptionDescription(children=[option_139789495165552, option_139789495165824, option_139789495166096, option_139789495166368, option_139789495166640, option_139789495166912, option_139789495167184, option_139789495167456, option_139789495167728, option_139789495168000], **{'doc': u'', 'properties': (), 'name': 'file21'})
    option_139789495168272 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789495168544 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494648912 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494649184 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494649456 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494649728 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494650000 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494650272 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494650544 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494650816 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495118416 = OptionDescription(children=[option_139789495168272, option_139789495168544, option_139789494648912, option_139789494649184, option_139789494649456, option_139789494649728, option_139789494650000, option_139789494650272, option_139789494650544, option_139789494650816], **{'doc': u'', 'properties': (), 'name': 'file22'})
    option_139789494651088 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494651360 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494651632 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494651904 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494652176 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494652448 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494661200 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494661472 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494661744 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494662016 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495118736 = OptionDescription(children=[option_139789494651088, option_139789494651360, option_139789494651632, option_139789494651904, option_139789494652176, option_139789494652448, option_139789494661200, option_139789494661472, option_139789494661744, option_139789494662016], **{'doc': u'', 'properties': (), 'name': 'file23'})
    option_139789494662288 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494662560 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494662832 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494663104 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494663376 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494663648 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494663920 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494664192 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494664464 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494664736 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495119056 = OptionDescription(children=[option_139789494662288, option_139789494662560, option_139789494662832, option_139789494663104, option_139789494663376, option_139789494663648, option_139789494663920, option_139789494664192, option_139789494664464, option_139789494664736], **{'doc': u'', 'properties': (), 'name': 'file24'})
    option_139789494673488 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494673760 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494674032 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494674304 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494674576 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494674848 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494675120 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494675392 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494675664 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494675936 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789495119376 = OptionDescription(children=[option_139789494673488, option_139789494673760, option_139789494674032, option_139789494674304, option_139789494674576, option_139789494674848, option_139789494675120, option_139789494675392, option_139789494675664, option_139789494675936], **{'doc': u'', 'properties': (), 'name': 'file25'})
    option_139789494676208 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494676480 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494676752 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494677024 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494681680 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494681952 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494682224 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494682496 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494682768 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494683040 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494685776 = OptionDescription(children=[option_139789494676208, option_139789494676480, option_139789494676752, option_139789494677024, option_139789494681680, option_139789494681952, option_139789494682224, option_139789494682496, option_139789494682768, option_139789494683040], **{'doc': u'', 'properties': (), 'name': 'file26'})
    option_139789494683312 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494683584 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494683856 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494684128 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494684400 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494684672 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494684944 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494685216 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494693968 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494694240 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494686096 = OptionDescription(children=[option_139789494683312, option_139789494683584, option_139789494683856, option_139789494684128, option_139789494684400, option_139789494684672, option_139789494684944, option_139789494685216, option_139789494693968, option_139789494694240], **{'doc': u'', 'properties': (), 'name': 'file27'})
    option_139789494694512 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494694784 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494695056 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494695328 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494695600 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494695872 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494696144 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494696416 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494696688 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494696960 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494686416 = OptionDescription(children=[option_139789494694512, option_139789494694784, option_139789494695056, option_139789494695328, option_139789494695600, option_139789494695872, option_139789494696144, option_139789494696416, option_139789494696688, option_139789494696960], **{'doc': u'', 'properties': (), 'name': 'file28'})
    option_139789494697232 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494697504 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494702160 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494702432 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494702704 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494702976 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494703248 = UnicodeOption(**{'default': u'/etc/network/interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494703520 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494703792 = UnicodeOption(**{'default': u'/var/lib/creole/lxc.interfaces', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494704064 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494686736 = OptionDescription(children=[option_139789494697232, option_139789494697504, option_139789494702160, option_139789494702432, option_139789494702704, option_139789494702976, option_139789494703248, option_139789494703520, option_139789494703792, option_139789494704064], **{'doc': u'', 'properties': (), 'name': 'file29'})
    option_139789494704336 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494704608 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494704880 = UnicodeOption(**{'default': u'root', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494705152 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494705424 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494705696 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494710352 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494710624 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494710896 = BoolOption(**{'default': True, 'doc': u'', 'multi': False, 'properties': (), 'name': 'activate'})
    option_139789494687056 = OptionDescription(children=[option_139789494704336, option_139789494704608, option_139789494704880, option_139789494705152, option_139789494705424, option_139789494705696, option_139789494710352, option_139789494710624, option_139789494710896], **{'doc': u'', 'properties': (), 'name': 'file30'})
    option_139789494711168 = UnicodeOption(**{'default': u'annuaire', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494711440 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494711712 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494711984 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494712256 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494712528 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494712800 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494713072 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494713344 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494713616 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494687376 = OptionDescription(children=[option_139789494711168, option_139789494711440, option_139789494711712, option_139789494711984, option_139789494712256, option_139789494712528, option_139789494712800, option_139789494713072, option_139789494713344, option_139789494713616], **{'doc': u'', 'properties': (), 'name': 'file31'})
    option_139789494713888 = UnicodeOption(**{'default': u'mail', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494718544 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494718816 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494719088 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494719360 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494719632 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494719904 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494720176 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494720448 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494720720 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494687696 = OptionDescription(children=[option_139789494713888, option_139789494718544, option_139789494718816, option_139789494719088, option_139789494719360, option_139789494719632, option_139789494719904, option_139789494720176, option_139789494720448, option_139789494720720], **{'doc': u'', 'properties': (), 'name': 'file32'})
    option_139789494720992 = UnicodeOption(**{'default': u'dhcp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494721264 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494721536 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494721808 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494722080 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494726736 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494727008 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494727280 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494727552 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494727824 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494688016 = OptionDescription(children=[option_139789494720992, option_139789494721264, option_139789494721536, option_139789494721808, option_139789494722080, option_139789494726736, option_139789494727008, option_139789494727280, option_139789494727552, option_139789494727824], **{'doc': u'', 'properties': (), 'name': 'file33'})
    option_139789494728096 = UnicodeOption(**{'default': u'fichier', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494728368 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494728640 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494728912 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494729184 = UnicodeOption(**{'default': u'/var/lib/lxc/partage/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494729456 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494729728 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494730000 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494730272 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494739024 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494688336 = OptionDescription(children=[option_139789494728096, option_139789494728368, option_139789494728640, option_139789494728912, option_139789494729184, option_139789494729456, option_139789494729728, option_139789494730000, option_139789494730272, option_139789494739024], **{'doc': u'', 'properties': (), 'name': 'file34'})
    option_139789494739296 = UnicodeOption(**{'default': u'web', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494739568 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494739840 = UnicodeOption(**{'default': u'reseau', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494740112 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494740384 = UnicodeOption(**{'default': u'/var/lib/lxc/reseau/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494740656 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494740928 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494741200 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494741472 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494741744 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494688656 = OptionDescription(children=[option_139789494739296, option_139789494739568, option_139789494739840, option_139789494740112, option_139789494740384, option_139789494740656, option_139789494740928, option_139789494741200, option_139789494741472, option_139789494741744], **{'doc': u'', 'properties': (), 'name': 'file35'})
    option_139789494742016 = UnicodeOption(**{'default': u'dns', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494742288 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494742560 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494747216 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494747488 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494747760 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494748032 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494748304 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494748576 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494748848 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494688976 = OptionDescription(children=[option_139789494742016, option_139789494742288, option_139789494742560, option_139789494747216, option_139789494747488, option_139789494747760, option_139789494748032, option_139789494748304, option_139789494748576, option_139789494748848], **{'doc': u'', 'properties': (), 'name': 'file36'})
    option_139789494749120 = UnicodeOption(**{'default': u'mysql', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494749392 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494749664 = UnicodeOption(**{'default': u'bdd', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494749936 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494750208 = UnicodeOption(**{'default': u'/var/lib/lxc/bdd/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494750480 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494750752 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494759504 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494759776 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494760048 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494689296 = OptionDescription(children=[option_139789494749120, option_139789494749392, option_139789494749664, option_139789494749936, option_139789494750208, option_139789494750480, option_139789494750752, option_139789494759504, option_139789494759776, option_139789494760048], **{'doc': u'', 'properties': (), 'name': 'file37'})
    option_139789494760320 = UnicodeOption(**{'default': u'proxy', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494760592 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container_group'})
    option_139789494760864 = UnicodeOption(**{'default': u'internet', 'doc': u'', 'multi': False, 'properties': (), 'name': 'real_container'})
    option_139789494761136 = UnicodeOption(**{'default': u'container', 'doc': u'', 'multi': False, 'properties': (), 'name': 'filelist'})
    option_139789494761408 = UnicodeOption(**{'default': u'/var/lib/lxc/internet/rootfs/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'full_name'})
    option_139789494761680 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'mkdir'})
    option_139789494761952 = UnicodeOption(**{'default': u'/etc/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'name'})
    option_139789494762224 = BoolOption(**{'default': False, 'doc': u'', 'multi': False, 'properties': (), 'name': 'rm'})
    option_139789494762496 = UnicodeOption(**{'default': u'/var/lib/creole/resolv.conf', 'doc': u'', 'multi': False, 'properties': (), 'name': 'source'})
    option_139789494762768 = BoolOption(**{'multi': False, 'name': 'activate', 'default': True, 'doc': u'', 'properties': (), "requires": [{'expected': u'non', 'action': 'disabled', 'inverse': False, "option": option_139789497889120}]})
    option_139789494767696 = OptionDescription(children=[option_139789494760320, option_139789494760592, option_139789494760864, option_139789494761136, option_139789494761408, option_139789494761680, option_139789494761952, option_139789494762224, option_139789494762496, option_139789494762768], **{'doc': u'', 'properties': (), 'name': 'file38'})
    option_139789494763040 = UnicodeOption(**{'default': u'ftp', 'doc': u'', 'multi': False, 'properties': (), 'name': 'container'})
    option_139789494775888 = UnicodeOption(**{'default': u'partage', 'doc': u'', 'multi': False, 'properties': (), 'name': 