#!/usr/bin/env python3
"""Hangman example
"""


from json import dumps, loads
from http.server import HTTPServer, SimpleHTTPRequestHandler
from urllib.parse import unquote
from tiramisu_web import TiramisuWeb
from examples.AmonEcole import amonecole

config = amonecole.get_config()
config.property.add('expert')
config.property.add('normal')
permissive = config.permissive.get()
permissive = list(permissive) + ['expert', 'normal']
config.permissive.set(frozenset(permissive))

tiramisu_web = TiramisuWeb(config,
                           clearable='all',
                           remotable='minimum',
                           root='creole')


class RequestHandler(SimpleHTTPRequestHandler):
    """main
    """
    def do_GET(self):
        if self.path == '/variables':
            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            values = tiramisu_web.get_jsonform()
            self.wfile.write(dumps(values).encode())
        else:
            if self.path == '/':
                self.path = '/src/index.html'
            elif self.path == '/example.html':
                self.path = '/src/example.html'
            elif self.path.startswith('/bower_components'):
                self.path = '/src' + self.path
            elif self.path.startswith('/javascript'):
                self.path = '/src' + self.path
            SimpleHTTPRequestHandler.do_GET(self)

    def do_POST(self):
        """Post data
        """
        content_len = int(self.headers.get('content-length', 0))
        body = loads(self.rfile.read(content_len))
        splitted_path = unquote(self.path).split('/', 4)
        print("POST on {}".format(self.path))
        from pprint import pprint
        pprint(body['updates'])
        if splitted_path[1] == 'variables':
            values = tiramisu_web.set_updates(body)
            text = "OK"
            type_ = 'info'
            self.send_response(200)
            self.send_header('Content-Type', 'application/json')
            self.end_headers()
            values['message'] = {'text': text, 'type': type_}
            self.wfile.write(dumps(values).encode())


def main(port=8000):
    """Launches the http server
    """
    print('Listening on localhost:%s' % port)
    server = HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == "__main__":
    main()
