from tiramisu import ChoiceOption, ParamContext, ParamOption


def _(text):
    return text


class TiramisuWebRoot(object):
    def set_api(self, api, root):
        self.api = api
        self.root = root

    def read_write(self):
        self.api.property.read_write()

    def get_unrestraint(self, root):
        if root is None:
            return self.api.unrestraint.option
        return self.api.unrestraint.option(root)

    def get_child(self, root):
        return self.api.option(root)

    def get_list(self, root, subchildapi):
        for childapi in subchildapi.list('all'):
            childname = childapi.option.name()
            if root is None:
                path = childname
            else:
                path = root + '.' + childname
            yield path, childapi

    def manage_requires(self,
                        require_obj,
                        childapi,
                        path,
                        form,
                        action_hide,
                        current_action):
        for requires in childapi.option.requires():
            for require in requires:
                options, action, inverse, \
                    transitive, same_action, operator = require
                if transitive is False:
                    raise Exception('transitive to "False" not supported yet for a requirement')
                if same_action is False:
                    raise Exception('same_action to "False" not supported yet for a requirement')
                if operator == 'and':
                    raise Exception('operator "and" not supported yet for a requirement')
                for option, expected in options:
                    option_path = require_obj.options.get(option)
                    if option_path is not None and action in action_hide:
                        if current_action is None:
                            current_action = action
                        elif current_action != action:
                            if require_obj.remotable == 'none':
                                raise Exception('require set for {} but remotable is "none"'
                                                ''.format(path))
                            form.setdefault(option_path, {})['remote'] = True
                        for exp in expected:
                            if inverse:
                                act = 'show'
                                inv_act = 'hide'
                            else:
                                act = 'hide'
                                inv_act = 'show'
                            require_obj.requires.setdefault(path,
                                                            {'expected': {}}
                                                           )['expected'].setdefault(exp,
                                                                                    {}).setdefault(act,
                                                                                                   []).append(option_path)
                            if isinstance(option, ChoiceOption):
                                for value in require_obj.api.unrestraint.option(option_path).value.list():
                                    if value not in expected:
                                        require_obj.requires.setdefault(path,
                                                                        {'expected': {}}
                                                                       )['expected'].setdefault(value,
                                                                                                {}).setdefault(inv_act,
                                                                                                               []).append(option_path)
                            require_obj.requires[path].setdefault('default', {}).setdefault(inv_act, []).append(option_path)
                    else:
                        if require_obj.remotable == 'none':
                            raise Exception('require set for {} but remotable est "none"'
                                            ''.format(path))
                        form.setdefault(option_path, {})['remote'] = True

    def manage_callbacks(self,
                         callback_obj,
                         path,
                         child,
                         options,
                         callback,
                         callback_params,
                         form):
        if callback_params is not None:
            for callback_param in callback_params.args:
                if isinstance(callback_param, ParamContext):
                    raise Exception(_('context is not supported from now for {}').format(path))
                if isinstance(callback_param, ParamOption):
                    if callback.__name__ == 'tiramisu_copy':
                        if callback_obj.clearable == 'minimum':
                            form.setdefault(options[child], {})['clearable'] = True
                        if form[options[callback_param.option]].get('remote', False) != True:
                            form.setdefault(options[callback_param.option], {})
                            form[options[callback_param.option]].setdefault('copy', []).append(options[child])
                    elif options.get(callback_param.option) is not None:
                        if callback_obj.remotable == 'none':
                            raise Exception(_('option {} only works when remotable is not "none"').format(path))
                        #form.setdefault(options[callback_param.option], {})
                        #FIXME form[options[callback_param.option]]['remote'] = True
                        form.setdefault(options[child], {})
                        form[options[child]]['remote'] = True
                        break

            for key, callback_param in callback_params.kwargs.items():
                #FIXME
                form.setdefault(options[child], {})
                form[options[child]]['remote'] = True

    def get_unrestraint_child_index(self, path, index):
        return self.api.unrestraint.option(path, index)

    def get_child_index(self, path, index):
        return self.api.option(path, index)

    def get_properties(self, childapi, path, index=None, apply_requires=True):
        return childapi.property.get(apply_requires=apply_requires)

    def get_option(self, childapi):
        return childapi.option.get()

    def get_option_option(self, childapi):
        return childapi.get()

    def get_default(self, childapi):
        return childapi.option.default()

    def isoptiondescription(self, childapi):
        return childapi.option.isoptiondescription()

    def get_consistencies(self, childapi):
        for consistency in childapi.option.consistencies():
            cons_id, func, all_cons_opts, params = consistency
            yield func, all_cons_opts

    def get_callbacks(self, childapi):
        return childapi.option.callbacks()

    def get_childapi_option(self, childapi):
        return childapi.option

    def get_option_doc(self, childapi):
        return childapi.doc()

    def get_option_default(self, childapi):
        return childapi.default()

    def get_ismulti(self, childapi):
        return childapi.option.ismulti()

    def get_option_ismulti(self, childapi):
        return childapi.ismulti()

    def get_option_issubmulti(self, childapi):
        return childapi.issubmulti()

    def get_option_get_default_multi(self, childapi):
        return childapi.defaultmulti()

    def get_option_help(self, childapi):
        return childapi.information.get('help', None)

    def get_option_has_dependency(self, childapi):
        return childapi.has_dependency()

    def get_option_ismasterslaves(self, childapi):
        return childapi.ismasterslaves()

    def get_option_isslave(self, childapi):
        return childapi.isslave()

    def get_isslave(self, childapi):
        return childapi.option.isslave()

    def get_option_ismaster(self, childapi):
        return childapi.ismaster()

    def get_value(self, childapi, path, props, index, validate_properties):
        return childapi.value.get()

    def del_value(self, childapi, path, index):
        if index is not None and childapi.option.ismaster():
            childapi.value.pop(index)
        elif index is None or childapi.option.isslave():
            childapi.value.reset()
        else:
            multi = childapi.value.get()
            multi.pop(index)
            childapi.value.set(multi)

    def add_value(self, childapi, path, value):
        multi = childapi.value.get()
        multi.append(value)
        childapi.value.set(multi)

    def mod_value(self, childapi, path, index, value):
        if index is None or childapi.option.isslave():
            childapi.value.set(value)
        else:
            multi = childapi.value.get()
            if not multi and index == 0:
                multi.append(value)
            else:
                multi[index] = value
            childapi.value.set(multi)

    def get_option_values(self, childapi):
        return childapi.value.list()

    def get_value_len(self, childapi, path):
        return childapi.value.len()

    def get_owner(self, childapi, path, index):
        return childapi.owner.get()
